/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemService;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.thirld.PlanPushFreeGoods;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanPassMqTagEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.InterfacePushStateEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.OperationTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import com.bizunited.nebula.common.util.JsonUtils;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC${rocketmq.environment}", selectorExpression="TPM_ACTIVITY_PLAN_PASS_PUSH_SAP", consumerGroup="TPM_ACTIVITY_PLAN_PASS_PUSH_SAP${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY, messageModel=MessageModel.CLUSTERING)
public class ActivityPlanPassPushSAPConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanPassPushSAPConsumer.class);
    @Autowired(required=false)
    private ActivityPlanItemService activityPlanItemService;
    @Autowired(required=false)
    private PlanPushFreeGoods planPushFreeGoods;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleMessage(MqMessageVo message) {
        block8: {
            log.info("\u6d3b\u52a8\u65b9\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001sap order mq message received  : {}", (Object)message);
            if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
                return "\u6d88\u606f\u4e3a\u7a7a!";
            }
            try {
                List businessNoList = JSON.parseArray((String)message.getMsgBody(), String.class);
                List<Object> activityPlanItemVos = this.activityPlanItemService.findListByPlanCodes(businessNoList);
                if (!CollectionUtils.isNotEmpty(activityPlanItemVos)) break block8;
                activityPlanItemVos = activityPlanItemVos.stream().filter(o -> !InterfacePushStateEnum.SUCCESS.getCode().equals(o.getSapInterfaceState())).collect(Collectors.toList());
                boolean hasLock = false;
                List planItemCodes = activityPlanItemVos.stream().map(ActivityPlanItemBase::getPlanItemCode).collect(Collectors.toList());
                try {
                    hasLock = this.redisLockService.batchLock("plan_item:free_goods_lock:", planItemCodes, TimeUnit.MINUTES, 30);
                    if (!hasLock) {
                        log.error("\u514d\u8d39\u8d27\u7269\u6b63\u5728\u63a8\u9001SAP\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff0c\u65b9\u6848\u660e\u7ec6\u7f16\u7801\uff1a{}", (Object)JsonUtils.obj2JsonString(planItemCodes));
                        throw new RuntimeException("\u514d\u8d39\u8d27\u7269\u6b63\u5728\u63a8\u9001SAP\u4e2d,\u8bf7\u52ff\u91cd\u590d\u63a8\u9001");
                    }
                    this.planPushFreeGoods.pushActivityToFreeGoods(activityPlanItemVos, OperationTypeEnum.CREATE);
                }
                finally {
                    if (hasLock) {
                        this.redisLockService.batchUnLock("plan_item:free_goods_lock:", planItemCodes);
                    }
                }
            }
            catch (Exception e) {
                log.error(ActivityPlanPassMqTagEnum.PASS_PUSH_SAP.getName() + "\u5904\u7406\u5931\u8d25" + e.getMessage(), (Throwable)e);
                return "\u6d88\u8d39\u5931\u8d25." + e.getMessage();
            }
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }
}

