/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DataTooLongGenerateRespUtil;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanAsyncService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanBudgetService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanService;
import com.biz.crm.tpm.business.activity.plan.local.service.CorrectionDiscountRateQuantumService;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanApproveSubmitDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanOutDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.ActivityPlanItemPushSfaDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.ActivityPlanItemPushSfaListDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.SfaActivityPlanItemStatusUpdateDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.event.ActivityPlanPushSfaEventListener;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyItemDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyItemSdkService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategySdkService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/activityPlan"})
@Api(tags={"\u6d3b\u52a8\u65b9\u6848\u8868"})
public class ActivityPlanController {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanController.class);
    @Autowired(required=false)
    private ActivityPlanService activityPlanService;
    @Autowired(required=false)
    private ActivityPlanAsyncService activityPlanAsyncService;
    @Autowired(required=false)
    private ActivityPlanBudgetService activityPlanBudgetService;
    @Autowired(required=false)
    private MarketingStrategySdkService marketingStrategySdkService;
    @Autowired(required=false)
    private MarketingStrategyItemSdkService marketingStrategyItemSdkService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private CorrectionDiscountRateQuantumService correctionDiscountRateQuantumService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<ActivityPlanVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="activityDetailPlanDto", value="\u67e5\u8be2\u5b9e\u4f53") ActivityPlanDto activityPlanDto) {
        try {
            Page<ActivityPlanVo> page = this.activityPlanService.findByConditions(pageable, activityPlanDto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u65b9\u6848\u65b0\u589e\u7f16\u8f91-\u80fd\u529b\u4e2d\u5fc3")
    @PostMapping(value={"saveActivityPlanNoCache"})
    public Result<ActivityPlanOutDto> saveActivityPlanNoCache(@ApiParam(name="ActivityPlanDto", value="\u6d3b\u52a8\u65b9\u6848\u8868\u5934") @RequestBody ActivityPlanOutDto dto) {
        try {
            this.loginUserService.refreshAuthentication(null);
            return Result.ok((Object)this.activityPlanService.saveActivityPlanNoCache(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)DataTooLongGenerateRespUtil.generateRespStr((Exception)e, ActivityPlan.class));
        }
    }

    @ApiOperation(value="\u514d\u8d39\u8d27\u7269\u63a8\u9001sap")
    @PostMapping(value={"pushActivityToFreeGoods"})
    public Result<?> pushActivityToFreeGoods(@RequestBody List<String> planCodes) {
        try {
            this.activityPlanService.pushActivityToFreeGoods(planCodes);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)DataTooLongGenerateRespUtil.generateRespStr((Exception)e, ActivityPlan.class));
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u65b9\u6848\u65b0\u589e\u7f16\u8f91")
    @PostMapping(value={"saveActivityPlan"})
    public Result saveActivityPlan(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="ActivityPlanDto", value="\u6d3b\u52a8\u65b9\u6848\u8868\u5934") @RequestBody ActivityPlanDto dto) {
        try {
            UserIdentity loginUser = this.loginUserService.getLoginUser();
            this.activityPlanAsyncService.saveActivityPlanAsync(dto, cacheKey, loginUser);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u65b9\u6848\u65b0\u589e\u539f\u5b50\u63a5\u53e3")
    @PostMapping(value={"atomSaveActivityPlan"})
    public Result atomSaveActivityPlan(@ApiParam(name="ActivityPlanDto", value="\u6d3b\u52a8\u65b9\u6848\u8868\u5934") @RequestBody ActivityPlanDto dto) {
        try {
            return Result.ok((Object)this.activityPlanService.atomSaveActivityPlan(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)DataTooLongGenerateRespUtil.generateRespStr((Exception)e, ActivityPlan.class));
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u65b9\u6848\u7f16\u7801\u67e5\u8be2\u63a8\u9001sfa\u6570\u636e")
    @PostMapping(value={"findSfaDataByPlanCodes"})
    public Result findSfaDataByPlanCodes(@RequestBody List<String> planCodeList) {
        try {
            List<ActivityPlanItemPushSfaDto> sfaDataByPlanCodes = this.activityPlanService.findSfaDataByPlanCodes(planCodeList);
            return Result.ok(sfaDataByPlanCodes);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u53ef\u4ee5\u9009\u62e9\u7684\u8425\u9500\u7b56\u7565")
    @GetMapping(value={"findMarketingStrategyByConditions"})
    public Result<Page<MarketingStrategyVo>> findMarketingStrategyByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="MarketingStrategyDto", value="\u7b56\u7565\u67e5\u8be2\u5b9e\u4f53") MarketingStrategyDto dto) {
        try {
            dto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            Page page = this.marketingStrategySdkService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u53ef\u4ee5\u9009\u62e9\u7684\u8425\u9500\u7b56\u7565")
    @GetMapping(value={"findMarketingStrategyItemByConditions"})
    public Result<Page<MarketingStrategyItemVo>> findMarketingStrategyItemByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="MarketingStrategyItemDto", value="\u7b56\u7565\u67e5\u8be2\u5b9e\u4f53") MarketingStrategyItemDto dto) {
        try {
            dto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            dto.setAttrOrgQueryExcludeHeadStrategy(1);
            dto.setIsClose(BooleanEnum.FALSE.getCapital());
            Page page = this.marketingStrategyItemSdkService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u65b9\u6848\u7533\u8bf7\u53ef\u4ee5\u9009\u62e9\u7684\u603b\u90e8\u65b9\u6848")
    @GetMapping(value={"findRelateActivityPlanListByConditions"})
    public Result<Page<ActivityPlanVo>> findRelateActivityPlanListByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="MarketingStrategyDto", value="\u7b56\u7565\u67e5\u8be2\u5b9e\u4f53") ActivityPlanDto dto) {
        try {
            dto.setPlanType(ActivityPlanTypeEnum.headquarters.getCode());
            Page<ActivityPlanVo> page = this.activityPlanService.findRelateActivityPlanListByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u53ef\u4ee5\u9009\u62e9\u7684\u6708\u5ea6\u9884\u7b97")
    @GetMapping(value={"findMonthBudgetByConditions"})
    public Result<Page<MonthBudgetVo>> findMonthBudgetByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="MonthBudgetDto", value="\u6708\u5ea6\u9884\u7b97\u4fe1\u606f") ActivityPlanBudgetDto planBudgetDto, @ApiParam(name="MonthBudgetDto", value="\u6708\u5ea6\u9884\u7b97\u4fe1\u606f") MonthBudgetDto monthBudgetDto) {
        try {
            Page<MonthBudgetVo> page = this.activityPlanService.findMonthBudgetByConditions(pageable, planBudgetDto, monthBudgetDto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7id\u83b7\u53d6\u6d3b\u52a8\u65b9\u6848\u6570\u636e")
    @GetMapping(value={"findById"})
    public Result<ActivityPlanVo> findById(@ApiParam(value="id") @RequestParam String id) {
        try {
            ActivityPlanVo vo = this.activityPlanService.findById(id);
            return Result.ok((Object)vo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6263\u51cf\u6708\u5ea6\u9884\u7b97")
    @PostMapping(value={"useMonthBudgetByPlanCodeList"})
    public Result useMonthBudgetByPlanCodeList(@RequestBody List<String> planCodeList) {
        try {
            this.activityPlanBudgetService.useMonthBudgetByPlanCodeList(planCodeList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u63d0\u4ea4\u6d41\u7a0b,\u591a\u9009\u6279\u91cf\u63d0\u4ea4")
    @PostMapping(value={"submitApproval"})
    public Result submitApproval(@ApiParam(value="\u63d0\u4ea4\u6d41\u7a0b,\u591a\u9009\u6279\u91cf\u63d0\u4ea4") @RequestBody ActivityPlanApproveSubmitDto dto) {
        List<String> ids = dto.getIds();
        boolean lockSuccess = false;
        try {
            Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            lockSuccess = this.redisLockService.batchLock("activity_plan:lock:approve:", ids, TimeUnit.HOURS, 1);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.activityPlanService.submitApproval(dto.getIds(), dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.batchUnLock("activity_plan:lock:approve:", ids);
            }
        }
    }

    @ApiOperation(value="\u5220\u9664\u6d3b\u52a8\u65b9\u6848")
    @DeleteMapping(value={"delete"})
    public Result delete(@ApiParam(value="\u7b56\u7565id\u96c6\u5408") @RequestParam List<String> ids) {
        try {
            this.activityPlanService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u6d3b\u52a8\u65b9\u6848")
    @PostMapping(value={"deletePos"})
    public Result deletePos(@ApiParam(value="\u7b56\u7565id\u96c6\u5408") @RequestParam List<String> ids) {
        try {
            this.activityPlanService.deleteForOut(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0SFA\u6d3b\u52a8\u5360\u7528\u72b6\u6001")
    @PostMapping(value={"updateSfaActivityPlanState"})
    public Result updateSfaActivityPlanState(@RequestBody List<SfaActivityPlanItemStatusUpdateDto> updateList) {
        try {
            log.info(JSONObject.toJSONString(updateList));
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="sfa\u63a8\u9001\u6d3b\u52a8\u65b9\u6848")
    @PostMapping(value={"pushSfaActByPlanCodeList"})
    public Result pushSfaActByPlanCodeList(@RequestBody List<String> planCodeList) {
        try {
            List<ActivityPlanItemPushSfaDto> dtos = this.activityPlanService.findSfaDataByPlanCodes(planCodeList);
            SerializableBiConsumer & Serializable activityPlanProcessPass = ActivityPlanPushSfaEventListener::pushActivityPlanListToSfa;
            ActivityPlanItemPushSfaListDto activityPlanItemPushSfaListDto = new ActivityPlanItemPushSfaListDto();
            ActivityPlanItemPushSfaDto activityPlanItemPushSfaDto = dtos.get(0);
            activityPlanItemPushSfaDto.setSfaPlanCode("HDFA146942043833483728937");
            activityPlanItemPushSfaDto.setActualAmount(new BigDecimal("5"));
            activityPlanItemPushSfaDto.setSuggestedAmount(new BigDecimal("6"));
            activityPlanItemPushSfaListDto.setList(dtos);
            this.nebulaNetEventClient.publish((NebulaEventDto)activityPlanItemPushSfaListDto, ActivityPlanPushSfaEventListener.class, (SerializableBiConsumer)activityPlanProcessPass);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="sfa\u63a8\u9001\u6d3b\u52a8\u65b9\u6848")
    @PostMapping(value={"pushSfaAct"})
    public Result pushSfaAct(@RequestBody List<ActivityPlanItemPushSfaDto> dtos) {
        try {
            SerializableBiConsumer & Serializable activityPlanProcessPass = ActivityPlanPushSfaEventListener::pushActivityPlanListToSfa;
            ActivityPlanItemPushSfaListDto activityPlanItemPushSfaListDto = new ActivityPlanItemPushSfaListDto();
            activityPlanItemPushSfaListDto.setList(dtos);
            this.nebulaNetEventClient.publish((NebulaEventDto)activityPlanItemPushSfaListDto, ActivityPlanPushSfaEventListener.class, (SerializableBiConsumer)activityPlanProcessPass);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5408\u540c\u751f\u6210\u65b9\u6848")
    @DynamicTaskService(cornExpression="0 0 2 28 * ?", taskDesc="\u6bcf\u670828\u53f7 02:00 \u6267\u884c\u4e00\u6b21\u5408\u540c\u751f\u6210\u65b9\u6848")
    @GetMapping(value={"/contractGenerateActivityPlan"})
    public void contractGenerateActivityPlan() {
        boolean lockSuccess = false;
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String key = "activity_plan:lock:contract_generate:" + sdf.format(date);
        try {
            lockSuccess = this.redisLockService.tryLock(key, TimeUnit.MINUTES, 30L);
            if (!lockSuccess) {
                return;
            }
            this.loginUserService.refreshAuthentication(null);
            this.activityPlanService.contractGenerateActivityPlan();
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u6309\u5c97\u5e97\u5206\u644a")
    @PostMapping(value={"proportionByTerminalEmployee"})
    public Result proportionByTerminalEmployee(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="ActivityPlanDto", value="\u6d3b\u52a8\u65b9\u6848\u8868\u5934") @RequestBody ActivityPlanDto dto) {
        String key = "activity_plan:lock:proportion:" + cacheKey;
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock(key, TimeUnit.MINUTES, 30L);
            if (!lockSuccess) {
                throw new RuntimeException("\u64cd\u4f5c\u6b63\u5728\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u6216\u91cd\u8bd5");
            }
            this.activityPlanService.proportionByTerminalEmployee(dto, cacheKey);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(key);
            }
        }
    }

    @ApiOperation(value="\u8ba1\u7b97\u6d3b\u52a8\u660e\u7ec6\u4e0a\u7684\u91d1\u989d\u6c47\u603b\u4fe1\u606f")
    @PostMapping(value={"calculateHeadAmount"})
    public Result<ActivityPlanVo> calculateHeadAmount(ActivityPlanDto planDto, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey) {
        try {
            ActivityPlanVo planVo = this.activityPlanService.calculateHeadAmount(planDto, cacheKey);
            return Result.ok((Object)planVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u6309\u9500\u552e\u8ba1\u5212\u5360\u6bd4\u5206\u644a")
    @PostMapping(value={"calculateSalePlanProportion"})
    public Result calculateSalePlanProportion(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="ActivityPlanDto", value="\u6d3b\u52a8\u65b9\u6848\u8868\u5934") @RequestBody ActivityPlanDto dto) {
        String key = "activity_plan:lock:proportion:" + cacheKey;
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock(key, TimeUnit.MINUTES, 30L);
            if (!lockSuccess) {
                throw new RuntimeException("\u64cd\u4f5c\u6b63\u5728\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u6216\u91cd\u8bd5");
            }
            this.activityPlanService.calculateSalePlanProportion(dto, cacheKey);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u6309\u00b7\u95e8\u5e97\u5206\u644a")
    @PostMapping(value={"proportionByTerminal"})
    public Result proportionByTerminal(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="ActivityPlanDto", value="\u6d3b\u52a8\u65b9\u6848\u8868\u5934") @RequestBody ActivityPlanDto dto) {
        String key = "activity_plan:lock:proportion:" + cacheKey;
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock(key, TimeUnit.MINUTES, 30L);
            if (!lockSuccess) {
                throw new RuntimeException("\u64cd\u4f5c\u6b63\u5728\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u6216\u91cd\u8bd5");
            }
            this.activityPlanService.proportionByTerminal(dto, cacheKey);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(key);
            }
        }
    }

    @ApiOperation(value="\u9000\u56de\u6708\u5ea6\u9884\u7b97")
    @PostMapping(value={"returnMonthBudgetByPlanCodeList"})
    public Result returnMonthBudgetByPlanCodeList(@RequestBody List<String> planCodeList) {
        try {
            this.activityPlanBudgetService.returnMonthBudgetByPlanCodeList(planCodeList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5782\u76f4\u6263\u51cf\u5927\u65e5\u671f\u5e93\u5b58")
    @PostMapping(value={"useInventoryCheck"})
    public Result useInventoryCheck(@RequestBody List<String> planCodeList) {
        try {
            this.activityPlanService.useInventoryCheck(planCodeList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5782\u76f4\u6263\u51cf\u5927\u65e5\u671f\u5e93\u5b58\u56de\u9000")
    @PostMapping(value={"returnInventoryCheck"})
    public Result returnInventoryCheck(@RequestBody List<String> planCodeList) {
        try {
            this.activityPlanService.returnInventoryCheck(planCodeList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u8c03\u7528\u4fee\u6b63\u6298\u6263\u7387")
    @GetMapping(value={"manualCorrectionDiscountRate"})
    public Result<?> manualCorrectionDiscountRate(@RequestParam(value="yearMonth") String yearMonth, @RequestParam(value="regionCode", required=false) String regionCode, @RequestParam(value="systemCode") String systemCode) {
        try {
            this.correctionDiscountRateQuantumService.frJob(Collections.singletonList(yearMonth), regionCode, systemCode);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

