/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.controller;

import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.enums.ActivitiesTemplateConfigTypeEnum;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractMaterialDto;
import com.biz.crm.tpm.business.activity.contract.sdk.enums.ContractStateEnum;
import com.biz.crm.tpm.business.activity.contract.sdk.enums.ContractTypeEnum;
import com.biz.crm.tpm.business.activity.contract.sdk.service.ActivityContractSdkService;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractMaterialVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractVo;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItem;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanAsyncService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanBudgetService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemTerminalService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanLockService;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanBudgetSumVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeSelectDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyBudgetVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/activityPlanItem"})
@Api(tags={"\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6\u8868"})
public class ActivityPlanItemController
extends MnPageCacheController<ActivityPlanItemVo, ActivityPlanItemDto> {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanItemController.class);
    @Autowired
    private ActivityPlanItemService activityPlanItemService;
    @Autowired
    private ActivityPlanItemTerminalService activityPlanItemTerminalService;
    @Autowired
    private ActivityPlanLockService activityPlanLockService;
    @Autowired
    private RedisLockService redisLockService;
    @Autowired
    private ActivityPlanAsyncService activityPlanAsyncService;
    @Autowired
    private ActivityPlanBudgetService activityPlanBudgetService;
    @Autowired(required=false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;
    @Autowired(required=false)
    private ActivityContractSdkService activityContractSdkService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<ActivityPlanItemVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="activityPlanItemDto", value="\u65b9\u6848\u67e5\u8be2\u5b9e\u4f53") ActivityPlanItemDto activityPlanItemDto) {
        try {
            Page<ActivityPlanItemVo> page = this.activityPlanItemService.findByConditions(pageable, activityPlanItemDto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u65b9\u6848\u7533\u8bf7\u53ef\u4ee5\u9009\u62e9\u7684\u603b\u90e8\u65b9\u6848\u660e\u7ec6")
    @GetMapping(value={"findRelateActivityPlanItemListByConditions"})
    public Result<Page<ActivityPlanItemVo>> findRelateActivityPlanListByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="ActivityPlanItemDto", value="\u65b9\u6848\u660e\u7ec6\u67e5\u8be2\u5b9e\u4f53") ActivityPlanItemDto dto) {
        try {
            dto.setPlanType(ActivityPlanTypeEnum.headquarters.getCode());
            dto.setProcessStatus(ProcessStatusEnum.PASS.getKey());
            Page<ActivityPlanItemVo> page = this.activityPlanItemService.findByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findItemBudgetByConditions"})
    public Result<Page<ActivityPlanItemBudgetVo>> findItemBudgetByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="activityPlanItemDto", value="\u67e5\u8be2\u5b9e\u4f53") ActivityPlanItemBudgetDto dto) {
        try {
            Page<ActivityPlanItemBudgetVo> page = this.activityPlanItemService.findItemBudgetByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5173\u95ed\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6")
    @PostMapping(value={"closeItem"})
    public Result<?> closeItem(@ApiParam(name="ids", value="\u5173\u95ed\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6") @RequestBody List<String> ids) {
        try {
            if (this.redisLockService.isBatchLock("activity_plan:lock:item_close:", ids)) {
                throw new RuntimeException("\u64cd\u4f5c\u6b63\u5728\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u64cd\u4f5c");
            }
            List<ActivityPlanItem> itemList = this.activityPlanItemService.closeItemBaseVerifyItem(ids, true, Lists.newArrayList());
            Assert.notEmpty(itemList, (String)"\u65e0\u6709\u6548\u53ef\u4ee5\u5173\u95ed\u65b9\u6848\u660e\u7ec6,\u8bf7\u5237\u65b0\u91cd\u8bd5!");
            this.activityPlanAsyncService.closeItemListAsync(itemList, this.loginUserService.getLoginUser());
            return Result.ok((String)"\u5173\u95ed\u8bf7\u6c42\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u6267\u884c\u7ed3\u679c");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5173\u95ed\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6-\u901a\u8fc7\u65b9\u6848id")
    @PostMapping(value={"closeItemByPlanIds"})
    public Result<?> closeItemByPlanIds(@ApiParam(name="ids", value="\u5173\u95ed\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6") @RequestBody List<String> ids) {
        try {
            this.activityPlanAsyncService.closeItemByPlanIdsAsync(ids, this.loginUserService.getLoginUser());
            return Result.ok((String)"\u5173\u95ed\u8bf7\u6c42\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u6267\u884c\u7ed3\u679c");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6d3b\u52a8\u65b9\u6848\u53ef\u4ee5\u9009\u62e9\u7684\u6a21\u677f")
    @PostMapping(value={"findItemColumnConfigSelect"})
    public Result<List<CommonSelectVo>> findItemColumnConfigSelect(@ApiParam(value="\u6a21\u677f\u7f16\u7801") ActivitiesTemplateConfigDto configDto, @ApiParam(value="\u6d3b\u52a8\u7c7b\u578bdto") @RequestBody CommonSelectDto dto) {
        try {
            Validate.notBlank((CharSequence)configDto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)configDto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)configDto.getSchemeTypeCode(), (String)"\u65b9\u6848\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (BusinessUnitEnum.isDefaultBusinessUnit((String)configDto.getBusinessUnitCode())) {
                configDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
            }
            configDto.setType(ActivitiesTemplateConfigTypeEnum.SCHEME.getCode());
            List list = this.activitiesTemplateSdkService.findActivitiesTemplateConfigSelectList(dto, configDto);
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6\u914d\u7f6e")
    @GetMapping(value={"getItemColumnConfig"})
    public Result<ActivitiesTemplateConfigVo> getItemColumnConfig(@ApiParam(value="\u6a21\u677f\u7f16\u7801") @RequestParam(required=false) String configCode) {
        try {
            configCode = Optional.ofNullable(configCode).orElse("HDMBPZ0004");
            ActivitiesTemplateConfigVo configVo = this.activitiesTemplateSdkService.findByCode(configCode);
            return Result.ok((Object)configVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u7c7b\u578b\u4e0b\u62c9")
    @PostMapping(value={"findActivityTypeSelectList"})
    public Result<List<CommonSelectVo>> findActivityTypeSelectList(@ApiParam(value="\u6d3b\u52a8\u7c7b\u578bdto") @RequestBody ActivityTypeSelectDto dto) {
        try {
            List<CommonSelectVo> list = this.activityPlanItemService.findActivityTypeSelectList(dto);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u5f62\u5f0f\u4e0b\u62c9")
    @PostMapping(value={"findActivityFormSelectList"})
    public Result<List<CommonSelectVo>> findActivityFormSelectList(@ApiParam(value="\u6d3b\u52a8\u5f62\u5f0fdto") @RequestBody ActivityFormSelectDto dto) {
        try {
            List<CommonSelectVo> list = this.activityPlanItemService.findActivityFormSelectList(dto);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u53ef\u4ee5\u9009\u62e9\u7684\u7b56\u7565\u9884\u7b97\u6570\u636e")
    @GetMapping(value={"findChooseStrategyBudgetList"})
    public Result<Page<MarketingStrategyBudgetVo>> findChooseStrategyBudgetList(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="activityPlanItemDto", value="\u67e5\u8be2\u5b9e\u4f53") MarketingStrategyBudgetDto dto) {
        try {
            Page<MarketingStrategyBudgetVo> page = this.activityPlanBudgetService.findChooseStrategyBudgetList(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u9884\u7b97\u6c47\u603b\u4fe1\u606f")
    @PostMapping(value={"findBudgetCacheSumList"})
    public Result<List<ActivityPlanBudgetSumVo>> findBudgetCacheSumList(@ApiParam(name="businessUnitCode", value="\u4e1a\u52a1\u5355\u5143") @RequestParam String businessUnitCode, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey) {
        try {
            List<ActivityPlanBudgetSumVo> list = this.activityPlanItemService.findBudgetCacheSumList(businessUnitCode, cacheKey);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8ba1\u7b97\u9500\u552e\u8ba1\u5212\u5360\u6bd4")
    @PostMapping(value={"calculateSalePlanProportion"})
    public Result<Map<String, BigDecimal>> calculateSalePlanProportion(@RequestBody ActivityPlanItemDto dto) {
        try {
            return Result.ok(this.activityPlanItemService.calculateSalePlanProportion(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309\u95e8\u5e97\u5206\u644a")
    @PostMapping(value={"proportionByTerminal"})
    public Result proportionByTerminal(@RequestBody ActivityPlanItemDto dto) {
        try {
            this.activityPlanItemTerminalService.proportionByTerminal(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309\u5c97\u5e97\u5206\u644a")
    @PostMapping(value={"proportionByTerminalEmployee"})
    public Result proportionByTerminalEmployee(@RequestBody ActivityPlanItemDto dto) {
        try {
            this.activityPlanItemTerminalService.proportionByTerminalEmployee(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u884c\u6570\u636e\u8ba1\u7b97")
    @PostMapping(value={"calculateItemData"})
    public Result<ActivityPlanItemVo> calculateItemData(@RequestBody ActivityPlanItemDto dto) {
        try {
            return Result.ok((Object)this.activityPlanItemService.calculateItemData(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6ca1\u6709\u6d3b\u52a8\u7ec6\u6848\u7684\u6d3b\u52a8\u65b9\u6848")
    @GetMapping(value={"findPlanItemNoActivityDetail"})
    public Result<?> findPlanItemNoActivityDetail(Pageable pageable, @RequestParam(value="yearMonth") String yearMonth, @RequestParam(value="salesOrgCode", required=false) String salesOrgCode) {
        try {
            Page<ActivityPlanItemVo> page = this.activityPlanItemService.findPlanItemNoActivityDetail(pageable, yearMonth, salesOrgCode);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u53ef\u4ee5\u9009\u62e9\u7684\u5408\u540c")
    @GetMapping(value={"findActivityContractByConditions"})
    public Result<Page<ActivityContractVo>> findActivityContractByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="activityPlanItemDto", value="\u67e5\u8be2\u5b9e\u4f53") ActivityContractDto dto) {
        try {
            dto.setContractState(ContractStateEnum.CONFIRMED.getCode());
            dto.setContractType(ContractTypeEnum.SUPPLIER_CONTRACT.getCode());
            dto.setCompareDateStr(DateUtil.getDateStrByFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            Page page = this.activityContractSdkService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u53ef\u4ee5\u9009\u62e9\u7684\u5408\u540c")
    @GetMapping(value={"getActivityContractMaterial"})
    public Result<ActivityContractMaterialVo> getActivityContractMaterial(ActivityContractMaterialDto dto) {
        try {
            ActivityContractMaterialVo contractMaterialVo = this.activityContractSdkService.getActivityContractMaterial(dto);
            return Result.ok((Object)contractMaterialVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

