/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemTerminalService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemTerminalDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemTerminalVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/activityPlanItemTerminal"})
@Api(tags={"\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6\u95e8\u5e97"})
public class ActivityPlanItemTerminalController {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanItemTerminalController.class);
    @Autowired(required=false)
    private ActivityPlanItemTerminalService activityPlanItemTerminalService;
    @Autowired(required=false)
    private ActivityPlanItemService activityPlanItemService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @ApiOperation(value="\u83b7\u53d6\u660e\u7ec6\u5217\u8868\u7f13\u5b58\u5206\u9875\u63a5\u53e3")
    @GetMapping(value={"findCachePageList"})
    public Result<Page<ActivityPlanItemTerminalVo>> findCachePageList(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="dto", value="\u67e5\u8be2\u5b9e\u4f53") ActivityPlanItemTerminalDto dto) {
        try {
            Page<ActivityPlanItemTerminalVo> page = this.activityPlanItemTerminalService.findCachePageList(pageable, dto, cacheKey);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6e05\u7406\u7f13\u5b58\u63a5\u53e3")
    @PostMapping(value={"clearCache"})
    public Result clearCache(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey) {
        try {
            this.activityPlanItemTerminalService.clearCache(cacheKey);
            return Result.ok();
        }
        catch (Exception var3) {
            log.error(var3.getMessage(), (Throwable)var3);
            return Result.error((String)var3.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u4e00\u884c\u63a5\u53e3\uff0c\u4fdd\u5b58\u5f53\u524d\u9875\u6570\u636e\u540e\uff0c\u5728\u7f13\u5b58\u4e2d\u884c\u9996\u63d2\u5165\u4e00\u6761\u6570\u636e\u5e76\u8fd4\u56de\u7b2c\u4e00\u9875\u6570\u636e")
    @PostMapping(value={"addItemCache"})
    public Result<Page<ActivityPlanItemTerminalVo>> addItemCache(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="dto", value="\u67e5\u8be2\u5b9e\u4f53") ActivityPlanItemTerminalDto dto, @ApiParam(value="\u5f53\u524d\u9875\u6570\u636e") @RequestBody List<ActivityPlanItemTerminalDto> itemList) {
        try {
            this.activityPlanItemTerminalService.addItemCache(cacheKey, itemList);
            Page<ActivityPlanItemTerminalVo> page = this.activityPlanItemTerminalService.findCachePageList(pageable, null, cacheKey);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u590d\u5236\u884c\u63a5\u53e3\uff0c\u4fdd\u5b58\u5f53\u524d\u9875\u6570\u636e\u540e\uff0c\u5728\u7f13\u5b58\u4e2d\u884c\u9996\u590d\u5236\u9009\u4e2d\u6570\u636e\u5e76\u8fd4\u56de\u7b2c\u4e00\u9875\u6570\u636e")
    @PostMapping(value={"copyItemListCache"})
    public Result<Page<ActivityPlanItemTerminalVo>> copyItemListCache(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="dto", value="\u67e5\u8be2\u5b9e\u4f53") ActivityPlanItemTerminalDto dto, @ApiParam(value="\u5f53\u524d\u9875\u6570\u636e\uff0c\u5305\u542b\u8981\u590d\u5236\u7684\u884c\u52fe\u9009\u4fe1\u606f") @RequestBody List<ActivityPlanItemTerminalDto> itemList) {
        try {
            this.activityPlanItemTerminalService.copyItemListCache(cacheKey, itemList);
            Page<ActivityPlanItemTerminalVo> page = this.activityPlanItemTerminalService.findCachePageList(pageable, null, cacheKey);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u5f53\u524d\u9875\u6570\u636e\u5230\u7f13\u5b58\u5e76\u8fd4\u56de\u6307\u5b9a\u9875\u6570\u636e\u63a5\u53e3")
    @PostMapping(value={"saveCurrentPageCache"})
    public Result<Page<ActivityPlanItemTerminalVo>> saveCurrentPageCache(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="dto", value="\u67e5\u8be2\u5b9e\u4f53") ActivityPlanItemTerminalDto dto, @ApiParam(value="\u5f53\u524d\u9875\u6570\u636e") @RequestBody List<ActivityPlanItemTerminalDto> saveList) {
        try {
            this.activityPlanItemTerminalService.saveCurrentPageCache(cacheKey, saveList);
            Page<ActivityPlanItemTerminalVo> page = this.activityPlanItemTerminalService.findCachePageList(pageable, null, cacheKey);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u591a\u884c\u5220\u9664\u5e76\u8fd4\u56de\u6307\u5b9a\u9875\u6570\u636e\u63a5\u53e3")
    @PostMapping(value={"deleteCacheList"})
    public Result<Page<ActivityPlanItemTerminalVo>> deleteCacheList(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="dto", value="\u67e5\u8be2\u5b9e\u4f53") ActivityPlanItemTerminalDto dto, @ApiParam(value="\u5f53\u524d\u9875\u6570\u636e\uff0c\u5305\u542b\u8981\u5220\u9664\u7684\u884c\u52fe\u9009\u4fe1\u606f") @RequestBody List<ActivityPlanItemTerminalDto> itemList) {
        try {
            this.activityPlanItemTerminalService.deleteCacheList(cacheKey, itemList);
            Page<ActivityPlanItemTerminalVo> page = this.activityPlanItemTerminalService.findCachePageList(pageable, null, cacheKey);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u6309\u00b7POS\u5206\u644a")
    @PostMapping(value={"proportionByPos"})
    public Result proportionByPos(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="ActivityPlanDto", value="\u6d3b\u52a8\u65b9\u6848\u8868\u5934") @RequestBody ActivityPlanDto dto) {
        String key = "activity_plan:lock:proportion:" + cacheKey;
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock(key, TimeUnit.MINUTES, 30L);
            if (!lockSuccess) {
                throw new RuntimeException("\u64cd\u4f5c\u6b63\u5728\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u6216\u91cd\u8bd5");
            }
            this.activityPlanItemService.proportionByPos(dto, cacheKey);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u521d\u59cb\u5316\u884c\u660e\u7ec6\u6d89\u53ca\u5230\u7684\u95e8\u5e97")
    @PostMapping(value={"initActivityPlanItemTerminal"})
    public Result initActivityPlanItemTerminal(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="ActivityPlanItemTerminalDto", value="\u95e8\u5e97\u6570\u636e\u67e5\u8be2") @RequestBody ActivityPlanItemTerminalDto dto) {
        String key = "activity_plan:lock:proportion:" + cacheKey;
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock(key, TimeUnit.MINUTES, 30L);
            if (!lockSuccess) {
                throw new RuntimeException("\u64cd\u4f5c\u6b63\u5728\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u6216\u91cd\u8bd5");
            }
            this.activityPlanItemTerminalService.initActivityPlanItemTerminal(dto, cacheKey);
            Result<Page<ActivityPlanItemTerminalVo>> result = this.findCachePageList(pageable, cacheKey, dto);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u6309\u5f53\u524d\u95e8\u5e97\u91cd\u65b0\u5206\u644a\u5408\u540c\u8d39\u7528")
    @PostMapping(value={"proportionPosByCurrTerminal"})
    public Result proportionPosByCurrTerminal(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="ActivityPlanItemTerminalDto", value="\u95e8\u5e97\u6570\u636e\u67e5\u8be2") @RequestBody ActivityPlanItemTerminalDto dto) {
        String key = "activity_plan:lock:proportion:" + cacheKey;
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock(key, TimeUnit.MINUTES, 30L);
            if (!lockSuccess) {
                throw new RuntimeException("\u64cd\u4f5c\u6b63\u5728\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u6216\u91cd\u8bd5");
            }
            this.activityPlanItemTerminalService.proportionPosByCurrTerminal(dto, cacheKey);
            Result<Page<ActivityPlanItemTerminalVo>> result = this.findCachePageList(pageable, cacheKey, dto);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(key);
            }
        }
    }
}

