/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanBudgetService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanVoService;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanBudgetSumVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.submitreportvo.ActivityPlanSubmitReportMainVo;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/activityPlan"})
@Api(tags={"\u6d3b\u52a8\u65b9\u6848\u8868"})
public class ActivityPlanVoController {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanVoController.class);
    @Autowired(required=false)
    private ActivityPlanService activityPlanService;
    @Autowired(required=false)
    private ActivityPlanVoService activityPlanVoService;
    @Autowired(required=false)
    private ActivityPlanItemService activityPlanItemService;
    @Autowired(required=false)
    private ActivityPlanBudgetService activityPlanBudgetService;

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u8d85\u9884\u7b97\u63d0\u793a")
    @PostMapping(value={"submitIsOverBudgetByIds"})
    public Result<List<String>> submitIsOverBudgetByIds(@ApiParam(value="\u7b56\u7565id\u96c6\u5408") @RequestParam List<String> ids) {
        try {
            List<String> msgs = this.activityPlanService.submitIsOverBudgetByIds(ids);
            return Result.ok(msgs);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b9\u6848\u5ba1\u6279\u9875\u9762\u662f\u5426\u8d85\u6536\u63d0\u793a")
    @PostMapping(value={"submitIsOverBudget"})
    public Result<List<String>> submitIsOverBudget(@ApiParam(name="processNo", value="\u6d41\u7a0b\u7f16\u53f7") @RequestParam String processNo) {
        try {
            List<String> msgs = this.activityPlanService.submitIsOverBudget(processNo);
            return Result.ok(msgs);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b9\u6848\u5ba1\u6279\u9875\u9762\u6c47\u603b")
    @PostMapping(value={"submitPageReport"})
    public Result<ActivityPlanSubmitReportMainVo> submitPageReport(@ApiParam(name="processNo", value="\u6d41\u7a0b\u7f16\u53f7") @RequestParam String processNo) {
        try {
            return Result.ok((Object)this.activityPlanService.submitPageReport(processNo));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b9\u6848\u5ba1\u6279\u9875\u9762\u6c47\u603b")
    @PostMapping(value={"modifySubmitPageReport"})
    public Result<ActivityPlanSubmitReportMainVo> modifySubmitPageReport(@ApiParam(name="processNo", value="\u6d41\u7a0b\u7f16\u53f7") @RequestParam String processNo) {
        try {
            return Result.ok((Object)this.activityPlanService.modifySubmitPageReport(processNo));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"findActivityPlanItemSumInfoByProcessNo"})
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Result<List<ActivityPlanItemVo>> findActivityPlanItemSumInfoByProcessNo(@RequestParam String processNo) {
        try {
            List<ActivityPlanItemVo> list = this.activityPlanVoService.findActivityPlanItemSumInfoByProcessNo(processNo);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)("\u9884\u7b97\u6c47\u603b\u4fe1\u606f\u67e5\u8be2\u5931\u8d25:" + e.getMessage()));
        }
    }

    @GetMapping(value={"findActivityPlanBudgetSumInfoByProcessNo"})
    public Result<List<ActivityPlanBudgetSumVo>> findActivityPlanBudgetSumInfoByProcessNo(@RequestParam String processNo) {
        try {
            List<ActivityPlanBudgetSumVo> list = this.activityPlanVoService.findActivityPlanBudgetSumInfoByProcessNo(processNo);
            return Result.ok(list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)("\u9884\u7b97\u6c47\u603b\u4fe1\u606f\u67e5\u8be2\u5931\u8d25:" + e.getMessage()));
        }
    }
}

