/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.exports.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.ie.sdk.process.MnExportProcess;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemService;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanItemPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityPlanItemExportByTemplateProcess
extends MnExportProcess {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanItemExportByTemplateProcess.class);
    @Autowired(required=false)
    private ActivityPlanItemService activityPlanItemService;
    @Autowired(required=false)
    private ActivityPlanItemPageCacheHelper pageCacheHelper;
    @Autowired(required=false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    protected static final ThreadLocal<ActivitiesTemplateConfigVo> templateConfigVoThreadLocal = new ThreadLocal();

    public Integer getTotal(Map<String, Object> params) {
        Object cacheKeyObj = params.get("cacheKey");
        Validate.notNull((Object)cacheKeyObj, (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        String cacheKey = cacheKeyObj.toString();
        Integer total = this.pageCacheHelper.getTotal(cacheKey);
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Object cacheKeyObj = params.get("cacheKey");
        Validate.notNull((Object)cacheKeyObj, (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        String cacheKey = cacheKeyObj.toString();
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        ActivityPlanItemDto dto = new ActivityPlanItemDto();
        Page cachePage = this.activityPlanItemService.findCachePageList((Pageable)pageable, dto, cacheKey);
        if (cachePage.getTotal() == 0L) {
            return new JSONArray();
        }
        List records = cachePage.getRecords();
        this.adjustData(cacheKey, records);
        return JSON.parseArray((String)JSON.toJSONString((Object)records, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
    }

    public String getBusinessCode() {
        return "TPM_ACTIVITY_PLAN_ITEM_BY_TEMPLATE_EXPORT";
    }

    public String getBusinessName() {
        return "\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6\u5bfc\u51fa-\u6309\u6a21\u677f\u914d\u7f6e";
    }

    private void adjustData(String cacheKey, Collection<ActivityPlanItemVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        ActivitiesTemplateConfigVo templateConfigVo = templateConfigVoThreadLocal.get();
        List dictFieldList = templateConfigVo.getDetails().stream().filter(item -> StringUtil.isNotEmpty((CharSequence)item.getDictCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dictFieldList)) {
            return;
        }
        List dictCodes = dictFieldList.stream().map(ActivitiesTemplateConfigDetailVo::getDictCode).distinct().collect(Collectors.toList());
        Map dictMap = this.dictDataVoService.findByDictTypeCodeList(dictCodes);
        Map<String, Map> dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> ((List)item.getValue()).stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> n)), (o, n) -> n));
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanItemVo.class);
        Map propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        for (ActivityPlanItemVo data : list) {
            data.setActivityType(data.getActivityTypeName());
            data.setActivityForm(data.getActivityFormName());
            for (ActivitiesTemplateConfigDetailVo activitiesTemplateConfigDetailVo : dictFieldList) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyMap.get(activitiesTemplateConfigDetailVo.getField());
                if (null == propertyDescriptor) continue;
                try {
                    Object originValue = propertyDescriptor.getReadMethod().invoke((Object)data, new Object[0]);
                    if (null == originValue) continue;
                    String originStrValue = originValue.toString();
                    Map thisDictMap = dictMapMap.get(activitiesTemplateConfigDetailVo.getDictCode());
                    propertyDescriptor.getWriteMethod().invoke((Object)data, thisDictMap.getOrDefault(originStrValue, originStrValue));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public List<List<String>> findHead(ExportTaskProcessVo task, Map<String, Object> paramsMap) {
        Object cacheKeyObj = paramsMap.get("cacheKey");
        Validate.notNull((Object)cacheKeyObj, (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        String cacheKey = cacheKeyObj.toString();
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        ActivitiesTemplateConfigVo templateConfigVo = this.activitiesTemplateSdkService.findByCode(templateCode);
        if (null == templateConfigVo) {
            throw new RuntimeException("\u6d3b\u52a8\u6a21\u677f\u914d\u7f6e[" + templateCode + "]\u67e5\u8be2\u5931\u8d25");
        }
        templateConfigVoThreadLocal.set(templateConfigVo);
        ArrayList result = Lists.newArrayList();
        for (ActivitiesTemplateConfigDetailVo detail : templateConfigVo.getDetails()) {
            if (null == detail.getVisible() || !detail.getVisible().booleanValue()) continue;
            result.add(Lists.newArrayList((Object[])new String[]{detail.getTitle()}));
        }
        return result;
    }

    public List<String> findCrmExcelColumnField(ExportTaskProcessVo task, Map<String, Object> paramsMap) {
        Object cacheKeyObj = paramsMap.get("cacheKey");
        Validate.notNull((Object)cacheKeyObj, (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        String cacheKey = cacheKeyObj.toString();
        ActivitiesTemplateConfigVo templateConfigVo = templateConfigVoThreadLocal.get();
        ArrayList list = Lists.newArrayList();
        for (ActivitiesTemplateConfigDetailVo detail : templateConfigVo.getDetails()) {
            if (null == detail.getVisible() || !detail.getVisible().booleanValue()) continue;
            list.add(detail.getField());
        }
        return list;
    }
}

