/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.exports.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.plan.local.exports.vo.ActivityPlanItemExportsVo;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemService;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanItemPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ActivityPlanItemExportsProcess
implements ExportProcess<ActivityPlanItemExportsVo> {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanItemExportsProcess.class);
    @Autowired(required=false)
    private ActivityPlanItemService activityPlanItemService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private ActivityPlanItemPageCacheHelper pageCacheHelper;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        Object cacheKeyObj = params.get("cacheKey");
        Validate.notNull((Object)cacheKeyObj, (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        String cacheKey = cacheKeyObj.toString();
        Integer total = this.pageCacheHelper.getTotal(cacheKey);
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Validate.notNull((Object)params.get("cacheKey"), (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        String cacheKey = (String)params.get("cacheKey");
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        ActivityPlanItemDto dto = new ActivityPlanItemDto();
        Page cachePage = this.activityPlanItemService.findCachePageList((Pageable)pageable, dto, cacheKey);
        if (cachePage.getTotal() == 0L) {
            return new JSONArray();
        }
        Collection exportsVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)cachePage.getRecords(), ActivityPlanItemVo.class, ActivityPlanItemExportsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.adjustData(exportsVos);
        return JSON.parseArray((String)JSON.toJSONString((Object)exportsVos));
    }

    public String getBusinessCode() {
        return "TPM_ACTIVITY_PLAN_ITEM_EXPORT";
    }

    public String getBusinessName() {
        return "\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6\u5bfc\u51fa";
    }

    private void adjustData(Collection<ActivityPlanItemExportsVo> data) {
        Map poMap = this.dictToolkitService.findMapByDictTypeCode("tpm_promotion_object");
        Map ptMap = this.dictToolkitService.findMapByDictTypeCode("tpm_activity_plan_promotion_type");
        Map atMap = this.dictToolkitService.findMapByDictTypeCode("tpm_audit_type");
        for (ActivityPlanItemExportsVo vo : data) {
            if (null != vo.getActivityBeginDate()) {
                vo.setActivityBeginDateStr(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)vo.getActivityBeginDate()));
            }
            if (null != vo.getActivityEndDate()) {
                vo.setActivityEndDateStr(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)vo.getActivityEndDate()));
            }
            if (null != vo.getOrderBeginDate()) {
                vo.setOrderBeginDateStr(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)vo.getOrderBeginDate()));
            }
            if (null != vo.getOrderEndDate()) {
                vo.setOrderEndDateStr(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM_dd, (Date)vo.getOrderEndDate()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getPromotionObject())) {
                vo.setPromotionObject(poMap.getOrDefault(vo.getPromotionObject(), vo.getPromotionObject()));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getPromotionType())) {
                vo.setPromotionType(ptMap.getOrDefault(vo.getPromotionType(), vo.getPromotionType()));
            }
            if (!StringUtils.isNotBlank((CharSequence)vo.getAuditType())) continue;
            vo.setAuditType(atMap.getOrDefault(vo.getAuditType(), vo.getAuditType()));
        }
    }

    public Class<ActivityPlanItemExportsVo> findCrmExcelVoClass() {
        return ActivityPlanItemExportsVo.class;
    }
}

