/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.imports;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.promoters.sdk.service.PromotersVoService;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.tpm.business.activity.plan.local.imports.vo.ActivityItemTerminalImportVo;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemTerminalService;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanItemPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemTerminalDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityItemTerminalImportsProcess
implements ImportProcess<ActivityItemTerminalImportVo> {
    private static final Logger log = LoggerFactory.getLogger(ActivityItemTerminalImportsProcess.class);
    @Autowired(required=false)
    private ActivityPlanItemTerminalService activityPlanItemTerminalService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private PromotersVoService promotersVoService;
    @Autowired(required=false)
    private ActivityPlanItemPageCacheHelper itemHelper;

    public Map<Integer, String> execute(LinkedHashMap<Integer, ActivityItemTerminalImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        String cacheKey = (String)params.get("cacheKey");
        Validate.isTrue((!StringUtils.isEmpty((CharSequence)cacheKey) ? 1 : 0) != 0, (String)"\u7f13\u5b58key\u4e0d\u80fd\u7a7a", (Object[])new Object[0]);
        HashMap errorMap = Maps.newHashMap();
        List<ActivityPlanItemTerminalDto> itemTerminalDtoList = this.buildData(data, errorMap, cacheKey);
        if (errorMap.size() == 0) {
            this.activityPlanItemTerminalService.importNewItem(cacheKey, itemTerminalDtoList);
        }
        return errorMap;
    }

    private List<ActivityPlanItemTerminalDto> buildData(LinkedHashMap<Integer, ActivityItemTerminalImportVo> data, Map<Integer, String> errorMap, String cacheKey) {
        Object value;
        String itemId;
        if (CollectionUtils.isEmpty(data.values())) {
            return null;
        }
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        ActivityPlanItemDto itemDto = (ActivityPlanItemDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1));
        if (null == itemDto) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
        }
        List<Object> existsTerminalCodeList = Lists.newArrayList();
        List itemTerminalList = itemDto.getActivityPlanItemTerminalList();
        if (null != itemTerminalList) {
            existsTerminalCodeList = itemTerminalList.stream().map(ActivityPlanItemTerminalDto::getTerminalCode).collect(Collectors.toList());
        }
        HashMap errorListMap = Maps.newHashMap();
        Set<Map.Entry<Integer, ActivityItemTerminalImportVo>> dataEntry = data.entrySet();
        HashSet terminalCodeSet = Sets.newHashSet();
        HashSet employeeCodeSet = Sets.newHashSet();
        for (Map.Entry<Integer, ActivityItemTerminalImportVo> entry : dataEntry) {
            ActivityItemTerminalImportVo value2 = entry.getValue();
            Integer key = entry.getKey();
            List list = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());
            try {
                if (StringUtils.isEmpty((CharSequence)value2.getTerminalCode())) {
                    list.add("\u7ec8\u7aef\u7f16\u7801\u5fc5\u987b\u8f93\u5165");
                } else {
                    terminalCodeSet.add(value2.getTerminalCode());
                }
                if (Objects.nonNull(value2.getFloatingRate()) && (value2.getFloatingRate().compareTo(BigDecimal.ZERO) < 0 || value2.getFloatingRate().compareTo(BigDecimal.ONE) > 0)) {
                    list.add("\u6d6e\u52a8\u7387\u53ea\u80fd\u57280\u52301\u4e4b\u95f4");
                }
                if (StringUtils.isEmpty((CharSequence)value2.getEmployeeCode())) {
                    employeeCodeSet.add(value2.getEmployeeCode());
                }
                if (null == value2.getAmount()) {
                    list.add("\u8d39\u7528\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null != value2.getFeeAmount()) continue;
                list.add("\u6211\u65b9\u627f\u62c5\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            catch (Exception e) {
                list.add(e.getMessage());
            }
        }
        Map<Object, Object> terminalVoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)terminalCodeSet)) {
            List terminalVoList = this.terminalVoService.findDetailsByIdsOrTerminalCodes(null, new ArrayList(terminalCodeSet));
            terminalVoMap = terminalVoList.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity(), (o, n) -> n));
        }
        Map<Object, Object> promotersVoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)employeeCodeSet)) {
            List promotersVoList = this.promotersVoService.findByCodes(new ArrayList(employeeCodeSet));
            promotersVoMap = promotersVoList.stream().collect(Collectors.toMap(PromotersVo::getEmployeeCode, Function.identity(), (o, n) -> n));
        }
        ArrayList activityPlanItemTerminalDtos = Lists.newArrayList();
        for (Map.Entry<Integer, ActivityItemTerminalImportVo> entry : dataEntry) {
            value = entry.getValue();
            Integer key = entry.getKey();
            List errorList = errorListMap.computeIfAbsent(key, k -> Lists.newArrayList());
            try {
                ActivityPlanItemTerminalDto activityPlanItemTerminalDto = (ActivityPlanItemTerminalDto)this.nebulaToolkitService.copyObjectByWhiteList(value, ActivityPlanItemTerminalDto.class, HashSet.class, ArrayList.class, new String[0]);
                activityPlanItemTerminalDtos.add(activityPlanItemTerminalDto);
                if (StringUtils.isNotEmpty((CharSequence)activityPlanItemTerminalDto.getTerminalCode())) {
                    TerminalVo terminalVo = (TerminalVo)terminalVoMap.get(activityPlanItemTerminalDto.getTerminalCode());
                    if (terminalVo == null) {
                        errorList.add("\u7ec8\u7aef" + activityPlanItemTerminalDto.getTerminalCode() + "\u4e0d\u5b58\u5728");
                    } else {
                        if (!EnableStatusEnum.ENABLE.getCode().equals(terminalVo.getEnableStatus()) || !BooleanEnum.TRUE.getNumStr().equals(terminalVo.getTerminalState())) {
                            errorList.add("\u65b9\u6848\u4e2d\u5305\u542b\u5df2\u88ab\u7981\u7528\u3001\u5df2\u5173\u95ed\u7684\u95e8\u5e97\uff0c\u95e8\u5e97\u7f16\u7801\u4e3a" + terminalVo.getTerminalCode() + ",\u8bf7\u6821\u5bf9\u540e\u518d\u63d0\u4ea4");
                        }
                        activityPlanItemTerminalDto.setTerminalName(terminalVo.getTerminalName());
                    }
                    if (existsTerminalCodeList.contains(activityPlanItemTerminalDto.getTerminalCode())) {
                        errorList.add("\u95e8\u5e97\u7f16\u7801" + terminalVo.getTerminalCode() + "\u91cd\u590d\u6dfb\u52a0");
                    }
                    existsTerminalCodeList.add(activityPlanItemTerminalDto.getTerminalCode());
                }
                if (!StringUtils.isNotEmpty((CharSequence)activityPlanItemTerminalDto.getEmployeeCode())) continue;
                PromotersVo promotersVo = (PromotersVo)promotersVoMap.get(activityPlanItemTerminalDto.getEmployeeCode());
                if (promotersVo == null) {
                    errorList.add("\u4fc3\u9500\u4eba\u5458" + activityPlanItemTerminalDto.getEmployeeCode() + "\u4e0d\u5b58\u5728");
                    continue;
                }
                activityPlanItemTerminalDto.setEmpId(promotersVo.getEmpId());
                activityPlanItemTerminalDto.setIdentityCard(promotersVo.getIdentityCard());
                activityPlanItemTerminalDto.setResponsibleSupervision(promotersVo.getResponsibleSupervision());
                activityPlanItemTerminalDto.setName(promotersVo.getName());
                activityPlanItemTerminalDto.setPhone(promotersVo.getPhone());
                activityPlanItemTerminalDto.setResponsibleSupervision(promotersVo.getResponsibleSupervision());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                errorList.add(e.getMessage());
            }
        }
        if (errorListMap.size() > 0) {
            for (Map.Entry<Integer, ActivityItemTerminalImportVo> entry : errorListMap.entrySet()) {
                value = (List)((Object)entry.getValue());
                if (value.size() <= 0) continue;
                errorMap.put(entry.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)value));
            }
        }
        return activityPlanItemTerminalDtos;
    }

    public Class<ActivityItemTerminalImportVo> findCrmExcelVoClass() {
        return ActivityItemTerminalImportVo.class;
    }

    public String getTemplateCode() {
        return "ACTIVITY_ITEM_TERMINAL";
    }

    public String getTemplateName() {
        return "tpm-\u65b9\u6848\u660e\u7ec6\u7ec8\u7aef\u5bfc\u5165";
    }
}

