/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.imports;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.brand.sdk.service.ProductBrandService;
import com.biz.crm.mdm.business.product.brand.sdk.vo.ProductBrandVo;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgRangeDto;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.supplier.sdk.service.SupplierVoService;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mdm.business.terminal.channel.sdk.service.MdmTerminalChannelVoService;
import com.biz.crm.mdm.business.terminal.channel.sdk.vo.MdmTerminalChannelVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.plan.local.imports.vo.ActivityPlanItemDY00000008SupplyHeadImportVo;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanItemPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityPlanItemDY00000008SupplyHeadImportsProcess
implements ImportProcess<ActivityPlanItemDY00000008SupplyHeadImportVo> {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanItemDY00000008SupplyHeadImportsProcess.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityPlanItemPageCacheHelper activityPlanItemPageCacheHelper;
    @Autowired(required=false)
    private SupplierVoService supplierVoService;
    @Autowired(required=false)
    private ActivityTypeService activityTypeService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private MdmTerminalChannelVoService terminalChannelVoService;
    @Autowired(required=false)
    private ProductBrandService productBrandService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private AuditFormulaMainService auditFormulaMainService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;

    public Map<Integer, String> execute(LinkedHashMap<Integer, ActivityPlanItemDY00000008SupplyHeadImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        try {
            List auditFormulaList;
            List orgVos;
            List supplierVos;
            List channelVos;
            Object businessFormatCodeObj = params.get("businessFormatCode");
            if (null == businessFormatCodeObj) {
                throw new RuntimeException("\u4e1a\u6001\u6709\u8bef\uff01");
            }
            String businessFormatCode = String.valueOf(businessFormatCodeObj);
            ArrayList importVos = Lists.newArrayList(data.values());
            HashSet orgCodeSet = Sets.newHashSet();
            HashSet activityTypeCodeSet = Sets.newHashSet();
            HashSet activityFormCodeSet = Sets.newHashSet();
            HashSet monthBudgetCodeSet = Sets.newHashSet();
            HashSet terminalChannelSet = Sets.newHashSet();
            HashSet productBrandCodeSet = Sets.newHashSet();
            HashSet productLevelCodeSet = Sets.newHashSet();
            HashSet productCodeSet = Sets.newHashSet();
            HashSet salesOrgCodeSet = Sets.newHashSet();
            HashSet salesInsErpCodeSet = Sets.newHashSet();
            HashSet salesInsCodeSet = Sets.newHashSet();
            HashSet supplierCodeSet = Sets.newHashSet();
            HashSet materialCodeSet = Sets.newHashSet();
            HashSet auditFormulaCodeSet = Sets.newHashSet();
            HashSet cusChannelCodeSet = Sets.newHashSet();
            for (ActivityPlanItemDY00000008SupplyHeadImportVo importVo : importVos) {
                List<String> channelCodes;
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityTypeCode())) {
                    List<String> typeCodes = Arrays.asList(importVo.getActivityTypeCode().split(","));
                    activityTypeCodeSet.addAll(typeCodes);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityFormCode())) {
                    List<String> formCodes = Arrays.asList(importVo.getActivityFormCode().split(","));
                    activityFormCodeSet.addAll(formCodes);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getHeadMonthBudgetCode())) {
                    monthBudgetCodeSet.add(importVo.getHeadMonthBudgetCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getChannelCode())) {
                    cusChannelCodeSet.add(importVo.getChannelCode());
                }
                Validate.notBlank((CharSequence)importVo.getSalesInstitutionCode(), (String)"\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                salesInsErpCodeSet.add(importVo.getSalesInstitutionCode());
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityOrgCode())) {
                    Validate.notBlank((CharSequence)importVo.getChannelCode(), (String)"\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    salesInsCodeSet.add(importVo.getChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode());
                    salesOrgCodeSet.add(importVo.getActivityOrgCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getFirstChannelCode())) {
                    channelCodes = Arrays.asList(importVo.getFirstChannelCode().split(","));
                    terminalChannelSet.addAll(channelCodes);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getSecondChannelCode())) {
                    channelCodes = Arrays.asList(importVo.getSecondChannelCode().split(","));
                    terminalChannelSet.addAll(channelCodes);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getSupplierCode())) {
                    supplierCodeSet.add(importVo.getSupplierCode());
                }
                if (!StringUtils.isNotEmpty((CharSequence)importVo.getAuditConditionCode())) continue;
                auditFormulaCodeSet.add(importVo.getAuditConditionCode());
            }
            Map salesMap = Maps.newHashMap();
            Map<Object, Object> salesInsMap = Maps.newHashMap();
            Map<Object, Object> activityTypeMap = Maps.newHashMap();
            Map activityFormMap = Maps.newHashMap();
            Map<Object, Object> monthBudgetMap = Maps.newHashMap();
            Map<Object, Object> terminalChannelMap = Maps.newHashMap();
            Map<Object, Object> supplierMap = Maps.newHashMap();
            Map<Object, Object> auditFormulaMap = Maps.newHashMap();
            Map<Object, Object> cusChannelMap = Maps.newHashMap();
            Map<Object, Object> productBrandMap = Maps.newHashMap();
            Map<Object, Object> productLevelMap = Maps.newHashMap();
            Map<Object, Object> productMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty((Collection)activityTypeCodeSet)) {
                List activityTypeList = this.activityTypeService.findByCodes((List)Lists.newArrayList((Iterable)activityTypeCodeSet));
                activityTypeMap = activityTypeList.stream().collect(Collectors.toMap(ActivityTypeVo::getActivityTypeCode, ActivityTypeVo::getActivityTypeName, (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)activityFormCodeSet)) {
                ArrayList activityFormCodeList = Lists.newArrayList((Iterable)activityFormCodeSet);
                ArrayList activityFormCodeListBag = Lists.newArrayList();
                activityFormCodeListBag.add(activityFormCodeList);
                activityFormMap = this.activityFormService.findFormByCodes((List)activityFormCodeListBag);
            }
            if (!CollectionUtils.isEmpty((Collection)monthBudgetCodeSet)) {
                List monthBudgetVos = this.monthBudgetService.listByCodes((List)Lists.newArrayList((Iterable)monthBudgetCodeSet));
                monthBudgetMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity(), (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)cusChannelCodeSet) && !CollectionUtils.isEmpty((Collection)(channelVos = this.customerChannelVoService.findByCodes(new ArrayList(cusChannelCodeSet))))) {
                cusChannelMap = channelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity(), (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)supplierCodeSet)) {
                supplierVos = this.supplierVoService.findBySupplierCodes((List)Lists.newArrayList((Iterable)supplierCodeSet));
                supplierMap = supplierVos.stream().collect(Collectors.toMap(SupplierVo::getSupplierCode, Function.identity()));
            }
            if (!CollectionUtils.isEmpty((Collection)salesOrgCodeSet)) {
                SalesOrgRangeDto rangeDto = new SalesOrgRangeDto();
                rangeDto.setSalesInstitutionCodes(new ArrayList(salesInsCodeSet));
                rangeDto.setErpCodes(new ArrayList(salesOrgCodeSet));
                salesMap = this.salesOrgVoService.findMapBySalesOrgErpCodesAndInsCodes(rangeDto);
            }
            if (!CollectionUtils.isEmpty((Collection)salesInsErpCodeSet) && !CollectionUtils.isEmpty((Collection)(orgVos = this.salesOrgVoService.findByErpCodeList(new ArrayList(salesInsErpCodeSet))))) {
                salesInsMap = orgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity(), (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)terminalChannelSet)) {
                List mdmTerminalChannelVos = this.terminalChannelVoService.listByCodes((List)Lists.newArrayList((Iterable)terminalChannelSet));
                terminalChannelMap = mdmTerminalChannelVos.stream().collect(Collectors.toMap(MdmTerminalChannelVo::getTerminalChannelCode, MdmTerminalChannelVo::getTerminalChannelName, (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)productBrandCodeSet)) {
                List productBrandVos = this.productBrandService.listByCodes((List)Lists.newArrayList((Iterable)productBrandCodeSet));
                productBrandMap = productBrandVos.stream().collect(Collectors.toMap(ProductBrandVo::getProductBrandCode, ProductBrandVo::getProductBrandName, (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)productLevelCodeSet)) {
                List productLevelVos = this.productLevelVoSdkService.findListByBusinessFormatAndCodes(businessFormatCode, (List)Lists.newArrayList((Iterable)productLevelCodeSet));
                productLevelMap = productLevelVos.stream().collect(Collectors.toMap(ProductLevelVo::getProductLevelCode, ProductLevelVo::getProductLevelName, (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)productCodeSet)) {
                List productVos = this.productVoService.findByCodes((List)Lists.newArrayList((Iterable)productCodeSet));
                productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (o, n) -> n));
            }
            if (!CollectionUtils.isEmpty((Collection)supplierCodeSet)) {
                supplierVos = this.supplierVoService.findBySupplierCodes((List)Lists.newArrayList((Iterable)supplierCodeSet));
                supplierMap = supplierVos.stream().collect(Collectors.toMap(SupplierVo::getSupplierCode, Function.identity()));
            }
            if (!CollectionUtils.isEmpty((Collection)auditFormulaCodeSet) && !CollectionUtils.isEmpty((Collection)(auditFormulaList = this.auditFormulaMainService.findByCodeList((List)Lists.newArrayList((Iterable)auditFormulaCodeSet))))) {
                auditFormulaMap = auditFormulaList.stream().collect(Collectors.toMap(AuditFormulaMainVo::getAuditFormulaCode, Function.identity(), (o, n) -> n));
            }
            Map dictDataMap = this.dictDataVoService.findByDictTypeCodeList(Arrays.asList("tpm_audit_type"));
            ArrayList newList = Lists.newArrayList();
            for (ActivityPlanItemDY00000008SupplyHeadImportVo importVo : importVos) {
                String terminalChannelName;
                String insCode;
                LinkedList<String> allNames;
                String[] codes;
                ActivityPlanItemDto itemDto = (ActivityPlanItemDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)importVo, ActivityPlanItemDto.class, HashSet.class, ArrayList.class, new String[0]);
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityBeginDateStr())) {
                    Validate.isTrue((boolean)this.isFlag(importVo.getActivityBeginDateStr()), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff01", (Object[])new Object[0]);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityEndDateStr())) {
                    Validate.isTrue((boolean)this.isFlag(importVo.getActivityEndDateStr()), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff01", (Object[])new Object[0]);
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityTypeCode())) {
                    codes = importVo.getActivityTypeCode().split(",");
                    allNames = new LinkedList<String>();
                    for (String code : codes) {
                        String activityTypeName = (String)activityTypeMap.get(code);
                        if (StringUtils.isEmpty((CharSequence)activityTypeName)) {
                            throw new RuntimeException("\u6d3b\u52a8\u5206\u7c7b[" + code + "]\u6709\u8bef");
                        }
                        allNames.add(activityTypeName);
                    }
                    itemDto.setActivityTypeName(String.join((CharSequence)",", allNames));
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityFormCode())) {
                    codes = importVo.getActivityFormCode().split(",");
                    allNames = new LinkedList();
                    for (String code : codes) {
                        String activityFormName = (String)activityFormMap.get(code);
                        if (StringUtils.isEmpty((CharSequence)activityFormName)) {
                            throw new RuntimeException("\u6d3b\u52a8\u5f62\u5f0f[" + code + "]\u6709\u8bef");
                        }
                        allNames.add(activityFormName);
                    }
                    itemDto.setActivityForm(importVo.getActivityFormCode());
                    itemDto.setActivityFormName(String.join((CharSequence)",", allNames));
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getChannelCode())) {
                    CustomerChannelVo channelVo = (CustomerChannelVo)cusChannelMap.get(importVo.getChannelCode());
                    if (null == channelVo) {
                        throw new RuntimeException("\u6e20\u9053\u7f16\u7801[" + importVo.getChannelCode() + "]\u6709\u8bef");
                    }
                    itemDto.setDistributionChannelCode(channelVo.getCustomerChannelCode());
                    itemDto.setDistributionChannelName(channelVo.getCustomerChannelName());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getSupplierCode())) {
                    SupplierVo supplierVo = (SupplierVo)supplierMap.get(importVo.getSupplierCode());
                    if (null == supplierVo) {
                        throw new RuntimeException("\u4f9b\u5e94\u5546[" + importVo.getSupplierCode() + "]\u6709\u8bef");
                    }
                    itemDto.setSupplierCode(supplierVo.getSupplierCode());
                    itemDto.setSupplierName(supplierVo.getSupplierName());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getSalesInstitutionCode())) {
                    insCode = importVo.getChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode();
                    Validate.isTrue((boolean)salesInsMap.containsKey(insCode), (String)("\u9500\u552e\u673a\u6784[" + importVo.getSalesInstitutionCode() + "]\u6709\u8bef"), (Object[])new Object[0]);
                    SalesOrgVo salesOrgVo = (SalesOrgVo)salesInsMap.get(insCode);
                    itemDto.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
                    itemDto.setSalesInstitutionCode(salesOrgVo.getSalesOrgCode());
                    itemDto.setSalesInstitutionErpCode(salesOrgVo.getErpCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getActivityOrgCode())) {
                    insCode = importVo.getChannelCode() + businessFormatCode + importVo.getSalesInstitutionCode();
                    Map salesOrgVoMap = (Map)salesMap.get(insCode);
                    if (salesOrgVoMap.isEmpty()) {
                        throw new RuntimeException("\u533a\u57df\u7f16\u7801[" + importVo.getActivityOrgCode() + "]\u672a\u5728\u9500\u552e\u673a\u6784[" + importVo.getSalesInstitutionCode() + "]\u4e0b");
                    }
                    SalesOrgVo salesOrgVo = (SalesOrgVo)salesOrgVoMap.get(importVo.getActivityOrgCode());
                    if (Objects.isNull(salesOrgVo)) {
                        throw new RuntimeException("\u533a\u57df\u7f16\u7801[" + importVo.getActivityOrgCode() + "]\u672a\u5728\u9500\u552e\u673a\u6784[" + importVo.getSalesInstitutionCode() + "]\u4e0b");
                    }
                    itemDto.setActivityOrgName(salesOrgVo.getSalesOrgName());
                    itemDto.setActivityOrgCode(salesOrgVo.getSalesOrgCode());
                    itemDto.setActivityOrgErpCode(salesOrgVo.getErpCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getFirstChannelCode())) {
                    codes = importVo.getFirstChannelCode().split(",");
                    allNames = new LinkedList();
                    for (String code : codes) {
                        terminalChannelName = (String)terminalChannelMap.get(code);
                        if (StringUtils.isEmpty((CharSequence)terminalChannelName)) {
                            throw new RuntimeException("\u4e00\u7ea7\u6e20\u9053[" + importVo.getFirstChannelCode() + "]\u6709\u8bef");
                        }
                        allNames.add(terminalChannelName);
                    }
                    itemDto.setFirstChannelName(String.join((CharSequence)",", allNames));
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getSecondChannelCode())) {
                    codes = importVo.getSecondChannelCode().split(",");
                    allNames = new LinkedList();
                    for (String code : codes) {
                        terminalChannelName = (String)terminalChannelMap.get(code);
                        if (StringUtils.isEmpty((CharSequence)terminalChannelName)) {
                            throw new RuntimeException("\u4e8c\u7ea7\u6e20\u9053[" + importVo.getSecondChannelCode() + "]\u6709\u8bef");
                        }
                        allNames.add(terminalChannelName);
                    }
                    itemDto.setSecondChannelName(String.join((CharSequence)",", allNames));
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getHeadMonthBudgetCode())) {
                    MonthBudgetVo monthBudgetVo = (MonthBudgetVo)monthBudgetMap.get(importVo.getHeadMonthBudgetCode());
                    if (null == monthBudgetVo) {
                        throw new RuntimeException("\u603b\u90e8\u8d39\u7528\u9884\u7b97\u7f16\u7801" + importVo.getHeadMonthBudgetCode() + "\u6709\u8bef");
                    }
                    itemDto.setHeadBudgetItemCode(monthBudgetVo.getBudgetItemCode());
                    itemDto.setHeadBudgetItemName(monthBudgetVo.getBudgetItemName());
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getAuditType())) {
                    DictDataVo auditType = ((List)dictDataMap.get("tpm_audit_type")).stream().filter(e -> e.getDictValue().equals(importVo.getAuditType())).findFirst().orElse(null);
                    if (auditType == null) {
                        throw new IllegalArgumentException("\u6838\u9500\u7c7b\u578b\u3010" + importVo.getAuditType() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                    importVo.setAuditType(auditType.getDictCode());
                    if (TpmAuditTypeEnum.AUDITTYPE2.getValue().equals(auditType.getDictValue())) {
                        Validate.notBlank((CharSequence)importVo.getAuditConditionCode(), (String)"\u6838\u9500\u6761\u4ef6\u7f16\u7801\u5fc5\u586b\uff01", (Object[])new Object[0]);
                        AuditFormulaMainVo auditFormula = (AuditFormulaMainVo)auditFormulaMap.get(importVo.getAuditConditionCode());
                        if (auditFormula == null) {
                            throw new RuntimeException("\u6838\u9500\u6761\u4ef6[" + importVo.getAuditConditionCode() + "]\u6709\u8bef");
                        }
                        itemDto.setAuditConditionName(auditFormula.getAuditFormulaName());
                    }
                }
                newList.add(itemDto);
            }
            this.activityPlanItemPageCacheHelper.importNewItem(String.valueOf(params.get("cacheKey")), newList);
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            String errorMsg = e2.getMessage();
            if (StringUtils.isEmpty((CharSequence)e2.getMessage())) {
                errorMsg = "\u6570\u636e\u5904\u7406\u5931\u8d25\uff01";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return null;
    }

    private boolean isFlag(String currentTime) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        boolean flag = true;
        try {
            dtf.parse(currentTime);
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public Class<ActivityPlanItemDY00000008SupplyHeadImportVo> findCrmExcelVoClass() {
        return ActivityPlanItemDY00000008SupplyHeadImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_ACTIVITY_PLAN_IMPORT_SUPPLY_DY00000008_HEAD";
    }

    public String getTemplateName() {
        return "\u4f9b\u5e94\u5546\u6d3b\u52a8\uff08\u4e3b\u4f53_\u603b\u90e8\u65b9\u6848\uff09";
    }

    public String getBusinessCode() {
        return "TPM_ACTIVITY_PLAN_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6\u5bfc\u5165";
    }
}

