/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.job;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanModifyService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ActivityPlanVerticalPersonUpdateJob {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanVerticalPersonUpdateJob.class);
    @Autowired(required=false)
    private ActivityPlanModifyService activityPlanModifyService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"verticalPersonUpdateJob"})
    @DynamicTaskService(cornExpression="0 0 2 * * ?", taskDesc="\u5782\u76f4\u4fc3\u9500\u4eba\u5458\u53d8\u66f4\u66f4\u65b0\u6d3b\u52a8\u65b9\u6848\u4efb\u52a1")
    public void verticalPersonUpdateJob() {
        boolean hasLock = false;
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String key = "activity_plan:lock:vertical_person_update_job:" + sdf.format(date);
        try {
            hasLock = this.redisLockService.tryLock(key, TimeUnit.MINUTES, 30L);
            if (!hasLock) {
                return;
            }
            log.info("=====>    \u5782\u76f4\u4fc3\u9500\u4eba\u5458\u53d8\u66f4\u66f4\u65b0\u6d3b\u52a8\u65b9\u6848\u4efb\u52a1[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
            this.loginUserService.refreshAuthentication(null);
            this.activityPlanModifyService.verticalPersonUpdateJob();
            log.info("=====>    \u5782\u76f4\u4fc3\u9500\u4eba\u5458\u53d8\u66f4\u66f4\u65b0\u6d3b\u52a8\u65b9\u6848\u4efb\u52a1[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
        }
        finally {
            this.redisLockService.unlock(key);
        }
    }
}

