/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.listener;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.rocketmq.event.RocketMqProducerEvent;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanService;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanPassMqTagEnum;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityPlanProcessCompleteListener
implements ProcessCompleteListener {
    @Autowired(required=false)
    private ActivityPlanService activityPlanService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Resource
    private ApplicationEventPublisher eventPublisher;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public String getBusinessCode() {
        return "activity_plan";
    }

    public void onProcessComplete(ProcessStatusDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getBusinessNo())) {
            return;
        }
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty((CharSequence)dto.getProcessNo(), (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            this.activityPlanService.processPass(dto);
            this.passPushMq(dto.getProcessNo(), dto.getBusinessNoList());
        }
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) || ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            this.activityPlanService.processRejectAndRecover(dto);
        }
    }

    private void passPushMq(String processNo, List<String> businessNoList) {
        if (CollectionUtils.isEmpty(businessNoList)) {
            return;
        }
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String accountJson = "";
        String currentAccount = "";
        if (this.loginUserService != null) {
            currentAccount = this.loginUserService.getLoginAccountName();
            AbstractCrmUserIdentity userIdentity = this.loginUserService.getAbstractLoginUser();
            accountJson = Objects.isNull(userIdentity) ? null : JSON.toJSONString((Object)userIdentity);
        }
        for (ActivityPlanPassMqTagEnum mqTagEnum : ActivityPlanPassMqTagEnum.values()) {
            RocketMqProducerEvent rocketMqProducerEvent = new RocketMqProducerEvent((Object)this, currentAccount, accountJson, false, uuid, "TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment(), mqTagEnum.getCode(), JSON.toJSONString(businessNoList));
            this.eventPublisher.publishEvent((ApplicationEvent)rocketMqProducerEvent);
        }
    }
}

