/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.modify.consumer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanModifyService;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.enums.ActivityPlanModifyMqTagEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@RocketMQMessageListener(topic="TPM_ACTIVITY_PLAN_MODIFY_PROCESS_PASS_TOPIC${rocketmq.environment}", selectorExpression="TPM_ACTIVITY_PLAN_MODIFY_PASS_UPDATE_ORIGIN", consumerGroup="TPM_ACTIVITY_PLAN_MODIFY_PASS_UPDATE_ORIGIN${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY, messageModel=MessageModel.CLUSTERING)
public class ActivityPlanModifyPassUpdatePlanConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanModifyPassUpdatePlanConsumer.class);
    @Autowired
    private ActivityPlanModifyService activityPlanModifyService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;

    protected Object handleMessage(MqMessageVo message) {
        log.info(ActivityPlanModifyMqTagEnum.PASS_UPDATE_ORIGIN.getName() + " order mq message received  : {}", (Object)message);
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        try {
            String businessNo = message.getMsgBody();
            ActivityPlanModifyDto activityPlanModifyDto = this.activityPlanModifyService.doUpdateOriginData(businessNo);
            this.passPushMq(businessNo);
            this.updateHeadSchemeForecast(activityPlanModifyDto);
        }
        catch (Exception e) {
            log.error(ActivityPlanModifyMqTagEnum.PASS_UPDATE_ORIGIN.getName() + "\u5904\u7406\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "\u6d88\u8d39\u5931\u8d25." + e.getMessage();
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }

    private void updateHeadSchemeForecast(ActivityPlanModifyDto activityPlanModifyDto) {
        String businessUnitCode = activityPlanModifyDto.getBusinessUnitCode();
        if (!BusinessUnitEnum.isDefaultBusinessUnit((String)businessUnitCode)) {
            return;
        }
        MqMessageVo mqMessageVo = new MqMessageVo();
        mqMessageVo.setTopic("TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
        mqMessageVo.setTag("PASS_TPM_HEAD_SCHEME_FORECAST");
        mqMessageVo.setMsgBody(JSONObject.toJSONString((Object)Lists.newArrayList((Object[])new String[]{activityPlanModifyDto.getPlanCode()})));
        this.rocketMqProducer.sendMqMsg(mqMessageVo, 10L);
    }

    private void passPushMq(String businessNo) {
        if (StringUtils.isEmpty((CharSequence)businessNo)) {
            return;
        }
        ArrayList pushTagList = Lists.newArrayList();
        for (ActivityPlanModifyMqTagEnum mqTagEnum : ActivityPlanModifyMqTagEnum.values()) {
            if (!ActivityPlanModifyMqTagEnum.PushType.after_update_origin.equals((Object)mqTagEnum.getPushType())) continue;
            pushTagList.add(mqTagEnum);
        }
        if (CollectionUtils.isEmpty((Collection)pushTagList)) {
            return;
        }
        for (ActivityPlanModifyMqTagEnum mqTagEnum : pushTagList) {
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(businessNo);
            mqMessageVo.setTopic("TPM_ACTIVITY_PLAN_MODIFY_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(mqTagEnum.getCode());
            this.rocketMqProducer.sendMqMsg(mqMessageVo);
        }
    }
}

