/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.modify.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanItemModifyService;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanModifyService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanModifyApproveSubmitDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/activityPlanModify"})
@Api(tags={"\u6d3b\u52a8\u65b9\u6848\u53d8\u66f4\u8868"})
public class ActivityPlanModifyController {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanModifyController.class);
    @Autowired(required=false)
    private ActivityPlanModifyService activityPlanModifyService;
    @Autowired(required=false)
    private ActivityPlanItemModifyService activityPlanItemModifyService;

    @ApiOperation(value="\u83b7\u53d6\u5f85\u8c03\u6574\u7684\u65b9\u6848\u6570\u636e")
    @GetMapping(value={"findToModifyList"})
    public Result<Page<ActivityPlanVo>> findToModifyList(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u67e5\u8be2\u6761\u4ef6") ActivityPlanDto dto) {
        try {
            Page<ActivityPlanVo> page = this.activityPlanModifyService.findToModifyList(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7id\u83b7\u53d6\u6d3b\u52a8\u65b9\u6848\u53d8\u66f4\u6570\u636e")
    @GetMapping(value={"findById"})
    public Result<ActivityPlanModifyVo> findById(@ApiParam(value="id") @RequestParam(required=false) String id, @ApiParam(value="code") @RequestParam(required=false) String code) {
        try {
            ActivityPlanModifyVo vo = this.activityPlanModifyService.findByIdOrCode(id, code);
            return Result.ok((Object)vo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping(value={"create"})
    public Result<?> create(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="dto", value="\u5b9e\u4f53\u5bf9\u8c61") @RequestBody ActivityPlanModifyDto dto) {
        try {
            this.activityPlanModifyService.create(cacheKey, dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u6570\u636e")
    @PatchMapping(value={"update"})
    public Result<?> update(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="dto", value="\u5206\u5b50\u516c\u53f8\u7ec6\u6848\u53d8\u66f4\u8868\u5934") @RequestBody ActivityPlanModifyDto dto) {
        try {
            if (StringUtils.isEmpty((CharSequence)dto.getId())) {
                throw new RuntimeException("\u7f16\u8f91\u64cd\u4f5c\u53c2\u6570\u6709\u8bef");
            }
            this.activityPlanModifyService.create(cacheKey, dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279\u6d41")
    @PostMapping(value={"/submit"})
    public Result submit(@RequestBody ActivityPlanModifyApproveSubmitDto dto) {
        try {
            this.activityPlanModifyService.submit(dto);
            return Result.ok((String)"\u63d0\u4ea4\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"delete"})
    public Result delete(@ApiParam(value="\u7b56\u7565id\u96c6\u5408") @RequestParam List<String> ids) {
        try {
            this.activityPlanModifyService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba1\u6279\u901a\u8fc7\u9000\u9884\u7b97")
    @PostMapping(value={"passReturnMonthBudgetByModifyCode"})
    public Result passReturnMonthBudgetByModifyCode(@ApiParam(value="\u65b9\u6848\u53d8\u66f4\u7f16\u7801") @RequestParam String modifyBusinessCode) {
        try {
            this.activityPlanModifyService.passReturnMonthBudgetByModifyCode(modifyBusinessCode);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

