/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.modify.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.activity.plan.local.exports.vo.StoreDetailsExportVo;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanItemTerminalModifyService;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemTerminalModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanItemTerminalModifyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class StoreDetailsModifyExportProcess
implements ExportProcess<StoreDetailsExportVo> {
    private static final Logger log = LoggerFactory.getLogger(StoreDetailsModifyExportProcess.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private ActivityPlanItemTerminalModifyService activityPlanItemTerminalService;

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        Validate.notNull((Object)params.get("cacheKey"), (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        Integer total = this.getTotal((String)params.get("cacheKey"));
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    public Integer getTotal(String cacheKey) {
        return this.activityPlanItemTerminalService.findCacheList(cacheKey).size();
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Validate.notNull((Object)params.get("cacheKey"), (String)"\u7f13\u5b58\u952e\uff0c\u53c2\u6570\u672a\u4f20\u5165", (Object[])new Object[0]);
        String cacheKey = (String)params.get("cacheKey");
        PageRequest pageable = PageRequest.of((int)(vo.getPageNo() + 1), (int)this.getPageSize());
        ActivityPlanItemTerminalModifyDto dto = new ActivityPlanItemTerminalModifyDto();
        Page<ActivityPlanItemTerminalModifyVo> cachePage = this.activityPlanItemTerminalService.findCachePageList((Pageable)pageable, dto, cacheKey);
        if (cachePage.getTotal() == 0L) {
            return new JSONArray();
        }
        Collection exportVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)cachePage.getRecords(), ActivityPlanItemTerminalModifyVo.class, StoreDetailsExportVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return JSONArray.parseArray((String)JSON.toJSONString((Object)exportVos));
    }

    public String getBusinessCode() {
        return "TPM_STORE_DETAILS_MODIFY_EXPORT";
    }

    public String getBusinessName() {
        return "\u6d3b\u52a8\u65b9\u6848\u53d8\u66f4\u95e8\u5e97\u660e\u7ec6\u5bfc\u51fa";
    }

    public Class<StoreDetailsExportVo> findCrmExcelVoClass() {
        return StoreDetailsExportVo.class;
    }
}

