/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.modify.listener;

import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanModifyService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityPlanModifyCompleteListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanModifyCompleteListener.class);
    @Autowired(required=false)
    private ActivityPlanModifyService activityPlanModifyService;

    public String getBusinessCode() {
        return "activity_plan_modify";
    }

    public void onProcessComplete(ProcessStatusDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getBusinessNo())) {
            return;
        }
        String processStatus = dto.getProcessStatus();
        Validate.notEmpty((CharSequence)dto.getProcessNo(), (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            this.activityPlanModifyService.processPass(dto);
        }
        if (ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) || ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) {
            this.activityPlanModifyService.processRejectAndRecover(dto);
        }
    }
}

