/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanBudgetModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.mapper.ActivityPlanBudgetModifyMapper;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanBudgetModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityPlanBudgetModifyRepository
extends ServiceImpl<ActivityPlanBudgetModifyMapper, ActivityPlanBudgetModify> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<ActivityPlanBudgetModify> listByPlanCode(String planCode) {
        if (StringUtils.isEmpty((CharSequence)planCode)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivityPlanBudgetModify::getPlanCode, (Object)planCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<ActivityPlanBudgetModifyDto> listDtoListByModifyCode(String modifyCode) {
        if (StringUtils.isEmpty((CharSequence)modifyCode)) {
            return null;
        }
        return ((ActivityPlanBudgetModifyMapper)this.baseMapper).listDtoListByModifyCode(modifyCode);
    }

    public List<ActivityPlanBudgetModifyDto> listDtoByModifyCodeList(List<String> modifyCodeList) {
        List<ActivityPlanBudgetModify> activityPlanBudgets = this.listByModifyCodeList(modifyCodeList);
        if (CollectionUtils.isNotEmpty(activityPlanBudgets)) {
            List dtoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(activityPlanBudgets, ActivityPlanBudgetModify.class, ActivityPlanBudgetModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
            return dtoList;
        }
        return Lists.newArrayList();
    }

    public List<ActivityPlanBudgetModify> listByModifyCodeList(List<String> modifyCodeList) {
        if (org.springframework.util.CollectionUtils.isEmpty(modifyCodeList)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityPlanBudgetModify::getModifyBusinessCode, modifyCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<ActivityPlanBudgetModify> listByDetailCodeList(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityPlanBudgetModify::getPlanItemCode, itemCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public void deleteByIds(List<String> ids) {
        if (org.springframework.util.CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public void deletePhysicalByModifyBusinessCode(String modifyBusinessCode) {
        if (StringUtils.isEmpty((CharSequence)modifyBusinessCode)) {
            return;
        }
        LambdaQueryWrapper updateWrapper = new LambdaQueryWrapper();
        updateWrapper.eq(ActivityPlanBudgetModify::getModifyBusinessCode, (Object)modifyBusinessCode);
        this.remove((Wrapper)updateWrapper);
    }

    public void deleteByModifyBusinessCodes(List<String> modifyBusinessCodes) {
        if (org.springframework.util.CollectionUtils.isEmpty(modifyBusinessCodes)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityPlanBudgetModify::getModifyBusinessCode, modifyBusinessCodes);
        this.update((Wrapper)updateWrapper);
    }

    public void fillVoListProperties(List<ActivityPlanBudgetVo> voList) {
        if (org.springframework.util.CollectionUtils.isEmpty(voList)) {
            return;
        }
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanBudgetVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        for (ActivityPlanBudgetVo item : voList) {
            this.fillVoProperties(item, propertyMap);
        }
    }

    public void fillVoProperties(ActivityPlanBudgetVo item) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanBudgetVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        this.fillVoProperties(item, propertyMap);
    }

    public void fillVoProperties(ActivityPlanBudgetVo item, Map<String, PropertyDescriptor> propertyMap) {
        if (null == item) {
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties((Object)item, ActivityPlanBudgetVo.class, propertyMap);
        BigDecimal useAmount = Optional.ofNullable(item.getUseAmount()).orElse(BigDecimal.ZERO);
        BigDecimal usedAmount = Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO);
        item.setUsedAmount(usedAmount);
        item.setUsableAmount(useAmount.subtract(usedAmount));
    }
}

