/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanItemModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.mapper.ActivityPlanItemModifyMapper;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanBudgetModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanItemTerminalModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemTerminalDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanBudgetModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemTerminalModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanItemModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.submitreportvo.ActivityPlanSubmitReportSubVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityPlanItemModifyRepository
extends ServiceImpl<ActivityPlanItemModifyMapper, ActivityPlanItemModify> {
    @Autowired(required=false)
    private ActivityPlanItemModifyMapper activityPlanItemModifyMapper;
    @Autowired(required=false)
    private ActivityPlanBudgetModifyRepository activityPlanBudgetModifyRepository;
    @Autowired(required=false)
    private ActivityPlanItemTerminalModifyRepository activityPlanItemTerminalModifyRepository;
    @Autowired(required=false)
    private ActivityPlanItemRepository activityPlanItemRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    private static final String DATE_FORMAT_STR = "%Y-%m";

    public List<ActivityPlanItemModifyDto> findDtoListByModifyCode(String modifyCode) {
        if (StringUtils.isBlank((CharSequence)modifyCode)) {
            return Lists.newArrayList();
        }
        ActivityPlanItemModifyDto dto = new ActivityPlanItemModifyDto();
        dto.setModifyBusinessCode(modifyCode);
        List<ActivityPlanItemModify> itemList = this.findList(dto);
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityPlanItemModify.class, ActivityPlanItemModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.fillDtoListProperties(dtoList);
        return dtoList;
    }

    public List<ActivityPlanItemModifyDto> findDtoAndAttachListByModifyCode(String modifyCode) {
        List<ActivityPlanItemTerminalModifyDto> list;
        List<ActivityPlanItemModifyDto> dtoList = this.findDtoListByModifyCode(modifyCode);
        List<String> planItemCodeList = dtoList.stream().map(ActivityPlanItemBase::getPlanItemCode).collect(Collectors.toList());
        List<ActivityPlanItemDto> planItemDtos = this.activityPlanItemRepository.findDtoAndAttachListByPlanItemCodeList(planItemCodeList);
        Map planItemDtoMap = planItemDtos.stream().collect(Collectors.toMap(ActivityPlanItemDto::getPlanItemCode, Function.identity()));
        for (ActivityPlanItemModifyDto activityPlanItemModifyDto : dtoList) {
            ActivityPlanItemModify activityPlanItemModify = (ActivityPlanItemModify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityPlanItemModifyDto, ActivityPlanItemModify.class, HashSet.class, ArrayList.class, new String[0]));
            ActivityPlanItemDto planItemDto = (ActivityPlanItemDto)planItemDtoMap.get(activityPlanItemModifyDto.getPlanItemCode());
            BeanUtils.copyProperties((Object)planItemDto, (Object)activityPlanItemModifyDto);
            BeanUtils.copyProperties((Object)((Object)activityPlanItemModify), (Object)activityPlanItemModifyDto);
            if (planItemDto.getUsedHeadFeeAmount().compareTo(activityPlanItemModifyDto.getUsedHeadFeeAmount()) > 0) {
                activityPlanItemModifyDto.setUsedHeadFeeAmount(planItemDto.getUsedHeadFeeAmount());
            }
            if (planItemDto.getUsedDepartmentFeeAmount().compareTo(activityPlanItemModifyDto.getUsedDepartmentFeeAmount()) > 0) {
                activityPlanItemModifyDto.setUsedDepartmentFeeAmount(planItemDto.getUsedDepartmentFeeAmount());
            }
            if (planItemDto.getUsedCustomerFeeAmount().compareTo(activityPlanItemModifyDto.getUsedCustomerFeeAmount()) <= 0) continue;
            activityPlanItemModifyDto.setUsedCustomerFeeAmount(planItemDto.getUsedCustomerFeeAmount());
        }
        this.fillDtoListProperties(dtoList);
        List<ActivityPlanBudgetModifyDto> budgetList = this.activityPlanBudgetModifyRepository.listDtoListByModifyCode(modifyCode);
        if (!CollectionUtils.isEmpty(budgetList)) {
            this.convertMonthBudgetProperty(budgetList);
            for (ActivityPlanBudgetModifyDto activityPlanBudgetModifyDto : budgetList) {
                NumberStringDealUtil.setStringIfNotNull((Object)activityPlanBudgetModifyDto.getUseAmount(), arg_0 -> ((ActivityPlanBudgetModifyDto)activityPlanBudgetModifyDto).setUseAmountStr(arg_0));
            }
            Map<String, List<ActivityPlanBudgetModifyDto>> map = budgetList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getPlanItemCode())).collect(Collectors.groupingBy(ActivityPlanBudgetModifyDto::getPlanItemCode));
            for (ActivityPlanItemModifyDto itemDto : dtoList) {
                if (!map.containsKey(itemDto.getPlanItemCode())) continue;
                List<ActivityPlanBudgetModifyDto> budgetShares = map.get(itemDto.getPlanItemCode());
                itemDto.setBudgetShares(budgetShares);
            }
        }
        if (!CollectionUtils.isEmpty(list = this.activityPlanItemTerminalModifyRepository.listDtoListByModifyCode(modifyCode))) {
            Map<String, List<ActivityPlanItemTerminalModifyDto>> map = list.stream().collect(Collectors.groupingBy(ActivityPlanItemTerminalDto::getPlanItemCode));
            for (ActivityPlanItemModifyDto itemDto : dtoList) {
                if (!map.containsKey(itemDto.getPlanItemCode())) continue;
                itemDto.setActivityPlanItemTerminalList(map.get(itemDto.getPlanItemCode()));
            }
        }
        return dtoList;
    }

    public void convertMonthBudgetProperty(List<ActivityPlanBudgetModifyDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<Object, Object> feeSourceMap = Maps.newHashMap();
        if (null != this.dictDataVoService) {
            try {
                List feeSourceList = this.dictDataVoService.findByDictTypeCode("tpm_fee_belong_us");
                if (!CollectionUtils.isEmpty((Collection)feeSourceList)) {
                    feeSourceMap = feeSourceList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> o));
                }
            }
            catch (Exception e) {
                this.log.error("\u8d39\u7528\u5f52\u53e3\u6570\u636e\u5b57\u5178\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        for (ActivityPlanBudgetModifyDto vo : list) {
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)vo.getFeeBelongCode())) continue;
            vo.setFeeSourceName(feeSourceMap.getOrDefault(vo.getFeeBelongCode(), vo.getFeeBelongCode()));
        }
    }

    public List<ActivityPlanItemModifyDto> findDtoList(ActivityPlanItemModifyDto planItem) {
        List<ActivityPlanItemModify> itemList = this.findList(planItem);
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityPlanItemModify.class, ActivityPlanItemModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.fillDtoListProperties(dtoList);
        return dtoList;
    }

    public List<ActivityPlanItemModify> findListByModifyBusinessCode(String modifyBusinessCode) {
        if (StringUtils.isBlank((CharSequence)modifyBusinessCode)) {
            return Lists.newArrayList();
        }
        ActivityPlanItemModifyDto dto = new ActivityPlanItemModifyDto();
        dto.setModifyBusinessCode(modifyBusinessCode);
        return this.findList(dto);
    }

    public List<ActivityPlanItemModify> findList(ActivityPlanItemModifyDto planItem) {
        return this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivityPlanItemModify.class).eq(StringUtils.isNotBlank((CharSequence)planItem.getModifyBusinessCode()), ActivityPlanItemModify::getModifyBusinessCode, (Object)planItem.getModifyBusinessCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode()));
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public void fillVoListProperties(List<ActivityPlanItemModifyVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        for (ActivityPlanItemModifyVo item : voList) {
            this.fillVoProperties(item);
        }
    }

    public void fillVoProperties(ActivityPlanItemModifyVo item) {
        if (null == item) {
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties((Object)item, ActivityPlanItemModifyVo.class);
        BigDecimal feeAmount = Optional.ofNullable(item.getTotalFeeAmount()).orElse(BigDecimal.ZERO);
        BigDecimal usedAmount = Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO);
        item.setUsedAmount(usedAmount);
        item.setUsableAmount(feeAmount.subtract(usedAmount));
    }

    public void fillDtoListProperties(List<ActivityPlanItemModifyDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        for (ActivityPlanItemModifyDto item : dtoList) {
            this.fillDtoProperties(item);
        }
    }

    public void fillDtoProperties(ActivityPlanItemModifyDto item) {
        if (null == item) {
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties((Object)item, ActivityPlanItemModifyDto.class);
        item.setActivityType(item.getActivityTypeCode());
        item.setActivityForm(item.getActivityFormCode());
    }

    public void deleteByModifyCodes(List<String> modifyCodes) {
        if (CollectionUtils.isEmpty(modifyCodes)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityPlanItemModify::getModifyBusinessCode, modifyCodes);
        updateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        this.update((Wrapper)updateWrapper);
    }

    public List<ActivityPlanSubmitReportSubVo> modifySubmitPageReportDimension1(List<String> planCodeList, List<String> modifyBusinessCodeList) {
        if (CollectionUtils.isEmpty(planCodeList) && CollectionUtils.isEmpty(modifyBusinessCodeList)) {
            return Collections.emptyList();
        }
        return this.activityPlanItemModifyMapper.modifySubmitPageReportDimension1(planCodeList, modifyBusinessCodeList, DATE_FORMAT_STR);
    }

    public List<ActivityPlanSubmitReportSubVo> modifySubmitPageReportDimension3(List<String> planCodeList, List<String> modifyBusinessCodeList) {
        if (CollectionUtils.isEmpty(planCodeList) && CollectionUtils.isEmpty(modifyBusinessCodeList)) {
            return Collections.emptyList();
        }
        return this.activityPlanItemModifyMapper.modifySubmitPageReportDimension3(planCodeList, modifyBusinessCodeList, DATE_FORMAT_STR);
    }

    public Page<ActivityPlanItemModifyVo> findByConditions(Pageable pageable, ActivityPlanItemModifyDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<ActivityPlanItemModifyVo> pageList = this.activityPlanItemModifyMapper.findByConditions((Page<ActivityPlanItemModifyVo>)page, dto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }

    public Page<ActivityPlanItemModifyVo> findItemBeforeModifyList(Pageable pageable, ActivityPlanItemModifyDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<ActivityPlanItemModifyVo> pageList = this.activityPlanItemModifyMapper.findItemBeforeModifyList((Page<ActivityPlanItemModifyVo>)page, dto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }
}

