/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanItemTerminalModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.mapper.ActivityPlanItemTerminalModifyMapper;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemTerminalModifyDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityPlanItemTerminalModifyRepository
extends ServiceImpl<ActivityPlanItemTerminalModifyMapper, ActivityPlanItemTerminalModify> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<ActivityPlanItemTerminalModify> findByModifyBusinessCode(String modifyBusinessCode) {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ActivityPlanItemTerminalModify::getModifyBusinessCode, (Object)modifyBusinessCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public List<ActivityPlanItemTerminalModify> findByModifyBusinessAndPlanItemCode(String modifyBusinessCode, String planItemCode) {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ActivityPlanItemTerminalModify::getModifyBusinessCode, (Object)modifyBusinessCode)).eq(ActivityPlanItemTerminalModify::getPlanItemCode, (Object)planItemCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public void deleteByModifyBusinessCode(String modifyBusinessCode) {
        this.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ActivityPlanItemTerminalModify::getModifyBusinessCode, (Object)modifyBusinessCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public void deleteByModifyBusinessCode(List<String> modifyBusinessCodeList) {
        this.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(ActivityPlanItemTerminalModify::getModifyBusinessCode, modifyBusinessCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public List<ActivityPlanItemTerminalModifyDto> listDtoListByModifyCode(String modifyBusinessCode) {
        List<ActivityPlanItemTerminalModify> entityList = this.listByModifyCode(modifyBusinessCode);
        if (CollectionUtils.isNotEmpty(entityList)) {
            List dtoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, ActivityPlanItemTerminalModify.class, ActivityPlanItemTerminalModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
            ObjectConvertStringUtil.fillObjectListStrProperties((List)dtoList, ActivityPlanItemTerminalModifyDto.class);
            return dtoList;
        }
        return Lists.newArrayList();
    }

    public List<ActivityPlanItemTerminalModify> listByModifyCode(String modifyBusinessCode) {
        if (StringUtils.isBlank((CharSequence)modifyBusinessCode)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityPlanItemTerminalModify::getModifyBusinessCode, new Object[]{modifyBusinessCode})).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }
}

