/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.mapper.ActivityPlanModifyMapper;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityPlanModifyRepository
extends ServiceImpl<ActivityPlanModifyMapper, ActivityPlanModify> {
    @Autowired(required=false)
    private ActivityPlanModifyMapper activityPlanModifyMapper;

    public Page<ActivityPlanVo> findToModifyList(Pageable pageable, ActivityPlanDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ActivityPlanVo> pageList = this.activityPlanModifyMapper.findToModifyList((Page<ActivityPlanVo>)page, dto);
        return pageList;
    }

    public ActivityPlanModify getByCode(String modifyBusinessCode) {
        if (StringUtils.isEmpty((CharSequence)modifyBusinessCode)) {
            return null;
        }
        return (ActivityPlanModify)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ActivityPlanModify::getModifyBusinessCode, (Object)modifyBusinessCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())));
    }

    public void deleteIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public void updateProcessStatusAndProcessNo(String modifyBusinessCode, String processStatus, String processNo) {
        if (StringUtils.isEmpty((CharSequence)modifyBusinessCode)) {
            return;
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(ActivityPlanModify.class).set(ActivityPlanModify::getProcessStatus, (Object)processStatus)).set(ActivityPlanModify::getProcessNo, (Object)processNo)).in(ActivityPlanModify::getModifyBusinessCode, new Object[]{modifyBusinessCode})).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public void updateProcessStatus(String businessNo, String processStatus) {
        if (StringUtils.isEmpty((CharSequence)businessNo)) {
            return;
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(ActivityPlanModify.class).set(ActivityPlanModify::getProcessStatus, (Object)processStatus)).in(ActivityPlanModify::getModifyBusinessCode, new Object[]{businessNo})).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public List<ActivityPlanModify> findByProcessNoList(List<String> processNoList) {
        if (CollectionUtils.isEmpty(processNoList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().select(new SFunction[]{ActivityPlanModify::getPlanCode, ActivityPlanModify::getBusinessUnitCode, ActivityPlanModify::getModifyBusinessCode}).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(ActivityPlanModify::getProcessNo, processNoList)).list();
    }

    public void fillVoProperties(ActivityPlanModifyVo item) {
        this.fillVoProperties(item, null);
    }

    public void fillVoProperties(ActivityPlanModifyVo item, SimpleDateFormat dayFormat) {
        if (null == item) {
            return;
        }
        if (null == dayFormat) {
            dayFormat = new SimpleDateFormat("yyyy-MM-dd");
        }
        if (null != item.getBeginDate()) {
            item.setBeginDateStr(dayFormat.format(item.getBeginDate()));
        }
        if (null != item.getEndDate()) {
            item.setEndDateStr(dayFormat.format(item.getEndDate()));
        }
    }
}

