/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.mapper.ActivityPlanRelatePlanMapper;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanRelatePlanModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.mapper.ActivityPlanRelatePlanModifyMapper;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanRelatePlanModifyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityPlanRelatePlanModifyRepository
extends ServiceImpl<ActivityPlanRelatePlanModifyMapper, ActivityPlanRelatePlanModify> {
    @Autowired(required=false)
    private ActivityPlanRelatePlanMapper activityPlanRelatePlanMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<ActivityPlanRelatePlanModifyVo> findListVoByModifyCode(String modifyCode) {
        if (StringUtils.isBlank((CharSequence)modifyCode)) {
            return null;
        }
        List<ActivityPlanRelatePlanModify> itemList = this.findListByModifyCode(modifyCode);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityPlanRelatePlanModify.class, ActivityPlanRelatePlanModifyVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<ActivityPlanRelatePlanModify> findListByModifyCode(String modifyCode) {
        if (StringUtils.isBlank((CharSequence)modifyCode)) {
            return null;
        }
        return this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivityPlanRelatePlanModify.class).eq(ActivityPlanRelatePlanModify::getModifyBusinessCode, (Object)modifyCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode()));
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public void deleteByModifyCodes(List<String> modifyCodes) {
        if (CollectionUtils.isEmpty(modifyCodes)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityPlanRelatePlanModify::getModifyBusinessCode, modifyCodes);
        this.update((Wrapper)updateWrapper);
    }
}

