/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.mapper.ActivityPlanStrategyMapper;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanStrategyModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.mapper.ActivityPlanStrategyModifyMapper;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanStrategyModifyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityPlanStrategyModifyRepository
extends ServiceImpl<ActivityPlanStrategyModifyMapper, ActivityPlanStrategyModify> {
    @Autowired(required=false)
    private ActivityPlanStrategyMapper activityPlanStrategyMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<ActivityPlanStrategyModifyVo> findListVoByModifyCode(String modifyCode) {
        if (StringUtils.isBlank((CharSequence)modifyCode)) {
            return null;
        }
        List<ActivityPlanStrategyModify> itemList = this.findListByModifyCode(modifyCode);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityPlanStrategyModify.class, ActivityPlanStrategyModifyVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<ActivityPlanStrategyModify> findListByModifyCode(String modifyCode) {
        if (StringUtils.isBlank((CharSequence)modifyCode)) {
            return null;
        }
        return this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivityPlanStrategyModify.class).eq(ActivityPlanStrategyModify::getModifyBusinessCode, (Object)modifyCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode()));
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public void deleteByModifyCodes(List<String> modifyCodes) {
        if (CollectionUtils.isEmpty(modifyCodes)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityPlanStrategyModify::getModifyBusinessCode, modifyCodes);
        this.update((Wrapper)updateWrapper);
    }
}

