/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.modify.service.internal;

import com.aliyun.openservices.shade.org.apache.commons.lang3.Validate;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanBudget;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanBudgetModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanBudgetModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanBudgetModifyService;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanBudgetServiceImpl;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.OperateActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanBudgetOccupyTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanBudgetModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.OperateMarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyBudgetSdkService;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityPlanBudgetModifyServiceImpl
implements ActivityPlanBudgetModifyService {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityPlanBudgetRepository activityPlanBudgetRepository;
    @Autowired(required=false)
    private ActivityPlanBudgetModifyRepository activityPlanBudgetModifyRepository;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private MarketingStrategyBudgetSdkService marketingStrategyBudgetSdkService;
    @Autowired(required=false)
    private ActivityPlanBudgetServiceImpl activityPlanBudgetService;
    @Autowired(required=false)
    private MonthBudgetLockService monthBudgetLockService;

    @Override
    public Page<ActivityPlanBudgetVo> findByConditions(Pageable pageable, ActivityPlanBudgetDto dto) {
        return this.activityPlanBudgetRepository.findByConditions(pageable, dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveActivityPlanBudgetList(ActivityPlanModify entity, boolean update, List<ActivityPlanItemModifyDto> itemDtoList) {
        HashMap oldMap = Maps.newHashMap();
        if (update) {
            this.activityPlanBudgetModifyRepository.deletePhysicalByModifyBusinessCode(entity.getModifyBusinessCode());
        }
        for (ActivityPlanItemModifyDto itemDto : itemDtoList) {
            if (CollectionUtils.isEmpty((Collection)itemDto.getBudgetShares())) continue;
            itemDto.getBudgetShares().forEach(item -> {
                item.setPlanItemCode(itemDto.getPlanItemCode());
                item.setPlanCode(itemDto.getPlanCode());
                item.setModifyBusinessCode(entity.getModifyBusinessCode());
            });
        }
        List budgetDtoList = itemDtoList.stream().map(ActivityPlanItemModifyDto::getBudgetShares).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(budgetDtoList, ActivityPlanBudgetModifyDto.class, ActivityPlanBudgetModify.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (ActivityPlanBudgetModify item2 : list) {
            item2.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item2.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item2.setTenantCode(entity.getTenantCode());
            item2.setId(null);
            saveList.add(item2);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.activityPlanBudgetModifyRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.activityPlanBudgetModifyRepository.updateBatchById(updateList);
        }
    }

    @Override
    public void deleteByModifyCodes(List<String> planCodes) {
        this.activityPlanBudgetModifyRepository.deleteByModifyBusinessCodes(planCodes);
    }

    @Override
    public void useMonthBudgetByModifyCode(String modifyCode, String planCode, boolean doSave) {
        List<ActivityPlanBudgetModifyDto> modifyItemBudgetList = this.activityPlanBudgetModifyRepository.listDtoByModifyCodeList(Lists.newArrayList((Object[])new String[]{modifyCode}));
        this.useMonthBudget(modifyItemBudgetList, planCode, doSave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void useMonthBudget(List<ActivityPlanBudgetModifyDto> modifyItemBudgetList, String planCode, final boolean doSave) {
        Set monthBudgetCodeSet;
        BigDecimal originUseAmount;
        String key;
        List<ActivityPlanBudget> originBudgetList = this.activityPlanBudgetRepository.listByPlanCode(planCode);
        Map<String, BigDecimal> originBudgetMap = originBudgetList.stream().filter(item -> null != item.getUseAmount()).collect(Collectors.toMap(item -> item.getOccupyType() + item.getPlanItemCode() + item.getMonthBudgetCode(), ActivityPlanBudget::getUseAmount));
        HashMap looseAmountMap = Maps.newHashMap();
        ArrayList strategyOperateList = Lists.newArrayList();
        ArrayList budgetOperateList = Lists.newArrayList();
        ArrayList planBudgetOperateList = Lists.newArrayList();
        for (final ActivityPlanBudgetModifyDto budgetShareModify : modifyItemBudgetList) {
            String looseAmountKey;
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            key = budgetShareModify.getOccupyType() + budgetShareModify.getPlanItemCode() + budgetShareModify.getMonthBudgetCode();
            originUseAmount = originBudgetMap.getOrDefault(key, BigDecimal.ZERO);
            if (budgetShareModify.getUseAmount().compareTo(originUseAmount) > 0) continue;
            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType()) && StringUtils.isNotEmpty((CharSequence)budgetShareModify.getRelateStrategyItemCode())) {
                looseAmountKey = budgetShareModify.getRelateStrategyItemCode() + budgetShareModify.getMonthBudgetCode();
                looseAmountMap.put(looseAmountKey, looseAmountMap.getOrDefault(looseAmountKey, BigDecimal.ZERO).add(originUseAmount.subtract(budgetShareModify.getUseAmount())));
            }
            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType())) {
                looseAmountKey = budgetShareModify.getMonthBudgetCode();
                looseAmountMap.put(looseAmountKey, looseAmountMap.getOrDefault(looseAmountKey, BigDecimal.ZERO).add(originUseAmount.subtract(budgetShareModify.getUseAmount())));
            }
            if (!ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(budgetShareModify.getOccupyType()) || !StringUtils.isNotEmpty((CharSequence)budgetShareModify.getRelatePlanItemCode())) continue;
            looseAmountKey = budgetShareModify.getRelatePlanItemCode() + budgetShareModify.getMonthBudgetCode();
            looseAmountMap.put(looseAmountKey, looseAmountMap.getOrDefault(looseAmountKey, BigDecimal.ZERO).add(originUseAmount.subtract(budgetShareModify.getUseAmount())));
        }
        for (final ActivityPlanBudgetModifyDto budgetShareModify : modifyItemBudgetList) {
            Object operateBudgetDto;
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            key = budgetShareModify.getOccupyType() + budgetShareModify.getPlanItemCode() + budgetShareModify.getMonthBudgetCode();
            originUseAmount = originBudgetMap.getOrDefault(key, BigDecimal.ZERO);
            if (budgetShareModify.getUseAmount().compareTo(originUseAmount) <= 0) continue;
            final BigDecimal useAmount = budgetShareModify.getUseAmount().subtract(originUseAmount);
            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType()) && StringUtils.isNotEmpty((CharSequence)budgetShareModify.getRelateStrategyItemCode())) {
                operateBudgetDto = new OperateMarketingStrategyBudgetDto(){
                    {
                        this.setBusinessCode(budgetShareModify.getPlanItemCode());
                        this.setStrategyCode(budgetShareModify.getRelateStrategyCode());
                        this.setStrategyItemCode(budgetShareModify.getRelateStrategyItemCode());
                        this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                        this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                        this.setOperationAmount(useAmount);
                        this.setDoSave(doSave);
                    }
                };
                strategyOperateList.add(operateBudgetDto);
            }
            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType())) {
                operateBudgetDto = new OperateMonthBudgetDto(){
                    {
                        this.setBusinessCode(budgetShareModify.getPlanItemCode());
                        this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                        this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                        this.setOperationAmount(useAmount);
                        this.setDoSave(doSave);
                    }
                };
                budgetOperateList.add(operateBudgetDto);
            }
            if (!ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(budgetShareModify.getOccupyType()) || !StringUtils.isNotEmpty((CharSequence)budgetShareModify.getRelatePlanItemCode())) continue;
            operateBudgetDto = new OperateActivityPlanBudgetDto(){
                {
                    this.setBusinessCode(budgetShareModify.getPlanItemCode());
                    this.setPlanCode(budgetShareModify.getRelatePlanCode());
                    this.setPlanItemCode(budgetShareModify.getRelatePlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                    this.setOperationAmount(useAmount);
                    this.setDoSave(doSave);
                }
            };
            planBudgetOperateList.add(operateBudgetDto);
        }
        if (!CollectionUtils.isEmpty((Collection)strategyOperateList)) {
            monthBudgetCodeSet = strategyOperateList.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
            try {
                Validate.isTrue((boolean)this.monthBudgetLockService.lock(new ArrayList(monthBudgetCodeSet), TimeUnit.SECONDS, 1200), (String)"\u9884\u7b97\u52a0\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
                this.marketingStrategyBudgetSdkService.operateAmount((List)strategyOperateList, (Map)looseAmountMap);
            }
            finally {
                this.monthBudgetLockService.unLock(new ArrayList(monthBudgetCodeSet));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)budgetOperateList)) {
            monthBudgetCodeSet = budgetOperateList.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
            try {
                Validate.isTrue((boolean)this.monthBudgetLockService.lock(new ArrayList(monthBudgetCodeSet), TimeUnit.SECONDS, 1200), (String)"\u9884\u7b97\u52a0\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
                this.monthBudgetService.operateBudget((List)budgetOperateList, (Map)looseAmountMap);
            }
            finally {
                this.monthBudgetLockService.unLock(new ArrayList(monthBudgetCodeSet));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)planBudgetOperateList)) {
            monthBudgetCodeSet = planBudgetOperateList.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
            try {
                Validate.isTrue((boolean)this.monthBudgetLockService.lock(new ArrayList(monthBudgetCodeSet), TimeUnit.SECONDS, 1200), (String)"\u9884\u7b97\u52a0\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
                this.activityPlanBudgetService.operateBudget(planBudgetOperateList, looseAmountMap);
            }
            finally {
                this.monthBudgetLockService.unLock(new ArrayList(monthBudgetCodeSet));
            }
        }
    }

    @Override
    public void returnMonthBudgetByModifyCode(String modifyCode, String planCode) {
        List<ActivityPlanBudgetModify> modifyItemBudgetList = this.activityPlanBudgetModifyRepository.listByModifyCodeList(Lists.newArrayList((Object[])new String[]{modifyCode}));
        List<ActivityPlanBudget> originBudgetList = this.activityPlanBudgetRepository.listByPlanCode(planCode);
        Map<String, BigDecimal> originBudgetMap = originBudgetList.stream().collect(Collectors.toMap(item -> item.getOccupyType() + item.getPlanItemCode() + item.getRelateStrategyItemCode() + item.getRelatePlanItemCode() + item.getMonthBudgetCode(), ActivityPlanBudget::getUseAmount));
        ArrayList strategyOperateList = Lists.newArrayList();
        ArrayList budgetOperateList = Lists.newArrayList();
        ArrayList planBudgetOperateList = Lists.newArrayList();
        for (final ActivityPlanBudgetModify budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            String key = budgetShareModify.getOccupyType() + budgetShareModify.getPlanItemCode() + budgetShareModify.getRelateStrategyItemCode() + budgetShareModify.getRelatePlanItemCode() + budgetShareModify.getMonthBudgetCode();
            final BigDecimal originUseAmount = originBudgetMap.getOrDefault(key, BigDecimal.ZERO);
            if (budgetShareModify.getUseAmount().compareTo(originUseAmount) <= 0) continue;
            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType()) && StringUtils.isNotEmpty((CharSequence)budgetShareModify.getRelateStrategyItemCode())) {
                strategyOperateList.add(new OperateMarketingStrategyBudgetDto(){
                    {
                        this.setBusinessCode(budgetShareModify.getPlanItemCode());
                        this.setStrategyCode(budgetShareModify.getRelateStrategyCode());
                        this.setStrategyItemCode(budgetShareModify.getRelateStrategyItemCode());
                        this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                        this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                        this.setOperationAmount(budgetShareModify.getUseAmount().subtract(originUseAmount));
                    }
                });
            }
            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType())) {
                budgetOperateList.add(new OperateMonthBudgetDto(){
                    {
                        this.setBusinessCode(budgetShareModify.getPlanItemCode());
                        this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                        this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                        this.setOperationAmount(budgetShareModify.getUseAmount().subtract(originUseAmount));
                    }
                });
            }
            if (!ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(budgetShareModify.getOccupyType()) || !StringUtils.isNotEmpty((CharSequence)budgetShareModify.getRelatePlanItemCode())) continue;
            planBudgetOperateList.add(new OperateActivityPlanBudgetDto(){
                {
                    this.setBusinessCode(budgetShareModify.getPlanItemCode());
                    this.setPlanCode(budgetShareModify.getRelatePlanCode());
                    this.setPlanItemCode(budgetShareModify.getRelatePlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    this.setOperationAmount(budgetShareModify.getUseAmount().subtract(originUseAmount));
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)strategyOperateList)) {
            this.marketingStrategyBudgetSdkService.operateAmount((List)strategyOperateList);
        }
        if (!CollectionUtils.isEmpty((Collection)budgetOperateList)) {
            this.monthBudgetService.operateBudget((List)budgetOperateList);
        }
        if (!CollectionUtils.isEmpty((Collection)planBudgetOperateList)) {
            this.activityPlanBudgetService.operateBudget(planBudgetOperateList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void passReturnMonthBudgetByModifyCode(List<ActivityPlanBudget> originBudgetList, List<ActivityPlanBudgetModify> modifyItemBudgetList) {
        Map<String, BigDecimal> originBudgetMap = originBudgetList.stream().filter(item -> null != item.getUseAmount()).collect(Collectors.toMap(item -> item.getOccupyType() + item.getPlanItemCode() + item.getMonthBudgetCode(), ActivityPlanBudget::getUseAmount));
        ArrayList strategyOperateList = Lists.newArrayList();
        ArrayList budgetOperateList = Lists.newArrayList();
        ArrayList planBudgetOperateList = Lists.newArrayList();
        for (final ActivityPlanBudgetModify budgetShareModify : modifyItemBudgetList) {
            if (null == budgetShareModify.getUseAmount() || budgetShareModify.getUseAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            String key = budgetShareModify.getOccupyType() + budgetShareModify.getPlanItemCode() + budgetShareModify.getMonthBudgetCode();
            final BigDecimal originUseAmount = originBudgetMap.getOrDefault(key, BigDecimal.ZERO);
            if (budgetShareModify.getUseAmount().compareTo(originUseAmount) >= 0) continue;
            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType()) && StringUtils.isNotEmpty((CharSequence)budgetShareModify.getRelateStrategyItemCode())) {
                strategyOperateList.add(new OperateMarketingStrategyBudgetDto(){
                    {
                        this.setBusinessCode(budgetShareModify.getPlanItemCode());
                        this.setStrategyCode(budgetShareModify.getRelateStrategyCode());
                        this.setStrategyItemCode(budgetShareModify.getRelateStrategyItemCode());
                        this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                        this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                        this.setOperationAmount(originUseAmount.subtract(budgetShareModify.getUseAmount()));
                    }
                });
            }
            if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShareModify.getOccupyType())) {
                budgetOperateList.add(new OperateMonthBudgetDto(){
                    {
                        this.setBusinessCode(budgetShareModify.getPlanItemCode());
                        this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                        this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                        this.setOperationAmount(originUseAmount.subtract(budgetShareModify.getUseAmount()));
                    }
                });
            }
            if (!ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(budgetShareModify.getOccupyType()) || !StringUtils.isNotEmpty((CharSequence)budgetShareModify.getRelatePlanItemCode())) continue;
            planBudgetOperateList.add(new OperateActivityPlanBudgetDto(){
                {
                    this.setBusinessCode(budgetShareModify.getPlanItemCode());
                    this.setPlanCode(budgetShareModify.getRelatePlanCode());
                    this.setPlanItemCode(budgetShareModify.getRelatePlanItemCode());
                    this.setMonthBudgetCode(budgetShareModify.getMonthBudgetCode());
                    this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                    this.setOperationAmount(originUseAmount.subtract(budgetShareModify.getUseAmount()));
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)strategyOperateList)) {
            this.marketingStrategyBudgetSdkService.operateAmount((List)strategyOperateList);
        }
        if (!CollectionUtils.isEmpty((Collection)budgetOperateList)) {
            this.monthBudgetService.operateBudget((List)budgetOperateList);
        }
        if (!CollectionUtils.isEmpty((Collection)planBudgetOperateList)) {
            this.activityPlanBudgetService.operateBudget(planBudgetOperateList);
        }
    }
}

