/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.modify.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanItemModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanBudgetModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanItemModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class ActivityPlanItemModifyPageCacheHelper
extends MnPageCacheHelper<ActivityPlanItemModifyVo, ActivityPlanItemModifyDto> {
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private ActivityPlanItemModifyRepository activityPlanItemModifyRepository;
    @Autowired(required=false)
    private ActivityPlanItemRepository activityPlanItemRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getCacheKeyPrefix() {
        return "activity_plan:item_cache:modify";
    }

    public Class<ActivityPlanItemModifyDto> getDtoClass() {
        return ActivityPlanItemModifyDto.class;
    }

    public Class<ActivityPlanItemModifyVo> getVoClass() {
        return ActivityPlanItemModifyVo.class;
    }

    public List<ActivityPlanItemModifyDto> findDtoListFromRepository(ActivityPlanItemModifyDto dto, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)dto.getModifyBusinessCode()) && StringUtils.isEmpty((CharSequence)dto.getPlanCode())) {
            return Lists.newArrayList();
        }
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        ArrayList allDtoList = null;
        if (StringUtils.isNotEmpty((CharSequence)dto.getModifyBusinessCode())) {
            allDtoList = this.activityPlanItemModifyRepository.findDtoAndAttachListByModifyCode(dto.getModifyBusinessCode());
        } else {
            List<ActivityPlanItemDto> planItemDtos = this.activityPlanItemRepository.findDtoAndAttachListByPlanCode(dto.getPlanCode());
            allDtoList = Lists.newArrayList();
            for (ActivityPlanItemDto activityPlanItemDto : planItemDtos) {
                ActivityPlanItemModifyDto modifyItemDto = (ActivityPlanItemModifyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityPlanItemDto, ActivityPlanItemModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
                if (!CollectionUtils.isEmpty((Collection)activityPlanItemDto.getBudgetShares())) {
                    modifyItemDto.setBudgetShares((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)activityPlanItemDto.getBudgetShares(), ActivityPlanBudgetDto.class, ActivityPlanBudgetModifyDto.class, HashSet.class, ArrayList.class, new String[0]));
                }
                allDtoList.add(modifyItemDto);
            }
        }
        allDtoList.sort(Comparator.comparing(ActivityPlanItemBase::getPlanItemCode));
        Map<String, List<ActivityPlanItemModifyDto>> allMap = allDtoList.stream().collect(Collectors.groupingBy(ActivityPlanItemBase::getTemplateConfigCode));
        for (Map.Entry entry : allMap.entrySet()) {
            String thisRedisIdCacheKey = redisCacheIdKey.replace(templateCode, (CharSequence)entry.getKey());
            String thisRedisDataCacheKey = redisCacheDataKey.replace(templateCode, (CharSequence)entry.getKey());
            Map newItemMap = ((List)entry.getValue()).stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
            this.redisService.lPushAll(thisRedisIdCacheKey, Long.valueOf(this.getExpireTime()), ((List)entry.getValue()).stream().map(this::getDtoKey).toArray());
            this.redisTemplate.opsForHash().putAll((Object)thisRedisDataCacheKey, newItemMap);
            this.redisService.expire(thisRedisDataCacheKey, this.getExpireTime());
        }
        return allMap.get(templateCode);
    }

    public boolean initToCacheFromRepository() {
        return false;
    }

    public List<ActivityPlanItemModifyDto> newItem(String cacheKey, List<ActivityPlanItemModifyDto> itemList) {
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        ActivityPlanItemModifyDto newItem = new ActivityPlanItemModifyDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        newItem.setTemplateConfigCode(templateCode);
        return Lists.newArrayList((Object[])new ActivityPlanItemModifyDto[]{newItem});
    }

    public List<ActivityPlanItemModifyDto> copyItem(String cacheKey, List<ActivityPlanItemModifyDto> itemList) {
        List newItemList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityPlanItemModifyDto.class, ActivityPlanItemModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (ActivityPlanItemModifyDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setPlanItemCode(null);
        }
        return newItemList;
    }

    public void updateItem(String cacheKey, List<ActivityPlanItemModifyDto> itemList) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null != requestAttributes) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
            String businessUnitCode = servletRequestAttributes.getRequest().getParameter("businessUnitCode");
            if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
                for (ActivityPlanItemModifyDto itemDto : itemList) {
                    if (CollectionUtils.isEmpty((Collection)itemDto.getBudgetShares())) continue;
                    BigDecimal headFeeAmount = BigDecimal.ZERO;
                    BigDecimal regionAutomaticFeeAmount = BigDecimal.ZERO;
                    BigDecimal regionReferendumFeeAmount = BigDecimal.ZERO;
                    HashSet headMonthBudgetCodeSet = Sets.newHashSet();
                    HashSet regionAutomaticMonthBudgetCodeSet = Sets.newHashSet();
                    HashSet regionReferendumMonthBudgetCodeSet = Sets.newHashSet();
                    HashSet headBudgetItemCodeSet = Sets.newHashSet();
                    HashSet regionAutomaticBudgetItemCodeSet = Sets.newHashSet();
                    HashSet regionReferendumBudgetItemCodeSet = Sets.newHashSet();
                    HashSet headBudgetItemNameSet = Sets.newHashSet();
                    HashSet regionAutomaticBudgetItemNameSet = Sets.newHashSet();
                    HashSet regionReferendumBudgetItemNameSet = Sets.newHashSet();
                    for (ActivityPlanBudgetModifyDto budgetDto : itemDto.getBudgetShares()) {
                        if (StringUtils.isEmpty((CharSequence)budgetDto.getFeeBelongCode())) continue;
                        if (StringUtils.isNotEmpty((CharSequence)budgetDto.getUseAmountStr())) {
                            NumberStringDealUtil.validateNumberStrAndSet((String)budgetDto.getUseAmountStr(), (String)"\u672c\u6b21\u4f7f\u7528\u9884\u7b97\u91d1\u989d", (boolean)false, arg_0 -> ((ActivityPlanBudgetModifyDto)budgetDto).setUseAmount(arg_0), BigDecimal.class);
                            if (FeeBelongEnum.HEAD.getCode().equals(budgetDto.getFeeBelongCode())) {
                                headFeeAmount = headFeeAmount.add(budgetDto.getUseAmount());
                            } else if (FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(budgetDto.getFeeBelongCode())) {
                                regionAutomaticFeeAmount = regionAutomaticFeeAmount.add(budgetDto.getUseAmount());
                            } else if (FeeBelongEnum.REGION_REFERENDUM.getCode().equals(budgetDto.getFeeBelongCode())) {
                                regionReferendumFeeAmount = regionReferendumFeeAmount.add(budgetDto.getUseAmount());
                            }
                        }
                        if (FeeBelongEnum.HEAD.getCode().equals(budgetDto.getFeeBelongCode())) {
                            if (StringUtils.isNotEmpty((CharSequence)budgetDto.getMonthBudgetCode())) {
                                headMonthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemCode())) {
                                headBudgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                            }
                            if (!StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemName())) continue;
                            headBudgetItemNameSet.add(budgetDto.getBudgetItemName());
                            continue;
                        }
                        if (FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(budgetDto.getFeeBelongCode())) {
                            if (StringUtils.isNotEmpty((CharSequence)budgetDto.getMonthBudgetCode())) {
                                regionAutomaticMonthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemCode())) {
                                regionAutomaticBudgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                            }
                            if (!StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemName())) continue;
                            regionAutomaticBudgetItemNameSet.add(budgetDto.getBudgetItemName());
                            continue;
                        }
                        if (!FeeBelongEnum.REGION_REFERENDUM.getCode().equals(budgetDto.getFeeBelongCode())) continue;
                        if (StringUtils.isNotEmpty((CharSequence)budgetDto.getMonthBudgetCode())) {
                            regionReferendumMonthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemCode())) {
                            regionReferendumBudgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemName())) continue;
                        regionReferendumBudgetItemNameSet.add(budgetDto.getBudgetItemName());
                    }
                    itemDto.setHeadFeeAmount(headFeeAmount);
                    itemDto.setHeadFeeAmountStr(headFeeAmount.toString());
                    itemDto.setRegionAutomaticFeeAmount(regionAutomaticFeeAmount);
                    itemDto.setRegionAutomaticFeeAmountStr(regionAutomaticFeeAmount.toString());
                    itemDto.setRegionReferendumFeeAmount(regionReferendumFeeAmount);
                    itemDto.setRegionReferendumFeeAmountStr(regionReferendumFeeAmount.toString());
                    itemDto.setHeadMonthBudgetCode(String.join((CharSequence)",", headMonthBudgetCodeSet));
                    itemDto.setRegionAutomaticMonthBudgetCode(String.join((CharSequence)",", regionAutomaticMonthBudgetCodeSet));
                    itemDto.setRegionReferendumMonthBudgetCode(String.join((CharSequence)",", regionReferendumMonthBudgetCodeSet));
                    itemDto.setHeadBudgetItemCode(String.join((CharSequence)",", headBudgetItemCodeSet));
                    itemDto.setRegionAutomaticBudgetItemCode(String.join((CharSequence)",", regionAutomaticBudgetItemCodeSet));
                    itemDto.setRegionReferendumBudgetItemCode(String.join((CharSequence)",", regionReferendumBudgetItemCodeSet));
                    itemDto.setHeadBudgetItemName(String.join((CharSequence)",", headBudgetItemNameSet));
                    itemDto.setRegionAutomaticBudgetItemName(String.join((CharSequence)",", regionAutomaticBudgetItemNameSet));
                    itemDto.setRegionReferendumBudgetItemName(String.join((CharSequence)",", regionReferendumBudgetItemNameSet));
                }
            }
        }
    }

    public Object getDtoKey(ActivityPlanItemModifyDto activityPlanItemModifyDto) {
        return activityPlanItemModifyDto.getId();
    }

    public String getCheckedStatus(ActivityPlanItemModifyDto activityPlanItemModifyDto) {
        return activityPlanItemModifyDto.getChecked();
    }

    public String getRedisCacheInitKey(String cacheKey) {
        String redisCacheInitKey = super.getRedisCacheInitKey(cacheKey);
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        return redisCacheInitKey.replace(templateCode, "");
    }
}

