/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.modify.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateStringDealUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanItemModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanItemModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanItemModifyService;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanBudgetSumVo;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanModifyFieldValue;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanSapAmountEventDto;
import com.biz.crm.tpm.business.activity.plan.sdk.event.ActivityPlanSapAmountListener;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.ActivityPlanQueryHeadSchemeForecastListener;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.dto.ActivityPlanQueryHeadSchemeForecastDto;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.vo.ActivityPlanQueryHeadSchemeForecastResponse;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.vo.ActivityPlanQueryHeadSchemeForecastVo;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanItemModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanSapAmountResponse;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessMappingDto;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiModelProperty;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityPlanItemModifyServiceImpl
extends MnPageCacheServiceImpl<ActivityPlanItemModifyVo, ActivityPlanItemModifyDto>
implements ActivityPlanItemModifyService {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanItemModifyServiceImpl.class);
    @Autowired(required=false)
    private ActivityPlanItemModifyRepository activityPlanItemModifyRepository;
    @Autowired(required=false)
    private ActivityPlanItemRepository activityPlanItemRepository;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;
    @Autowired(required=false)
    private BudgetItemService budgetItemService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private ProcessBusinessMappingService processBusinessMappingService;

    @Override
    public Page<ActivityPlanItemModifyVo> findByConditions(Pageable pageable, ActivityPlanItemModifyDto dto) {
        return this.activityPlanItemModifyRepository.findByConditions(pageable, dto);
    }

    @Override
    public List<ActivityPlanBudgetSumVo> findBudgetCacheSumList(String cacheKey) {
        ArrayList feeBudgetCodeList;
        List budgetVos;
        List itemList = this.findCacheList(cacheKey);
        HashMap budgetSumVoMap = Maps.newHashMap();
        HashSet feeBudgetCodeSet = Sets.newHashSet();
        for (ActivityPlanItemModifyDto item : itemList) {
            ActivityPlanBudgetSumVo budgetSumVo;
            if (StringUtils.isNotEmpty((CharSequence)item.getHeadMonthBudgetCode())) {
                budgetSumVo = budgetSumVoMap.computeIfAbsent(item.getHeadMonthBudgetCode(), key -> new ActivityPlanBudgetSumVo(){
                    {
                        this.setUseAmount(BigDecimal.ZERO);
                        this.setAccumulatedAvailableBalance(BigDecimal.ZERO);
                    }
                });
                budgetSumVo.setMonthBudgetCode(item.getHeadMonthBudgetCode());
                budgetSumVo.setBudgetItemCode(item.getHeadBudgetItemCode());
                budgetSumVo.setBudgetItemName(item.getHeadBudgetItemName());
                if (null != item.getHeadFeeAmountStr()) {
                    try {
                        budgetSumVo.setUseAmount(budgetSumVo.getUseAmount().add(new BigDecimal(item.getHeadFeeAmountStr().trim())));
                    }
                    catch (Exception e) {
                        log.error("\u83b7\u53d6\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6\u9884\u7b97\u6c47\u603b\u65f6\uff0c\u9884\u7b97\u91d1\u989d\u6709\u8bef\uff01");
                    }
                }
                feeBudgetCodeSet.add(budgetSumVo.getMonthBudgetCode());
            }
            if (!StringUtils.isNotEmpty((CharSequence)item.getMonthBudgetCode())) continue;
            budgetSumVo = budgetSumVoMap.computeIfAbsent(item.getMonthBudgetCode(), key -> new ActivityPlanBudgetSumVo(){
                {
                    this.setUseAmount(BigDecimal.ZERO);
                    this.setAccumulatedAvailableBalance(BigDecimal.ZERO);
                }
            });
            budgetSumVo.setMonthBudgetCode(item.getMonthBudgetCode());
            budgetSumVo.setBudgetItemCode(item.getBudgetItemCode());
            budgetSumVo.setBudgetItemName(item.getBudgetItemName());
            if (null != item.getDepartmentFeeAmountStr()) {
                try {
                    budgetSumVo.setUseAmount(budgetSumVo.getUseAmount().add(new BigDecimal(item.getDepartmentFeeAmountStr().trim())));
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6\u9884\u7b97\u6c47\u603b\u65f6\uff0c\u9884\u7b97\u91d1\u989d\u6709\u8bef\uff01");
                }
            }
            feeBudgetCodeSet.add(budgetSumVo.getMonthBudgetCode());
        }
        if (feeBudgetCodeSet.size() > 0 && null != (budgetVos = this.monthBudgetService.findByCodes((List)(feeBudgetCodeList = Lists.newArrayList((Iterable)feeBudgetCodeSet)), null))) {
            for (MonthBudgetVo budgetVo : budgetVos) {
                ActivityPlanBudgetSumVo budgetSumVo = (ActivityPlanBudgetSumVo)budgetSumVoMap.get(budgetVo.getMonthBudgetCode());
                budgetSumVo.setYearMonthLy(budgetVo.getYearMonthLy());
                budgetSumVo.setBudgetItemCode(budgetVo.getBudgetItemCode());
                budgetSumVo.setBudgetItemName(budgetVo.getBudgetItemName());
                budgetSumVo.setFeeBelongCode(budgetVo.getFeeBelongCode());
                budgetSumVo.setOrgCode(budgetVo.getOrgCode());
                budgetSumVo.setOrgName(budgetVo.getOrgName());
                if (null != budgetVo.getAccumulatedAvailableBalance()) {
                    budgetSumVo.setAccumulatedAvailableBalance(budgetVo.getAccumulatedAvailableBalance());
                }
                if (null == budgetVo.getControlBalanceAmount()) continue;
                budgetSumVo.setControlBalanceAmount(budgetVo.getControlBalanceAmount());
            }
        }
        ArrayList<ActivityPlanBudgetSumVo> budgetSumList = new ArrayList<ActivityPlanBudgetSumVo>(budgetSumVoMap.values());
        return budgetSumList;
    }

    @Override
    public void saveActivityPlanItemList(ActivityPlanModify entity, boolean update, List<ActivityPlanItemModifyDto> itemCacheList, Map<String, ActivityPlanItemDto> itemMap) {
        this.saveActivityPlanItemList(entity, update, itemCacheList, itemMap, true);
    }

    @Override
    public void saveActivityPlanItemList(ActivityPlanModify entity, boolean update, List<ActivityPlanItemModifyDto> itemCacheList, Map<String, ActivityPlanItemDto> itemMap, boolean createValidate) {
        if (createValidate) {
            this.createValidateList(itemCacheList, itemMap);
        }
        Map<Object, Object> oldMap = Maps.newHashMap();
        if (update) {
            List<ActivityPlanItemModify> oldList = this.activityPlanItemModifyRepository.findListByModifyBusinessCode(entity.getModifyBusinessCode());
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        HashMap dtoMap = Maps.newHashMap();
        for (ActivityPlanItemModifyDto item : itemCacheList) {
            dtoMap.put(item.getId(), item);
            item.setPlanCode(entity.getPlanCode());
            if (oldMap.containsKey(item.getId())) {
                ActivityPlanItemModify oldItemEntity = (ActivityPlanItemModify)((Object)oldMap.get(item.getId()));
                item.setPlanItemCode(oldItemEntity.getPlanItemCode());
                ActivityPlanItemModify itemEntity = (ActivityPlanItemModify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, ActivityPlanItemModify.class, HashSet.class, ArrayList.class, new String[0]));
                updateList.add(itemEntity);
                oldMap.remove(item.getId());
                continue;
            }
            ActivityPlanItemModify itemEntity = (ActivityPlanItemModify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, ActivityPlanItemModify.class, HashSet.class, ArrayList.class, new String[0]));
            itemEntity.setPlanCode(entity.getPlanCode());
            itemEntity.setModifyBusinessCode(entity.getModifyBusinessCode());
            itemEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            itemEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            itemEntity.setTenantCode(entity.getTenantCode());
            saveList.add(itemEntity);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            for (ActivityPlanItemModify activityPlanItem : saveList) {
                ActivityPlanItemModifyDto dto = (ActivityPlanItemModifyDto)dtoMap.get(activityPlanItem.getId());
                dto.setPlanItemCode(activityPlanItem.getPlanItemCode());
                activityPlanItem.setId(null);
            }
            this.activityPlanItemModifyRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.activityPlanItemModifyRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            this.activityPlanItemModifyRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    @Override
    public void createValidateList(List<ActivityPlanItemModifyDto> dtoList, Map<String, ActivityPlanItemDto> itemMap) {
        this.createValidateList(new ActivityPlanModifyDto(), dtoList, itemMap);
    }

    @Override
    public void createValidateList(ActivityPlanModifyDto planDto, List<ActivityPlanItemModifyDto> dtoList, Map<String, ActivityPlanItemDto> itemMap) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        HashSet templateConfigCodeSet = Sets.newHashSet();
        for (ActivityPlanItemModifyDto dto : dtoList) {
            Validate.notBlank((CharSequence)dto.getTemplateConfigCode(), (String)"\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            templateConfigCodeSet.add(dto.getTemplateConfigCode());
        }
        List templateList = this.activitiesTemplateSdkService.findByCodeList((List)Lists.newArrayList((Iterable)templateConfigCodeSet));
        if (templateList.size() != templateConfigCodeSet.size()) {
            throw new RuntimeException("\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6\u6a21\u677f\u6570\u636e\u6709\u8bef\uff01");
        }
        Map templateMap = templateList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));
        Map<String, List<ActivityPlanItemModifyDto>> dtoMap = dtoList.stream().collect(Collectors.groupingBy(ActivityPlanItemBase::getTemplateConfigCode));
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanItemModifyDto.class);
        Map propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        for (Map.Entry<String, List<ActivityPlanItemModifyDto>> dtoEntry : dtoMap.entrySet()) {
            List<ActivityPlanItemModifyDto> thisDtoList = dtoEntry.getValue();
            ActivitiesTemplateConfigVo templateConfigVo = (ActivitiesTemplateConfigVo)templateMap.get(dtoEntry.getKey());
            Map<String, String> templateDetailTitleMap = templateConfigVo.getDetails().stream().collect(Collectors.toMap(ActivitiesTemplateConfigDetailVo::getField, ActivitiesTemplateConfigDetailVo::getTitle));
            for (ActivityPlanItemModifyDto dto : thisDtoList) {
                Validate.notBlank((CharSequence)dto.getActivityTypeCode(), (String)(templateDetailTitleMap.getOrDefault("activityTypeCode", "\u6d3b\u52a8\u5206\u7c7b") + "\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
                DateStringDealUtil.validateDateStrAndSet((String)dto.getActivityBeginDateStr(), (String)"\u65b9\u6848\u5f00\u59cb\u65f6\u95f4", (boolean)true, (String)"yyyy-MM-dd", arg_0 -> ((ActivityPlanItemModifyDto)dto).setActivityBeginDate(arg_0));
                DateStringDealUtil.validateDateStrAndSet((String)dto.getActivityEndDateStr(), (String)"\u65b9\u6848\u7ed3\u675f\u65f6\u95f4", (boolean)true, (String)"yyyy-MM-dd", arg_0 -> ((ActivityPlanItemModifyDto)dto).setActivityEndDate(arg_0));
                Validate.notNull((Object)dto.getTotalFeeAmountStr(), (String)(templateDetailTitleMap.getOrDefault("totalFeeAmountStr", "\u8d39\u7528\u5408\u8ba1") + "\u4e0d\u80fd\u4e3a\u7a7a\uff01"), (Object[])new Object[0]);
            }
            for (ActivitiesTemplateConfigDetailVo configDetail : templateConfigVo.getDetails()) {
                if (null == configDetail.getRequired() || !configDetail.getRequired().booleanValue()) continue;
                if (!propertyMap.containsKey(configDetail.getField())) {
                    throw new RuntimeException("\u6a21\u677f[" + templateConfigVo.getConfigName() + "]\u5c5e\u6027[" + configDetail.getTitle() + "]\u914d\u7f6e\u6709\u8bef");
                }
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyMap.get(configDetail.getField());
                if (null != propertyDescriptor) {
                    for (ActivityPlanItemModifyDto dto : thisDtoList) {
                        try {
                            Object invoke = propertyDescriptor.getReadMethod().invoke((Object)dto, new Object[0]);
                            if (null != invoke && !StringUtils.isEmpty((CharSequence)invoke.toString())) continue;
                            throw new RuntimeException("[" + configDetail.getTitle() + "]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException("[" + configDetail.getTitle() + "]\u8bfb\u53d6\u5931\u8d25\uff01");
                        }
                    }
                    continue;
                }
                throw new RuntimeException("[" + configDetail.getTitle() + "]\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            ObjectConvertStringUtil.convertObjectListStrProperties(dtoList, ActivityPlanItemModifyDto.class, (boolean)true, templateDetailTitleMap);
        }
        this.verticalValidate(planDto, dtoList, itemMap);
        this.headquartersValidate(planDto, dtoList, itemMap);
    }

    private void verticalValidate(ActivityPlanModifyDto planDto, List<ActivityPlanItemModifyDto> dtoList, Map<String, ActivityPlanItemDto> itemMap) {
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(planDto.getBusinessUnitCode())) {
            return;
        }
        List actFormCodes = dtoList.stream().map(ActivityPlanItemBase::getActivityFormCode).distinct().collect(Collectors.toList());
        Map formMap = this.activityFormService.findPushSap(actFormCodes);
        Date nowDate = new Date();
        ArrayList validateSapList = Lists.newArrayList();
        for (ActivityPlanItemModifyDto itemDto : dtoList) {
            ActivityPlanItemDto activityPlanItem = itemMap.get(itemDto.getPlanItemCode());
            if (activityPlanItem.getActivityEndDate().before(nowDate)) {
                throw new RuntimeException("[" + activityPlanItem.getPlanItemCode() + "]\u6d3b\u52a8\u65f6\u95f4\u5df2\u7ed3\u675f\u4e0d\u5141\u8bb8\u53d8\u66f4\u6d3b\u52a8");
            }
            if (itemDto.getActivityEndDate().before(nowDate) || null != itemDto.getOrderEndDate() && itemDto.getOrderEndDate().before(nowDate)) {
                throw new RuntimeException("[" + activityPlanItem.getPlanItemCode() + "]\u6d3b\u52a8/\u8ba2\u5355\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65e5\u671f");
            }
            if (activityPlanItem.getActivityBeginDate().after(nowDate)) {
                if (itemDto.getActivityBeginDate().before(nowDate) || null != itemDto.getOrderBeginDate() && itemDto.getOrderBeginDate().before(nowDate)) {
                    throw new RuntimeException("[" + activityPlanItem.getPlanItemCode() + "]\u6d3b\u52a8\u8fd8\u672a\u5f00\u59cb\uff0c\u53d8\u66f4\u5f00\u59cb\u65e5\u671f\u65f6\uff0c\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65e5\u671f");
                }
            } else if (activityPlanItem.getActivityBeginDate().compareTo(itemDto.getActivityBeginDate()) != 0 || null != activityPlanItem.getOrderBeginDate() && null != itemDto.getOrderBeginDate() && activityPlanItem.getOrderBeginDate().compareTo(itemDto.getOrderBeginDate()) != 0) {
                throw new RuntimeException("[" + activityPlanItem.getPlanItemCode() + "]\u5df2\u7ecf\u5f00\u59cb\uff0c\u6d3b\u52a8/\u8ba2\u5355\u5f00\u59cb\u65e5\u671f\u4e0d\u5141\u8bb8\u53d8\u66f4");
            }
            if (formMap.containsKey(itemDto.getActivityFormCode())) {
                validateSapList.add(itemDto);
            }
            if (!StringUtils.isNotBlank((CharSequence)itemDto.getPublicOrNot()) || !BooleanEnum.TRUE.getCapital().equals(itemDto.getPublicOrNot())) continue;
            if (Optional.ofNullable(activityPlanItem.getStoreUtility()).orElse(0).compareTo(Optional.ofNullable(itemDto.getStoreUtility()).orElse(0)) != 0) {
                throw new RuntimeException("[" + activityPlanItem.getPlanItemCode() + "]\u662f\u5426\u5171\u7528\u4e3a\u201c\u662f\u201d\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u95e8\u5e97\u5171\u7528\u91cf");
            }
            if (Optional.ofNullable(activityPlanItem.getStorePublicAmount()).orElse(BigDecimal.ZERO).compareTo(Optional.ofNullable(itemDto.getStorePublicAmount()).orElse(BigDecimal.ZERO)) == 0) continue;
            throw new RuntimeException("[" + activityPlanItem.getPlanItemCode() + "]\u662f\u5426\u5171\u7528\u4e3a\u201c\u662f\u201d\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u95e8\u5e97\u5171\u7528\u91d1\u989d");
        }
        if (!CollectionUtils.isEmpty((Collection)validateSapList)) {
            List validateSapPlanItemCodeList = validateSapList.stream().map(ActivityPlanItemBase::getPlanItemCode).collect(Collectors.toList());
            ActivityPlanSapAmountEventDto sapAmountEventDto = new ActivityPlanSapAmountEventDto();
            sapAmountEventDto.setPlanItemCodeList(validateSapPlanItemCodeList);
            SerializableBiConsumer & Serializable getSapAmountByDetailItemNos = ActivityPlanSapAmountListener::getSapAmountByDetailItemNos;
            ActivityPlanSapAmountResponse sapAmountResponse = (ActivityPlanSapAmountResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)sapAmountEventDto, ActivityPlanSapAmountListener.class, (SerializableBiConsumer)getSapAmountByDetailItemNos);
            Map sapMap = sapAmountResponse.getAmountMap();
            for (ActivityPlanItemModifyDto itemDto : validateSapList) {
                ActivityPlanItemDto activityPlanItem = itemMap.get(itemDto.getPlanItemCode());
                if (Optional.ofNullable(itemDto.getPeriodPromotionalNumber()).orElse(0).compareTo(Optional.ofNullable(activityPlanItem.getPeriodPromotionalNumber()).orElse(0)) <= 0) {
                    BigDecimal sapAmount = (BigDecimal)sapMap.get(itemDto.getPlanItemCode());
                    if (new BigDecimal(Optional.ofNullable(itemDto.getPeriodPromotionalNumber()).orElse(0)).compareTo(Optional.ofNullable(sapAmount).orElse(BigDecimal.ZERO)) >= 0) continue;
                    throw new RuntimeException("[" + activityPlanItem.getPlanItemCode() + "]\u8c03\u51cf\u4e0d\u5141\u8bb8\u5c11\u4e8e\u53d1\u751f\u91cf");
                }
                throw new RuntimeException("[" + activityPlanItem.getPlanItemCode() + "]\u8ffd\u52a0\u91cf\u65f6\uff0c\u5982\u679c\u539f\u6d3b\u52a8\u91cf\u8fd8\u6709\u5269\u4f59\uff0c\u5219\u5148\u5173\u95ed\u539f\u6d3b\u52a8\uff0c\u518d\u65b0\u589e\u6d3b\u52a8");
            }
        }
    }

    private void headquartersValidate(ActivityPlanModifyDto planDto, List<ActivityPlanItemModifyDto> dtoList, Map<String, ActivityPlanItemDto> itemMap) {
        if (!BusinessUnitEnum.isDefaultBusinessUnit((String)planDto.getBusinessUnitCode())) {
            return;
        }
        HashSet budgetItemCodeSet = Sets.newHashSet();
        HashSet feeBudgetCodeSet = Sets.newHashSet();
        for (ActivityPlanItemModifyDto itemDto : dtoList) {
            if (null != itemDto.getSalesAmount() && BigDecimal.ZERO.compareTo(itemDto.getSalesAmount()) != 0) {
                BigDecimal sumFeeAmount = BigDecimal.ZERO;
                if (null != itemDto.getHeadFeeAmount()) {
                    sumFeeAmount = sumFeeAmount.add(itemDto.getHeadFeeAmount());
                }
                if (null != itemDto.getDepartmentFeeAmount()) {
                    sumFeeAmount = sumFeeAmount.add(itemDto.getDepartmentFeeAmount());
                }
                itemDto.setFeeRate(sumFeeAmount.divide(itemDto.getSalesAmount(), 4, RoundingMode.HALF_DOWN));
            }
            if (StringUtils.isNotEmpty((CharSequence)itemDto.getHeadMonthBudgetCode())) {
                budgetItemCodeSet.add(itemDto.getHeadBudgetItemCode());
                feeBudgetCodeSet.add(itemDto.getHeadMonthBudgetCode());
            }
            if (!StringUtils.isNotEmpty((CharSequence)itemDto.getMonthBudgetCode())) continue;
            budgetItemCodeSet.add(itemDto.getBudgetItemCode());
            feeBudgetCodeSet.add(itemDto.getMonthBudgetCode());
        }
        if (!CollectionUtils.isEmpty((Collection)feeBudgetCodeSet)) {
            List budgetItemVos = this.budgetItemService.listByCodes((List)Lists.newArrayList((Iterable)budgetItemCodeSet));
            if (CollectionUtils.isEmpty((Collection)budgetItemVos)) {
                throw new RuntimeException("\u9884\u7b97\u9879\u76ee\u67e5\u8be2\u5931\u8d25\uff01");
            }
            ArrayList feeBudgetCodeList = Lists.newArrayList((Iterable)feeBudgetCodeSet);
            List budgetVos = this.monthBudgetService.findByCodes((List)feeBudgetCodeList, null);
            Map budgetVoMap = budgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
            Map budgetItemMap = budgetItemVos.stream().collect(Collectors.toMap(BudgetItemVo::getBudgetItemCode, Function.identity()));
            Calendar calendar = Calendar.getInstance();
            for (ActivityPlanItemModifyDto item : dtoList) {
                MonthBudgetVo monthBudgetVo;
                BudgetItemVo budgetItemVo;
                String allowAcrossMonth = BooleanEnum.FALSE.getCapital();
                String headYearMonth = null;
                String yearMonth = null;
                if (StringUtils.isNotEmpty((CharSequence)item.getHeadMonthBudgetCode())) {
                    budgetItemVo = (BudgetItemVo)budgetItemMap.get(item.getHeadBudgetItemCode());
                    if (null == budgetItemVo) {
                        throw new RuntimeException("\u9884\u7b97\u9879\u76ee[" + item.getHeadBudgetItemCode() + "]\u6709\u8bef\uff01");
                    }
                    if (BooleanEnum.TRUE.getCapital().equals(budgetItemVo.getAllowCrossMonth())) {
                        allowAcrossMonth = BooleanEnum.TRUE.getCapital();
                    }
                    if (null == (monthBudgetVo = (MonthBudgetVo)budgetVoMap.get(item.getHeadMonthBudgetCode()))) {
                        throw new RuntimeException("\u603b\u90e8\u9884\u7b97[" + item.getHeadMonthBudgetCode() + "]\u6709\u8bef\uff01");
                    }
                    headYearMonth = monthBudgetVo.getYearMonthLy();
                }
                if (StringUtils.isNotEmpty((CharSequence)item.getMonthBudgetCode())) {
                    budgetItemVo = (BudgetItemVo)budgetItemMap.get(item.getBudgetItemCode());
                    if (null == budgetItemVo) {
                        throw new RuntimeException("\u9884\u7b97\u9879\u76ee[" + item.getBudgetItemCode() + "]\u6709\u8bef\uff01");
                    }
                    if (BooleanEnum.TRUE.getCapital().equals(budgetItemVo.getAllowCrossMonth())) {
                        allowAcrossMonth = BooleanEnum.TRUE.getCapital();
                    }
                    if (null == (monthBudgetVo = (MonthBudgetVo)budgetVoMap.get(item.getMonthBudgetCode()))) {
                        throw new RuntimeException("\u5927\u533a\u9884\u7b97[" + item.getHeadMonthBudgetCode() + "]\u6709\u8bef\uff01");
                    }
                    yearMonth = monthBudgetVo.getYearMonthLy();
                }
                if (!BooleanEnum.FALSE.getCapital().equals(allowAcrossMonth)) continue;
                if (StringUtils.isNotEmpty(headYearMonth)) {
                    int year = Integer.parseInt(headYearMonth.substring(0, 4));
                    int month = Integer.parseInt(headYearMonth.substring(5)) - 1;
                    calendar.setTime(item.getActivityBeginDate());
                    if (calendar.get(1) != year || calendar.get(2) != month) {
                        throw new RuntimeException("\u9884\u7b97\u9879\u76ee[" + item.getBudgetItemCode() + "]\u4e0d\u5141\u8bb8\u8de8\u6708\u4f7f\u7528\uff0c\u8bf7\u4fee\u6539\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u3001\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\uff01");
                    }
                    calendar.setTime(item.getActivityEndDate());
                    if (calendar.get(1) != year || calendar.get(2) != month) {
                        throw new RuntimeException("\u9884\u7b97\u9879\u76ee[" + item.getBudgetItemCode() + "]\u4e0d\u5141\u8bb8\u8de8\u6708\u4f7f\u7528\uff0c\u8bf7\u4fee\u6539\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u3001\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\uff01");
                    }
                }
                if (!StringUtils.isNotEmpty(yearMonth)) continue;
                int year = Integer.parseInt(yearMonth.substring(0, 4));
                int month = Integer.parseInt(yearMonth.substring(5)) - 1;
                calendar.setTime(item.getActivityBeginDate());
                if (calendar.get(1) != year || calendar.get(2) != month) {
                    throw new RuntimeException("\u9884\u7b97\u9879\u76ee[" + item.getBudgetItemCode() + "]\u4e0d\u5141\u8bb8\u8de8\u6708\u4f7f\u7528\uff0c\u8bf7\u4fee\u6539\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u3001\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\uff01");
                }
                calendar.setTime(item.getActivityEndDate());
                if (calendar.get(1) == year && calendar.get(2) == month) continue;
                throw new RuntimeException("\u9884\u7b97\u9879\u76ee[" + item.getBudgetItemCode() + "]\u4e0d\u5141\u8bb8\u8de8\u6708\u4f7f\u7528\uff0c\u8bf7\u4fee\u6539\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u3001\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\uff01");
            }
        }
        for (ActivityPlanItemModifyDto itemDto : dtoList) {
            ActivityPlanItemDto activityPlanItem = itemMap.get(itemDto.getPlanItemCode());
            if (itemDto.getActivityBeginDate().compareTo(activityPlanItem.getActivityBeginDate()) > 0) {
                throw new RuntimeException("\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u53ea\u80fd\u63d0\u524d\uff01");
            }
            if (itemDto.getActivityEndDate().compareTo(activityPlanItem.getActivityEndDate()) < 0) {
                throw new RuntimeException("\u6d3b\u52a8\u5f00\u59cb\u7ed3\u675f\u53ea\u80fd\u5ef6\u540e\uff01");
            }
            if (null != itemDto.getUsedHeadFeeAmount() && itemDto.getUsedHeadFeeAmount().compareTo(BigDecimal.ZERO) > 0 && (null == itemDto.getHeadFeeAmount() || itemDto.getHeadFeeAmount().compareTo(itemDto.getUsedHeadFeeAmount()) < 0)) {
                throw new RuntimeException("\u603b\u90e8\u627f\u62c5\u91d1\u989d[" + itemDto.getHeadFeeAmount() + "]\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u53d1\u751f\u91d1\u989d[" + itemDto.getUsedHeadFeeAmount() + "]");
            }
            if (null != itemDto.getUsedDepartmentFeeAmount() && itemDto.getUsedDepartmentFeeAmount().compareTo(BigDecimal.ZERO) > 0 && (null == itemDto.getDepartmentFeeAmount() || itemDto.getDepartmentFeeAmount().compareTo(itemDto.getUsedDepartmentFeeAmount()) < 0)) {
                throw new RuntimeException("\u5927\u533a\u627f\u62c5\u91d1\u989d[" + itemDto.getDepartmentFeeAmount() + "]\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u53d1\u751f\u91d1\u989d[" + itemDto.getUsedDepartmentFeeAmount() + "]");
            }
            if (null != itemDto.getUsedCustomerFeeAmount() && itemDto.getUsedCustomerFeeAmount().compareTo(BigDecimal.ZERO) > 0 && (null == itemDto.getCustomerFeeAmount() || itemDto.getCustomerFeeAmount().compareTo(itemDto.getUsedCustomerFeeAmount()) < 0)) {
                throw new RuntimeException("\u5ba2\u6237\u627f\u62c5\u91d1\u989d[" + itemDto.getCustomerFeeAmount() + "]\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u53d1\u751f\u91d1\u989d[" + itemDto.getUsedCustomerFeeAmount() + "]");
            }
            if (null != activityPlanItem.getUsedHeadFeeAmount() && activityPlanItem.getUsedHeadFeeAmount().compareTo(BigDecimal.ZERO) > 0 && (null == itemDto.getUsedHeadFeeAmount() || itemDto.getUsedHeadFeeAmount().compareTo(activityPlanItem.getUsedHeadFeeAmount()) < 0)) {
                throw new RuntimeException("\u603b\u90e8\u627f\u62c5\u91d1\u989d\u5df2\u53d1\u751f\u91d1\u989d[" + itemDto.getUsedHeadFeeAmount() + "]\u4e0d\u80fd\u5c0f\u4e8e\u5b9e\u9645\u5df2\u53d1\u751f\u91d1\u989d[" + activityPlanItem.getUsedHeadFeeAmount() + "]");
            }
            if (null != activityPlanItem.getUsedDepartmentFeeAmount() && activityPlanItem.getUsedDepartmentFeeAmount().compareTo(BigDecimal.ZERO) > 0 && (null == itemDto.getUsedDepartmentFeeAmount() || itemDto.getUsedDepartmentFeeAmount().compareTo(activityPlanItem.getUsedDepartmentFeeAmount()) < 0)) {
                throw new RuntimeException("\u5927\u533a\u627f\u62c5\u91d1\u989d\u5df2\u53d1\u751f\u91d1\u989d[" + itemDto.getUsedDepartmentFeeAmount() + "]\u4e0d\u80fd\u5c0f\u4e8e\u5b9e\u9645\u5df2\u53d1\u751f\u91d1\u989d[" + activityPlanItem.getUsedDepartmentFeeAmount() + "]");
            }
            if (null != activityPlanItem.getUsedCustomerFeeAmount() && activityPlanItem.getUsedCustomerFeeAmount().compareTo(BigDecimal.ZERO) > 0 && (null == itemDto.getUsedCustomerFeeAmount() || itemDto.getUsedCustomerFeeAmount().compareTo(activityPlanItem.getUsedCustomerFeeAmount()) < 0)) {
                throw new RuntimeException("\u5ba2\u6237\u627f\u62c5\u91d1\u989d\u5df2\u53d1\u751f\u91d1\u989d[" + itemDto.getUsedCustomerFeeAmount() + "]\u4e0d\u80fd\u5c0f\u4e8e\u5b9e\u9645\u5df2\u53d1\u751f\u91d1\u989d[" + activityPlanItem.getUsedCustomerFeeAmount() + "]");
            }
            if (!BooleanEnum.TRUE.getCapital().equals(activityPlanItem.getWholeAudit())) continue;
            throw new RuntimeException("\u6d3b\u52a8\u65b9\u6848\u660e\u7ec6[" + activityPlanItem.getPlanItemCode() + "]\u5df2\u8fdb\u884c\u9884\u7b97\u56de\u9000\uff0c\u4e0d\u80fd\u8c03\u6574");
        }
        List planItemCodeList = dtoList.stream().map(ActivityPlanItemBase::getPlanItemCode).collect(Collectors.toList());
        ActivityPlanQueryHeadSchemeForecastDto headSchemeForecastEventDto = new ActivityPlanQueryHeadSchemeForecastDto();
        headSchemeForecastEventDto.setPlanItemCodeList(planItemCodeList);
        SerializableBiConsumer & Serializable headSchemeForecastConsumer = ActivityPlanQueryHeadSchemeForecastListener::findListByConditions;
        ActivityPlanQueryHeadSchemeForecastResponse headSchemeForecastEventResponse = (ActivityPlanQueryHeadSchemeForecastResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)headSchemeForecastEventDto, ActivityPlanQueryHeadSchemeForecastListener.class, (SerializableBiConsumer)headSchemeForecastConsumer);
        if (null != headSchemeForecastEventResponse && !CollectionUtils.isEmpty((Collection)headSchemeForecastEventResponse.getList())) {
            Map headSchemeForecastVoMap = headSchemeForecastEventResponse.getList().stream().collect(Collectors.toMap(ActivityPlanQueryHeadSchemeForecastVo::getSchemeItemCode, Function.identity()));
            for (ActivityPlanItemModifyDto next : dtoList) {
                ActivityPlanQueryHeadSchemeForecastVo headSchemeForecastVo = (ActivityPlanQueryHeadSchemeForecastVo)headSchemeForecastVoMap.get(next.getPlanItemCode());
                if (null == headSchemeForecastVo || !"2".equals(headSchemeForecastVo.getStatus())) continue;
                String errorMsg = "\u65b9\u6848\u660e\u7ec6[" + next.getPlanItemCode() + "]\u5df2\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed";
                throw new RuntimeException(errorMsg);
            }
        }
    }

    @Override
    public void deleteByModifyCodes(List<String> modifyCodes) {
        if (CollectionUtils.isEmpty(modifyCodes)) {
            return;
        }
        this.activityPlanItemModifyRepository.deleteByModifyCodes(modifyCodes);
    }

    @Override
    public Page<ActivityPlanModifyFieldValue> findItemModifyLFieldValueList(Pageable pageable, String modifyCode) throws InvocationTargetException, IllegalAccessException {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page.setTotal(0L);
        page.setRecords((List)Lists.newArrayList());
        PageRequest tempPageable = PageRequest.of((int)1, (int)999999);
        ActivityPlanItemModifyDto activityPlanItemModifyDto = new ActivityPlanItemModifyDto();
        activityPlanItemModifyDto.setModifyBusinessCode(modifyCode);
        Page<ActivityPlanItemModifyVo> itemBeforeModifyPage = this.findItemBeforeModifyList((Pageable)tempPageable, activityPlanItemModifyDto);
        Page<ActivityPlanItemModifyVo> itemModifyPage = this.findByConditions((Pageable)tempPageable, activityPlanItemModifyDto);
        List itemBeforeModifyList = itemBeforeModifyPage.getRecords();
        List itemModifyList = itemModifyPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)itemBeforeModifyList)) {
            return page;
        }
        List<ActivityPlanModifyFieldValue> itemModifyLFieldValueList = this.findItemModifyLFieldValueList(itemModifyList, itemBeforeModifyList);
        page.setTotal((long)itemModifyLFieldValueList.size());
        long start = page.offset();
        if (page.getTotal() > start) {
            long end = page.offset() + page.getSize();
            if (page.getTotal() < end) {
                end = page.getTotal();
            }
            List<ActivityPlanModifyFieldValue> recordList = itemModifyLFieldValueList.subList((int)page.offset(), (int)end);
            page.setRecords(recordList);
        }
        return page;
    }

    @Override
    public List<ActivityPlanModifyFieldValue> findItemModifyLFieldValueListByProcessNo(String processNo) throws InvocationTargetException, IllegalAccessException {
        PageRequest tempPageable = PageRequest.of((int)1, (int)999999);
        List<String> businessNoList = this.findModifyBusinessNoListByProcessNo(processNo);
        ActivityPlanItemModifyDto activityPlanItemModifyDto = new ActivityPlanItemModifyDto();
        activityPlanItemModifyDto.setModifyBusinessCodeList(businessNoList);
        Page<ActivityPlanItemModifyVo> itemBeforeModifyPage = this.findItemBeforeModifyList((Pageable)tempPageable, activityPlanItemModifyDto);
        Page<ActivityPlanItemModifyVo> itemModifyPage = this.findByConditions((Pageable)tempPageable, activityPlanItemModifyDto);
        List itemBeforeModifyList = itemBeforeModifyPage.getRecords();
        List itemModifyList = itemModifyPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)itemBeforeModifyList)) {
            return Lists.newArrayList();
        }
        return this.findItemModifyLFieldValueList(itemModifyList, itemBeforeModifyList);
    }

    private List<ActivityPlanModifyFieldValue> findItemModifyLFieldValueList(List<ActivityPlanItemModifyVo> itemModifyList, List<ActivityPlanItemModifyVo> itemBeforeModifyList) throws InvocationTargetException, IllegalAccessException {
        Field[] declaredFields;
        Map itemModifyMap = itemModifyList.stream().collect(Collectors.toMap(ActivityPlanItemBase::getPlanItemCode, Function.identity()));
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanItemModifyVo.class);
        Map propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        HashMap modifyFieldMap = Maps.newHashMap();
        for (Field declaredField : declaredFields = ActivityPlanItemModify.class.getDeclaredFields()) {
            ApiModelProperty modelProperty = declaredField.getDeclaredAnnotation(ApiModelProperty.class);
            if (null == modelProperty) continue;
            modifyFieldMap.put(declaredField.getName(), modelProperty.value());
        }
        ArrayList modifyFieldValueList = Lists.newArrayList();
        for (ActivityPlanItemModifyVo itemVo : itemBeforeModifyList) {
            ActivityPlanItemModifyVo itemModifyVo = (ActivityPlanItemModifyVo)itemModifyMap.get(itemVo.getPlanItemCode());
            for (Map.Entry entry : modifyFieldMap.entrySet()) {
                String fieldName = (String)entry.getKey();
                String fieldTitle = (String)entry.getValue();
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyMap.get(fieldName);
                Object beforeFieldValue = propertyDescriptor.getReadMethod().invoke((Object)itemVo, new Object[0]);
                Object fieldValue = propertyDescriptor.getReadMethod().invoke((Object)itemModifyVo, new Object[0]);
                if (null == beforeFieldValue && null == fieldValue) continue;
                ActivityPlanModifyFieldValue modifyFieldValue = new ActivityPlanModifyFieldValue();
                modifyFieldValue.setPlanCode(itemVo.getPlanCode());
                modifyFieldValue.setPlanItemCode(itemVo.getPlanItemCode());
                modifyFieldValue.setFieldName(fieldName);
                modifyFieldValue.setFieldTitle(fieldTitle);
                if (null != beforeFieldValue && null != fieldValue) {
                    BigDecimal fieldValueBigDecimal;
                    BigDecimal beforeFieldValueBigDecimal;
                    Integer fieldValueInt;
                    Integer beforeFieldValueInt;
                    if (beforeFieldValue.equals(fieldValue) || (propertyDescriptor.getPropertyType() == Integer.class ? (beforeFieldValueInt = (Integer)beforeFieldValue).compareTo(fieldValueInt = (Integer)fieldValue) == 0 : propertyDescriptor.getPropertyType() == BigDecimal.class && (beforeFieldValueBigDecimal = (BigDecimal)beforeFieldValue).compareTo(fieldValueBigDecimal = (BigDecimal)fieldValue) == 0)) continue;
                    modifyFieldValue.setBeforeFieldValue(beforeFieldValue.toString());
                    modifyFieldValue.setFieldValue(fieldValue.toString());
                } else if (null != beforeFieldValue) {
                    modifyFieldValue.setBeforeFieldValue(beforeFieldValue.toString());
                } else {
                    modifyFieldValue.setFieldValue(fieldValue.toString());
                }
                modifyFieldValueList.add(modifyFieldValue);
            }
        }
        return modifyFieldValueList;
    }

    public Page<ActivityPlanItemModifyVo> findItemBeforeModifyList(Pageable pageable, ActivityPlanItemModifyDto dto) {
        return this.activityPlanItemModifyRepository.findItemBeforeModifyList(pageable, dto);
    }

    private List<String> findModifyBusinessNoListByProcessNo(String processNo) {
        ProcessBusinessMappingDto processBusinessMappingDto = new ProcessBusinessMappingDto();
        processBusinessMappingDto.setProcessNo(processNo);
        List processBusinessMappingVoList = this.processBusinessMappingService.findMultiByByConditions(processBusinessMappingDto);
        if (CollectionUtils.isEmpty((Collection)processBusinessMappingVoList)) {
            throw new RuntimeException("\u6d41\u7a0b\u6570\u636e\u6709\u8bef\uff01");
        }
        return processBusinessMappingVoList.stream().map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
    }
}

