/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.modify.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanItemTerminalModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanItemTerminalModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanItemTerminalModifyService;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.internal.ActivityPlanItemModifyPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemTerminalModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanItemTerminalModifyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityPlanItemTerminalModifyServiceImpl
implements ActivityPlanItemTerminalModifyService {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityPlanItemTerminalModifyRepository activityPlanItemTerminalModifyRepository;
    @Autowired(required=false)
    private ActivityPlanItemModifyPageCacheHelper itemHelper;

    @Override
    public void saveActivityPlanItemTerminalList(ActivityPlanModify entity, boolean update, List<ActivityPlanItemModifyDto> itemList) {
        if (update) {
            this.activityPlanItemTerminalModifyRepository.deleteByModifyBusinessCode(entity.getModifyBusinessCode());
        }
        ArrayList allList = new ArrayList();
        for (ActivityPlanItemModifyDto itemDto : itemList) {
            List terminalList = itemDto.getActivityPlanItemTerminalList();
            if (CollectionUtils.isEmpty((Collection)terminalList)) continue;
            for (ActivityPlanItemTerminalModifyDto dto : terminalList) {
                dto.setModifyBusinessCode(entity.getModifyBusinessCode());
                dto.setPlanCode(entity.getPlanCode());
                dto.setPlanItemCode(itemDto.getPlanItemCode());
                if (null == dto.getBeginDate()) {
                    dto.setBeginDate(itemDto.getActivityBeginDate());
                }
                if (null == dto.getEndDate()) {
                    dto.setEndDate(itemDto.getActivityEndDate());
                }
                dto.setTenantCode(TenantUtils.getTenantCode());
            }
            List activityPlanItemTerminals = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)terminalList, ActivityPlanItemTerminalModifyDto.class, ActivityPlanItemTerminalModify.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            allList.addAll(activityPlanItemTerminals);
        }
        if (!CollectionUtils.isEmpty(allList)) {
            this.activityPlanItemTerminalModifyRepository.saveBatch(allList);
        }
    }

    @Override
    public void deleteByModifyCodes(List<String> modifyCodes) {
        this.activityPlanItemTerminalModifyRepository.deleteByModifyBusinessCode(modifyCodes);
    }

    @Override
    public void clearCache(String cacheKey) {
        String itemId;
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        ActivityPlanItemModifyDto itemDto = (ActivityPlanItemModifyDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1));
        if (null == itemDto) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
        }
        itemDto.setActivityPlanItemTerminalList(null);
        HashMap updateMap = Maps.newHashMap();
        updateMap.put(itemId, itemDto);
        this.itemHelper.doSaveItem(itemCacheKey, updateMap);
    }

    @Override
    public void addItemCache(String cacheKey, List<ActivityPlanItemTerminalModifyDto> itemList) {
        String itemId;
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        ActivityPlanItemModifyDto itemDto = (ActivityPlanItemModifyDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1));
        if (null == itemDto) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
        }
        List itemTerminalList = itemDto.getActivityPlanItemTerminalList();
        if (null == itemTerminalList) {
            itemTerminalList = Lists.newArrayList();
            itemDto.setActivityPlanItemTerminalList(itemTerminalList);
        }
        ActivityPlanItemTerminalModifyDto newItem = new ActivityPlanItemTerminalModifyDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        itemTerminalList.add(0, newItem);
        HashMap updateMap = Maps.newHashMap();
        updateMap.put(itemId, itemDto);
        this.itemHelper.doSaveItem(itemCacheKey, updateMap);
    }

    @Override
    public Page<ActivityPlanItemTerminalModifyVo> findCachePageList(Pageable pageable, ActivityPlanItemTerminalModifyDto dto, String cacheKey) {
        String itemId;
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        ActivityPlanItemModifyDto itemDto = (ActivityPlanItemModifyDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1));
        if (null == itemDto) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page.setTotal(0L);
        page.setRecords((List)com.google.common.collect.Lists.newArrayList());
        List dtoList = itemDto.getActivityPlanItemTerminalList();
        if (CollectionUtils.isEmpty((Collection)dtoList)) {
            return page;
        }
        page.setTotal((long)dtoList.size());
        long start = page.offset();
        if (page.getTotal() > start) {
            long end = page.offset() + page.getSize();
            if (page.getTotal() < end) {
                end = page.getTotal();
            }
            List recordDtoList = dtoList.subList((int)page.offset(), (int)end);
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(recordDtoList, ActivityPlanItemTerminalModifyDto.class, ActivityPlanItemTerminalModifyVo.class, HashSet.class, ArrayList.class, new String[0]);
            page.setRecords(voList);
        }
        return page;
    }

    @Override
    public List<ActivityPlanItemTerminalModifyDto> findCacheList(String cacheKey) {
        String itemId;
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        ActivityPlanItemModifyDto itemDto = (ActivityPlanItemModifyDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1));
        if (null == itemDto) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
        }
        return itemDto.getActivityPlanItemTerminalList();
    }

    @Override
    public void saveListCache(String cacheKey, List<ActivityPlanItemTerminalModifyDto> itemList) {
        String itemId;
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        ActivityPlanItemModifyDto itemDto = (ActivityPlanItemModifyDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1));
        if (null == itemDto) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
        }
        List itemTerminalList = itemDto.getActivityPlanItemTerminalList();
        if (null == itemTerminalList) {
            itemTerminalList = Lists.newArrayList();
            itemDto.setActivityPlanItemTerminalList(itemTerminalList);
        }
        List idList = itemTerminalList.stream().map(UuidDto::getId).collect(Collectors.toList());
        List updateList = itemList.stream().filter(item -> idList.contains(item.getId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(updateList)) {
            Map existsMap = itemTerminalList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
            for (ActivityPlanItemTerminalModifyDto terminalDto : updateList) {
                ActivityPlanItemTerminalModifyDto oldTerminalDto = (ActivityPlanItemTerminalModifyDto)existsMap.get(terminalDto);
                if (null == oldTerminalDto) continue;
                BeanUtils.copyProperties((Object)terminalDto, (Object)oldTerminalDto);
            }
        }
        List newItemList = itemList.stream().filter(item -> !idList.contains(item.getId())).collect(Collectors.toList());
        itemTerminalList.addAll(newItemList);
        HashMap updateMap = Maps.newHashMap();
        updateMap.put(itemId, itemDto);
        this.itemHelper.doSaveItem(itemCacheKey, updateMap);
    }

    @Override
    public void copyItemListCache(String cacheKey, List<ActivityPlanItemTerminalModifyDto> updateList) {
        String itemId;
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        ActivityPlanItemModifyDto itemDto = (ActivityPlanItemModifyDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1));
        if (null == itemDto) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
        }
        List itemTerminalList = itemDto.getActivityPlanItemTerminalList();
        if (null == itemTerminalList) {
            itemTerminalList = Lists.newArrayList();
            itemDto.setActivityPlanItemTerminalList(itemTerminalList);
        }
        Map existsMap = itemTerminalList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        for (ActivityPlanItemTerminalModifyDto terminalDto : updateList) {
            ActivityPlanItemTerminalModifyDto oldTerminalDto = (ActivityPlanItemTerminalModifyDto)existsMap.get(terminalDto.getId());
            if (BooleanEnum.TRUE.getNumStr().equals(terminalDto.getChecked())) {
                ActivityPlanItemTerminalModifyDto copyTerminalDto = (ActivityPlanItemTerminalModifyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)terminalDto, ActivityPlanItemTerminalModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
                copyTerminalDto.setId(UUID.randomUUID().toString().replace("-", ""));
                copyTerminalDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                copyTerminalDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                itemTerminalList.add(0, copyTerminalDto);
                continue;
            }
            if (null == oldTerminalDto) continue;
            BeanUtils.copyProperties((Object)terminalDto, (Object)oldTerminalDto);
        }
        HashMap updateMap = Maps.newHashMap();
        updateMap.put(itemId, itemDto);
        this.itemHelper.doSaveItem(itemCacheKey, updateMap);
    }

    @Override
    public void saveCurrentPageCache(String cacheKey, List<ActivityPlanItemTerminalModifyDto> updateList) {
        String itemId;
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        ActivityPlanItemModifyDto itemDto = (ActivityPlanItemModifyDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1));
        if (null == itemDto) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
        }
        List itemTerminalList = itemDto.getActivityPlanItemTerminalList();
        if (null == itemTerminalList) {
            itemTerminalList = Lists.newArrayList();
            itemDto.setActivityPlanItemTerminalList(itemTerminalList);
        }
        Map existsMap = itemTerminalList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        for (ActivityPlanItemTerminalModifyDto terminalDto : updateList) {
            ActivityPlanItemTerminalModifyDto oldTerminalDto = (ActivityPlanItemTerminalModifyDto)existsMap.get(terminalDto.getId());
            if (null == oldTerminalDto) continue;
            BeanUtils.copyProperties((Object)terminalDto, (Object)oldTerminalDto);
        }
        HashMap updateMap = Maps.newHashMap();
        updateMap.put(itemId, itemDto);
        this.itemHelper.doSaveItem(itemCacheKey, updateMap);
    }

    @Override
    public void deleteCacheList(String cacheKey, List<ActivityPlanItemTerminalModifyDto> updateList) {
        String itemId;
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        ActivityPlanItemModifyDto itemDto = (ActivityPlanItemModifyDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1));
        if (null == itemDto) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
        }
        List itemTerminalList = itemDto.getActivityPlanItemTerminalList();
        if (null == itemTerminalList) {
            itemTerminalList = Lists.newArrayList();
            itemDto.setActivityPlanItemTerminalList(itemTerminalList);
        }
        Map existsMap = itemTerminalList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        for (ActivityPlanItemTerminalModifyDto terminalDto : updateList) {
            ActivityPlanItemTerminalModifyDto oldTerminalDto = (ActivityPlanItemTerminalModifyDto)existsMap.get(terminalDto.getId());
            if (BooleanEnum.TRUE.getNumStr().equals(terminalDto.getChecked())) {
                itemTerminalList.remove(oldTerminalDto);
                continue;
            }
            if (null == oldTerminalDto) continue;
            BeanUtils.copyProperties((Object)terminalDto, (Object)oldTerminalDto);
        }
        HashMap updateMap = Maps.newHashMap();
        updateMap.put(itemId, itemDto);
        this.itemHelper.doSaveItem(itemCacheKey, updateMap);
    }
}

