/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.modify.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.service.PromotersVoService;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.rocketmq.event.RocketMqProducerEvent;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanBudget;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItem;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItemTerminal;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanRelatePlan;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanStrategy;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanBudgetModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanItemModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanItemTerminalModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanRelatePlanModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanStrategyModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanBudgetModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanItemModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanItemTerminalModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanRelatePlanModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanStrategyModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanBudgetModifyService;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanItemModifyService;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanItemTerminalModifyService;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanModifyService;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanRelatePlanModifyService;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanStrategyModifyService;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemTerminalRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanRelatePlanRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanStrategyRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.log.ActivityPlanModifyLogEventDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanBudgetOccupyTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.PlanRelateLimitEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.event.log.ActivityPlanLogEventListener;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanBudgetModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanItemTerminalModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanModifyApproveSubmitDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanRelatePlanModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanStrategyModifyDto;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.enums.ActivityPlanModifyMqTagEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanRelatePlanModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.vo.ActivityPlanStrategyModifyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanRelatePlanBase;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanStrategyBase;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemTerminalVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyBudgetSdkService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityPlanModifyServiceImpl
implements ActivityPlanModifyService {
    @Autowired(required=false)
    private ActivityPlanModifyRepository activityPlanModifyRepository;
    @Autowired(required=false)
    private ActivityPlanItemModifyRepository activityPlanItemModifyRepository;
    @Autowired(required=false)
    private ActivityPlanStrategyModifyRepository activityPlanStrategyModifyRepository;
    @Autowired(required=false)
    private ActivityPlanRelatePlanModifyRepository activityPlanRelatePLanModifyRepository;
    @Autowired(required=false)
    private ActivityPlanBudgetModifyRepository activityPlanBudgetModifyRepository;
    @Autowired(required=false)
    private ActivityPlanService activityPlanService;
    @Autowired(required=false)
    private ActivityPlanRepository activityPlanRepository;
    @Autowired(required=false)
    private ActivityPlanItemRepository activityPlanItemRepository;
    @Autowired(required=false)
    private ActivityPlanItemTerminalRepository activityPlanItemTerminalRepository;
    @Autowired(required=false)
    private ActivityPlanItemTerminalModifyRepository activityPlanItemTerminalModifyRepository;
    @Autowired(required=false)
    private ActivityPlanRelatePlanRepository activityPlanRelatePlanRepository;
    @Autowired(required=false)
    private ActivityPlanStrategyRepository activityPlanStrategyRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private ActivityPlanItemModifyService activityPlanItemModifyService;
    @Autowired(required=false)
    private ActivityPlanStrategyModifyService activityPlanStrategyModifyService;
    @Autowired(required=false)
    private ActivityPlanRelatePlanModifyService activityPlanRelatePlanModifyService;
    @Autowired(required=false)
    private ActivityPlanBudgetModifyService activityPlanBudgetModifyService;
    @Autowired(required=false)
    private ActivityPlanItemTerminalModifyService activityPlanItemTerminalModifyService;
    @Autowired(required=false)
    private MarketingStrategyBudgetSdkService marketingStrategyBudgetSdkService;
    @Autowired(required=false)
    private ActivityPlanBudgetRepository activityPlanBudgetRepository;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Resource
    private ApplicationEventPublisher eventPublisher;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private PromotersVoService promotersVoService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;

    @Override
    public Page<ActivityPlanVo> findToModifyList(Pageable pageable, ActivityPlanDto dto) {
        return this.activityPlanModifyRepository.findToModifyList(pageable, dto);
    }

    @Override
    public ActivityPlanModifyVo findById(String id) {
        return this.findByIdOrCode(id, null);
    }

    @Override
    public ActivityPlanModifyVo findByIdOrCode(String id, String code) {
        if (StringUtils.isEmpty((CharSequence)id) && StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        ActivityPlanModify entity = null;
        entity = StringUtils.isNotEmpty((CharSequence)id) ? (ActivityPlanModify)((Object)this.activityPlanModifyRepository.getById((Serializable)((Object)id))) : this.activityPlanModifyRepository.getByCode(code);
        if (null != entity) {
            ActivityPlanVo planVo = this.activityPlanService.findByCode(entity.getPlanCode());
            ActivityPlanModifyVo planModifyVo = (ActivityPlanModifyVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)planVo, ActivityPlanModifyVo.class, HashSet.class, ArrayList.class, new String[0]);
            BeanUtils.copyProperties((Object)((Object)entity), (Object)planModifyVo);
            List<ActivityPlanStrategyModifyVo> strategyDtos = this.activityPlanStrategyModifyRepository.findListVoByModifyCode(entity.getModifyBusinessCode());
            planModifyVo.setStrategyList(strategyDtos);
            List<ActivityPlanRelatePlanModifyVo> relatePlanList = this.activityPlanRelatePLanModifyRepository.findListVoByModifyCode(entity.getModifyBusinessCode());
            planModifyVo.setRelatePlanList(relatePlanList);
            planModifyVo.setTemplateList(planVo.getTemplateList());
            this.activityPlanModifyRepository.fillVoProperties(planModifyVo);
            return planModifyVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void create(String cacheKey, ActivityPlanModifyDto dto) {
        List itemList = this.activityPlanItemModifyService.findCacheList(cacheKey);
        this.create(dto, itemList);
    }

    @Transactional(rollbackFor={Exception.class})
    public String create(ActivityPlanModifyDto dto, List<ActivityPlanItemModifyDto> itemList) {
        boolean update;
        if (CollectionUtils.isEmpty(itemList)) {
            throw new RuntimeException("\u65b9\u6848\u53d8\u66f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List<String> planItemCodeList = itemList.stream().map(ActivityPlanItemBase::getPlanItemCode).collect(Collectors.toList());
        List<ActivityPlanItemDto> originItemList = this.activityPlanItemRepository.findDtoAndAttachListByPlanItemCodeList(planItemCodeList);
        Map<String, ActivityPlanItemDto> originItemMap = originItemList.stream().collect(Collectors.toMap(ActivityPlanItemDto::getPlanItemCode, Function.identity()));
        this.createValidate(dto, itemList, originItemMap);
        ActivityPlanModify entity = null;
        ActivityPlanModifyDto oldDto = null;
        boolean bl = update = !StringUtils.isBlank((CharSequence)dto.getId());
        if (!update) {
            entity = (ActivityPlanModify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ActivityPlanModify.class, HashSet.class, ArrayList.class, new String[0]));
            String code = (String)this.generateCodeService.generateCode("AC", 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
            entity.setModifyBusinessCode(code);
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setTenantCode(TenantContextHolder.getTenantInfo().getTenantCode());
            this.activityPlanModifyRepository.save((Object)entity);
        } else {
            ActivityPlanModify oldEntity = (ActivityPlanModify)((Object)this.activityPlanModifyRepository.getById((Serializable)((Object)dto.getId())));
            oldDto = (ActivityPlanModifyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ActivityPlanModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
            dto.setModifyBusinessCode(oldEntity.getModifyBusinessCode());
            dto.setTenantCode(oldEntity.getTenantCode());
            entity = (ActivityPlanModify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ActivityPlanModify.class, HashSet.class, ArrayList.class, new String[0]));
            this.activityPlanModifyRepository.updateById((Object)entity);
        }
        this.activityPlanStrategyModifyService.saveActivityPlanStrategyList(entity, update, dto.getStrategyList());
        this.activityPlanRelatePlanModifyService.saveActivityPlanRelatePlanList(entity, update, dto.getRelatePlanList());
        this.activityPlanItemModifyService.saveActivityPlanItemList(entity, update, itemList, originItemMap, false);
        this.activityPlanBudgetModifyService.saveActivityPlanBudgetList(entity, update, itemList);
        this.activityPlanItemTerminalModifyService.saveActivityPlanItemTerminalList(entity, update, itemList);
        this.backupInitVersionData(entity.getPlanCode());
        ActivityPlanModifyLogEventDto logEventDto = new ActivityPlanModifyLogEventDto();
        logEventDto.setNewest((ActivityPlanModifyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ActivityPlanModifyDto.class, HashSet.class, ArrayList.class, new String[0]));
        if (!update) {
            logEventDto.setOriginal(null);
            SerializableBiConsumer & Serializable onCreate = ActivityPlanLogEventListener::onCreateModify;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityPlanLogEventListener.class, (SerializableBiConsumer)onCreate);
        } else {
            logEventDto.setOriginal(oldDto);
            SerializableBiConsumer & Serializable onUpdate = ActivityPlanLogEventListener::onUpdateModify;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityPlanLogEventListener.class, (SerializableBiConsumer)onUpdate);
        }
        return entity.getModifyBusinessCode();
    }

    private void createValidate(ActivityPlanModifyDto dto, List<ActivityPlanItemModifyDto> itemCacheList, Map<String, ActivityPlanItemDto> originItemMap) {
        List relatePlanList;
        List strategyList;
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getPlanCode(), (String)"\u65b0\u589e\u65f6\uff0c\u5173\u8054\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u65b0\u589e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessUnitCode(), (String)"\u65b0\u589e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPlanName(), (String)"\u65b0\u589e\u65f6\uff0c\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPlanType(), (String)"\u65b0\u589e\u65f6\uff0c\u65b9\u6848\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBeginDateStr(), (String)"\u65b0\u589e\u65f6\uff0c\u65b9\u6848\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date beginDate = dayFormat.parse(dto.getBeginDateStr());
            dto.setBeginDate(beginDate);
        }
        catch (Exception e) {
            throw new RuntimeException("\u65b9\u6848\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u6709\u8bef\uff01");
        }
        Validate.notBlank((CharSequence)dto.getEndDateStr(), (String)"\u65b0\u589e\u65f6\uff0c\u65b9\u6848\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        try {
            Date endDate = dayFormat.parse(dto.getEndDateStr());
            dto.setEndDate(endDate);
        }
        catch (Exception e) {
            throw new RuntimeException("\u65b9\u6848\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u6709\u8bef\uff01");
        }
        if (ActivityPlanTypeEnum.headquarters.getCode().equals(dto.getPlanType())) {
            Validate.notBlank((CharSequence)dto.getPlanRelateLimitCode(), (String)"\u65b0\u589e\u65f6\uff0c\u603b\u90e8\u65b9\u6848\u65b9\u6848\u5173\u8054\u9650\u5236\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)dto.getPlanClassify(), (String)"\u65b0\u589e\u65f6\uff0c\u65b9\u6848\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(itemCacheList) ? 1 : 0) != 0, (String)"\u65b0\u589e\u65f6\uff0c\u65b9\u6848\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ActivityPlanVo planVo = this.activityPlanService.findByCode(dto.getPlanCode());
        dto.setBusinessFormatCode(planVo.getBusinessFormatCode());
        dto.setBusinessUnitCode(planVo.getBusinessUnitCode());
        dto.setDepartmentCode(planVo.getDepartmentCode());
        dto.setDepartmentName(planVo.getDepartmentName());
        this.activityPlanItemModifyService.createValidateList(dto, itemCacheList, originItemMap);
        List<ActivityPlanBudgetModifyDto> budgetDtos = this.matchActivityPlanBudgetRelate(dto, itemCacheList, originItemMap);
        this.activityPlanBudgetModifyService.useMonthBudget(budgetDtos, dto.getPlanCode(), false);
        HashMap strategyUseAmountMap = Maps.newHashMap();
        HashMap relatePlanUseAmountMap = Maps.newHashMap();
        BigDecimal budgetFeeAmount = BigDecimal.ZERO;
        BigDecimal feeAmount = BigDecimal.ZERO;
        BigDecimal headFeeAmount = BigDecimal.ZERO;
        BigDecimal departmentFeeAmount = BigDecimal.ZERO;
        BigDecimal customerFeeAmount = BigDecimal.ZERO;
        BigDecimal totalFeeAmount = BigDecimal.ZERO;
        for (ActivityPlanItemModifyDto activityPlanItemDto : itemCacheList) {
            BigDecimal thisFeeAmount = BigDecimal.ZERO;
            BigDecimal thisTotalFeeAmount = BigDecimal.ZERO;
            if (null != activityPlanItemDto.getHeadFeeAmount()) {
                headFeeAmount = headFeeAmount.add(activityPlanItemDto.getHeadFeeAmount());
                thisFeeAmount = thisFeeAmount.add(activityPlanItemDto.getHeadFeeAmount());
                thisTotalFeeAmount = thisTotalFeeAmount.add(activityPlanItemDto.getHeadFeeAmount());
            }
            if (null != activityPlanItemDto.getDepartmentFeeAmount()) {
                departmentFeeAmount = departmentFeeAmount.add(activityPlanItemDto.getDepartmentFeeAmount());
                thisFeeAmount = thisFeeAmount.add(activityPlanItemDto.getDepartmentFeeAmount());
                thisTotalFeeAmount = thisTotalFeeAmount.add(activityPlanItemDto.getDepartmentFeeAmount());
            }
            if (null != activityPlanItemDto.getCustomerFeeAmount()) {
                customerFeeAmount = customerFeeAmount.add(activityPlanItemDto.getCustomerFeeAmount());
                thisTotalFeeAmount = thisTotalFeeAmount.add(activityPlanItemDto.getCustomerFeeAmount());
            }
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                activityPlanItemDto.setFeeAmount(thisFeeAmount);
            }
            if (null != activityPlanItemDto.getFeeAmount()) {
                feeAmount = feeAmount.add(activityPlanItemDto.getFeeAmount());
            }
            if (null == activityPlanItemDto.getTotalFeeAmount()) continue;
            if (BusinessUnitEnum.isDefaultBusinessUnit((String)dto.getBusinessUnitCode())) {
                Assert.isTrue((thisTotalFeeAmount.compareTo(activityPlanItemDto.getTotalFeeAmount()) == 0 ? 1 : 0) != 0, (String)"\u8d39\u7528\u5408\u8ba1\u5fc5\u987b\u7b49\u4e8e\u603b\u90e8\u627f\u62c5+\u5927\u533a\u627f\u62c5+\u5ba2\u6237\u627f\u62c5\u91d1\u989d");
            }
            totalFeeAmount = totalFeeAmount.add(activityPlanItemDto.getTotalFeeAmount());
            if (CollectionUtils.isEmpty((Collection)activityPlanItemDto.getBudgetShares())) continue;
            for (ActivityPlanBudgetModifyDto budgetShare : activityPlanItemDto.getBudgetShares()) {
                if (null != budgetShare.getUseAmount()) {
                    budgetFeeAmount = budgetFeeAmount.add(budgetShare.getUseAmount());
                }
                if (StringUtils.isNotEmpty((CharSequence)budgetShare.getRelateStrategyItemCode())) {
                    BigDecimal strategyUseAmount = Optional.ofNullable(strategyUseAmountMap.get(budgetShare.getRelateStrategyItemCode())).orElse(BigDecimal.ZERO);
                    strategyUseAmountMap.put(budgetShare.getRelateStrategyItemCode(), strategyUseAmount.add(budgetShare.getUseAmount()));
                }
                if (!StringUtils.isNotEmpty((CharSequence)budgetShare.getRelatePlanCode())) continue;
                BigDecimal relatePlanUseAmount = Optional.ofNullable(relatePlanUseAmountMap.get(budgetShare.getRelatePlanCode())).orElse(BigDecimal.ZERO);
                relatePlanUseAmountMap.put(budgetShare.getRelatePlanCode(), relatePlanUseAmount.add(budgetShare.getUseAmount()));
            }
        }
        if (null != dto.getSalesAmount() && dto.getSalesAmount().compareTo(BigDecimal.ZERO) != 0) {
            if (BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
                dto.setPlanIoRate(feeAmount.divide(dto.getSalesAmount(), 2, RoundingMode.HALF_DOWN));
            } else {
                dto.setPlanIoRate(totalFeeAmount.add(departmentFeeAmount).divide(dto.getSalesAmount(), 2, RoundingMode.HALF_DOWN));
            }
        }
        dto.setFeeAmount(feeAmount);
        dto.setHeadFeeAmount(headFeeAmount);
        dto.setDepartmentFeeAmount(departmentFeeAmount);
        dto.setCustomerFeeAmount(customerFeeAmount);
        dto.setTotalFeeAmount(totalFeeAmount);
        if (BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode()) && feeAmount.compareTo(budgetFeeAmount) != 0) {
            throw new RuntimeException("\u8d39\u7528\u91d1\u989d[" + feeAmount + "]\u4e0d\u7b49\u4e8e\u5b9e\u9645\u9884\u7b97\u4f7f\u7528\u91d1\u989d[" + budgetFeeAmount + "]");
        }
        if (strategyUseAmountMap.size() > 0 && !CollectionUtils.isEmpty((Collection)(strategyList = dto.getStrategyList()))) {
            Map strategyMap = strategyList.stream().collect(Collectors.toMap(ActivityPlanStrategyBase::getStrategyItemCode, Function.identity(), (o, n) -> n));
            for (Map.Entry entry : strategyUseAmountMap.entrySet()) {
                ActivityPlanStrategyModifyDto strategyDto = (ActivityPlanStrategyModifyDto)strategyMap.get(entry.getKey());
                if (null == strategyDto) continue;
                strategyDto.setUseAmount((BigDecimal)entry.getValue());
            }
        }
        if (relatePlanUseAmountMap.size() > 0 && !CollectionUtils.isEmpty((Collection)(relatePlanList = dto.getRelatePlanList()))) {
            Map relatePlanMap = relatePlanList.stream().collect(Collectors.toMap(ActivityPlanRelatePlanBase::getRelatePlanCode, Function.identity(), (o, n) -> n));
            for (Map.Entry entry : relatePlanUseAmountMap.entrySet()) {
                ActivityPlanRelatePlanModifyDto planRelatePlanDto = (ActivityPlanRelatePlanModifyDto)relatePlanMap.get(entry.getKey());
                if (null == planRelatePlanDto) continue;
                planRelatePlanDto.setUseAmount((BigDecimal)entry.getValue());
            }
        }
    }

    public List<ActivityPlanBudgetModifyDto> matchActivityPlanBudgetRelate(ActivityPlanModifyDto planDto, List<ActivityPlanItemModifyDto> itemList, Map<String, ActivityPlanItemDto> originItemMap) {
        ArrayList budgetDtos;
        List strategyList = planDto.getStrategyList();
        List relatePlanList = planDto.getRelatePlanList();
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(planDto.getBusinessUnitCode())) {
            if (ActivityPlanTypeEnum.headquarters.getCode().equals(planDto.getPlanType())) {
                Validate.isTrue((!CollectionUtils.isEmpty((Collection)strategyList) ? 1 : 0) != 0, (String)"\u603b\u90e8\u65b9\u6848\u5173\u8054\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            } else if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())) {
                Validate.isTrue((!CollectionUtils.isEmpty((Collection)strategyList) || !CollectionUtils.isEmpty((Collection)relatePlanList) ? 1 : 0) != 0, (String)"\u5927\u533a\u65b9\u6848\u5173\u8054\u7b56\u7565\u548c\u65b9\u6848\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a!", (Object[])new Object[0]);
            } else {
                throw new RuntimeException("\u65b9\u6848\u7c7b\u578b\u6709\u8bef");
            }
        }
        HashSet monthBudgetCodeSet = org.apache.commons.compress.utils.Sets.newHashSet((Object[])new String[0]);
        Map<Object, Object> relateStrategyBudgetMap = Maps.newHashMap();
        Map<Object, Object> strategyBudgetMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)strategyList)) {
            List strategyCodeList = strategyList.stream().map(ActivityPlanStrategyBase::getStrategyCode).distinct().collect(Collectors.toList());
            MarketingStrategyBudgetDto budgetDto = new MarketingStrategyBudgetDto();
            budgetDto.setStrategyCodeList(strategyCodeList);
            List strategyBudgetDtos = this.marketingStrategyBudgetSdkService.findListByConditions(budgetDto);
            relateStrategyBudgetMap = strategyBudgetDtos.stream().collect(Collectors.groupingBy(MarketingStrategyBudgetDto::getMonthBudgetCode));
            strategyBudgetMap = strategyBudgetDtos.stream().collect(Collectors.groupingBy(MarketingStrategyBudgetDto::getStrategyItemCode));
            monthBudgetCodeSet.addAll(strategyBudgetDtos.stream().map(MarketingStrategyBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        }
        Map<Object, Object> relatePlanBudgetMap = Maps.newHashMap();
        Map<Object, Object> planBudgetMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)relatePlanList)) {
            List<String> planCodeList = relatePlanList.stream().map(ActivityPlanRelatePlanBase::getRelatePlanCode).distinct().collect(Collectors.toList());
            List<ActivityPlanBudget> activityPlanBudgets = this.activityPlanBudgetRepository.listByPlanCodeList(planCodeList);
            relatePlanBudgetMap = activityPlanBudgets.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getMonthBudgetCode())).collect(Collectors.groupingBy(ActivityPlanBudget::getMonthBudgetCode));
            planBudgetMap = activityPlanBudgets.stream().collect(Collectors.groupingBy(ActivityPlanBudget::getPlanItemCode));
            monthBudgetCodeSet.addAll(activityPlanBudgets.stream().map(ActivityPlanBudget::getMonthBudgetCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        }
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(planDto.getBusinessUnitCode())) {
            boolean hasModifyAmount = false;
            budgetDtos = Lists.newArrayList();
            for (ActivityPlanItemModifyDto activityPlanItemModifyDto : itemList) {
                ActivityPlanItemDto originItemDto = originItemMap.get(activityPlanItemModifyDto.getPlanItemCode());
                if (Optional.ofNullable(activityPlanItemModifyDto.getHeadFeeAmount()).orElse(BigDecimal.ZERO).compareTo(Optional.ofNullable(originItemDto.getHeadFeeAmount()).orElse(BigDecimal.ZERO)) != 0) {
                    hasModifyAmount = true;
                    break;
                }
                if (Optional.ofNullable(activityPlanItemModifyDto.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO).compareTo(Optional.ofNullable(originItemDto.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO)) != 0) {
                    hasModifyAmount = true;
                    break;
                }
                budgetDtos.addAll(originItemDto.getBudgetShares());
            }
            if (!hasModifyAmount) {
                return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)budgetDtos, ActivityPlanBudgetDto.class, ActivityPlanBudgetModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
            }
        }
        for (ActivityPlanItemModifyDto itemDto : itemList) {
            ActivityPlanItemDto originItemDto = originItemMap.get(itemDto.getPlanItemCode());
            if (CollectionUtils.isEmpty((Collection)originItemDto.getBudgetShares())) continue;
            for (ActivityPlanBudgetDto budgetShare : originItemDto.getBudgetShares()) {
                List activityPlanBudgets;
                if (ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(budgetShare.getOccupyType()) && StringUtils.isNotEmpty((CharSequence)budgetShare.getRelateStrategyItemCode())) {
                    List strategyBudgetDtos = (List)strategyBudgetMap.get(budgetShare.getRelateStrategyItemCode());
                    if (CollectionUtils.isEmpty((Collection)strategyBudgetDtos)) continue;
                    ActivityPlanBudgetModifyDto budgetDto = (MarketingStrategyBudgetDto)strategyBudgetDtos.get(0);
                    budgetDto.setUsedAmount(Optional.ofNullable(budgetDto.getUsedAmount()).orElse(BigDecimal.ZERO).subtract(budgetShare.getUseAmount()));
                    continue;
                }
                if (!ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(budgetShare.getOccupyType()) || !StringUtils.isNotEmpty((CharSequence)budgetShare.getRelatePlanItemCode()) || CollectionUtils.isEmpty((Collection)(activityPlanBudgets = (List)planBudgetMap.get(budgetShare.getRelatePlanItemCode())))) continue;
                ActivityPlanBudget activityPlanBudget = (ActivityPlanBudget)((Object)activityPlanBudgets.get(0));
                activityPlanBudget.setUsedAmount(Optional.ofNullable(activityPlanBudget.getUsedAmount()).orElse(BigDecimal.ZERO).subtract(budgetShare.getUseAmount()));
            }
        }
        Map<Object, Object> monthBudgetMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)monthBudgetCodeSet)) {
            List monthBudgetList = this.monthBudgetService.listByCodes((List)Lists.newArrayList((Iterable)monthBudgetCodeSet));
            monthBudgetMap = monthBudgetList.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
        }
        budgetDtos = Lists.newArrayList();
        for (int i = 0; i < itemList.size(); ++i) {
            ActivityPlanItemModifyDto activityPlanItemModifyDto = itemList.get(i);
            ArrayList budgetList = Lists.newArrayList();
            if (!BusinessUnitEnum.VERTICAL.getCode().equals(planDto.getBusinessUnitCode())) {
                BigDecimal customerFeeAmount;
                ActivityPlanBudgetModifyDto monthBudget;
                BigDecimal thisAmount;
                BigDecimal usableAmount;
                BigDecimal usedAmount;
                BigDecimal useAmount;
                ActivityPlanBudgetModifyDto monthBudget2;
                Set planBudgetItemSet;
                BigDecimal leaveAmount;
                if (ActivityPlanTypeEnum.headquarters.getCode().equals(planDto.getPlanType())) {
                    Validate.isTrue((!StringUtils.isEmpty((CharSequence)activityPlanItemModifyDto.getHeadMonthBudgetCode()) ? 1 : 0) != 0, (String)"\u603b\u90e8\u65b9\u6848\u603b\u90e8\u9884\u7b97\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
                } else if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())) {
                    Validate.isTrue((!StringUtils.isEmpty((CharSequence)activityPlanItemModifyDto.getHeadMonthBudgetCode()) || !StringUtils.isEmpty((CharSequence)activityPlanItemModifyDto.getMonthBudgetCode()) ? 1 : 0) != 0, (String)"\u5927\u533a\u65b9\u6848\u603b\u90e8\u9884\u7b97\u548c\u5927\u533a\u9884\u7b97\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a!", (Object[])new Object[0]);
                }
                if (StringUtils.isNotEmpty((CharSequence)activityPlanItemModifyDto.getHeadMonthBudgetCode())) {
                    BigDecimal headFeeAmount = activityPlanItemModifyDto.getHeadFeeAmount();
                    if (null == headFeeAmount || BigDecimal.ZERO.compareTo(headFeeAmount) == 0) {
                        throw new RuntimeException("\u9009\u62e9\u603b\u90e8\u9884\u7b97\u540e\u603b\u90e8\u627f\u62c5\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u62160");
                    }
                } else {
                    if (null != activityPlanItemModifyDto.getHeadFeeAmount() && activityPlanItemModifyDto.getHeadFeeAmount().compareTo(BigDecimal.ZERO) != 0) {
                        throw new RuntimeException("\u672a\u9009\u62e9\u603b\u90e8\u9884\u7b97\u7f16\u7801\uff0c\u603b\u90e8\u627f\u62c5\u91d1\u989d\u53ea\u80fd\u4e3a0");
                    }
                    if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType()) && StringUtils.isNotEmpty((CharSequence)activityPlanItemModifyDto.getRelatePlanItemCode())) {
                        throw new RuntimeException("\u5927\u533a\u65b9\u6848\u672a\u586b\u5199\u603b\u90e8\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u586b\u5199\u5173\u8054\u65b9\u6848\u660e\u7ec6\u7f16\u7801");
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)activityPlanItemModifyDto.getMonthBudgetCode())) {
                    BigDecimal departmentFeeAmount = activityPlanItemModifyDto.getDepartmentFeeAmount();
                    if (null == departmentFeeAmount || BigDecimal.ZERO.compareTo(departmentFeeAmount) == 0) {
                        throw new RuntimeException("\u9009\u62e9\u5927\u533a\u9884\u7b97\u540e\u5927\u533a\u627f\u62c5\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u62160");
                    }
                } else if (null != activityPlanItemModifyDto.getDepartmentFeeAmount() && activityPlanItemModifyDto.getDepartmentFeeAmount().compareTo(BigDecimal.ZERO) != 0 && ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType())) {
                    throw new RuntimeException("\u672a\u9009\u62e9\u5927\u533a\u9884\u7b97\u7f16\u7801\uff0c\u5927\u533a\u627f\u62c5\u91d1\u989d\u53ea\u80fd\u4e3a0");
                }
                String relateStrategyCode = activityPlanItemModifyDto.getRelateStrategyCode();
                String relateStrategyItemCode = activityPlanItemModifyDto.getRelateStrategyItemCode();
                String relateHeadStrategyCode = activityPlanItemModifyDto.getRelateHeadStrategyCode();
                String relateHeadStrategyItemCode = activityPlanItemModifyDto.getRelateHeadStrategyItemCode();
                String relatePlanCode = activityPlanItemModifyDto.getRelatePlanCode();
                Object relatePlanItemCode = activityPlanItemModifyDto.getRelatePlanItemCode();
                if (StringUtils.isNotEmpty((CharSequence)activityPlanItemModifyDto.getHeadMonthBudgetCode())) {
                    List strategyBudgetDtos;
                    BigDecimal headFeeAmount = activityPlanItemModifyDto.getHeadFeeAmount();
                    if (null == headFeeAmount || BigDecimal.ZERO.compareTo(headFeeAmount) == 0) {
                        throw new RuntimeException("\u9009\u62e9\u603b\u90e8\u9884\u7b97\u540e\u603b\u90e8\u627f\u62c5\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u62160");
                    }
                    leaveAmount = headFeeAmount;
                    if (StringUtils.isNotEmpty((CharSequence)relatePlanItemCode)) {
                        List planItemBudgetList = (List)planBudgetMap.get(relatePlanItemCode);
                        if (CollectionUtils.isEmpty((Collection)planItemBudgetList)) {
                            throw new RuntimeException("\u603b\u90e8\u9884\u7b97\u7f16\u7801[" + activityPlanItemModifyDto.getHeadMonthBudgetCode() + "]\u4e0d\u5c5e\u4e8e\u65b9\u6848\u660e\u7ec6[" + (String)relatePlanItemCode + "]");
                        }
                        planBudgetItemSet = planItemBudgetList.stream().map(ActivityPlanBudget::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
                        if (!planBudgetItemSet.contains(activityPlanItemModifyDto.getHeadMonthBudgetCode())) {
                            throw new RuntimeException("\u603b\u90e8\u9884\u7b97\u7f16\u7801[" + activityPlanItemModifyDto.getHeadMonthBudgetCode() + "]\u4e0d\u5c5e\u4e8e\u65b9\u6848\u660e\u7ec6[" + (String)relatePlanItemCode + "]");
                        }
                        ActivityPlanBudgetModifyDto monthBudget22 = new ActivityPlanBudgetModifyDto();
                        monthBudget22.setPlanCode(activityPlanItemModifyDto.getPlanCode());
                        monthBudget22.setPlanItemCode(activityPlanItemModifyDto.getPlanItemCode());
                        monthBudget22.setRelatePlanCode(relatePlanCode);
                        monthBudget22.setRelatePlanItemCode((String)relatePlanItemCode);
                        monthBudget22.setMonthBudgetCode(activityPlanItemModifyDto.getHeadMonthBudgetCode());
                        monthBudget22.setBudgetItemCode(activityPlanItemModifyDto.getHeadBudgetItemCode());
                        monthBudget22.setBudgetItemName(activityPlanItemModifyDto.getHeadBudgetItemName());
                        monthBudget22.setUseAmount(leaveAmount);
                        monthBudget22.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                        monthBudget22.setFeeBelongCode(monthBudgetMap.containsKey(activityPlanItemModifyDto.getHeadMonthBudgetCode()) ? ((MonthBudgetVo)monthBudgetMap.get(activityPlanItemModifyDto.getHeadMonthBudgetCode())).getFeeBelongCode() : null);
                        budgetList.add(monthBudget22);
                    } else if (StringUtils.isNotEmpty((CharSequence)relateHeadStrategyItemCode)) {
                        strategyBudgetDtos = (List)strategyBudgetMap.get(relateHeadStrategyItemCode);
                        if (CollectionUtils.isEmpty((Collection)strategyBudgetDtos)) {
                            throw new RuntimeException("\u603b\u90e8\u9884\u7b97\u7f16\u7801[" + activityPlanItemModifyDto.getHeadMonthBudgetCode() + "]\u4e0d\u5c5e\u4e8e\u7b56\u7565\u660e\u7ec6[" + relateHeadStrategyItemCode + "]");
                        }
                        planBudgetItemSet = strategyBudgetDtos.stream().map(MarketingStrategyBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
                        if (!planBudgetItemSet.contains(activityPlanItemModifyDto.getHeadMonthBudgetCode())) {
                            throw new RuntimeException("\u603b\u90e8\u9884\u7b97\u7f16\u7801[" + activityPlanItemModifyDto.getHeadMonthBudgetCode() + "]\u4e0d\u5c5e\u4e8e\u7b56\u7565\u660e\u7ec6[" + relateHeadStrategyItemCode + "]");
                        }
                        monthBudget2 = new ActivityPlanBudgetModifyDto();
                        monthBudget2.setPlanCode(activityPlanItemModifyDto.getPlanCode());
                        monthBudget2.setPlanItemCode(activityPlanItemModifyDto.getPlanItemCode());
                        monthBudget2.setRelateStrategyCode(relateHeadStrategyCode);
                        monthBudget2.setRelateStrategyItemCode(relateHeadStrategyItemCode);
                        monthBudget2.setMonthBudgetCode(activityPlanItemModifyDto.getHeadMonthBudgetCode());
                        monthBudget2.setBudgetItemCode(activityPlanItemModifyDto.getHeadBudgetItemCode());
                        monthBudget2.setBudgetItemName(activityPlanItemModifyDto.getHeadBudgetItemName());
                        monthBudget2.setUseAmount(leaveAmount);
                        monthBudget2.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                        monthBudget2.setFeeBelongCode(monthBudgetMap.containsKey(activityPlanItemModifyDto.getHeadMonthBudgetCode()) ? ((MonthBudgetVo)monthBudgetMap.get(activityPlanItemModifyDto.getHeadMonthBudgetCode())).getFeeBelongCode() : null);
                        budgetList.add(monthBudget2);
                    } else {
                        List activityPlanBudgets;
                        strategyBudgetDtos = (List)relateStrategyBudgetMap.get(activityPlanItemModifyDto.getHeadMonthBudgetCode());
                        if (null != strategyBudgetDtos) {
                            for (Object strategyBudgetDto : strategyBudgetDtos) {
                                if (leaveAmount.compareTo(BigDecimal.ZERO) == 0) break;
                                useAmount = Optional.ofNullable(strategyBudgetDto.getUseAmount()).orElse(BigDecimal.ZERO);
                                usableAmount = useAmount.subtract(usedAmount = Optional.ofNullable(strategyBudgetDto.getUsedAmount()).orElse(BigDecimal.ZERO));
                                if (usableAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                                if (StringUtils.isNotEmpty((CharSequence)relateHeadStrategyItemCode)) {
                                    if (!relateHeadStrategyItemCode.equals(strategyBudgetDto.getStrategyItemCode())) {
                                        continue;
                                    }
                                } else {
                                    relateHeadStrategyItemCode = strategyBudgetDto.getStrategyItemCode();
                                    relateHeadStrategyCode = strategyBudgetDto.getStrategyCode();
                                }
                                if (usableAmount.compareTo(thisAmount = leaveAmount) < 0) {
                                    thisAmount = usableAmount;
                                }
                                monthBudget = new ActivityPlanBudgetModifyDto();
                                monthBudget.setPlanCode(activityPlanItemModifyDto.getPlanCode());
                                monthBudget.setPlanItemCode(activityPlanItemModifyDto.getPlanItemCode());
                                monthBudget.setRelateStrategyCode(strategyBudgetDto.getStrategyCode());
                                monthBudget.setRelateStrategyItemCode(strategyBudgetDto.getStrategyItemCode());
                                monthBudget.setMonthBudgetCode(strategyBudgetDto.getMonthBudgetCode());
                                monthBudget.setBudgetItemCode(strategyBudgetDto.getBudgetItemCode());
                                monthBudget.setBudgetItemName(strategyBudgetDto.getBudgetItemName());
                                monthBudget.setUseAmount(thisAmount);
                                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                                monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(activityPlanItemModifyDto.getMonthBudgetCode()) ? ((MonthBudgetVo)monthBudgetMap.get(activityPlanItemModifyDto.getMonthBudgetCode())).getFeeBelongCode() : null);
                                budgetList.add(monthBudget);
                                leaveAmount = leaveAmount.subtract(thisAmount);
                                strategyBudgetDto.setUsedAmount(usedAmount.add(thisAmount));
                            }
                        }
                        if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType()) && null != (activityPlanBudgets = (List)relatePlanBudgetMap.get(activityPlanItemModifyDto.getHeadMonthBudgetCode()))) {
                            Object strategyBudgetDto;
                            strategyBudgetDto = activityPlanBudgets.iterator();
                            while (strategyBudgetDto.hasNext()) {
                                BigDecimal thisAmount2;
                                BigDecimal usedAmount2;
                                ActivityPlanBudget activityPlanBudget = (ActivityPlanBudget)((Object)strategyBudgetDto.next());
                                if (leaveAmount.compareTo(BigDecimal.ZERO) == 0) break;
                                BigDecimal useAmount2 = Optional.ofNullable(activityPlanBudget.getUseAmount()).orElse(BigDecimal.ZERO);
                                BigDecimal usableAmount2 = useAmount2.subtract(usedAmount2 = Optional.ofNullable(activityPlanBudget.getUsedAmount()).orElse(BigDecimal.ZERO));
                                if (usableAmount2.compareTo(BigDecimal.ZERO) <= 0) continue;
                                if (StringUtils.isNotEmpty((CharSequence)relatePlanItemCode)) {
                                    if (!((String)relatePlanItemCode).equals(activityPlanBudget.getPlanItemCode())) {
                                        continue;
                                    }
                                } else {
                                    relatePlanItemCode = activityPlanBudget.getPlanItemCode();
                                    relatePlanCode = activityPlanBudget.getPlanCode();
                                }
                                if (usableAmount2.compareTo(thisAmount2 = leaveAmount) < 0) {
                                    thisAmount2 = usableAmount2;
                                }
                                ActivityPlanBudgetModifyDto monthBudget3 = new ActivityPlanBudgetModifyDto();
                                monthBudget3.setPlanCode(activityPlanItemModifyDto.getPlanCode());
                                monthBudget3.setPlanItemCode(activityPlanItemModifyDto.getPlanItemCode());
                                monthBudget3.setRelatePlanCode(activityPlanBudget.getPlanCode());
                                monthBudget3.setRelatePlanItemCode(activityPlanBudget.getPlanItemCode());
                                monthBudget3.setMonthBudgetCode(activityPlanBudget.getMonthBudgetCode());
                                monthBudget3.setBudgetItemCode(activityPlanBudget.getBudgetItemCode());
                                monthBudget3.setBudgetItemName(activityPlanBudget.getBudgetItemName());
                                monthBudget3.setUseAmount(thisAmount2);
                                monthBudget3.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                                monthBudget3.setFeeBelongCode(monthBudgetMap.containsKey(activityPlanItemModifyDto.getMonthBudgetCode()) ? ((MonthBudgetVo)monthBudgetMap.get(activityPlanItemModifyDto.getMonthBudgetCode())).getFeeBelongCode() : null);
                                budgetList.add(monthBudget3);
                                leaveAmount = leaveAmount.subtract(thisAmount2);
                                activityPlanBudget.setUsedAmount(usedAmount2.add(thisAmount2));
                            }
                        }
                        if (leaveAmount.compareTo(BigDecimal.ZERO) > 0) {
                            throw new RuntimeException("\u603b\u90e8\u8d39\u7528\u91d1\u989d[" + headFeeAmount + "]\u8d85\u8fc7\u5b9e\u9645\u53ef\u7528\u4f59\u989d");
                        }
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)activityPlanItemModifyDto.getMonthBudgetCode())) {
                    BigDecimal departmentFeeAmount = activityPlanItemModifyDto.getDepartmentFeeAmount();
                    if (null == departmentFeeAmount || BigDecimal.ZERO.compareTo(departmentFeeAmount) == 0) {
                        throw new RuntimeException("\u9009\u62e9\u5927\u533a\u9884\u7b97\u540e\u5927\u533a\u627f\u62c5\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u62160");
                    }
                    leaveAmount = departmentFeeAmount;
                    if (StringUtils.isNotEmpty((CharSequence)activityPlanItemModifyDto.getRelateStrategyItemCode())) {
                        List strategyItemBudgetList = (List)strategyBudgetMap.get(relateStrategyItemCode);
                        if (CollectionUtils.isEmpty((Collection)strategyItemBudgetList)) {
                            throw new RuntimeException("\u5927\u533a\u9884\u7b97\u7f16\u7801[" + activityPlanItemModifyDto.getMonthBudgetCode() + "]\u4e0d\u5c5e\u4e8e\u7b56\u7565\u660e\u7ec6[" + relateStrategyItemCode + "]");
                        }
                        planBudgetItemSet = strategyItemBudgetList.stream().map(MarketingStrategyBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
                        if (!planBudgetItemSet.contains(activityPlanItemModifyDto.getMonthBudgetCode())) {
                            throw new RuntimeException("\u5927\u533a\u9884\u7b97\u7f16\u7801[" + activityPlanItemModifyDto.getMonthBudgetCode() + "]\u4e0d\u5c5e\u4e8e\u7b56\u7565\u660e\u7ec6[" + relateStrategyItemCode + "]");
                        }
                        monthBudget2 = new ActivityPlanBudgetModifyDto();
                        monthBudget2.setPlanCode(activityPlanItemModifyDto.getPlanCode());
                        monthBudget2.setPlanItemCode(activityPlanItemModifyDto.getPlanItemCode());
                        monthBudget2.setRelateStrategyCode(activityPlanItemModifyDto.getRelateStrategyCode());
                        monthBudget2.setRelateStrategyItemCode(activityPlanItemModifyDto.getRelateStrategyItemCode());
                        monthBudget2.setMonthBudgetCode(activityPlanItemModifyDto.getMonthBudgetCode());
                        monthBudget2.setBudgetItemCode(activityPlanItemModifyDto.getBudgetItemCode());
                        monthBudget2.setBudgetItemName(activityPlanItemModifyDto.getBudgetItemName());
                        monthBudget2.setUseAmount(leaveAmount);
                        monthBudget2.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                        monthBudget2.setFeeBelongCode(monthBudgetMap.containsKey(activityPlanItemModifyDto.getMonthBudgetCode()) ? ((MonthBudgetVo)monthBudgetMap.get(activityPlanItemModifyDto.getMonthBudgetCode())).getFeeBelongCode() : null);
                        budgetList.add(monthBudget2);
                    } else {
                        List activityPlanBudgets = (List)relateStrategyBudgetMap.get(activityPlanItemModifyDto.getMonthBudgetCode());
                        if (!CollectionUtils.isEmpty((Collection)activityPlanBudgets)) {
                            for (Object strategyBudgetDto : activityPlanBudgets) {
                                if (leaveAmount.compareTo(BigDecimal.ZERO) == 0) break;
                                useAmount = Optional.ofNullable(strategyBudgetDto.getUseAmount()).orElse(BigDecimal.ZERO);
                                usableAmount = useAmount.subtract(usedAmount = Optional.ofNullable(strategyBudgetDto.getUsedAmount()).orElse(BigDecimal.ZERO));
                                if (usableAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                                if (StringUtils.isNotEmpty((CharSequence)relateStrategyItemCode)) {
                                    if (!relateStrategyItemCode.equals(strategyBudgetDto.getStrategyItemCode())) {
                                        continue;
                                    }
                                } else {
                                    relateStrategyItemCode = strategyBudgetDto.getStrategyItemCode();
                                    relateStrategyCode = strategyBudgetDto.getStrategyCode();
                                }
                                if (usableAmount.compareTo(thisAmount = leaveAmount) < 0) {
                                    thisAmount = usableAmount;
                                }
                                monthBudget = new ActivityPlanBudgetModifyDto();
                                monthBudget.setPlanCode(activityPlanItemModifyDto.getPlanCode());
                                monthBudget.setPlanItemCode(activityPlanItemModifyDto.getPlanItemCode());
                                monthBudget.setRelateStrategyCode(strategyBudgetDto.getStrategyCode());
                                monthBudget.setRelateStrategyItemCode(strategyBudgetDto.getStrategyItemCode());
                                monthBudget.setMonthBudgetCode(strategyBudgetDto.getMonthBudgetCode());
                                monthBudget.setBudgetItemCode(strategyBudgetDto.getBudgetItemCode());
                                monthBudget.setBudgetItemName(strategyBudgetDto.getBudgetItemName());
                                monthBudget.setUseAmount(thisAmount);
                                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                                monthBudget.setFeeBelongCode(monthBudgetMap.containsKey(activityPlanItemModifyDto.getMonthBudgetCode()) ? ((MonthBudgetVo)monthBudgetMap.get(activityPlanItemModifyDto.getMonthBudgetCode())).getFeeBelongCode() : null);
                                budgetList.add(monthBudget);
                                leaveAmount = leaveAmount.subtract(thisAmount);
                                strategyBudgetDto.setUsedAmount(usedAmount.add(thisAmount));
                            }
                        }
                        if (leaveAmount.compareTo(BigDecimal.ZERO) > 0) {
                            throw new RuntimeException("\u5927\u533a\u65b9\u6848\u5360\u7528\u7b56\u7565\u91d1\u989d[" + departmentFeeAmount + "]\u8d85\u8fc7\u5b9e\u9645\u53ef\u7528\u4f59\u989d");
                        }
                    }
                }
                if (null != (customerFeeAmount = activityPlanItemModifyDto.getCustomerFeeAmount()) && BigDecimal.ZERO.compareTo(customerFeeAmount) != 0) {
                    ActivityPlanBudgetModifyDto monthBudget4 = new ActivityPlanBudgetModifyDto();
                    monthBudget4.setPlanCode(activityPlanItemModifyDto.getPlanCode());
                    monthBudget4.setPlanItemCode(activityPlanItemModifyDto.getPlanItemCode());
                    monthBudget4.setUseAmount(customerFeeAmount);
                    monthBudget4.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.CUSTOMER.getCode());
                    budgetList.add(monthBudget4);
                }
                activityPlanItemModifyDto.setRelatePlanCode(relatePlanCode);
                activityPlanItemModifyDto.setRelatePlanItemCode((String)relatePlanItemCode);
                activityPlanItemModifyDto.setRelateStrategyCode(relateStrategyCode);
                activityPlanItemModifyDto.setRelateStrategyItemCode(relateStrategyItemCode);
                activityPlanItemModifyDto.setRelateHeadStrategyCode(relateHeadStrategyCode);
                activityPlanItemModifyDto.setRelateHeadStrategyItemCode(relateHeadStrategyItemCode);
            } else if (!CollectionUtils.isEmpty((Collection)activityPlanItemModifyDto.getBudgetShares())) {
                for (ActivityPlanBudgetModifyDto budgetDto : activityPlanItemModifyDto.getBudgetShares()) {
                    List activityPlanBudgets;
                    BigDecimal useAmount;
                    BigDecimal leaveAmount = useAmount = budgetDto.getUseAmount();
                    List strategyBudgetDtos = (List)strategyBudgetMap.get(budgetDto.getMonthBudgetCode());
                    if (!CollectionUtils.isEmpty((Collection)strategyBudgetDtos)) {
                        for (Object strategyBudgetDto : strategyBudgetDtos) {
                            BigDecimal usedAmount;
                            if (leaveAmount.compareTo(BigDecimal.ZERO) == 0) break;
                            BigDecimal strategyBudgetUseAmount = Optional.ofNullable(strategyBudgetDto.getUseAmount()).orElse(BigDecimal.ZERO);
                            BigDecimal usableAmount = strategyBudgetUseAmount.subtract(usedAmount = Optional.ofNullable(strategyBudgetDto.getUsedAmount()).orElse(BigDecimal.ZERO));
                            if (usableAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                            BigDecimal thisAmount = leaveAmount;
                            if (usableAmount.compareTo(thisAmount) < 0) {
                                thisAmount = usableAmount;
                            }
                            ActivityPlanBudgetModifyDto monthBudget = (ActivityPlanBudgetModifyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetDto, ActivityPlanBudgetModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
                            monthBudget.setPlanCode(activityPlanItemModifyDto.getPlanCode());
                            monthBudget.setPlanItemCode(activityPlanItemModifyDto.getPlanItemCode());
                            monthBudget.setRelateStrategyCode(strategyBudgetDto.getStrategyCode());
                            monthBudget.setRelateStrategyItemCode(strategyBudgetDto.getStrategyItemCode());
                            monthBudget.setMonthBudgetCode(strategyBudgetDto.getMonthBudgetCode());
                            monthBudget.setBudgetItemCode(strategyBudgetDto.getBudgetItemCode());
                            monthBudget.setBudgetItemName(strategyBudgetDto.getBudgetItemName());
                            monthBudget.setUseAmount(thisAmount);
                            if (ActivityPlanTypeEnum.headquarters.getCode().equals(planDto.getPlanType()) && PlanRelateLimitEnum.AFTER.getCode().equals(planDto.getPlanRelateLimitCode())) {
                                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.FREEZE.getCode());
                            } else if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType()) && StringUtils.isNotBlank((CharSequence)monthBudget.getSchemeForecastDetailCode())) {
                                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.USE_FREEZE.getCode());
                            } else {
                                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                            }
                            budgetList.add(monthBudget);
                            leaveAmount = leaveAmount.subtract(thisAmount);
                            strategyBudgetDto.setUsedAmount(usedAmount.add(thisAmount));
                        }
                    }
                    if (!CollectionUtils.isEmpty((Collection)(activityPlanBudgets = (List)relatePlanBudgetMap.get(budgetDto.getMonthBudgetCode())))) {
                        Object strategyBudgetDto;
                        strategyBudgetDto = activityPlanBudgets.iterator();
                        while (strategyBudgetDto.hasNext()) {
                            BigDecimal usedAmount;
                            ActivityPlanBudget activityPlanBudget = (ActivityPlanBudget)((Object)strategyBudgetDto.next());
                            if (leaveAmount.compareTo(BigDecimal.ZERO) == 0) break;
                            BigDecimal planBudgetUseAmount = Optional.ofNullable(activityPlanBudget.getUseAmount()).orElse(BigDecimal.ZERO);
                            BigDecimal usableAmount = planBudgetUseAmount.subtract(usedAmount = Optional.ofNullable(activityPlanBudget.getUsedAmount()).orElse(BigDecimal.ZERO));
                            if (usableAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                            BigDecimal thisAmount = leaveAmount;
                            if (usableAmount.compareTo(thisAmount) < 0) {
                                thisAmount = usableAmount;
                            }
                            ActivityPlanBudgetModifyDto monthBudget = (ActivityPlanBudgetModifyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetDto, ActivityPlanBudgetModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
                            monthBudget.setPlanCode(activityPlanItemModifyDto.getPlanCode());
                            monthBudget.setPlanItemCode(activityPlanItemModifyDto.getPlanItemCode());
                            monthBudget.setRelatePlanCode(activityPlanBudget.getPlanCode());
                            monthBudget.setRelatePlanItemCode(activityPlanBudget.getPlanItemCode());
                            monthBudget.setMonthBudgetCode(activityPlanBudget.getMonthBudgetCode());
                            monthBudget.setBudgetItemCode(activityPlanBudget.getBudgetItemCode());
                            monthBudget.setBudgetItemName(activityPlanBudget.getBudgetItemName());
                            monthBudget.setUseAmount(thisAmount);
                            if (ActivityPlanTypeEnum.headquarters.getCode().equals(planDto.getPlanType()) && PlanRelateLimitEnum.AFTER.getCode().equals(planDto.getPlanRelateLimitCode())) {
                                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.FREEZE.getCode());
                            } else if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType()) && StringUtils.isNotBlank((CharSequence)monthBudget.getSchemeForecastDetailCode())) {
                                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.USE_FREEZE.getCode());
                            } else {
                                monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode());
                            }
                            budgetList.add(monthBudget);
                            leaveAmount = leaveAmount.subtract(thisAmount);
                            activityPlanBudget.setUsedAmount(usedAmount.add(thisAmount));
                        }
                    }
                    if (leaveAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                    ActivityPlanBudgetModifyDto monthBudget = (ActivityPlanBudgetModifyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetDto, ActivityPlanBudgetModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
                    monthBudget.setPlanCode(activityPlanItemModifyDto.getPlanCode());
                    monthBudget.setPlanItemCode(activityPlanItemModifyDto.getPlanItemCode());
                    monthBudget.setUseAmount(leaveAmount);
                    if (ActivityPlanTypeEnum.headquarters.getCode().equals(planDto.getPlanType()) && PlanRelateLimitEnum.AFTER.getCode().equals(planDto.getPlanRelateLimitCode())) {
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.FREEZE.getCode());
                    } else if (ActivityPlanTypeEnum.region.getCode().equals(planDto.getPlanType()) && StringUtils.isNotBlank((CharSequence)monthBudget.getSchemeForecastDetailCode())) {
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.USE_FREEZE.getCode());
                    } else {
                        monthBudget.setOccupyType(ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode());
                    }
                    budgetList.add(monthBudget);
                }
            }
            activityPlanItemModifyDto.setBudgetShares((List)budgetList);
            for (ActivityPlanBudgetModifyDto dto : budgetList) {
                dto.setIndexNo(activityPlanItemModifyDto.getIndexNo());
            }
            if (CollectionUtils.isEmpty((Collection)budgetList)) continue;
            budgetDtos.addAll(budgetList);
        }
        return budgetDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submit(ActivityPlanModifyApproveSubmitDto dto) {
        Validate.notNull((Object)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ActivityPlanModify entity = (ActivityPlanModify)((Object)this.activityPlanModifyRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)entity), (String)"\u5b9e\u4f8b\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01\uff01", (Object[])new Object[0]);
        if (!(ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus()))) {
            throw new RuntimeException("\u65b9\u6848\u53d8\u66f4[" + entity.getModifyBusinessCode() + "]\u4e0d\u5904\u4e8e\u5f85\u63d0\u4ea4\u3001\u9a73\u56de\u3001\u8ffd\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279\uff01");
        }
        dto.setModifyBusinessCode(entity.getModifyBusinessCode());
        this.activityPlanBudgetModifyService.useMonthBudgetByModifyCode(entity.getModifyBusinessCode(), entity.getPlanCode(), true);
        this.commitProcess(dto);
    }

    private void commitProcess(ActivityPlanModifyApproveSubmitDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.notNull((Object)processBusiness, (String)"\u63d0\u4ea4\u5de5\u4f5c\u6d41\u65f6\uff0c\u672a\u4f20\u5de5\u4f5c\u6d41\u5bf9\u8c61\u4fe1\u606f!", (Object[])new Object[0]);
        processBusiness.setBusinessNo(dto.getModifyBusinessCode());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        processBusiness.setBusinessCode("activity_plan_modify");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        this.activityPlanModifyRepository.updateProcessStatusAndProcessNo(dto.getModifyBusinessCode(), ProcessStatusEnum.COMMIT.getKey(), processBusinessVo.getProcessNo());
    }

    @Override
    public void processPass(ProcessStatusDto dto) {
        this.activityPlanModifyRepository.updateProcessStatus(dto.getBusinessNo(), dto.getProcessStatus());
        this.passPushMq(dto.getProcessNo(), dto.getBusinessNo());
    }

    private void passPushMq(String processNo, String businessNo) {
        if (StringUtils.isEmpty((CharSequence)businessNo)) {
            return;
        }
        ArrayList pushTagList = Lists.newArrayList();
        for (ActivityPlanModifyMqTagEnum mqTagEnum : ActivityPlanModifyMqTagEnum.values()) {
            if (!ActivityPlanModifyMqTagEnum.PushType.code.equals((Object)mqTagEnum.getPushType())) continue;
            pushTagList.add(mqTagEnum);
        }
        if (CollectionUtils.isEmpty((Collection)pushTagList)) {
            return;
        }
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String accountJson = "";
        String currentAccount = "";
        if (this.loginUserService != null) {
            currentAccount = this.loginUserService.getLoginAccountName();
            AbstractCrmUserIdentity userIdentity = this.loginUserService.getAbstractLoginUser();
            accountJson = Objects.isNull(userIdentity) ? null : JSON.toJSONString((Object)userIdentity);
        }
        for (ActivityPlanModifyMqTagEnum mqTagEnum : pushTagList) {
            RocketMqProducerEvent rocketMqProducerEvent = new RocketMqProducerEvent((Object)this, currentAccount, accountJson, false, uuid, "TPM_ACTIVITY_PLAN_MODIFY_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment(), mqTagEnum.getCode(), businessNo);
            this.eventPublisher.publishEvent((ApplicationEvent)rocketMqProducerEvent);
        }
    }

    @Override
    public void processRejectAndRecover(ProcessStatusDto dto) {
        ActivityPlanModify entity = this.activityPlanModifyRepository.getByCode(dto.getBusinessNo());
        this.activityPlanBudgetModifyService.returnMonthBudgetByModifyCode(dto.getBusinessNo(), entity.getPlanCode());
        this.activityPlanModifyRepository.updateProcessStatus(dto.getBusinessNo(), dto.getProcessStatus());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ActivityPlanModifyDto doUpdateOriginData(String businessNo) {
        List<ActivityPlanItemTerminalModify> planItemTerminalModifyList;
        ActivityPlanModify modifyEntity = this.activityPlanModifyRepository.getByCode(businessNo);
        ActivityPlan planEntity = this.activityPlanRepository.getByPlanCode(modifyEntity.getPlanCode());
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(TenantFlagOpEntity.class);
        List<String> ignoreFieldList = Arrays.stream(propertyDescriptors).map(FeatureDescriptor::getName).collect(Collectors.toList());
        ignoreFieldList.add("processStatus");
        ignoreFieldList.add("processNo");
        String[] ignoreFieldArr = ignoreFieldList.toArray(new String[0]);
        BeanUtils.copyProperties((Object)((Object)modifyEntity), (Object)((Object)planEntity), (String[])ignoreFieldArr);
        planEntity.setCurrModifyBusinessCode(modifyEntity.getModifyBusinessCode());
        this.activityPlanRepository.updateById(planEntity);
        List<ActivityPlanItemModify> itemModifyList = this.activityPlanItemModifyRepository.findListByModifyBusinessCode(businessNo);
        List<ActivityPlanItem> itemList = this.activityPlanItemRepository.findListByPlanCode(modifyEntity.getPlanCode());
        Map itemModifyMap = itemModifyList.stream().collect(Collectors.toMap(ActivityPlanItemModify::getPlanItemCode, Function.identity()));
        for (ActivityPlanItem activityPlanItem : itemList) {
            ActivityPlanItemModify modifyItem = (ActivityPlanItemModify)((Object)itemModifyMap.get(activityPlanItem.getPlanItemCode()));
            BeanUtils.copyProperties((Object)((Object)modifyItem), (Object)((Object)activityPlanItem), (String[])ignoreFieldArr);
            activityPlanItem.setCurrModifyBusinessCode(modifyItem.getModifyBusinessCode());
        }
        this.activityPlanItemRepository.updateBatchById(itemList);
        this.activityPlanRelatePlanRepository.deleteByPlanCode(planEntity.getPlanCode());
        List<ActivityPlanRelatePlanModify> relatePlanModifyList = this.activityPlanRelatePLanModifyRepository.findListByModifyCode(businessNo);
        if (!CollectionUtils.isEmpty(relatePlanModifyList)) {
            Collection budgetShareList = this.nebulaToolkitService.copyCollectionByBlankList(relatePlanModifyList, ActivityPlanRelatePlanModify.class, ActivityPlanRelatePlan.class, HashSet.class, ArrayList.class, new String[0]);
            this.activityPlanRelatePlanRepository.saveBatch(budgetShareList);
        }
        this.activityPlanStrategyRepository.deleteByPlanCode(planEntity.getPlanCode());
        List<ActivityPlanStrategyModify> strategyModifyList = this.activityPlanStrategyModifyRepository.findListByModifyCode(businessNo);
        if (!CollectionUtils.isEmpty(strategyModifyList)) {
            Collection strategyList = this.nebulaToolkitService.copyCollectionByBlankList(strategyModifyList, ActivityPlanStrategyModify.class, ActivityPlanStrategy.class, HashSet.class, ArrayList.class, new String[0]);
            this.activityPlanStrategyRepository.saveBatch(strategyList);
        }
        List<ActivityPlanBudgetModify> budgetModifyList = this.activityPlanBudgetModifyRepository.listByModifyCodeList(Lists.newArrayList((Object[])new String[]{businessNo}));
        List<ActivityPlanBudget> activityPlanBudgets = this.activityPlanBudgetRepository.listByPlanCode(planEntity.getPlanCode());
        this.activityPlanBudgetModifyService.passReturnMonthBudgetByModifyCode(activityPlanBudgets, budgetModifyList);
        Map<String, BigDecimal> usedAmountMap = activityPlanBudgets.stream().filter(item -> null != item.getUsedAmount()).collect(Collectors.groupingBy(item -> item.getPlanItemCode() + item.getMonthBudgetCode(), Collectors.reducing(BigDecimal.ZERO, ActivityPlanBudget::getUsedAmount, BigDecimal::add)));
        this.activityPlanBudgetRepository.deletePhysicalByPlanCode(planEntity.getPlanCode());
        if (!CollectionUtils.isEmpty(budgetModifyList)) {
            Collection budgetList = this.nebulaToolkitService.copyCollectionByBlankList(budgetModifyList, ActivityPlanBudgetModify.class, ActivityPlanBudget.class, HashSet.class, ArrayList.class, new String[0]);
            Map<String, List<ActivityPlanBudget>> budgetShareMap = budgetList.stream().collect(Collectors.groupingBy(item -> item.getPlanItemCode() + item.getMonthBudgetCode()));
            for (Map.Entry<String, BigDecimal> entry : usedAmountMap.entrySet()) {
                List<ActivityPlanBudget> thisBudgetShareList;
                BigDecimal usedAmount = entry.getValue();
                if (usedAmount.compareTo(BigDecimal.ZERO) == 0 || CollectionUtils.isEmpty(thisBudgetShareList = budgetShareMap.get(entry.getKey()))) continue;
                for (ActivityPlanBudget budget : thisBudgetShareList) {
                    if (budget.getUseAmount().compareTo(usedAmount) >= 0) {
                        budget.setUsedAmount(Optional.ofNullable(budget.getUsedAmount()).orElse(BigDecimal.ZERO).add(usedAmount));
                        usedAmount = BigDecimal.ZERO;
                        continue;
                    }
                    budget.setUsedAmount(budget.getUseAmount());
                    usedAmount = usedAmount.subtract(budget.getUseAmount());
                }
                if (usedAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                ActivityPlanBudget firstBudget = thisBudgetShareList.get(0);
                firstBudget.setUsedAmount(Optional.ofNullable(firstBudget.getUsedAmount()).orElse(BigDecimal.ZERO).add(usedAmount));
            }
            this.activityPlanBudgetRepository.saveBatch(budgetList);
        }
        if (!CollectionUtils.isEmpty(planItemTerminalModifyList = this.activityPlanItemTerminalModifyRepository.findByModifyBusinessCode(businessNo))) {
            Set originIdSet = planItemTerminalModifyList.stream().map(ActivityPlanItemTerminalModify::getOriginId).collect(Collectors.toSet());
            this.activityPlanItemTerminalRepository.removeByIds(originIdSet);
            Collection budgetList = this.nebulaToolkitService.copyCollectionByBlankList(planItemTerminalModifyList, ActivityPlanItemTerminalModify.class, ActivityPlanItemTerminal.class, HashSet.class, ArrayList.class, new String[0]);
            this.activityPlanItemTerminalRepository.saveBatch(budgetList);
        }
        ActivityPlanModifyDto activityPlanModifyDto = (ActivityPlanModifyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)modifyEntity, ActivityPlanModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
        List activityPlanItemDtos = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityPlanItem.class, ActivityPlanItemModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
        activityPlanModifyDto.setItemList(activityPlanItemDtos);
        return activityPlanModifyDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void passReturnMonthBudgetByModifyCode(String modifyBusinessCode) {
        ActivityPlanModify modifyEntity = this.activityPlanModifyRepository.getByCode(modifyBusinessCode);
        ActivityPlan planEntity = this.activityPlanRepository.getByPlanCode(modifyEntity.getPlanCode());
        List<ActivityPlanBudgetModify> budgetModifyList = this.activityPlanBudgetModifyRepository.listByModifyCodeList(Lists.newArrayList((Object[])new String[]{modifyBusinessCode}));
        List<ActivityPlanBudget> activityPlanBudgets = this.activityPlanBudgetRepository.listByPlanCode(planEntity.getPlanCode());
        this.activityPlanBudgetModifyService.passReturnMonthBudgetByModifyCode(activityPlanBudgets, budgetModifyList);
    }

    private void backupInitVersionData(String planCode) {
        List noModifyList = this.activityPlanRepository.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ActivityPlan::getPlanCode, (Object)planCode)).and(w -> {
            w.eq(ActivityPlan::getHasModify, (Object)BooleanEnum.FALSE.getCapital());
            w.or();
            w.isNull(ActivityPlan::getHasModify);
        }));
        if (CollectionUtils.isEmpty((Collection)noModifyList)) {
            return;
        }
        ActivityPlan planEntity = this.activityPlanRepository.getByPlanCode(planCode);
        ActivityPlanModify activityPlanModify = (ActivityPlanModify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)planEntity, ActivityPlanModify.class, HashSet.class, ArrayList.class, new String[0]));
        this.activityPlanModifyRepository.save((Object)activityPlanModify);
        List<ActivityPlanItem> itemList = this.activityPlanItemRepository.findListByPlanCode(planCode);
        List itemModifyList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityPlanItem.class, ActivityPlanItemModify.class, HashSet.class, ArrayList.class, new String[0]);
        this.activityPlanItemModifyRepository.saveBatch(itemModifyList);
        List<ActivityPlanRelatePlan> relatePlanList = this.activityPlanRelatePlanRepository.findListByPlanCode(planCode);
        List relatePlanModifyList = (List)this.nebulaToolkitService.copyCollectionByBlankList(relatePlanList, ActivityPlanRelatePlan.class, ActivityPlanRelatePlanModify.class, HashSet.class, ArrayList.class, new String[0]);
        this.activityPlanRelatePLanModifyRepository.saveBatch(relatePlanModifyList);
        List<ActivityPlanStrategy> strategyList = this.activityPlanStrategyRepository.findListByPlanCode(planCode);
        List strategyModifyList = (List)this.nebulaToolkitService.copyCollectionByBlankList(strategyList, ActivityPlanStrategy.class, ActivityPlanStrategyModify.class, HashSet.class, ArrayList.class, new String[0]);
        this.activityPlanStrategyModifyRepository.saveBatch(strategyModifyList);
        List<ActivityPlanBudget> budgetList = this.activityPlanBudgetRepository.listByPlanCode(planCode);
        List budgetModifyList = (List)this.nebulaToolkitService.copyCollectionByBlankList(budgetList, ActivityPlanBudget.class, ActivityPlanBudgetModify.class, HashSet.class, ArrayList.class, new String[0]);
        this.activityPlanBudgetModifyRepository.saveBatch(budgetModifyList);
        this.activityPlanRepository.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(ActivityPlan::getHasModify, (Object)BooleanEnum.TRUE.getCapital())).eq(ActivityPlan::getPlanCode, (Object)planCode));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List entities = this.activityPlanModifyRepository.listByIds(ids);
        Validate.notEmpty((Collection)entities, (String)"\u672a\u67e5\u8be2\u5230\u8981\u5220\u9664\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        for (ActivityPlanModify entity : entities) {
            Validate.isTrue((ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()) ? 1 : 0) != 0, (String)("\u65b9\u6848\u53d8\u66f4[" + entity.getModifyBusinessCode() + "]\u4e0d\u662f\u5f85\u63d0\u4ea4\u3001\u9a73\u56de\u6216\u8ffd\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664\uff01"), (Object[])new Object[0]);
        }
        this.activityPlanModifyRepository.deleteIds(ids);
        List<String> modifyCodes = entities.stream().map(ActivityPlanModify::getModifyBusinessCode).collect(Collectors.toList());
        this.activityPlanItemModifyService.deleteByModifyCodes(modifyCodes);
        this.activityPlanBudgetModifyService.deleteByModifyCodes(modifyCodes);
        this.activityPlanStrategyModifyService.deleteByModifyCodes(modifyCodes);
        this.activityPlanRelatePlanModifyService.deleteByModifyCodes(modifyCodes);
        Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, ActivityPlanModify.class, ActivityPlanModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onDelete = ActivityPlanLogEventListener::onDeleteModify;
        for (ActivityPlanModifyDto dto : dtoList) {
            ActivityPlanModifyLogEventDto logEventDto = new ActivityPlanModifyLogEventDto();
            logEventDto.setOriginal(dto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ActivityPlanLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void verticalPersonUpdateJob() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.verticalPersonUpdateJob(simpleDateFormat.format(calendar.getTime()));
    }

    @Transactional(rollbackFor={Exception.class})
    public void verticalPersonUpdateJob(String updateDate) {
        String planCode;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(simpleDateFormat.parse(updateDate));
        }
        catch (ParseException e) {
            throw new RuntimeException("\u65f6\u95f4\u53c2\u6570\u6709\u8bef\uff01");
        }
        PromotersDto mdmPromotersQueryDto = new PromotersDto();
        mdmPromotersQueryDto.setUserType("ZKCC");
        mdmPromotersQueryDto.setCreateDate(updateDate);
        List updatePromoterVoList = this.promotersVoService.findTerminalPromotersByTerminal(mdmPromotersQueryDto);
        if (CollectionUtils.isEmpty((Collection)updatePromoterVoList)) {
            return;
        }
        Set terminalCodeList = updatePromoterVoList.stream().map(PromotersVo::getTerminalCode).collect(Collectors.toSet());
        mdmPromotersQueryDto = new PromotersDto();
        mdmPromotersQueryDto.setUserType("ZKCC");
        mdmPromotersQueryDto.setTerminalCodeSet(terminalCodeList);
        List promoterVoList = this.promotersVoService.findTerminalPromotersByTerminal(mdmPromotersQueryDto);
        Map<String, List<PromotersVo>> terminalEmployeeMap = promoterVoList.stream().collect(Collectors.groupingBy(PromotersVo::getTerminalCode));
        List<ActivityPlanItemTerminalVo> verticalPersonUpdateList = this.activityPlanItemTerminalRepository.findVerticalPersonUpdateList(Lists.newArrayList(terminalCodeList), updateDate);
        HashMap modifyItemMap = Maps.newHashMap();
        calendar.set(11, 23);
        calendar.set(12, 23);
        calendar.set(13, 59);
        Date nowEndDate = calendar.getTime();
        calendar.add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date nextBeginDate = calendar.getTime();
        Map<String, List<ActivityPlanItemTerminalVo>> verticalPersonUpdatePlanMap = verticalPersonUpdateList.stream().collect(Collectors.groupingBy(ActivityPlanItemTerminalVo::getPlanCode));
        for (Map.Entry<String, List<ActivityPlanItemTerminalVo>> entry : verticalPersonUpdatePlanMap.entrySet()) {
            planCode = entry.getKey();
            List<ActivityPlanItemTerminalVo> planTerminalList = entry.getValue();
            Map<String, List<ActivityPlanItemTerminalVo>> planItemTerminalMap = planTerminalList.stream().collect(Collectors.groupingBy(item -> item.getPlanItemCode() + "-" + item.getTerminalCode()));
            ArrayList modifyItemList = Lists.newArrayList();
            for (Map.Entry<String, List<ActivityPlanItemTerminalVo>> planTerminalEntry : planItemTerminalMap.entrySet()) {
                String[] keySplit = planTerminalEntry.getKey().split("-");
                String planItemCode = keySplit[0];
                String terminalCode = keySplit[1];
                List<ActivityPlanItemTerminalVo> terminalEmployeeList = planTerminalEntry.getValue();
                List<PromotersVo> list = terminalEmployeeMap.get(terminalCode);
                Iterator<Object> employeeCodeSet = list.stream().map(PromotersVo::getEmployeeCode).collect(Collectors.toSet());
                boolean bl = false;
                ArrayList updateTerminalEmployeeList = Lists.newArrayList();
                for (ActivityPlanItemTerminalVo terminalEmployee : terminalEmployeeList) {
                    if (employeeCodeSet.contains(terminalEmployee.getEmployeeCode())) continue;
                    bl = true;
                    updateTerminalEmployeeList.add(terminalEmployee);
                }
                if (!bl || employeeCodeSet.size() < terminalEmployeeList.size()) continue;
                ActivityPlanItemModifyDto activityPlanItemModifyDto = new ActivityPlanItemModifyDto();
                activityPlanItemModifyDto.setPlanCode(planCode);
                activityPlanItemModifyDto.setPlanItemCode(planItemCode);
                ArrayList terminalModifyList = Lists.newArrayList();
                Set planEmployeeSet = terminalEmployeeList.stream().map(ActivityPlanItemTerminalVo::getEmployeeCode).collect(Collectors.toSet());
                for (ActivityPlanItemTerminalVo activityPlanItemTerminalVo : updateTerminalEmployeeList) {
                    Date beginDate = activityPlanItemTerminalVo.getBeginDate();
                    Date endDate = activityPlanItemTerminalVo.getEndDate();
                    Calendar tempCalendar = Calendar.getInstance();
                    tempCalendar.setTime(beginDate);
                    int firstDaySize = 0;
                    int daySize = 0;
                    while (tempCalendar.getTime().before(endDate)) {
                        tempCalendar.add(5, 1);
                        ++daySize;
                        if (!tempCalendar.getTime().before(nowEndDate)) continue;
                        ++firstDaySize;
                    }
                    BigDecimal amount = activityPlanItemTerminalVo.getAmount();
                    BigDecimal endAmount = amount.multiply(new BigDecimal(firstDaySize)).divide(new BigDecimal(daySize), 2, RoundingMode.HALF_DOWN);
                    ActivityPlanItemTerminalModifyDto activityPlanItemTerminalModifyDto = (ActivityPlanItemTerminalModifyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityPlanItemTerminalVo, ActivityPlanItemTerminalModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
                    activityPlanItemTerminalModifyDto.setOriginId(activityPlanItemTerminalVo.getId());
                    activityPlanItemTerminalModifyDto.setBeginDate(beginDate);
                    activityPlanItemTerminalModifyDto.setEndDate(nowEndDate);
                    activityPlanItemTerminalModifyDto.setAmount(endAmount);
                    terminalModifyList.add(activityPlanItemTerminalModifyDto);
                    PromotersVo thisPromotersVo = null;
                    for (PromotersVo promotersVo : list) {
                        if (planEmployeeSet.contains(promotersVo.getEmployeeCode())) continue;
                        thisPromotersVo = promotersVo;
                        break;
                    }
                    planEmployeeSet.add(thisPromotersVo.getEmployeeCode());
                    ActivityPlanItemTerminalModifyDto activityPlanItemTerminalModifyDto2 = new ActivityPlanItemTerminalModifyDto();
                    activityPlanItemTerminalModifyDto2.setPlanCode(activityPlanItemTerminalVo.getPlanCode());
                    activityPlanItemTerminalModifyDto2.setPlanItemCode(activityPlanItemTerminalVo.getPlanItemCode());
                    activityPlanItemTerminalModifyDto2.setOriginId(activityPlanItemTerminalVo.getId());
                    BeanUtils.copyProperties((Object)thisPromotersVo, (Object)activityPlanItemTerminalModifyDto2);
                    activityPlanItemTerminalModifyDto2.setBeginDate(nextBeginDate);
                    activityPlanItemTerminalModifyDto2.setEndDate(activityPlanItemTerminalVo.getEndDate());
                    activityPlanItemTerminalModifyDto2.setAmount(amount.subtract(endAmount));
                    terminalModifyList.add(activityPlanItemTerminalModifyDto2);
                }
                activityPlanItemModifyDto.setActivityPlanItemTerminalList((List)terminalModifyList);
                modifyItemList.add(activityPlanItemModifyDto);
            }
            if (modifyItemList.size() == 0) continue;
            modifyItemMap.put(planCode, modifyItemList);
        }
        if (modifyItemMap.size() == 0) {
            return;
        }
        for (Map.Entry<String, List<Object>> entry : modifyItemMap.entrySet()) {
            planCode = entry.getKey();
            List<Object> value = entry.getValue();
            List<String> planItemCodeList = value.stream().map(ActivityPlanItemBase::getPlanItemCode).collect(Collectors.toList());
            ActivityPlanVo planVo = this.activityPlanService.findByCode(planCode);
            ActivityPlanModifyDto dto = (ActivityPlanModifyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)planVo, ActivityPlanModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
            dto.setId(null);
            List<ActivityPlanItemDto> itemDtoList = this.activityPlanItemRepository.findDtoAndAttachListByPlanItemCode(planItemCodeList);
            ArrayList modifyItemDtoList = Lists.newArrayList();
            for (ActivityPlanItemDto planItemDto : itemDtoList) {
                ActivityPlanItemModifyDto modifyItemDto = (ActivityPlanItemModifyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)planItemDto, ActivityPlanItemModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
                if (!CollectionUtils.isEmpty((Collection)planItemDto.getBudgetShares())) {
                    modifyItemDto.setBudgetShares((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)planItemDto.getBudgetShares(), ActivityPlanBudgetDto.class, ActivityPlanBudgetModifyDto.class, HashSet.class, ArrayList.class, new String[0]));
                }
                modifyItemDto.setId(null);
                modifyItemDtoList.add(modifyItemDto);
            }
            Map modifyItemDtoMap = modifyItemDtoList.stream().collect(Collectors.toMap(ActivityPlanItemBase::getPlanItemCode, Function.identity()));
            HashSet planTerminalIdList = Sets.newHashSet();
            for (ActivityPlanItemModifyDto activityPlanItemModifyDto : value) {
                for (ActivityPlanItemTerminalModifyDto activityPlanItemTerminalModifyDto : activityPlanItemModifyDto.getActivityPlanItemTerminalList()) {
                    planTerminalIdList.add(activityPlanItemTerminalModifyDto.getOriginId());
                }
            }
            List activityPlanItemTerminals = this.activityPlanItemTerminalRepository.listByIds(planTerminalIdList);
            Map map = activityPlanItemTerminals.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
            for (ActivityPlanItemModifyDto activityPlanItemModifyDto : value) {
                ArrayList planItemTerminalList = Lists.newArrayList();
                for (ActivityPlanItemTerminalModifyDto activityPlanItemTerminalModifyDto : activityPlanItemModifyDto.getActivityPlanItemTerminalList()) {
                    ActivityPlanItemTerminal activityPlanItemTerminal = (ActivityPlanItemTerminal)((Object)map.get(activityPlanItemTerminalModifyDto.getOriginId()));
                    ActivityPlanItemTerminalModifyDto newPlanItemTerminal = (ActivityPlanItemTerminalModifyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityPlanItemTerminal, ActivityPlanItemTerminalModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
                    newPlanItemTerminal.setId(null);
                    newPlanItemTerminal.setOriginId(activityPlanItemTerminalModifyDto.getOriginId());
                    newPlanItemTerminal.setEmployeeCode(activityPlanItemTerminalModifyDto.getEmployeeCode());
                    newPlanItemTerminal.setName(activityPlanItemTerminalModifyDto.getName());
                    newPlanItemTerminal.setEmpId(activityPlanItemTerminalModifyDto.getEmpId());
                    newPlanItemTerminal.setResponsibleBusiness(activityPlanItemTerminalModifyDto.getResponsibleBusiness());
                    newPlanItemTerminal.setResponsibleSupervision(activityPlanItemTerminalModifyDto.getResponsibleSupervision());
                    newPlanItemTerminal.setBeginDate(activityPlanItemTerminalModifyDto.getBeginDate());
                    newPlanItemTerminal.setEndDate(activityPlanItemTerminalModifyDto.getEndDate());
                    newPlanItemTerminal.setAmount(activityPlanItemTerminalModifyDto.getAmount());
                    planItemTerminalList.add(newPlanItemTerminal);
                }
                ActivityPlanItemModifyDto planItemModifyDto = (ActivityPlanItemModifyDto)modifyItemDtoMap.get(activityPlanItemModifyDto.getPlanItemCode());
                planItemModifyDto.setActivityPlanItemTerminalList((List)planItemTerminalList);
            }
            String modifyBusinessCode = this.create(dto, modifyItemDtoList);
            ProcessStatusDto processStatusDto = new ProcessStatusDto();
            processStatusDto.setBusinessNo(modifyBusinessCode);
            processStatusDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            this.processPass(processStatusDto);
        }
    }
}

