/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.modify.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanRelatePlanModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanRelatePlanModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanRelatePlanModifyService;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanRelatePlanModifyDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityPlanRelatePlanModifyServiceImpl
implements ActivityPlanRelatePlanModifyService {
    @Autowired(required=false)
    private ActivityPlanRelatePlanModifyRepository activityPlanRelatePlanRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveActivityPlanRelatePlanList(ActivityPlanModify entity, boolean update, List<ActivityPlanRelatePlanModifyDto> strategyList) {
        if (CollectionUtils.isEmpty(strategyList)) {
            return;
        }
        Map<Object, Object> oldMap = Maps.newHashMap();
        if (update) {
            List<ActivityPlanRelatePlanModify> oldList = this.activityPlanRelatePlanRepository.findListByModifyCode(entity.getModifyBusinessCode());
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        List activityPlanStrategies = (List)this.nebulaToolkitService.copyCollectionByWhiteList(strategyList, ActivityPlanRelatePlanModifyDto.class, ActivityPlanRelatePlanModify.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (ActivityPlanRelatePlanModify item : activityPlanStrategies) {
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
                oldMap.remove(item.getId());
                continue;
            }
            item.setPlanCode(entity.getPlanCode());
            item.setModifyBusinessCode(entity.getModifyBusinessCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            item.setId(null);
            saveList.add(item);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.activityPlanRelatePlanRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.activityPlanRelatePlanRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            this.activityPlanRelatePlanRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    @Override
    public void deleteByModifyCodes(List<String> modifyCodes) {
        if (CollectionUtils.isEmpty(modifyCodes)) {
            return;
        }
        this.activityPlanRelatePlanRepository.deleteByModifyCodes(modifyCodes);
    }
}

