/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.modify.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.entity.ActivityPlanStrategyModify;
import com.biz.crm.tpm.business.activity.plan.local.modify.repository.ActivityPlanStrategyModifyRepository;
import com.biz.crm.tpm.business.activity.plan.local.modify.service.ActivityPlanStrategyModifyService;
import com.biz.crm.tpm.business.activity.plan.sdk.modify.dto.ActivityPlanStrategyModifyDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityPlanStrategyModifyServiceImpl
implements ActivityPlanStrategyModifyService {
    @Autowired(required=false)
    private ActivityPlanStrategyModifyRepository activityPlanStrategyRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveActivityPlanStrategyList(ActivityPlanModify entity, boolean update, List<ActivityPlanStrategyModifyDto> strategyList) {
        if (CollectionUtils.isEmpty(strategyList)) {
            return;
        }
        Map<Object, Object> oldMap = Maps.newHashMap();
        if (update) {
            List<ActivityPlanStrategyModify> oldList = this.activityPlanStrategyRepository.findListByModifyCode(entity.getModifyBusinessCode());
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        List activityPlanStrategies = (List)this.nebulaToolkitService.copyCollectionByWhiteList(strategyList, ActivityPlanStrategyModifyDto.class, ActivityPlanStrategyModify.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (ActivityPlanStrategyModify item : activityPlanStrategies) {
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
                oldMap.remove(item.getId());
                continue;
            }
            item.setPlanCode(entity.getPlanCode());
            item.setModifyBusinessCode(entity.getModifyBusinessCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            item.setId(null);
            saveList.add(item);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.activityPlanStrategyRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.activityPlanStrategyRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            this.activityPlanStrategyRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    @Override
    public void deleteByModifyCodes(List<String> modifyCodes) {
        if (CollectionUtils.isEmpty(modifyCodes)) {
            return;
        }
        this.activityPlanStrategyRepository.deleteByModifyCodes(modifyCodes);
    }
}

