/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.notifier;

import com.biz.crm.kms.business.financial.auditing.sdk.dto.totpm.KmsActivityPlanItemDto;
import com.biz.crm.kms.business.financial.auditing.sdk.dto.totpm.KmsCreateActivityPlanDto;
import com.biz.crm.kms.business.financial.auditing.sdk.event.KmsCreateActivityPlanEvent;
import com.biz.crm.kms.business.financial.auditing.sdk.vo.KmsCreateActivityPlanResponse;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanWhereFrom;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class KmsCreateActivityPlanEventImpl
implements KmsCreateActivityPlanEvent {
    @Autowired(required=false)
    private ActivityPlanService activityPlanService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;

    public KmsCreateActivityPlanResponse createActivityPlan(KmsCreateActivityPlanDto dto) {
        List itemList = dto.getItemList();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getItemList()) ? 1 : 0) != 0, (String)"\u660e\u7ec6\u884c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String[] propertiesFilter = new String[]{"itemList"};
        ActivityPlanDto activityPlanDto = (ActivityPlanDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ActivityPlanDto.class, HashSet.class, ArrayList.class, propertiesFilter);
        activityPlanDto.setPlanType(ActivityPlanTypeEnum.region.getCode());
        ArrayList activityPlanItemList = Lists.newArrayList();
        List activityOrgCodeList = dto.getItemList().stream().map(KmsActivityPlanItemDto::getActivityOrgCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Object, Object> salesOrgMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(activityOrgCodeList)) {
            List salesOrgVos = this.salesOrgVoService.findBySalesOrgCodes(activityOrgCodeList);
            salesOrgMap = salesOrgVos.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity(), (o, n) -> n));
        }
        List productCodeList = itemList.stream().map(KmsActivityPlanItemDto::getProductCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Object, Object> productVoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(productCodeList)) {
            List productVoList = this.productVoService.findByCodes(productCodeList);
            productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (o, n) -> n));
        }
        for (KmsActivityPlanItemDto kmsActivityPlanItemDto : itemList) {
            SalesOrgVo salesOrgVo;
            ActivityPlanItemDto itemDto = (ActivityPlanItemDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)kmsActivityPlanItemDto, ActivityPlanItemDto.class, HashSet.class, ArrayList.class, new String[0]);
            itemDto.setActivityBeginDate(kmsActivityPlanItemDto.getActivityBeginTime());
            itemDto.setActivityEndDate(kmsActivityPlanItemDto.getActivityEndTime());
            if (StringUtils.isNotEmpty((CharSequence)kmsActivityPlanItemDto.getActivityOrgCode()) && null != (salesOrgVo = (SalesOrgVo)salesOrgMap.get(kmsActivityPlanItemDto.getActivityOrgCode()))) {
                itemDto.setSalesInstitutionErpCode(salesOrgVo.getErpCode());
                itemDto.setDistributionChannelCode(salesOrgVo.getChannelCode());
                itemDto.setDistributionChannelName(salesOrgVo.getChannelName());
            }
            if (StringUtils.isNotEmpty((CharSequence)itemDto.getProductCode()) && productVoMap.containsKey(itemDto.getProductCode())) {
                ProductVo productVo = (ProductVo)productVoMap.get(itemDto.getProductCode());
                itemDto.setProductUnit(productVo.getBaseUnit());
            }
            activityPlanItemList.add(itemDto);
            activityPlanDto.setRegionCode(itemDto.getRegion());
        }
        activityPlanDto.setItemList((List)activityPlanItemList);
        if (StringUtils.isEmpty((CharSequence)dto.getWhereFrom())) {
            activityPlanDto.setWhereFrom(ActivityPlanWhereFrom.KMS.getCode());
        } else {
            activityPlanDto.setWhereFrom(dto.getWhereFrom());
        }
        final String planCode = this.activityPlanService.createActivityPlan(activityPlanDto);
        return new KmsCreateActivityPlanResponse(){
            {
                this.setPlanCode(planCode);
            }
        };
    }
}

