/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.org.sdk.dto.OrgQueryDto;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanQueryActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanQueryActivityDetailPlanResponse;
import com.biz.crm.tpm.business.activity.plan.sdk.listener.ActivityPlanQueryActivityDetailPlanListener;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.bizunited.nebula.europa.database.register.sdk.service.MnDataviewRegister;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteParameter;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterOperatorBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityPlanDataViewRegister
implements MnDataviewRegister {
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    @Qualifier(value="inParameterOperatorBindingStrategy")
    private ParameterOperatorBindingStrategy inParameterOperatorBindingStrategy;
    @Autowired(required=false)
    private ActivityPlanItemRepository activityPlanItemRepository;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private ProcessBusinessMappingService processBusinessMappingService;

    public String code() {
        return "tpm_activity_plan_data_view";
    }

    public String desc() {
        return "TPM-\u6d3b\u52a8\u65b9\u6848";
    }

    public String buildSql() {
        return "select\na.id,\na.create_account,\na.create_name,\na.create_time,\na.modify_account,\na.modify_name,\na.modify_time,\na.del_flag,\na.enable_status,\na.remark,\na.tenant_code,\na.plan_code,\na.plan_name,\na.plan_type,\na.business_format_code,\na.business_unit_code,\na.begin_date,\na.end_date,\na.plan_org_code,\na.plan_org_name,\na.plan_classify,\na.plan_relate_limit_code,\na.plan_status,\na.fee_amount,\na.head_fee_amount,\na.department_fee_amount,\na.customer_fee_amount,\na.total_fee_amount,\na.region_automatic_fee_amount,\na.region_referendum_fee_amount,\na.used_amount,\na.sales_amount,\na.plan_io_rate,\na.plan_title,\na.plan_goal,\na.activity_background,\na.activity_target,\na.detail_explain,\na.full_accept,\na.template_config_code,\na.template_config_name,\na.process_no,\na.process_status,\na.where_from,\na.has_modify,\na.curr_modify_business_code,\na.is_cross_month,\na.nect_business_unit_code,\na.is_validate,\na.region_code,\ngroup_concat(org.org_code) as department_code,\ngroup_concat(org.org_name) as department_name,\n'' as parent_department_name,\n'' as plan_item_code,\n'' as relate_detail_plan_code\n from tpm_activity_plan a\n left join tpm_activity_plan_org org on org.plan_code = a.plan_code\nwhere a.tenant_code = :tenantCode\nand a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'\ngroup by a.plan_code";
    }

    public Object customBindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest databaseExecuteExternalRequest) {
        if (!(executeParameter instanceof DatabaseExecuteParameter)) {
            return null;
        }
        DatabaseExecuteParameter databaseExecuteParameter = (DatabaseExecuteParameter)executeParameter;
        String paramName = databaseExecuteParameter.getParamName();
        Object value = databaseExecuteExternalRequest.getAttribute(paramName);
        if (value == null) {
            return null;
        }
        String valueStr = String.valueOf(value);
        if ("parent_department_name".equals(databaseExecuteParameter.getTargetFieldName())) {
            return this.parentDepartmentNameQuery(databaseExecuteParameter, valueStr);
        }
        if ("plan_item_code".equals(databaseExecuteParameter.getTargetFieldName())) {
            return this.planItemCodeQuery(databaseExecuteParameter, valueStr);
        }
        if ("relate_detail_plan_code".equals(databaseExecuteParameter.getTargetFieldName())) {
            return this.relateDetailPlanItemCodeQuery(databaseExecuteParameter, valueStr);
        }
        if ("process_no".equals(databaseExecuteParameter.getTargetFieldName())) {
            return this.processNoQuery(databaseExecuteParameter, valueStr);
        }
        return valueStr;
    }

    private Object processNoQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "plan_code";
        String parameterName = databaseExecuteParameter.getParamName();
        String expression = this.inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);
        List processBusinessMappingVos = this.processBusinessMappingService.findAllByProcessNoCollection((Collection)Lists.newArrayList((Object[])new String[]{valueStr}));
        if (CollectionUtils.isEmpty((Collection)processBusinessMappingVos)) {
            return Lists.newArrayList((Object[])new String[]{"_"});
        }
        return processBusinessMappingVos.stream().map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
    }

    private Object parentDepartmentNameQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "department_code";
        String parameterName = databaseExecuteParameter.getParamName();
        String expression = this.inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);
        ArrayList orgCodeList = Lists.newArrayList((Object[])new String[]{"_"});
        OrgQueryDto orgQueryDto = new OrgQueryDto();
        orgQueryDto.setOrgName(valueStr);
        Set parentCodeSet = this.orgVoService.findByOrgQueryDto(orgQueryDto);
        if (CollectionUtils.isEmpty((Collection)parentCodeSet)) {
            return orgCodeList;
        }
        orgQueryDto.setOrgName(null);
        ArrayList parentOrgCodeList = Lists.newArrayList((Iterable)parentCodeSet);
        orgQueryDto.setParentOrgCodeList((List)parentOrgCodeList);
        Set codeSet = this.orgVoService.findByOrgQueryDto(orgQueryDto);
        orgCodeList.addAll(codeSet);
        return orgCodeList;
    }

    private Object relateDetailPlanItemCodeQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "plan_code";
        String parameterName = databaseExecuteParameter.getParamName();
        String expression = this.inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);
        ArrayList planCodeList = Lists.newArrayList((Object[])new String[]{"_"});
        ActivityPlanQueryActivityDetailPlanDto queryActivityDetailPlanDto = new ActivityPlanQueryActivityDetailPlanDto();
        List<String> detailPlanCodeList = Arrays.asList(valueStr.split("[, \uff0c]"));
        queryActivityDetailPlanDto.setDetailPlanCodeList(detailPlanCodeList);
        SerializableBiConsumer & Serializable queryActivityDetailPlan = ActivityPlanQueryActivityDetailPlanListener::detailPlanRelatePlanCodeList;
        ActivityPlanQueryActivityDetailPlanResponse queryActivityDetailPlanResponse = (ActivityPlanQueryActivityDetailPlanResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)queryActivityDetailPlanDto, ActivityPlanQueryActivityDetailPlanListener.class, (SerializableBiConsumer)queryActivityDetailPlan);
        if (!CollectionUtils.isEmpty((Collection)queryActivityDetailPlanResponse.getPlanCodeList())) {
            planCodeList.addAll(queryActivityDetailPlanResponse.getPlanCodeList());
        }
        return planCodeList;
    }

    private Object planItemCodeQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "plan_code";
        String parameterName = databaseExecuteParameter.getParamName();
        String expression = this.inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);
        ArrayList planCodeList = Lists.newArrayList((Object[])new String[]{"_"});
        planCodeList.addAll(this.activityPlanItemRepository.findPlanCodeListByItemCodeList(Arrays.asList(valueStr.split("[, \uff0c]"))));
        return planCodeList;
    }
}

