/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanBudget;
import com.biz.crm.tpm.business.activity.plan.local.mapper.ActivityPlanBudgetMapper;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyBudgetVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.StrategyActivityPlanItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ActivityPlanBudgetRepository
extends ServiceImpl<ActivityPlanBudgetMapper, ActivityPlanBudget> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<ActivityPlanBudget> listByPlanCode(String planCode) {
        if (StringUtils.isEmpty((CharSequence)planCode)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivityPlanBudget::getPlanCode, (Object)planCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<ActivityPlanBudgetDto> listDtoListByPlanCode(String planCode) {
        if (StringUtils.isEmpty((CharSequence)planCode)) {
            return null;
        }
        return ((ActivityPlanBudgetMapper)this.baseMapper).listDtoListByPlanCode(planCode);
    }

    public List<ActivityPlanBudget> listByOperateCodeList(List<String> operateCodeList) {
        if (CollectionUtils.isEmpty(operateCodeList)) {
            return null;
        }
        return ((ActivityPlanBudgetMapper)this.baseMapper).listByOperateCodeList(operateCodeList);
    }

    public LinkedList<ActivityPlanBudget> listByOperateCodeListVertical(List<String> operateCodeList) {
        if (CollectionUtils.isEmpty(operateCodeList)) {
            return null;
        }
        return ((ActivityPlanBudgetMapper)this.baseMapper).listByOperateCodeListVertical(operateCodeList);
    }

    public List<ActivityPlanBudget> listCustomerBudgetByOperateCodeList(List<String> planItemCodeList) {
        if (CollectionUtils.isEmpty(planItemCodeList)) {
            return null;
        }
        return ((ActivityPlanBudgetMapper)this.baseMapper).listCustomerBudgetByPlanItemCodeList(planItemCodeList);
    }

    public List<ActivityPlanBudgetDto> listDtoByPlanCodeList(List<String> planCodeList) {
        List<ActivityPlanBudget> activityPlanBudgets = this.listByPlanCodeList(planCodeList);
        if (CollectionUtils.isNotEmpty(activityPlanBudgets)) {
            List dtoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(activityPlanBudgets, ActivityPlanBudget.class, ActivityPlanBudgetDto.class, HashSet.class, ArrayList.class, new String[0]);
            return dtoList;
        }
        return Lists.newArrayList();
    }

    public List<ActivityPlanBudgetDto> listDtoByPlanItemCodeList(List<String> planItemCodeList) {
        List<ActivityPlanBudget> activityPlanBudgets = this.listByPlanItemCodeList(planItemCodeList);
        if (CollectionUtils.isNotEmpty(activityPlanBudgets)) {
            List dtoList = (List)this.nebulaToolkitService.copyCollectionByBlankList(activityPlanBudgets, ActivityPlanBudget.class, ActivityPlanBudgetDto.class, HashSet.class, ArrayList.class, new String[0]);
            return dtoList;
        }
        return Lists.newArrayList();
    }

    public List<ActivityPlanBudget> listByPlanItemCodeList(List<String> planItemCodeList) {
        if (org.springframework.util.CollectionUtils.isEmpty(planItemCodeList)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityPlanBudget::getPlanItemCode, planItemCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<ActivityPlanBudget> listByPlanCodeList(List<String> planCodeList) {
        if (org.springframework.util.CollectionUtils.isEmpty(planCodeList)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityPlanBudget::getPlanCode, planCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<ActivityPlanBudget> listByDetailCodeList(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityPlanBudget::getPlanItemCode, itemCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public void deleteByIds(List<String> ids) {
        if (org.springframework.util.CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public void deletePhysicalByPlanCode(String planCode) {
        if (StringUtils.isEmpty((CharSequence)planCode)) {
            return;
        }
        LambdaQueryWrapper updateWrapper = new LambdaQueryWrapper();
        updateWrapper.eq(ActivityPlanBudget::getPlanCode, (Object)planCode);
        this.remove((Wrapper)updateWrapper);
    }

    public void deleteByPlanCodes(List<String> planCodes) {
        if (org.springframework.util.CollectionUtils.isEmpty(planCodes)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityPlanBudget::getPlanCode, planCodes);
        this.update((Wrapper)updateWrapper);
    }

    public Page<ActivityPlanBudgetVo> findByConditions(Pageable pageable, ActivityPlanBudgetDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<ActivityPlanBudgetVo> pageList = ((ActivityPlanBudgetMapper)this.baseMapper).findConditions((Page<MarketingStrategyBudgetVo>)page, dto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }

    public void fillVoListProperties(List<ActivityPlanBudgetVo> voList) {
        if (org.springframework.util.CollectionUtils.isEmpty(voList)) {
            return;
        }
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanBudgetVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        for (ActivityPlanBudgetVo item : voList) {
            this.fillVoProperties(item, propertyMap);
        }
    }

    public void fillVoProperties(ActivityPlanBudgetVo item) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanBudgetVo.class);
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        this.fillVoProperties(item, propertyMap);
    }

    public void fillVoProperties(ActivityPlanBudgetVo item, Map<String, PropertyDescriptor> propertyMap) {
        if (null == item) {
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties((Object)item, ActivityPlanBudgetVo.class, propertyMap);
        BigDecimal useAmount = Optional.ofNullable(item.getUseAmount()).orElse(BigDecimal.ZERO);
        BigDecimal usedAmount = Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO);
        item.setUsedAmount(usedAmount);
        item.setUsableAmount(useAmount.subtract(usedAmount));
    }

    public List<ActivityPlanBudget> findCarGiftCloseReturnBudgetList(List<String> planItemCodeList) {
        if (CollectionUtils.isEmpty(planItemCodeList)) {
            return Lists.newArrayList();
        }
        return ((ActivityPlanBudgetMapper)this.baseMapper).findCarGiftCloseReturnBudgetList(planItemCodeList);
    }

    public List<String> getNoClosePlanItemNo(List<String> itemNos) {
        if (CollectionUtils.isEmpty(itemNos)) {
            return Lists.newArrayList();
        }
        return ((ActivityPlanBudgetMapper)this.baseMapper).getNoClosePlanItemNo(itemNos, TenantUtils.getTenantCode());
    }

    public List<ActivityPlanBudgetVo> findByPlanItemCode(Set<String> codeSet) {
        return ((ActivityPlanBudgetMapper)this.baseMapper).findByPlanItemCode(codeSet, TenantUtils.getTenantCode());
    }

    public List<ActivityPlanBudgetVo> findByPlanCode(Set<String> planSet) {
        return ((ActivityPlanBudgetMapper)this.baseMapper).findByPlanCode(planSet, TenantUtils.getTenantCode());
    }

    public List<ActivityPlanBudgetVo> findItemBudgetListByPlanCode(String planCode) {
        if (StringUtils.isEmpty((CharSequence)planCode)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivityPlanBudget::getRelatePlanCode, (Object)planCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Collection activityPlanBudgetVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, ActivityPlanBudget.class, ActivityPlanBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            return (List)activityPlanBudgetVos;
        }
        return Lists.newArrayList();
    }

    public List<ActivityPlanBudget> findItemBudgetListByPlanItemCode(String planItemCode) {
        if (StringUtils.isEmpty((CharSequence)planItemCode)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivityPlanBudget::getPlanItemCode, (Object)planItemCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<String> strategyRelatePlanCodeList(Set<String> planCodeList) {
        return ((ActivityPlanBudgetMapper)this.baseMapper).strategyRelatePlanCodeList(planCodeList, TenantUtils.getTenantCode());
    }

    public List<StrategyActivityPlanItemVo> findActivityPlanByStrategyItemCodeList(List<String> strategyItemCodeList) {
        return ((ActivityPlanBudgetMapper)this.baseMapper).findActivityPlanByStrategyItemCodeList(strategyItemCodeList, TenantUtils.getTenantCode());
    }

    public List<ActivityPlanBudgetVo> findRegionIsRelateHead(List<String> planCodes, String tenantCode) {
        return ((ActivityPlanBudgetMapper)this.baseMapper).findRegionIsRelateHead(planCodes, tenantCode);
    }
}

