/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItemRelateDetailItem;
import com.biz.crm.tpm.business.activity.plan.local.mapper.ActivityPlanItemRelateDetailItemMapper;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemRelateDetailItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemRelateDetailItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityPlanItemRelateDetailItemRepository
extends ServiceImpl<ActivityPlanItemRelateDetailItemMapper, ActivityPlanItemRelateDetailItem> {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanItemRelateDetailItemRepository.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<ActivityPlanItemRelateDetailItemVo> findListByPlanCode(String planCode) {
        if (StringUtils.isEmpty((CharSequence)planCode)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(ActivityPlanItemRelateDetailItem::getPlanCode, (Object)planCode)).list();
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, ActivityPlanItemRelateDetailItem.class, ActivityPlanItemRelateDetailItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<ActivityPlanItemRelateDetailItemDto> findDtoListByPlanCode(String planCode) {
        if (StringUtils.isEmpty((CharSequence)planCode)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(ActivityPlanItemRelateDetailItem::getPlanCode, (Object)planCode)).list();
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, ActivityPlanItemRelateDetailItem.class, ActivityPlanItemRelateDetailItemDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<ActivityPlanItemRelateDetailItem> findDtoByPlanCodeList(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(ActivityPlanItemRelateDetailItem::getPlanCode, planCodeList)).list();
        return list;
    }

    public List<ActivityPlanItemRelateDetailItemVo> findCountByPlanCodeList(List<String> planItemCodeList) {
        List list;
        if (CollectionUtils.isNotEmpty(planItemCodeList) && CollectionUtils.isNotEmpty((Collection)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityPlanItemRelateDetailItem::getPlanItemCode, planItemCodeList)).select(new SFunction[]{ActivityPlanItemRelateDetailItem::getPlanItemCode}).list()))) {
            Collection activityPlanItemRelateDetailItemVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, ActivityPlanItemRelateDetailItem.class, ActivityPlanItemRelateDetailItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            return (List)activityPlanItemRelateDetailItemVos;
        }
        return Lists.newArrayList();
    }

    public void deleteByPlanCode(String planCode) {
        if (StringUtils.isEmpty((CharSequence)planCode)) {
            return;
        }
        this.remove((Wrapper)Wrappers.lambdaUpdate(ActivityPlanItemRelateDetailItem.class).eq(ActivityPlanItemRelateDetailItem::getPlanCode, (Object)planCode));
    }
}

