/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.repository;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.extend.field.service.ExtendFieldService;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItem;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItemExtend;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItemExtendField;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItemProduct;
import com.biz.crm.tpm.business.activity.plan.local.mapper.ActivityPlanItemMapper;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemExtendFieldRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemExtendRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemProductRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemTerminalRepository;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemTerminalDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.RedPacketQueryScheme2Dto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanBudgetOccupyTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.InterfacePushStateEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.RedPacketQueryScheme2Vo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.submitreportvo.ActivityPlanSubmitReportSubVo;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.YesOrNoEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;
import org.apache.ibatis.binding.MapperMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityPlanItemRepository
extends ServiceImpl<ActivityPlanItemMapper, ActivityPlanItem> {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanItemRepository.class);
    @Autowired(required=false)
    private ActivityPlanItemMapper activityPlanItemMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityPlanBudgetRepository activityPlanBudgetRepository;
    @Autowired(required=false)
    private ActivityPlanItemExtendRepository activityPlanItemExtendRepository;
    @Autowired(required=false)
    private ActivityPlanItemExtendFieldRepository activityPlanItemExtendFieldRepository;
    @Autowired(required=false)
    private ActivityPlanItemProductRepository activityPlanItemProductRepository;
    @Autowired(required=false)
    private ActivityPlanItemTerminalRepository activityPlanItemTerminalRepository;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private ExtendFieldService extendFieldService;
    private static final String DATE_FORMAT_STR = "%Y-%m";

    public List<ActivityPlanItemDto> findDtoListByPlanCode(String planCode) {
        if (StringUtils.isBlank((CharSequence)planCode)) {
            return null;
        }
        ActivityPlanItemDto dto = new ActivityPlanItemDto();
        dto.setPlanCode(planCode);
        return this.findDtoList(dto);
    }

    public List<ActivityPlanItemDto> findDtoListByPlanCodeList(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return null;
        }
        ActivityPlanItemDto dto = new ActivityPlanItemDto();
        dto.setPlanCodeList(planCodeList);
        return this.findDtoList(dto);
    }

    public List<ActivityPlanItemVo> findVoListByPlanCodeList(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return Collections.emptyList();
        }
        ActivityPlanItemDto dto = new ActivityPlanItemDto();
        dto.setPlanCodeList(planCodeList);
        return this.findVoList(dto);
    }

    public List<ActivityPlanItemVo> findVoList(ActivityPlanItemDto planItem) {
        List<ActivityPlanItem> itemList = this.findList(planItem);
        List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityPlanItem.class, ActivityPlanItemVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.fillVoListProperties(voList);
        return voList;
    }

    public List<ActivityPlanItemDto> findDtoListByPlanItemCodeList(List<String> planItemCodeList) {
        if (CollectionUtils.isEmpty(planItemCodeList)) {
            return Lists.newArrayList();
        }
        ActivityPlanItemDto dto = new ActivityPlanItemDto();
        dto.setPlanItemCodeList(planItemCodeList);
        return this.findDtoList(dto);
    }

    public List<ActivityPlanItemDto> findDtoAndAttachListByPlanItemCodeList(List<String> planItemCodeList) {
        List<ActivityPlanItemDto> dtoList = this.findDtoListByPlanItemCodeList(planItemCodeList);
        this.buildDtoAttach(dtoList);
        return dtoList;
    }

    public List<ActivityPlanItemDto> findDtoAndAttachListByPlanCode(String planCode) {
        List<ActivityPlanItemDto> dtoList = this.findDtoListByPlanCode(planCode);
        this.buildDtoAttach(dtoList);
        return dtoList;
    }

    public List<ActivityPlanItemDto> findDtoAndAttachListByPlanCodeList(List<String> planCodeList) {
        List<ActivityPlanItemDto> dtoList = this.findDtoListByPlanCodeList(planCodeList);
        this.buildDtoAttach(dtoList);
        return dtoList;
    }

    private void buildDtoAttach(List<ActivityPlanItemDto> dtoList) {
        List<ActivityPlanItemTerminalDto> list;
        List<ActivityPlanItemExtendField> itemExtendFields;
        List<String> planItemCodeList = dtoList.stream().map(ActivityPlanItemDto::getPlanItemCode).collect(Collectors.toList());
        List<ActivityPlanBudgetDto> budgetList = this.activityPlanBudgetRepository.listDtoByPlanItemCodeList(planItemCodeList);
        if (!CollectionUtils.isEmpty(budgetList)) {
            this.convertMonthBudgetProperty(budgetList);
            for (ActivityPlanBudgetDto activityPlanBudgetDto : budgetList) {
                NumberStringDealUtil.setStringIfNotNull((Object)activityPlanBudgetDto.getUseAmount(), arg_0 -> ((ActivityPlanBudgetDto)activityPlanBudgetDto).setUseAmountStr(arg_0));
            }
            Map<String, List<ActivityPlanBudgetDto>> budgetMap = budgetList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getPlanItemCode())).collect(Collectors.groupingBy(ActivityPlanBudgetDto::getPlanItemCode));
            for (ActivityPlanItemDto itemDto : dtoList) {
                if (!budgetMap.containsKey(itemDto.getPlanItemCode())) continue;
                List<ActivityPlanBudgetDto> budgetShares = budgetMap.get(itemDto.getPlanItemCode());
                BigDecimal usedHeadFeeAmount = BigDecimal.ZERO;
                BigDecimal usedDepartmentFeeAmount = BigDecimal.ZERO;
                BigDecimal usedCustomerFeeAmount = BigDecimal.ZERO;
                for (ActivityPlanBudgetDto budgetShare : budgetShares) {
                    BigDecimal usedAmount = Optional.ofNullable(budgetShare.getUsedAmount()).orElse(BigDecimal.ZERO);
                    if (StringUtils.isNotBlank((CharSequence)budgetShare.getMonthBudgetCode()) && budgetShare.getMonthBudgetCode().equals(itemDto.getHeadMonthBudgetCode())) {
                        usedHeadFeeAmount = usedHeadFeeAmount.add(usedAmount);
                    }
                    if (StringUtils.isNotBlank((CharSequence)budgetShare.getMonthBudgetCode()) && budgetShare.getMonthBudgetCode().equals(itemDto.getMonthBudgetCode())) {
                        usedDepartmentFeeAmount = usedDepartmentFeeAmount.add(usedAmount);
                    }
                    if (!ActivityPlanBudgetOccupyTypeEnum.CUSTOMER.getCode().equals(budgetShare.getOccupyType())) continue;
                    usedCustomerFeeAmount = usedCustomerFeeAmount.add(usedAmount);
                }
                itemDto.setUsedHeadFeeAmount(usedHeadFeeAmount);
                itemDto.setUsedHeadFeeAmountStr(usedHeadFeeAmount.toString());
                itemDto.setUsedDepartmentFeeAmount(usedDepartmentFeeAmount);
                itemDto.setUsedDepartmentFeeAmountStr(usedDepartmentFeeAmount.toString());
                itemDto.setUsedCustomerFeeAmount(usedCustomerFeeAmount);
                itemDto.setUsedCustomerFeeAmountStr(usedCustomerFeeAmount.toString());
                itemDto.setBudgetShares(budgetShares);
            }
        }
        if (!CollectionUtils.isEmpty(itemExtendFields = this.activityPlanItemExtendFieldRepository.listByPlanItemCodeList(planItemCodeList))) {
            Map<String, List<ActivityPlanItemExtendField>> map = itemExtendFields.stream().collect(Collectors.groupingBy(ActivityPlanItemExtendField::getPlanItemCode));
            for (ActivityPlanItemDto itemDto : dtoList) {
                this.extendFieldService.fillExtendField((Object)itemDto, ActivityPlanItemDto.class, map.get(itemDto.getPlanItemCode()));
            }
        }
        if (!CollectionUtils.isEmpty(list = this.activityPlanItemTerminalRepository.listDtoByPlanItemCodeList(planItemCodeList))) {
            Map<String, List<ActivityPlanItemTerminalDto>> terminalMap = list.stream().collect(Collectors.groupingBy(ActivityPlanItemTerminalDto::getPlanItemCode));
            for (ActivityPlanItemDto itemDto : dtoList) {
                if (!terminalMap.containsKey(itemDto.getPlanItemCode())) continue;
                itemDto.setActivityPlanItemTerminalList(terminalMap.get(itemDto.getPlanItemCode()));
            }
        }
    }

    public List<ActivityPlanItemDto> findDtoAndAttachListByPlanItemCode(List<String> planItemCodeList) {
        List<ActivityPlanItemExtendField> itemExtendFields;
        List<ActivityPlanItemDto> dtoList = this.findDtoListByPlanItemCodeList(planItemCodeList);
        List<ActivityPlanBudgetDto> budgetList = this.activityPlanBudgetRepository.listDtoByPlanItemCodeList(planItemCodeList);
        if (!CollectionUtils.isEmpty(budgetList)) {
            this.convertMonthBudgetProperty(budgetList);
            for (ActivityPlanBudgetDto activityPlanBudgetDto : budgetList) {
                NumberStringDealUtil.setStringIfNotNull((Object)activityPlanBudgetDto.getUseAmount(), arg_0 -> ((ActivityPlanBudgetDto)activityPlanBudgetDto).setUseAmountStr(arg_0));
            }
            Map<String, List<ActivityPlanBudgetDto>> budgetMap = budgetList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getPlanItemCode())).collect(Collectors.groupingBy(ActivityPlanBudgetDto::getPlanItemCode));
            for (ActivityPlanItemDto itemDto : dtoList) {
                if (!budgetMap.containsKey(itemDto.getPlanItemCode())) continue;
                List<ActivityPlanBudgetDto> budgetShares = budgetMap.get(itemDto.getPlanItemCode());
                BigDecimal usedHeadFeeAmount = BigDecimal.ZERO;
                BigDecimal usedDepartmentFeeAmount = BigDecimal.ZERO;
                BigDecimal usedCustomerFeeAmount = BigDecimal.ZERO;
                for (ActivityPlanBudgetDto budgetShare : budgetShares) {
                    BigDecimal usedAmount = Optional.ofNullable(budgetShare.getUsedAmount()).orElse(BigDecimal.ZERO);
                    if (StringUtils.isNotBlank((CharSequence)budgetShare.getMonthBudgetCode()) && budgetShare.getMonthBudgetCode().equals(itemDto.getHeadMonthBudgetCode())) {
                        usedHeadFeeAmount = usedHeadFeeAmount.add(usedAmount);
                    }
                    if (StringUtils.isNotBlank((CharSequence)budgetShare.getMonthBudgetCode()) && budgetShare.getMonthBudgetCode().equals(itemDto.getMonthBudgetCode())) {
                        usedDepartmentFeeAmount = usedDepartmentFeeAmount.add(usedAmount);
                    }
                    if (!ActivityPlanBudgetOccupyTypeEnum.CUSTOMER.getCode().equals(budgetShare.getOccupyType())) continue;
                    usedCustomerFeeAmount = usedCustomerFeeAmount.add(usedAmount);
                }
                itemDto.setUsedHeadFeeAmount(usedHeadFeeAmount);
                itemDto.setUsedHeadFeeAmountStr(usedHeadFeeAmount.toString());
                itemDto.setUsedDepartmentFeeAmount(usedDepartmentFeeAmount);
                itemDto.setUsedDepartmentFeeAmountStr(usedDepartmentFeeAmount.toString());
                itemDto.setUsedCustomerFeeAmount(usedCustomerFeeAmount);
                itemDto.setUsedCustomerFeeAmountStr(usedCustomerFeeAmount.toString());
                itemDto.setBudgetShares(budgetShares);
            }
        }
        if (!CollectionUtils.isEmpty(itemExtendFields = this.activityPlanItemExtendFieldRepository.listByPlanItemCodeList(planItemCodeList))) {
            Map<String, List<ActivityPlanItemExtendField>> map = itemExtendFields.stream().collect(Collectors.groupingBy(ActivityPlanItemExtendField::getPlanItemCode));
            for (ActivityPlanItemDto itemDto : dtoList) {
                this.extendFieldService.fillExtendField((Object)itemDto, ActivityPlanItemDto.class, map.get(itemDto.getPlanItemCode()));
            }
        }
        return dtoList;
    }

    public void convertMonthBudgetProperty(List<ActivityPlanBudgetDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<Object, Object> feeSourceMap = Maps.newHashMap();
        if (null != this.dictDataVoService) {
            try {
                List feeSourceList = this.dictDataVoService.findByDictTypeCode("tpm_fee_belong_us");
                if (!CollectionUtils.isEmpty((Collection)feeSourceList)) {
                    feeSourceMap = feeSourceList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> o));
                }
            }
            catch (Exception e) {
                log.error("\u8d39\u7528\u5f52\u53e3\u6570\u636e\u5b57\u5178\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        for (ActivityPlanBudgetDto vo : list) {
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)vo.getFeeBelongCode())) continue;
            vo.setFeeSourceName(feeSourceMap.getOrDefault(vo.getFeeBelongCode(), vo.getFeeBelongCode()));
        }
    }

    public List<ActivityPlanItemDto> findDtoList(ActivityPlanItemDto planItem) {
        List<ActivityPlanItem> itemList = this.findList(planItem);
        List dtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityPlanItem.class, ActivityPlanItemDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.fillDtoListProperties(dtoList);
        return dtoList;
    }

    public List<ActivityPlanItem> findListByPlanCode(String planCode) {
        if (StringUtils.isBlank((CharSequence)planCode)) {
            return null;
        }
        ActivityPlanItemDto activityPlanItem = new ActivityPlanItemDto();
        activityPlanItem.setPlanCode(planCode);
        return this.findList(activityPlanItem);
    }

    public List<ActivityPlanItem> findList(ActivityPlanItemDto planItem) {
        if (StringUtils.isBlank((CharSequence)planItem.getPlanCode()) && CollectionUtil.isEmpty((Collection)planItem.getPlanCodeList()) && CollectionUtil.isEmpty((Collection)planItem.getPlanItemCodeList())) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivityPlanItem.class).eq(StringUtils.isNotBlank((CharSequence)planItem.getPlanCode()), ActivityPlanItem::getPlanCode, (Object)planItem.getPlanCode())).eq(StringUtils.isNotBlank((CharSequence)planItem.getTemplateConfigCode()), ActivityPlanItem::getTemplateConfigCode, (Object)planItem.getTemplateConfigCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        if (CollectionUtil.isNotEmpty((Collection)planItem.getPlanItemCodeList())) {
            wrapper.in(ActivityPlanItem::getPlanItemCode, (Collection)planItem.getPlanItemCodeList());
        }
        if (!CollectionUtils.isEmpty((Collection)planItem.getPlanCodeList())) {
            wrapper.in(ActivityPlanItem::getPlanCode, (Collection)planItem.getPlanCodeList());
        }
        return this.list((Wrapper<ActivityPlanItem>)wrapper);
    }

    public List<ActivityPlanItem> findListByCodeList(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return Lists.newArrayList();
        }
        return this.list((Wrapper<ActivityPlanItem>)((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivityPlanItem.class).in(ActivityPlanItem::getPlanCode, planCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())));
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public void deleteByPlanCodes(List<String> planCodes) {
        if (CollectionUtils.isEmpty(planCodes)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(ActivityPlanItem::getPlanCode, planCodes);
        this.update((Wrapper)updateWrapper);
        LambdaUpdateWrapper updateWrapper2 = new UpdateWrapper().lambda();
        updateWrapper2.in(ActivityPlanItemExtend::getPlanCode, planCodes);
        this.activityPlanItemExtendRepository.remove((Wrapper)updateWrapper2);
    }

    public List<ActivityPlanItem> listByDetailCodeList(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityPlanItem::getPlanItemCode, itemCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public Page<ActivityPlanItemVo> findByConditions(Pageable pageable, ActivityPlanItemDto activityPlanItemDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (pageable.getPageSize() == 999999) {
            page.setSize(-1L);
        }
        Page<ActivityPlanItemVo> pageList = this.activityPlanItemMapper.findByConditions((Page<ActivityPlanItemVo>)page, activityPlanItemDto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }

    public Page<ActivityPlanItemBudgetVo> findItemBudgetByConditions(Pageable pageable, ActivityPlanItemBudgetDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setFilterClose(true);
        Page<ActivityPlanItemBudgetVo> pageList = this.activityPlanItemMapper.findItemBudgetByConditions((Page<ActivityPlanItemBudgetVo>)page, dto);
        if (!CollectionUtils.isEmpty((Collection)pageList.getRecords())) {
            for (ActivityPlanItemBudgetVo itemBudgetVo : pageList.getRecords()) {
                itemBudgetVo.setUsableAmount(Optional.ofNullable(itemBudgetVo.getTotalFeeAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(itemBudgetVo.getUsedAmount()).orElse(BigDecimal.ZERO)));
                itemBudgetVo.setHeadUsableAmount(Optional.ofNullable(itemBudgetVo.getHeadFeeAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(itemBudgetVo.getHeadUsedAmount()).orElse(BigDecimal.ZERO)));
                itemBudgetVo.setDepartmentUsableAmount(Optional.ofNullable(itemBudgetVo.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(itemBudgetVo.getDepartmentUsedAmount()).orElse(BigDecimal.ZERO)));
                itemBudgetVo.setCustomerUsableAmount(Optional.ofNullable(itemBudgetVo.getCustomerFeeAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(itemBudgetVo.getCustomerUsedAmount()).orElse(BigDecimal.ZERO)));
            }
        }
        return pageList;
    }

    public List<ActivityPlanItemBudgetVo> findItemBudgetListByConditions(ActivityPlanItemBudgetDto dto) {
        List<ActivityPlanItemBudgetVo> pageList = this.activityPlanItemMapper.findItemBudgetListByConditions(dto);
        dto.setFilterClose(false);
        if (!CollectionUtils.isEmpty(pageList)) {
            List headPlanItemCodeList = pageList.stream().filter(item -> ActivityPlanTypeEnum.headquarters.getCode().equals(item.getPlanType())).map(ActivityPlanItemBudgetVo::getPlanItemCode).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(headPlanItemCodeList)) {
                List<ActivityPlanItemBudgetVo> headBudgetList = this.activityPlanItemMapper.findItemHeadBudgetListByConditions(dto);
                Map<String, BigDecimal> headDepartmentUsedAmountMap = headBudgetList.stream().filter(item -> null != item.getDepartmentUsedAmount()).collect(Collectors.toMap(ActivityPlanItemBudgetVo::getPlanItemCode, ActivityPlanItemBudgetVo::getDepartmentUsedAmount, (o, n) -> n));
                for (ActivityPlanItemBudgetVo planItemBudgetVo : pageList) {
                    if (!headDepartmentUsedAmountMap.containsKey(planItemBudgetVo.getPlanItemCode())) continue;
                    planItemBudgetVo.setDepartmentUsedAmount(headDepartmentUsedAmountMap.get(planItemBudgetVo.getPlanItemCode()));
                }
            }
            for (ActivityPlanItemBudgetVo itemBudgetVo : pageList) {
                itemBudgetVo.setUsableAmount(Optional.ofNullable(itemBudgetVo.getTotalFeeAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(itemBudgetVo.getUsedAmount()).orElse(BigDecimal.ZERO)));
                itemBudgetVo.setHeadUsableAmount(Optional.ofNullable(itemBudgetVo.getHeadFeeAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(itemBudgetVo.getHeadUsedAmount()).orElse(BigDecimal.ZERO)));
                itemBudgetVo.setDepartmentUsableAmount(Optional.ofNullable(itemBudgetVo.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(itemBudgetVo.getDepartmentUsedAmount()).orElse(BigDecimal.ZERO)));
                itemBudgetVo.setCustomerUsableAmount(Optional.ofNullable(itemBudgetVo.getCustomerFeeAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(itemBudgetVo.getCustomerUsedAmount()).orElse(BigDecimal.ZERO)));
            }
        }
        return pageList;
    }

    public void fillVoListProperties(List<ActivityPlanItemVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        for (ActivityPlanItemVo item : voList) {
            this.fillVoProperties(item);
        }
    }

    public void fillVoProperties(ActivityPlanItemVo item) {
        if (null == item) {
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties((Object)item, ActivityPlanItemVo.class);
        BigDecimal feeAmount = Optional.ofNullable(item.getTotalFeeAmount()).orElse(BigDecimal.ZERO);
        BigDecimal usedAmount = Optional.ofNullable(item.getUsedAmount()).orElse(BigDecimal.ZERO);
        item.setUsedAmount(usedAmount);
        item.setUsableAmount(feeAmount.subtract(usedAmount));
    }

    public void fillDtoListProperties(List<ActivityPlanItemDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        for (ActivityPlanItemDto item : dtoList) {
            this.fillDtoProperties(item);
        }
    }

    public void fillDtoProperties(ActivityPlanItemDto item) {
        if (null == item) {
            return;
        }
        ObjectConvertStringUtil.fillObjectStrProperties((Object)item, ActivityPlanItemDto.class);
        item.setActivityType(item.getActivityTypeCode());
        item.setActivityForm(item.getActivityFormCode());
    }

    public void closeItem(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(ActivityPlanItem.class).set(ActivityPlanItem::getIsClose, (Object)BooleanEnum.TRUE.getCapital())).in(UuidEntity::getId, ids));
    }

    public void closeItemVertical(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(ActivityPlanItem.class).set(ActivityPlanItem::getIsClose, (Object)BooleanEnum.TRUE.getCapital())).set(ActivityPlanItem::getIsRollbackBudget, (Object)BooleanEnum.FALSE.getCapital())).in(UuidEntity::getId, ids));
    }

    public List<RedPacketQueryScheme2Vo> redPacketQueryScheme(RedPacketQueryScheme2Dto dto) {
        List<RedPacketQueryScheme2Vo> redPacketQueryScheme2Vos = this.activityPlanItemMapper.redPacketQueryScheme(dto);
        return redPacketQueryScheme2Vos;
    }

    public Page<ActivityPlanItemVo> findPlanItemNoActivityDetail(Page<ActivityPlanItemVo> page, String beginDate, String endDate, String salesOrgCode, List<String> legalSalesOrgCodeList) {
        return this.activityPlanItemMapper.findPlanItemNoActivityDetail(page, beginDate, endDate, legalSalesOrgCodeList);
    }

    public ActivityPlanItemBase applyAmountFindByItemCode(ActivityPlanItemDto dto) {
        ActivityPlanItem planItem = (ActivityPlanItem)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotBlank((CharSequence)dto.getPlanItemCode()), ActivityPlanItem::getPlanItemCode, (Object)dto.getPlanItemCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
        if (Objects.isNull((Object)planItem)) {
            return new ActivityPlanItemVo();
        }
        ActivityPlanItemBase planItemBase = (ActivityPlanItemBase)this.nebulaToolkitService.copyObjectByWhiteList((Object)planItem, ActivityPlanItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return planItemBase;
    }

    public List<ActivityPlanItem> list(Wrapper<ActivityPlanItem> queryWrapper) {
        List list = super.list(queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List<String> planItemCodeList;
            List<ActivityPlanItemProduct> productList;
            List idList = list.stream().map(UuidEntity::getId).collect(Collectors.toList());
            List extendEntityList = this.activityPlanItemExtendRepository.listByIds(idList);
            if (!CollectionUtils.isEmpty((Collection)extendEntityList)) {
                Map extendMap = extendEntityList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
                String[] ignoreFieldArr = ActivityPlanItemExtendRepository.excludeFieldList.toArray(new String[0]);
                for (ActivityPlanItem activityPlanItem : list) {
                    ActivityPlanItemExtend activityPlanItemExtend = (ActivityPlanItemExtend)((Object)extendMap.get(activityPlanItem.getId()));
                    if (null == activityPlanItemExtend) continue;
                    BeanUtil.copyProperties((Object)((Object)activityPlanItemExtend), (Object)((Object)activityPlanItem), (String[])ignoreFieldArr);
                }
            }
            if (!CollectionUtils.isEmpty(productList = this.activityPlanItemProductRepository.findListByPlanItemCodeList(planItemCodeList = list.stream().map(ActivityPlanItem::getPlanItemCode).collect(Collectors.toList())))) {
                Map<String, List<ActivityPlanItemProduct>> productMap = productList.stream().collect(Collectors.groupingBy(ActivityPlanItemProduct::getPlanItemCode));
                for (ActivityPlanItem activityPlanItem : list) {
                    if (!productMap.containsKey(activityPlanItem.getPlanItemCode())) continue;
                    List<ActivityPlanItemProduct> itemProductList = productMap.get(activityPlanItem.getPlanItemCode());
                    String productCode = itemProductList.stream().map(ActivityPlanItemProduct::getProductCode).collect(Collectors.joining(","));
                    activityPlanItem.setProductCode(productCode);
                    String productName = itemProductList.stream().map(ActivityPlanItemProduct::getProductName).collect(Collectors.joining(","));
                    activityPlanItem.setProductName(productName);
                }
            }
        }
        return list;
    }

    public boolean save(ActivityPlanItem entity) {
        this.saveProduct(entity);
        boolean save = super.save((Object)entity);
        ActivityPlanItemExtend extendEntity = (ActivityPlanItemExtend)((Object)BeanUtil.copyProperties((Object)((Object)entity), ActivityPlanItemExtend.class, (String[])new String[0]));
        this.activityPlanItemExtendRepository.save((Object)extendEntity);
        return save;
    }

    private boolean saveProduct(ActivityPlanItem item) {
        return this.saveProductList(Lists.newArrayList((Object[])new ActivityPlanItem[]{item}));
    }

    private boolean saveProductList(Collection<ActivityPlanItem> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return false;
        }
        List<String> deleteItemCodeList = itemList.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getId())).map(ActivityPlanItem::getPlanItemCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(deleteItemCodeList)) {
            this.activityPlanItemProductRepository.deleteByPlanItemCodeList(deleteItemCodeList);
        }
        ArrayList saveList = Lists.newArrayList();
        for (ActivityPlanItem activityPlanItem : itemList) {
            if (!StringUtil.isNotEmpty((String)activityPlanItem.getProductCode()) || !activityPlanItem.getProductCode().contains(",")) continue;
            String[] productCodeSplit = activityPlanItem.getProductCode().split(",");
            if (StringUtil.isEmpty((String)activityPlanItem.getProductName())) {
                throw new RuntimeException("\u4ea7\u54c1\u540d\u79f0\u6709\u8bef\uff01");
            }
            String[] productNameSplit = activityPlanItem.getProductName().split(",");
            if (productNameSplit.length != productCodeSplit.length) {
                throw new RuntimeException("\u4ea7\u54c1\u540d\u79f0\u4e0e\u7f16\u7801\u6570\u91cf\u4e0d\u5339\u914d\uff01");
            }
            for (int i = 0; i < productCodeSplit.length; ++i) {
                ActivityPlanItemProduct itemProduct = new ActivityPlanItemProduct();
                itemProduct.setPlanCode(activityPlanItem.getPlanCode());
                itemProduct.setPlanItemCode(activityPlanItem.getPlanItemCode());
                itemProduct.setProductCode(productCodeSplit[i]);
                itemProduct.setProductName(productNameSplit[i]);
                saveList.add(itemProduct);
            }
            activityPlanItem.setProductCode(null);
            activityPlanItem.setProductName(null);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.activityPlanItemProductRepository.saveBatch(saveList);
        }
        return true;
    }

    public boolean saveOrUpdate(ActivityPlanItem entity, Wrapper<ActivityPlanItem> updateWrapper) {
        this.saveProduct(entity);
        boolean result = super.saveOrUpdate((Object)entity, updateWrapper);
        ActivityPlanItemExtend extendEntity = (ActivityPlanItemExtend)((Object)BeanUtil.copyProperties((Object)((Object)entity), ActivityPlanItemExtend.class, (String[])new String[0]));
        if (this.activityPlanItemExtendRepository.hasNotEmptyProperty(extendEntity)) {
            this.activityPlanItemExtendRepository.saveOrUpdate((Object)extendEntity);
        }
        return result;
    }

    public boolean saveBatch(Collection<ActivityPlanItem> entityList, int batchSize) {
        this.saveProductList(entityList);
        List partition = Lists.partition((List)Lists.newArrayList(entityList), (int)batchSize);
        for (List listPartition : partition) {
            this.activityPlanItemMapper.insertBatchSomeColumn(listPartition);
        }
        this.updateExtendBatchById(entityList, batchSize);
        return true;
    }

    public boolean saveOrUpdateBatch(Collection<ActivityPlanItem> entityList, int batchSize) {
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (ActivityPlanItem activityPlanItem : entityList) {
            if (StringUtils.isBlank((CharSequence)activityPlanItem.getId())) {
                saveList.add(activityPlanItem);
                continue;
            }
            updateList.add(activityPlanItem);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.saveBatch(entityList, batchSize);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.updateBatchById(entityList, batchSize);
        }
        return true;
    }

    public boolean updateBatchById(Collection<ActivityPlanItem> entityList, int batchSize) {
        this.saveProductList(entityList);
        boolean result = super.updateBatchById(entityList, batchSize);
        this.updateExtendBatchById(entityList, batchSize);
        return result;
    }

    protected void updateExtendBatchById(Collection<ActivityPlanItem> entityList, int batchSize) {
        ArrayList extendEntityList = Lists.newArrayList();
        for (ActivityPlanItem entity : entityList) {
            ActivityPlanItemExtend extendEntity = (ActivityPlanItemExtend)((Object)BeanUtil.copyProperties((Object)((Object)entity), ActivityPlanItemExtend.class, (String[])new String[0]));
            if (!this.activityPlanItemExtendRepository.hasNotEmptyProperty(extendEntity)) continue;
            extendEntityList.add(extendEntity);
        }
        if (!CollectionUtils.isEmpty((Collection)extendEntityList)) {
            this.activityPlanItemExtendRepository.saveOrUpdateBatch(extendEntityList, batchSize);
        }
    }

    public Integer findTotalByConditions(ActivityPlanItemDto activityPlanItemDto) {
        return this.activityPlanItemMapper.findTotalByConditions(activityPlanItemDto);
    }

    public void updateHeadStatus(List<String> itemCodeList) {
        this.activityPlanItemMapper.updateHeadStatus(itemCodeList);
    }

    public List<ActivityPlanItemVo> findRelatedPlanItemByCodes(List<String> relatePlanItemCodes) {
        if (CollectionUtils.isEmpty(relatePlanItemCodes)) {
            return Lists.newArrayList();
        }
        List<ActivityPlanItemVo> list = ((ActivityPlanItemMapper)this.baseMapper).findRelatedPlanItemByCodes(relatePlanItemCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    public List<String> findApprovedItemCodeListByRelatePlanItemCodeList(List<String> relatePlanItemCodeList) {
        return this.activityPlanItemMapper.findApprovedItemCodeListByRelatePlanItemCodeList(relatePlanItemCodeList);
    }

    public List<ActivityPlanItem> findByIdList(List<String> ids) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(UuidEntity::getId, ids)).list();
    }

    public List<ActivityPlanItem> findByHeadquartersPlanItemCode(String planItemCode) {
        if (StringUtils.isBlank((CharSequence)planItemCode)) {
            return Lists.newArrayList();
        }
        return ((ActivityPlanItemMapper)this.getBaseMapper()).findByHeadquartersPlanItemCode(planItemCode);
    }

    public List<ActivityPlanSubmitReportSubVo> submitPageReportDimension1(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return Collections.emptyList();
        }
        return this.activityPlanItemMapper.submitPageReportDimension1(planCodeList, DATE_FORMAT_STR);
    }

    public List<ActivityPlanSubmitReportSubVo> submitPageReportDimension2(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return Collections.emptyList();
        }
        return this.activityPlanItemMapper.submitPageReportDimension2(planCodeList, DATE_FORMAT_STR);
    }

    public List<ActivityPlanSubmitReportSubVo> submitPageReportDimension3(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return Collections.emptyList();
        }
        return this.activityPlanItemMapper.submitPageReportDimension3(planCodeList, DATE_FORMAT_STR);
    }

    public void updateAuditStatusByCodes(List<String> auditPlanItemCodes) {
        if (!CollectionUtils.isEmpty(auditPlanItemCodes)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(ActivityPlanItem::getPlanItemCode, auditPlanItemCodes)).set(ActivityPlanItem::getWholeAudit, (Object)YesOrNoEnum.YES.getCode())).update();
            log.info("\u6d3b\u52a8\u65b9\u6848\u9884\u7b97\u8ddf\u8e2a\u8868\u9000\u9884\u7b97\u66f4\u6539\u65b9\u6848\u660e\u7ec6\u72b6\u6001");
        }
    }

    public ActivityPlanItem findListByPlanItemCode(String planItemCode) {
        if (StringUtils.isBlank((CharSequence)planItemCode)) {
            return null;
        }
        return (ActivityPlanItem)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivityPlanItem::getPlanItemCode, (Object)planItemCode)).one());
    }

    public List<String> findItemCodeListByRelatePlanItemCodeList(List<String> planItemCodeList) {
        if (CollectionUtils.isEmpty(planItemCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivityPlanItem::getRelatePlanItemCode, planItemCodeList)).select(new SFunction[]{ActivityPlanItem::getPlanItemCode}).list().stream().map(ActivityPlanItem::getPlanItemCode).collect(Collectors.toList());
    }

    public void updateWholeAuditByPlanItemCode(String businessCode) {
        if (StringUtils.isBlank((CharSequence)businessCode)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ActivityPlanItem::getPlanItemCode, (Object)businessCode)).set(ActivityPlanItem::getWholeAudit, (Object)YesOrNoEnum.NO.getCode())).update();
    }

    public List<String> findActivityPlanItemCodeByActivityNumber(List<String> activityNumberList, String planCode) {
        return this.activityPlanItemMapper.findActivityPlanItemCodeByActivityNumber(activityNumberList, planCode);
    }

    public Collection<String> findPlanCodeListByItemCodeList(List<String> planItemCodeList) {
        if (CollectionUtils.isEmpty(planItemCodeList)) {
            return Lists.newArrayList();
        }
        return this.list((Wrapper<ActivityPlanItem>)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivityPlanItem.class).in(ActivityPlanItem::getPlanItemCode, planItemCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).select(new SFunction[]{ActivityPlanItem::getPlanCode})).stream().map(ActivityPlanItem::getPlanCode).distinct().collect(Collectors.toList());
    }

    public List<ActivityPlanItemVo> findCountForCarGift(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return Lists.newArrayList();
        }
        return ((ActivityPlanItemMapper)this.getBaseMapper()).findCountForCarGift(planCodeList);
    }

    public void updatePlanItemRollbackBudget(List<String> planItemCodeList) {
        if (CollectionUtils.isEmpty(planItemCodeList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(ActivityPlanItem::getPlanItemCode, planItemCodeList)).set(ActivityPlanItem::getIsRollbackBudget, (Object)BooleanEnum.TRUE.getCapital())).update();
    }

    public List<ActivityPlanItem> findListByPlanCodes(List<String> planCodes) {
        if (CollectionUtils.isEmpty(planCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(ActivityPlanItem::getPlanCode, planCodes)).list();
    }

    public void updatePlanItemSapState(String planItemCode, boolean success) {
        if (StringUtils.isBlank((CharSequence)planItemCode)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(ActivityPlanItemExtend::getSapInterfaceState, (Object)(success ? InterfacePushStateEnum.SUCCESS.getCode() : InterfacePushStateEnum.FAIL.getCode()));
        updateWrapper.eq(TenantEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        updateWrapper.eq(ActivityPlanItemExtend::getPlanItemCode, (Object)planItemCode);
        this.activityPlanItemExtendRepository.update((Wrapper)updateWrapper);
    }

    public List<String> listIdByPlanCodes(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return Lists.newArrayList();
        }
        return this.list((Wrapper<ActivityPlanItem>)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivityPlanItem.class).in(ActivityPlanItem::getPlanCode, planCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).select(new SFunction[]{UuidEntity::getId})).stream().map(UuidEntity::getId).collect(Collectors.toList());
    }

    public List<ActivityPlanItemVo> findListForFR(List<ActivityPlanItemDto> activityPlanItemDtos) {
        return this.activityPlanItemMapper.findListForFR(activityPlanItemDtos, TenantUtils.getTenantCode());
    }

    public List<ActivityPlanItemVo> findCostListForFR(List<ActivityPlanItemDto> itemDtos, String code) {
        return this.activityPlanItemMapper.findCostListForFR(itemDtos, code, TenantUtils.getTenantCode());
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean alwaysUpdateSomeColumnBatchById(Collection<ActivityPlanItem> entityList, int batchSize) {
        this.saveProductList(entityList);
        String sqlStatement = ActivityPlanItemMapper.class.getName() + ".alwaysUpdateSomeColumnById";
        boolean result = this.executeBatch(entityList, batchSize, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", (Object)entity);
            sqlSession.update(sqlStatement, (Object)param);
        });
        if (!result) {
            return result;
        }
        this.updateExtendBatchById(entityList, batchSize);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public int alwaysUpdateSomeColumnById(ActivityPlanItem entity) {
        this.saveProduct(entity);
        int i = this.activityPlanItemMapper.alwaysUpdateSomeColumnById((Object)entity);
        this.updateExtendBatchById(Lists.newArrayList((Object[])new ActivityPlanItem[]{entity}), 1000);
        return i;
    }
}

