/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanRelatePlan;
import com.biz.crm.tpm.business.activity.plan.local.mapper.ActivityPlanRelatePlanMapper;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanRelatePlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jodd.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityPlanRelatePlanRepository
extends ServiceImpl<ActivityPlanRelatePlanMapper, ActivityPlanRelatePlan> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<ActivityPlanRelatePlanVo> findListVoByPlanCode(String planCode) {
        if (StringUtils.isBlank((CharSequence)planCode)) {
            return null;
        }
        List<ActivityPlanRelatePlan> itemList = this.findListByPlanCode(planCode);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(itemList, ActivityPlanRelatePlan.class, ActivityPlanRelatePlanVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<ActivityPlanRelatePlan> findListByPlanCode(String planCode) {
        if (StringUtils.isBlank((CharSequence)planCode)) {
            return null;
        }
        return this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivityPlanRelatePlan.class).eq(ActivityPlanRelatePlan::getPlanCode, (Object)planCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode()));
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public void deleteByPlanCode(String planCode) {
        if (StringUtil.isEmpty((CharSequence)planCode)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.eq(ActivityPlanRelatePlan::getPlanCode, (Object)planCode);
        this.update((Wrapper)updateWrapper);
    }
}

