/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanOrg;
import com.biz.crm.tpm.business.activity.plan.local.mapper.ActivityPlanMapper;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanOrgRepository;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanProcessBusinessForm;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.ActivityPlanItemPushSfaDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.display.ActivityPlanItemPushSfaDisplayDto;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanBase;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanAuditVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanRedLineVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVerticalSchemeForecastVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityPlanRepository
extends ServiceImpl<ActivityPlanMapper, ActivityPlan> {
    @Autowired(required=false)
    private ActivityPlanMapper activityPlanMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityPlanOrgRepository activityPlanOrgRepository;

    public Page<ActivityPlanVo> findByConditions(Pageable pageable, ActivityPlanDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ActivityPlanVo> pageList = this.activityPlanMapper.findByConditions((Page<ActivityPlanVo>)page, dto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }

    private void setActivityUsableBudget(List<ActivityPlanVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<String> planCodeList = list.stream().map(ActivityPlanBase::getPlanCode).distinct().collect(Collectors.toList());
        List<ActivityPlanVo> budgetList = this.activityPlanMapper.findActivityPlanUsableBudgetList(planCodeList);
        if (CollectionUtils.isEmpty(budgetList)) {
            return;
        }
        Map budgetMap = budgetList.stream().collect(Collectors.toMap(ActivityPlanBase::getPlanCode, Function.identity(), (o, n) -> n));
        for (ActivityPlanVo planVo : list) {
            ActivityPlanVo budget = (ActivityPlanVo)budgetMap.get(planVo.getPlanCode());
            if (null == budget) continue;
            planVo.setUsableAmount(budget.getUsableAmount());
            planVo.setUsedAmount(budget.getUsedAmount());
        }
    }

    public boolean save(ActivityPlan entity) {
        boolean save = super.save((Object)entity);
        this.saveActivityPlanOrg(entity);
        return save;
    }

    public boolean updateById(ActivityPlan entity) {
        boolean b = super.updateById((Object)entity);
        this.activityPlanOrgRepository.deleteByPlanId(entity.getId());
        this.saveActivityPlanOrg(entity);
        return b;
    }

    private void saveActivityPlanOrg(ActivityPlan entity) {
        if (StringUtils.isBlank((CharSequence)entity.getDepartmentCode())) {
            return;
        }
        String[] departmentCodeArr = entity.getDepartmentCode().split(",");
        int length = departmentCodeArr.length;
        String[] departmentNameArr = entity.getDepartmentName().split(",");
        ArrayList activityPlanOrgList = Lists.newArrayList();
        for (int i = 0; i < length; ++i) {
            ActivityPlanOrg activityPlanOrg = new ActivityPlanOrg();
            activityPlanOrg.setPlanCode(entity.getPlanCode());
            activityPlanOrg.setPlanId(entity.getId());
            activityPlanOrg.setOrgCode(departmentCodeArr[i]);
            activityPlanOrg.setOrgName(departmentNameArr[i]);
            activityPlanOrg.setTenantCode(entity.getTenantCode());
            activityPlanOrgList.add(activityPlanOrg);
        }
        this.activityPlanOrgRepository.saveBatch(activityPlanOrgList);
    }

    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        this.update((Wrapper)updateWrapper);
    }

    public void updateProcessStatus(List<String> codeList, String processStatus) {
        if (CollectionUtils.isEmpty(codeList)) {
            return;
        }
        this.activityPlanMapper.updateProcessStatus(codeList, processStatus, TenantUtils.getTenantCode());
    }

    public void updateProcessStatusAndProcessNo(List<String> codeList, String processStatus, String processNo) {
        if (CollectionUtils.isEmpty(codeList)) {
            return;
        }
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(ActivityPlan.class).set(ActivityPlan::getProcessStatus, (Object)processStatus)).set(ActivityPlan::getProcessNo, (Object)processNo)).in(ActivityPlan::getPlanCode, codeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode()));
    }

    public ActivityPlanVo getVoById(Serializable id) {
        ActivityPlan entity = (ActivityPlan)((Object)this.getById(id));
        if (null == entity || !StringUtils.equals((CharSequence)TenantUtils.getTenantCode(), (CharSequence)entity.getTenantCode())) {
            return null;
        }
        ActivityPlanVo vo = (ActivityPlanVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ActivityPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.fillVoProperties(vo);
        return vo;
    }

    public ActivityPlanVo getVoByPlanCode(String planCode) {
        ActivityPlan entity = this.getByPlanCode(planCode);
        if (null == entity) {
            return null;
        }
        ActivityPlanVo vo = (ActivityPlanVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ActivityPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.fillVoProperties(vo);
        return vo;
    }

    public ActivityPlan getByPlanCode(String planCode) {
        if (StringUtils.isBlank((CharSequence)planCode)) {
            return null;
        }
        return (ActivityPlan)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ActivityPlan.class).eq(ActivityPlan::getPlanCode, (Object)planCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())));
    }

    public void fillVoListProperties(List<ActivityPlanVo> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        this.setActivityUsableBudget(voList);
        SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (ActivityPlanVo item : voList) {
            this.fillVoProperties(item, dayFormat);
        }
    }

    public void fillVoProperties(ActivityPlanVo item) {
        this.fillVoProperties(item, null);
    }

    public void fillVoProperties(ActivityPlanVo item, SimpleDateFormat dayFormat) {
        if (null == item) {
            return;
        }
        if (null == dayFormat) {
            dayFormat = new SimpleDateFormat("yyyy-MM-dd");
        }
        if (null != item.getBeginDate()) {
            item.setBeginDateStr(dayFormat.format(item.getBeginDate()));
        }
        if (null != item.getEndDate()) {
            item.setEndDateStr(dayFormat.format(item.getEndDate()));
        }
    }

    public List<ActivityPlanItemPushSfaDto> findSfaDataByPlanCodes(List<String> planCodes) {
        return this.activityPlanMapper.findSfaDataByPlanCodes(planCodes);
    }

    public List<ActivityPlanItemPushSfaDisplayDto> findSfaDisplayDataByPlanCodes(List<String> planCodes) {
        return this.activityPlanMapper.findSfaDisplayDataByPlanCodes(planCodes);
    }

    public List<ActivityPlanVo> findPlanActivityEndTime(Set<String> activityDetailCodes) {
        return this.activityPlanMapper.findPlanActivityEndTime(activityDetailCodes);
    }

    public ActivityPlanProcessBusinessForm getActivityPlanProcessBusinessForm(List<String> planCodeList) {
        return this.activityPlanMapper.getActivityPlanProcessBusinessForm(planCodeList);
    }

    public List<ActivityPlanDto> findDtoListByPlanCodeList(List<String> planCodeList) {
        List<ActivityPlan> byPlanCodeList = this.findByPlanCodeList(planCodeList);
        if (CollectionUtils.isEmpty(byPlanCodeList)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(byPlanCodeList, ActivityPlan.class, ActivityPlanDto.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<ActivityPlan> findByPlanCodeList(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return Collections.emptyList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(ActivityPlan::getPlanCode, planCodeList)).list();
        List<ActivityPlanOrg> orgList = this.activityPlanOrgRepository.findByPlanCodeList(planCodeList);
        Map<String, List<ActivityPlanOrg>> planOrgMap = orgList.stream().collect(Collectors.groupingBy(ActivityPlanOrg::getPlanCode));
        for (ActivityPlan plan : list) {
            List<ActivityPlanOrg> activityPlanOrgList = planOrgMap.get(plan.getPlanCode());
            if (CollectionUtils.isEmpty(activityPlanOrgList)) continue;
            String orgCode = activityPlanOrgList.stream().map(ActivityPlanOrg::getOrgCode).collect(Collectors.joining(","));
            String orgName = activityPlanOrgList.stream().map(ActivityPlanOrg::getOrgName).collect(Collectors.joining(","));
            plan.setDepartmentCode(orgCode);
            plan.setDepartmentName(orgName);
        }
        return list;
    }

    public List<ActivityPlan> findByProcessNoList(List<String> processNoList) {
        if (CollectionUtils.isEmpty(processNoList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().select(new SFunction[]{ActivityPlan::getPlanCode, ActivityPlan::getBusinessUnitCode}).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(ActivityPlan::getProcessNo, processNoList)).list();
    }

    public List<ActivityPlanVo> findByCodes(Set<String> planCodes) {
        List<ActivityPlanVo> byCodes = this.activityPlanMapper.findByCodes(planCodes);
        this.setActivityUsableBudget(byCodes);
        return byCodes;
    }

    public List<ActivityPlanRedLineVo> getActivityPlanBreakPrice(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return Lists.newArrayList();
        }
        return this.activityPlanMapper.getActivityPlanBreakPrice(planCodeList);
    }

    public Page<ActivityPlanVo> findRelateActivityPlanListByConditions(Pageable pageable, ActivityPlanDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ActivityPlanVo> pageList = this.activityPlanMapper.findRelateActivityPlanListByConditions((Page<ActivityPlanVo>)page, dto);
        this.fillVoListProperties(pageList.getRecords());
        return pageList;
    }

    public ActivityPlan findByPlanItemCode(String planItemCode) {
        if (StringUtils.isBlank((CharSequence)planItemCode)) {
            return null;
        }
        return ((ActivityPlanMapper)this.getBaseMapper()).findByPlanItemCode(planItemCode);
    }

    public List<ActivityPlanVo> findByPlanItemCodes(List<String> planItemCodes) {
        if (CollectionUtil.isEmpty(planItemCodes)) {
            return Collections.emptyList();
        }
        return ((ActivityPlanMapper)this.getBaseMapper()).findByPlanItemCodes(planItemCodes);
    }

    public List<ActivityPlanBudgetVo> findHeadquartersByRegionPlanCodes(Set<String> planCodes) {
        if (CollectionUtils.isEmpty(planCodes)) {
            return Lists.newArrayList();
        }
        return ((ActivityPlanMapper)this.getBaseMapper()).findHeadquartersByRegionPlanCodes(planCodes);
    }

    public List<ActivityPlanItemVo> findActivityPlanByRelatePlanCodes(List<String> relatePlanCodes) {
        if (CollectionUtils.isEmpty(relatePlanCodes)) {
            return Lists.newArrayList();
        }
        return this.activityPlanMapper.findActivityPlanByRelatePlanCodes(TenantUtils.getTenantCode(), relatePlanCodes);
    }

    public List<ActivityPlanVo> findActivityPlanByRelatePlanItemCodes(List<String> relatePlanItemCodes) {
        if (CollectionUtils.isEmpty(relatePlanItemCodes)) {
            return Lists.newArrayList();
        }
        return this.activityPlanMapper.findActivityPlanByRelatePlanItemCodes(TenantUtils.getTenantCode(), relatePlanItemCodes);
    }

    public List<ActivityPlanVo> findActivityUsableBudget(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return Lists.newArrayList();
        }
        return this.activityPlanMapper.findActivityPlanUsableBudgetList(planCodeList);
    }

    public List<ActivityPlanVo> findOrgCodeByPlanCode(List<String> planCodes) {
        return ((ActivityPlanMapper)this.baseMapper).findOrgCodeByPlanCode(planCodes, TenantUtils.getTenantCode());
    }

    public List<ActivityPlanVerticalSchemeForecastVo> findVerticalSchemeForecastByPlanItemCodes(List<String> planItemCodeList) {
        if (CollectionUtils.isEmpty(planItemCodeList)) {
            return Lists.newArrayList();
        }
        return ((ActivityPlanMapper)this.baseMapper).findVerticalSchemeForecastByPlanItemCodes(planItemCodeList, TenantUtils.getTenantCode());
    }

    public List<ActivityPlanAuditVo> findAuditInfoByPlanItemCodes(List<String> planItemCodeList) {
        if (CollectionUtils.isEmpty(planItemCodeList)) {
            return Lists.newArrayList();
        }
        return ((ActivityPlanMapper)this.baseMapper).findAuditInfoByPlanItemCodes(planItemCodeList, TenantUtils.getTenantCode());
    }
}

