/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItem;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanAsyncService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanLockService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanService;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanItemPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityPlanAsyncServiceImpl
implements ActivityPlanAsyncService {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanAsyncServiceImpl.class);
    @Autowired(required=false)
    private ActivityPlanItemPageCacheHelper activityPlanItemPageCacheHelper;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private ActivityPlanService activityPlanService;
    @Autowired(required=false)
    private ActivityPlanLockService activityPlanLockService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Async
    public void saveActivityPlanAsync(ActivityPlanDto dto, String cacheKey, UserIdentity loginUser) {
        this.loginUserService.refreshAuthentication((Object)loginUser);
        try {
            this.activityPlanItemPageCacheHelper.sendMsg("\u5f00\u59cb\u6267\u884c...\uff01");
            this.activityPlanService.saveActivityPlan(dto, cacheKey);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.activityPlanItemPageCacheHelper.sendMsg("\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage(), ExecStatusEnum.RUNNING.getKey());
            throw e;
        }
    }

    @Override
    @Async
    public void closeItemListAsync(List<ActivityPlanItem> itemList, UserIdentity userIdentity) {
        if (CollectionUtil.isEmpty(itemList)) {
            return;
        }
        this.loginUserService.refreshAuthentication((Object)userIdentity);
        this.activityPlanLockService.closeItemList(itemList);
    }

    @Override
    @Async
    public void closeItemByPlanIdsAsync(List<String> ids, UserIdentity userIdentity) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        this.loginUserService.refreshAuthentication((Object)userIdentity);
        this.activityPlanLockService.closeItemByPlanIds(ids);
    }
}

