/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanBudget;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanBudgetService;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanItemPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.OperateActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanBudgetOccupyTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.OperateMarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyBudgetSdkService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyBudgetVo;
import com.biz.crm.tpm.business.month.budget.sdk.dto.MonthBudgetDetailDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmVerticalSchemeForecastBudgetCashOperateDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmVerticalSchemeCashOperateTypeEnum;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.TpmVerticalSchemeForecastService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityPlanBudgetServiceImpl
implements ActivityPlanBudgetService {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityPlanBudgetRepository activityPlanBudgetRepository;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private MarketingStrategyBudgetSdkService marketingStrategyBudgetSdkService;
    @Autowired(required=false)
    private ActivityPlanBudgetServiceImpl activityPlanBudgetService;
    @Autowired(required=false)
    private TpmVerticalSchemeForecastService verticalSchemeForecastService;
    @Autowired(required=false)
    private ActivityPlanItemPageCacheHelper activityPlanItemPageCacheHelper;
    @Autowired(required=false)
    private MonthBudgetLockService monthBudgetLockService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @Override
    public Page<ActivityPlanBudgetVo> findByConditions(Pageable pageable, ActivityPlanBudgetDto dto) {
        return this.activityPlanBudgetRepository.findByConditions(pageable, dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveActivityPlanBudgetList(ActivityPlan entity, boolean update, List<ActivityPlanItemDto> itemDtoList) {
        HashMap oldMap = Maps.newHashMap();
        if (update) {
            this.activityPlanBudgetRepository.deletePhysicalByPlanCode(entity.getPlanCode());
        }
        for (ActivityPlanItemDto itemDto : itemDtoList) {
            if (CollectionUtils.isEmpty((Collection)itemDto.getBudgetShares())) continue;
            itemDto.getBudgetShares().forEach(item -> {
                item.setPlanItemCode(itemDto.getPlanItemCode());
                item.setPlanCode(itemDto.getPlanCode());
            });
        }
        List budgetDtoList = itemDtoList.stream().map(ActivityPlanItemDto::getBudgetShares).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(budgetDtoList, ActivityPlanBudgetDto.class, ActivityPlanBudget.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (ActivityPlanBudget item2 : list) {
            item2.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item2.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item2.setTenantCode(entity.getTenantCode());
            item2.setId(null);
            saveList.add(item2);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            int i = 0;
            int size = saveList.size();
            for (List activityPlanBudgets : Lists.partition((List)saveList, (int)1000)) {
                this.activityPlanItemPageCacheHelper.sendMsg("\u6b63\u5728\u4fdd\u5b58\u7b2c[" + 1000 * i++ + "/" + size + "]\u6761\u65b9\u6848\u9884\u7b97\u6269\u5c55\u4fe1\u606f...");
                this.activityPlanBudgetRepository.saveBatch(activityPlanBudgets);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            int i = 0;
            int size = updateList.size();
            for (List activityPlanBudgets : Lists.partition((List)updateList, (int)1000)) {
                this.activityPlanItemPageCacheHelper.sendMsg("\u6b63\u5728\u66f4\u65b0\u7b2c[" + 1000 * i++ + "/" + size + "]\u6761\u65b9\u6848\u9884\u7b97\u6269\u5c55\u4fe1\u606f...");
                this.activityPlanBudgetRepository.updateBatchById(activityPlanBudgets);
            }
        }
    }

    @Override
    public void deleteByPlanCodes(List<String> planCodes) {
        this.activityPlanBudgetRepository.deleteByPlanCodes(planCodes);
    }

    @Override
    @Transactional
    public List<ActivityPlanBudgetDto> useMonthBudgetByPlanCodeList(List<String> planCodeList) {
        List<ActivityPlanBudget> activityPlanBudgets = this.activityPlanBudgetRepository.listByPlanCodeList(planCodeList);
        if (CollectionUtils.isEmpty(activityPlanBudgets)) {
            return Lists.newArrayList();
        }
        List activityPlanBudgetDtos = (List)this.nebulaToolkitService.copyCollectionByBlankList(activityPlanBudgets, ActivityPlanBudget.class, ActivityPlanBudgetDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.useMonthBudget(activityPlanBudgetDtos, true);
        return activityPlanBudgetDtos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useMonthBudget(List<ActivityPlanBudgetDto> budgetList, boolean doSave) {
        List verticalSchemeForecastBudgetCashOperateList;
        List headUnfreezeBudgetOperateList;
        List<OperateActivityPlanBudgetDto> planBudgetOperateList;
        List freezeBudgetOperateList;
        List budgetOperateList;
        List strategyOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 && ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(item.getOccupyType()) && StringUtils.isNotEmpty((CharSequence)item.getRelateStrategyItemCode())).map(item -> new OperateMarketingStrategyBudgetDto((ActivityPlanBudgetDto)item, doSave){
            final /* synthetic */ ActivityPlanBudgetDto val$item;
            final /* synthetic */ boolean val$doSave;
            {
                this.val$item = activityPlanBudgetDto;
                this.val$doSave = bl;
                this.setBusinessCode(this.val$item.getPlanItemCode());
                this.setStrategyCode(this.val$item.getRelateStrategyCode());
                this.setStrategyItemCode(this.val$item.getRelateStrategyItemCode());
                this.setMonthBudgetCode(this.val$item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                this.setOperationAmount(this.val$item.getUseAmount());
                this.setDoSave(this.val$doSave);
            }
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(strategyOperateList)) {
            this.marketingStrategyBudgetSdkService.operateAmount(strategyOperateList);
        }
        if (!CollectionUtils.isEmpty(budgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 && ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(item.getOccupyType())).map(item -> new OperateMonthBudgetDto((ActivityPlanBudgetDto)item, doSave){
            final /* synthetic */ ActivityPlanBudgetDto val$item;
            final /* synthetic */ boolean val$doSave;
            {
                this.val$item = activityPlanBudgetDto;
                this.val$doSave = bl;
                this.setBusinessCode(this.val$item.getPlanItemCode());
                this.setIndexNo(this.val$item.getIndexNo());
                this.setMonthBudgetCode(this.val$item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                this.setOperationAmount(this.val$item.getUseAmount());
                this.setDoSave(this.val$doSave);
            }
        }).collect(Collectors.toList()))) {
            this.monthBudgetService.operateBudget(budgetOperateList);
        }
        if (!CollectionUtils.isEmpty(freezeBudgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 && ActivityPlanBudgetOccupyTypeEnum.FREEZE.getCode().equals(item.getOccupyType())).map(item -> new OperateMonthBudgetDto((ActivityPlanBudgetDto)item, doSave){
            final /* synthetic */ ActivityPlanBudgetDto val$item;
            final /* synthetic */ boolean val$doSave;
            {
                this.val$item = activityPlanBudgetDto;
                this.val$doSave = bl;
                this.setBusinessCode(this.val$item.getPlanItemCode());
                this.setIndexNo(this.val$item.getIndexNo());
                this.setMonthBudgetCode(this.val$item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.FREEZE.getCode());
                this.setOperationAmount(this.val$item.getUseAmount());
                this.setDoSave(this.val$doSave);
            }
        }).collect(Collectors.toList()))) {
            this.monthBudgetService.operateBudget(freezeBudgetOperateList);
        }
        if (!CollectionUtils.isEmpty(planBudgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 && ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(item.getOccupyType()) && StringUtils.isNotEmpty((CharSequence)item.getRelatePlanItemCode())).map(item -> new OperateActivityPlanBudgetDto((ActivityPlanBudgetDto)item, doSave){
            final /* synthetic */ ActivityPlanBudgetDto val$item;
            final /* synthetic */ boolean val$doSave;
            {
                this.val$item = activityPlanBudgetDto;
                this.val$doSave = bl;
                this.setBusinessCode(this.val$item.getPlanItemCode());
                this.setIndexNo(this.val$item.getIndexNo());
                this.setPlanCode(this.val$item.getRelatePlanCode());
                this.setPlanItemCode(this.val$item.getRelatePlanItemCode());
                this.setMonthBudgetCode(this.val$item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.USE.getCode());
                this.setOperationAmount(this.val$item.getUseAmount());
                this.setDoSave(this.val$doSave);
            }
        }).collect(Collectors.toList()))) {
            this.activityPlanBudgetService.operateBudget(planBudgetOperateList);
        }
        if (!CollectionUtils.isEmpty(headUnfreezeBudgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 && ActivityPlanBudgetOccupyTypeEnum.USE_FREEZE.getCode().equals(item.getOccupyType())).map(item -> new OperateMonthBudgetDto((ActivityPlanBudgetDto)item, doSave){
            final /* synthetic */ ActivityPlanBudgetDto val$item;
            final /* synthetic */ boolean val$doSave;
            {
                this.val$item = activityPlanBudgetDto;
                this.val$doSave = bl;
                this.setBusinessCode(this.val$item.getPlanItemCode());
                this.setIndexNo(this.val$item.getIndexNo());
                this.setMonthBudgetCode(this.val$item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.UNFREEZE.getCode());
                this.setOperationAmount(this.val$item.getUseAmount());
                this.setDoSave(this.val$doSave);
            }
        }).collect(Collectors.toList()))) {
            this.monthBudgetService.operateBudget(headUnfreezeBudgetOperateList);
            List headUseBudgetOperateList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(headUnfreezeBudgetOperateList, OperateMonthBudgetDto.class, OperateMonthBudgetDto.class, HashSet.class, ArrayList.class, new String[0]);
            headUseBudgetOperateList.forEach(operate -> operate.setOperationType(BudgetOperationTypeEnum.USE.getCode()));
            this.monthBudgetService.operateBudget(headUseBudgetOperateList);
        }
        if (!CollectionUtils.isEmpty(verticalSchemeForecastBudgetCashOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 && ActivityPlanBudgetOccupyTypeEnum.USE_FREEZE.getCode().equals(item.getOccupyType())).map(item -> new TpmVerticalSchemeForecastBudgetCashOperateDto((ActivityPlanBudgetDto)item){
            final /* synthetic */ ActivityPlanBudgetDto val$item;
            {
                this.val$item = activityPlanBudgetDto;
                this.setDetailCode(this.val$item.getSchemeForecastDetailCode());
                this.setOperateType(TpmVerticalSchemeCashOperateTypeEnum.use.getCode());
                this.setOperateAmount(this.val$item.getUseAmount());
            }
        }).collect(Collectors.toList()))) {
            List keys = verticalSchemeForecastBudgetCashOperateList.stream().map(TpmVerticalSchemeForecastBudgetCashOperateDto::getDetailCode).distinct().collect(Collectors.toList());
            List lockedKeys = this.verticalSchemeForecastService.lock(keys, TimeUnit.SECONDS, 60, 5);
            try {
                this.verticalSchemeForecastService.operate(verticalSchemeForecastBudgetCashOperateList, doSave);
            }
            finally {
                if (!CollectionUtils.isEmpty((Collection)lockedKeys)) {
                    this.verticalSchemeForecastService.unLock(lockedKeys);
                }
            }
        }
    }

    @Override
    @Transactional
    public void returnMonthBudgetByPlanItemCodeList(List<String> planItemCodeList) {
        if (CollectionUtils.isEmpty(planItemCodeList)) {
            return;
        }
        List<ActivityPlanBudget> planBudgetList = this.activityPlanBudgetRepository.listByPlanItemCodeList(planItemCodeList);
        if (CollectionUtils.isEmpty(planBudgetList)) {
            return;
        }
        this.returnMonthBudget(planBudgetList);
    }

    @Override
    @Transactional
    public void returnCarGiftMonthBudgetByPlanItemCodeList(List<String> planItemCodeList) {
        if (CollectionUtils.isEmpty(planItemCodeList)) {
            return;
        }
        List<ActivityPlanBudget> planBudgetList = this.activityPlanBudgetRepository.findCarGiftCloseReturnBudgetList(planItemCodeList);
        if (CollectionUtils.isEmpty(planBudgetList)) {
            return;
        }
        this.returnMonthBudget(planBudgetList);
    }

    @Override
    @Transactional
    public void returnMonthBudgetByPlanCodeList(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return;
        }
        List<ActivityPlanBudget> planBudgetList = this.activityPlanBudgetRepository.listByPlanCodeList(planCodeList);
        if (CollectionUtils.isEmpty(planBudgetList)) {
            return;
        }
        this.returnMonthBudget(planBudgetList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void returnMonthBudget(List<ActivityPlanBudget> budgetList) {
        List verticalSchemeForecastBudgetCashOperateList;
        List headReturnBudgetOperateList;
        List<OperateActivityPlanBudgetDto> planBudgetOperateList;
        List freezeBudgetOperateList;
        List budgetOperateList;
        List strategyOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 && ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(item.getOccupyType()) && StringUtils.isNotEmpty((CharSequence)item.getRelateStrategyItemCode())).map(item -> new OperateMarketingStrategyBudgetDto((ActivityPlanBudget)((Object)item)){
            final /* synthetic */ ActivityPlanBudget val$item;
            {
                this.val$item = activityPlanBudget;
                this.setBusinessCode(this.val$item.getPlanItemCode());
                this.setStrategyCode(this.val$item.getRelateStrategyCode());
                this.setStrategyItemCode(this.val$item.getRelateStrategyItemCode());
                this.setMonthBudgetCode(this.val$item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(this.val$item.getUseAmount());
            }
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(strategyOperateList)) {
            this.marketingStrategyBudgetSdkService.operateAmount(strategyOperateList);
        }
        if (!CollectionUtils.isEmpty(budgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 && ActivityPlanBudgetOccupyTypeEnum.BUDGET.getCode().equals(item.getOccupyType())).map(item -> new OperateMonthBudgetDto((ActivityPlanBudget)((Object)item)){
            final /* synthetic */ ActivityPlanBudget val$item;
            {
                this.val$item = activityPlanBudget;
                this.setBusinessCode(this.val$item.getPlanItemCode());
                this.setMonthBudgetCode(this.val$item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(this.val$item.getUseAmount());
            }
        }).collect(Collectors.toList()))) {
            this.monthBudgetService.operateBudget(budgetOperateList);
        }
        if (!CollectionUtils.isEmpty(freezeBudgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 && ActivityPlanBudgetOccupyTypeEnum.FREEZE.getCode().equals(item.getOccupyType())).map(item -> new OperateMonthBudgetDto((ActivityPlanBudget)((Object)item)){
            final /* synthetic */ ActivityPlanBudget val$item;
            {
                this.val$item = activityPlanBudget;
                this.setBusinessCode(this.val$item.getPlanItemCode());
                this.setMonthBudgetCode(this.val$item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.UNFREEZE.getCode());
                this.setOperationAmount(this.val$item.getUseAmount());
            }
        }).collect(Collectors.toList()))) {
            this.monthBudgetService.operateBudget(freezeBudgetOperateList);
        }
        if (!CollectionUtils.isEmpty(planBudgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 && ActivityPlanBudgetOccupyTypeEnum.PLAN.getCode().equals(item.getOccupyType())).map(item -> new OperateActivityPlanBudgetDto((ActivityPlanBudget)((Object)item)){
            final /* synthetic */ ActivityPlanBudget val$item;
            {
                this.val$item = activityPlanBudget;
                this.setBusinessCode(this.val$item.getPlanItemCode());
                this.setPlanCode(this.val$item.getRelatePlanCode());
                this.setPlanItemCode(this.val$item.getRelatePlanItemCode());
                this.setMonthBudgetCode(this.val$item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(this.val$item.getUseAmount());
            }
        }).collect(Collectors.toList()))) {
            this.activityPlanBudgetService.operateBudget(planBudgetOperateList);
        }
        if (!CollectionUtils.isEmpty(headReturnBudgetOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 && ActivityPlanBudgetOccupyTypeEnum.USE_FREEZE.getCode().equals(item.getOccupyType())).map(item -> new OperateMonthBudgetDto((ActivityPlanBudget)((Object)item)){
            final /* synthetic */ ActivityPlanBudget val$item;
            {
                this.val$item = activityPlanBudget;
                this.setBusinessCode(this.val$item.getPlanItemCode());
                this.setMonthBudgetCode(this.val$item.getMonthBudgetCode());
                this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                this.setOperationAmount(this.val$item.getUseAmount());
            }
        }).collect(Collectors.toList()))) {
            this.monthBudgetService.operateBudget(headReturnBudgetOperateList);
            List headFreezeBudgetOperateList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(headReturnBudgetOperateList, OperateMonthBudgetDto.class, OperateMonthBudgetDto.class, HashSet.class, ArrayList.class, new String[0]);
            headFreezeBudgetOperateList.forEach(operate -> operate.setOperationType(BudgetOperationTypeEnum.FREEZE.getCode()));
            this.monthBudgetService.operateBudget(headFreezeBudgetOperateList);
        }
        if (!CollectionUtils.isEmpty(verticalSchemeForecastBudgetCashOperateList = budgetList.stream().filter(item -> null != item.getUseAmount() && BigDecimal.ZERO.compareTo(item.getUseAmount()) != 0 && ActivityPlanBudgetOccupyTypeEnum.USE_FREEZE.getCode().equals(item.getOccupyType())).map(item -> new TpmVerticalSchemeForecastBudgetCashOperateDto((ActivityPlanBudget)((Object)item)){
            final /* synthetic */ ActivityPlanBudget val$item;
            {
                this.val$item = activityPlanBudget;
                this.setDetailCode(this.val$item.getSchemeForecastDetailCode());
                this.setOperateType(TpmVerticalSchemeCashOperateTypeEnum.back.getCode());
                this.setOperateAmount(this.val$item.getUseAmount());
            }
        }).collect(Collectors.toList()))) {
            List keys = verticalSchemeForecastBudgetCashOperateList.stream().map(TpmVerticalSchemeForecastBudgetCashOperateDto::getDetailCode).distinct().collect(Collectors.toList());
            List lockedKeys = this.verticalSchemeForecastService.lock(keys, TimeUnit.SECONDS, 60, 5);
            try {
                this.verticalSchemeForecastService.operate(verticalSchemeForecastBudgetCashOperateList, true);
            }
            finally {
                if (!CollectionUtils.isEmpty((Collection)lockedKeys)) {
                    this.verticalSchemeForecastService.unLock(lockedKeys);
                }
            }
        }
    }

    @Override
    public void operateBudget(List<OperateActivityPlanBudgetDto> operateList) {
        if (CollectionUtils.isEmpty(operateList)) {
            return;
        }
        Set monthBudgetCodeSet = operateList.stream().map(OperateMonthBudgetDto::getMonthBudgetCode).filter(Objects::nonNull).collect(Collectors.toSet());
        try {
            Validate.isTrue((boolean)this.monthBudgetLockService.lock(new ArrayList(monthBudgetCodeSet), TimeUnit.SECONDS, 1200), (String)"\u9884\u7b97\u52a0\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            this.operateBudget(operateList, Maps.newHashMap());
        }
        finally {
            this.monthBudgetLockService.unLock(new ArrayList(monthBudgetCodeSet));
        }
    }

    @Override
    public void operateBudget(List<OperateActivityPlanBudgetDto> operateList, Map<String, BigDecimal> looseAmountMap) {
        if (CollectionUtils.isEmpty(operateList)) {
            return;
        }
        operateList.forEach(dto -> {
            if (!this.redisLockService.isLock("month_budget:lock:" + dto.getMonthBudgetCode())) {
                throw new RuntimeException("\u9884\u7b97\u64cd\u4f5c\u5931\u8d25\uff0c\u6708\u5ea6\u9884\u7b97" + dto.getMonthBudgetCode() + "\u672a\u52a0\u9501\uff01");
            }
        });
        List<ActivityPlanBudget> activityPlanBudgets = this.validateOperateBudget(operateList);
        Map<String, List<ActivityPlanBudget>> budgetEntityMap = activityPlanBudgets.stream().collect(Collectors.groupingBy(item -> item.getPlanItemCode() + item.getMonthBudgetCode()));
        ArrayList detailList = Lists.newArrayList();
        for (OperateActivityPlanBudgetDto operateMonthBudgetDto : operateList) {
            BigDecimal operationAmount = operateMonthBudgetDto.getOperationAmount();
            String operationType = operateMonthBudgetDto.getOperationType();
            String businessCode = operateMonthBudgetDto.getBusinessCode();
            List<ActivityPlanBudget> monthBudgetEntities = budgetEntityMap.get(operateMonthBudgetDto.getPlanItemCode() + operateMonthBudgetDto.getMonthBudgetCode());
            BigDecimal looseAmount = looseAmountMap.getOrDefault(operateMonthBudgetDto.getPlanItemCode() + operateMonthBudgetDto.getMonthBudgetCode(), BigDecimal.ZERO);
            for (int i = 0; i < monthBudgetEntities.size(); ++i) {
                ActivityPlanBudget monthBudgetEntity = monthBudgetEntities.get(i);
                boolean negate = false;
                if (monthBudgetEntity.getUseAmount().compareTo(BigDecimal.ZERO) < 0) {
                    negate = true;
                }
                BigDecimal usableAmount = monthBudgetEntity.getUseAmount().subtract(monthBudgetEntity.getUsedAmount()).add(looseAmount);
                looseAmount = BigDecimal.ZERO;
                operateMonthBudgetDto.setOperationAmount(BigDecimal.ZERO);
                BigDecimal thisOperationAmount = operationAmount;
                if (BudgetOperationTypeEnum.USE.getCode().equals(operationType)) {
                    if (i == monthBudgetEntities.size() - 1) {
                        if (negate) {
                            Validate.isTrue((usableAmount.compareTo(thisOperationAmount) <= 0 ? 1 : 0) != 0, (String)((StringUtils.isNotEmpty((CharSequence)businessCode) ? "[" + businessCode + "]" : "\u7b2c[" + operateMonthBudgetDto.getIndexNo() + "]\u884c") + "\u4f7f\u7528\u91d1\u989d[" + thisOperationAmount + "]\u5927\u4e8e\u5f53\u524d\u53ef\u7528\u4f59\u989d" + usableAmount + "\uff0c\u8bf7\u68c0\u67e5\uff01"), (Object[])new Object[0]);
                        } else {
                            Validate.isTrue((usableAmount.compareTo(thisOperationAmount) >= 0 ? 1 : 0) != 0, (String)((StringUtils.isNotEmpty((CharSequence)businessCode) ? "[" + businessCode + "]" : "\u7b2c[" + operateMonthBudgetDto.getIndexNo() + "]\u884c") + "\u4f7f\u7528\u91d1\u989d[" + thisOperationAmount + "]\u5927\u4e8e\u5f53\u524d\u53ef\u7528\u4f59\u989d" + usableAmount + "\uff0c\u8bf7\u68c0\u67e5\uff01"), (Object[])new Object[0]);
                        }
                    } else if (!negate && usableAmount.compareTo(operationAmount) < 0) {
                        thisOperationAmount = usableAmount;
                    } else if (negate && usableAmount.compareTo(operationAmount) > 0) {
                        thisOperationAmount = usableAmount;
                    }
                    operationAmount = operationAmount.subtract(thisOperationAmount);
                    monthBudgetEntity.setUsedAmount(monthBudgetEntity.getUsedAmount().add(thisOperationAmount));
                    continue;
                }
                if (!BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) continue;
                monthBudgetEntity.setUsedAmount(monthBudgetEntity.getUsedAmount().subtract(operationAmount));
            }
        }
        Boolean doSave = operateList.get(0).getDoSave();
        if (null == doSave || doSave.booleanValue()) {
            this.activityPlanBudgetService.updateOperateBudget(activityPlanBudgets, detailList);
        }
    }

    public List<ActivityPlanBudget> validateOperateBudget(List<OperateActivityPlanBudgetDto> operateList) {
        for (OperateActivityPlanBudgetDto operateMonthBudgetDto : operateList) {
            Validate.notEmpty((CharSequence)operateMonthBudgetDto.getMonthBudgetCode(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)operateMonthBudgetDto.getOperationAmount(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)operateMonthBudgetDto.getOperationType(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)operateMonthBudgetDto.getPlanItemCode(), (String)"\u64cd\u4f5c\u65b9\u6848\u9884\u7b97\u65f6\uff0c\u65b9\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        List<String> operateCodeList = operateList.stream().map(item -> item.getPlanItemCode() + item.getMonthBudgetCode()).distinct().collect(Collectors.toList());
        List<ActivityPlanBudget> budgetEntityList = this.activityPlanBudgetRepository.listByOperateCodeList(operateCodeList);
        if (budgetEntityList.size() < operateCodeList.size()) {
            List existsCodes = budgetEntityList.stream().map(item -> item.getPlanItemCode() + item.getMonthBudgetCode()).collect(Collectors.toList());
            String notExistsJoinCodesStr = operateCodeList.stream().filter(item -> !existsCodes.contains(item)).collect(Collectors.joining(","));
            throw new RuntimeException("\u9884\u7b97\u64cd\u4f5c\u5931\u8d25\uff0c\u6d3b\u52a8\u660e\u7ec6[" + notExistsJoinCodesStr + "]\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9884\u7b97\u662f\u5426\u542f\u7528\u6216\u662f\u5426\u5b58\u5728\uff01\uff01");
        }
        for (ActivityPlanBudget activityPlanItem : budgetEntityList) {
            if (null == activityPlanItem.getUseAmount()) {
                activityPlanItem.setUseAmount(BigDecimal.ZERO);
            }
            if (null != activityPlanItem.getUsedAmount()) continue;
            activityPlanItem.setUsedAmount(BigDecimal.ZERO);
        }
        return budgetEntityList;
    }

    @Override
    public void operateCustomerBudget(List<OperateActivityPlanBudgetDto> operateList) {
        List<ActivityPlanBudget> activityPlanBudgets = this.validateOperateCustomerBudget(operateList);
        Map<String, List<ActivityPlanBudget>> budgetEntityMap = activityPlanBudgets.stream().collect(Collectors.groupingBy(ActivityPlanBudget::getPlanItemCode));
        ArrayList detailList = Lists.newArrayList();
        for (OperateActivityPlanBudgetDto operateMonthBudgetDto : operateList) {
            BigDecimal operationAmount = operateMonthBudgetDto.getOperationAmount();
            String operationType = operateMonthBudgetDto.getOperationType();
            String businessCode = operateMonthBudgetDto.getBusinessCode();
            List<ActivityPlanBudget> monthBudgetEntities = budgetEntityMap.get(operateMonthBudgetDto.getPlanItemCode());
            for (int i = 0; i < monthBudgetEntities.size(); ++i) {
                ActivityPlanBudget monthBudgetEntity = monthBudgetEntities.get(i);
                BigDecimal usableAmount = monthBudgetEntity.getUseAmount().subtract(monthBudgetEntity.getUsedAmount());
                BigDecimal thisOperationAmount = operationAmount;
                if (BudgetOperationTypeEnum.USE.getCode().equals(operationType)) {
                    if (i != monthBudgetEntities.size() - 1 && usableAmount.compareTo(operationAmount) < 0) {
                        thisOperationAmount = usableAmount;
                        operationAmount = operationAmount.subtract(thisOperationAmount);
                    }
                    monthBudgetEntity.setUsedAmount(monthBudgetEntity.getUsedAmount().add(thisOperationAmount));
                    continue;
                }
                if (!BudgetOperationTypeEnum.RETURN.getCode().equals(operationType)) continue;
                monthBudgetEntity.setUsedAmount(monthBudgetEntity.getUsedAmount().subtract(operationAmount));
            }
        }
        Boolean doSave = operateList.get(0).getDoSave();
        if (null == doSave || doSave.booleanValue()) {
            this.activityPlanBudgetService.updateOperateBudget(activityPlanBudgets, detailList);
        }
    }

    public List<ActivityPlanBudget> validateOperateCustomerBudget(List<OperateActivityPlanBudgetDto> operateList) {
        for (OperateActivityPlanBudgetDto operateMonthBudgetDto : operateList) {
            Validate.notNull((Object)operateMonthBudgetDto.getOperationAmount(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)operateMonthBudgetDto.getOperationType(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)operateMonthBudgetDto.getPlanItemCode(), (String)"\u64cd\u4f5c\u65b9\u6848\u9884\u7b97\u65f6\uff0c\u65b9\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        List<String> operateCodeList = operateList.stream().map(OperateActivityPlanBudgetDto::getPlanItemCode).distinct().collect(Collectors.toList());
        List<ActivityPlanBudget> budgetEntityList = this.activityPlanBudgetRepository.listCustomerBudgetByOperateCodeList(operateCodeList);
        if (budgetEntityList.size() < operateCodeList.size()) {
            List existsCodes = budgetEntityList.stream().map(item -> item.getPlanItemCode() + item.getMonthBudgetCode()).collect(Collectors.toList());
            String notExistsJoinCodesStr = operateCodeList.stream().filter(item -> !existsCodes.contains(item)).collect(Collectors.joining(","));
            throw new RuntimeException("\u9884\u7b97\u64cd\u4f5c\u5931\u8d25\uff0c\u6d3b\u52a8\u65b9\u6848\u5ba2\u6237\u9884\u7b97[" + notExistsJoinCodesStr + "]\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9884\u7b97\u662f\u5426\u542f\u7528\u6216\u662f\u5426\u5b58\u5728\uff01\uff01");
        }
        for (ActivityPlanBudget activityPlanItem : budgetEntityList) {
            if (null == activityPlanItem.getUseAmount()) {
                activityPlanItem.setUseAmount(BigDecimal.ZERO);
            }
            if (null != activityPlanItem.getUsedAmount()) continue;
            activityPlanItem.setUsedAmount(BigDecimal.ZERO);
        }
        return budgetEntityList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOperateBudget(Collection<ActivityPlanBudget> budgetList, List<MonthBudgetDetailDto> detailList) {
        this.activityPlanBudgetRepository.updateBatchById(budgetList);
    }

    @Override
    public Page<MarketingStrategyBudgetVo> findChooseStrategyBudgetList(Pageable pageable, MarketingStrategyBudgetDto dto) {
        return this.marketingStrategyBudgetSdkService.findByConditions(pageable, dto);
    }
}

