/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanBudget;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanBudgetServiceImpl;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.OperateActivityPlanBudgetVerticalDto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanBudgetVerticalService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.OperateMarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyBudgetSdkService;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityPlanBudgetVerticalServiceImpl
implements ActivityPlanBudgetVerticalService {
    @Autowired(required=false)
    private ActivityPlanBudgetRepository activityPlanBudgetRepository;
    @Autowired(required=false)
    private ActivityPlanBudgetServiceImpl activityPlanBudgetService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private MarketingStrategyBudgetSdkService marketingStrategyBudgetSdkService;
    @Autowired(required=false)
    private ActivityPlanItemRepository activityPlanItemRepository;

    @Transactional(rollbackFor={Exception.class})
    public void operateBudget(List<OperateActivityPlanBudgetVerticalDto> operateList) {
        List<ActivityPlanBudget> monthBudgetEntities;
        OperateActivityPlanBudgetVerticalDto operateMonthBudgetDto;
        BigDecimal operationAmount;
        List<ActivityPlanBudget> activityPlanBudgets = this.validateOperateBudget(operateList);
        Map<String, List<ActivityPlanBudget>> budgetEntityMap = activityPlanBudgets.stream().collect(Collectors.groupingBy(ActivityPlanBudget::getPlanItemCode));
        ArrayList detailList = Lists.newArrayList();
        ArrayList strategyOperateList = Lists.newArrayList();
        ArrayList budgetOperateList = Lists.newArrayList();
        HashSet<String> planItemSet = new HashSet<String>();
        Iterator<OperateActivityPlanBudgetVerticalDto> iterator = operateList.iterator();
        while (iterator.hasNext() && BigDecimal.ZERO.compareTo(operationAmount = (operateMonthBudgetDto = iterator.next()).getOperationAmount()) < 0 && !CollectionUtils.isEmpty(monthBudgetEntities = budgetEntityMap.get(operateMonthBudgetDto.getPlanItemCode()))) {
            for (int i = 0; i < monthBudgetEntities.size(); ++i) {
                final ActivityPlanBudget monthBudgetEntity = monthBudgetEntities.get(i);
                BigDecimal usableAmount = monthBudgetEntity.getUseAmount().subtract(monthBudgetEntity.getReturnAmount());
                BigDecimal thisOperationAmount = operationAmount;
                if (BigDecimal.ZERO.compareTo(operationAmount) >= 0) break;
                if (thisOperationAmount.compareTo(usableAmount) > 0) {
                    thisOperationAmount = usableAmount;
                }
                operationAmount = operationAmount.subtract(thisOperationAmount);
                monthBudgetEntity.setReturnAmount(monthBudgetEntity.getReturnAmount().subtract(thisOperationAmount));
                final BigDecimal finalThisOperationAmount = thisOperationAmount;
                budgetOperateList.add(new OperateMonthBudgetDto(){
                    {
                        this.setBusinessCode(monthBudgetEntity.getPlanItemCode());
                        this.setMonthBudgetCode(monthBudgetEntity.getMonthBudgetCode());
                        this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                        this.setOperationAmount(finalThisOperationAmount);
                    }
                });
                if (!StringUtils.isNotBlank((CharSequence)monthBudgetEntity.getRelateStrategyCode())) continue;
                strategyOperateList.add(new OperateMarketingStrategyBudgetDto(){
                    {
                        this.setBusinessCode(monthBudgetEntity.getPlanItemCode());
                        this.setStrategyCode(monthBudgetEntity.getRelateStrategyCode());
                        this.setStrategyItemCode(monthBudgetEntity.getRelateStrategyItemCode());
                        this.setMonthBudgetCode(monthBudgetEntity.getMonthBudgetCode());
                        this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                        this.setOperationAmount(finalThisOperationAmount);
                    }
                });
            }
            if (!operateMonthBudgetDto.getIsRollbackBudget().booleanValue()) continue;
            planItemSet.add(operateMonthBudgetDto.getPlanItemCode());
        }
        this.activityPlanBudgetService.updateOperateBudget(activityPlanBudgets, detailList);
        if (!CollectionUtils.isEmpty((Collection)strategyOperateList)) {
            this.marketingStrategyBudgetSdkService.operateAmount((List)strategyOperateList);
        }
        if (!CollectionUtils.isEmpty((Collection)budgetOperateList)) {
            this.monthBudgetService.operateBudget((List)budgetOperateList);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void operateBudgetDetailPlan(List<OperateActivityPlanBudgetVerticalDto> operateList) {
        List<ActivityPlanBudget> activityPlanBudgets = this.validateOperateBudget(operateList);
        Map<String, List<ActivityPlanBudget>> budgetEntityMap = activityPlanBudgets.stream().collect(Collectors.groupingBy(ActivityPlanBudget::getPlanItemCode));
        ArrayList detailList = Lists.newArrayList();
        ArrayList strategyOperateList = Lists.newArrayList();
        ArrayList budgetOperateList = Lists.newArrayList();
        block0: for (OperateActivityPlanBudgetVerticalDto operateMonthBudgetDto : operateList) {
            BigDecimal operationAmount = operateMonthBudgetDto.getOperationAmount();
            List<ActivityPlanBudget> monthBudgetEntities = budgetEntityMap.get(operateMonthBudgetDto.getPlanItemCode());
            for (int i = 0; i < monthBudgetEntities.size(); ++i) {
                final ActivityPlanBudget monthBudgetEntity = monthBudgetEntities.get(i);
                BigDecimal usableAmount = monthBudgetEntity.getUseAmount().subtract(monthBudgetEntity.getUsedAmount());
                BigDecimal thisOperationAmount = operationAmount;
                if (BigDecimal.ZERO.compareTo(operationAmount) >= 0) continue block0;
                if (thisOperationAmount.compareTo(usableAmount) > 0) {
                    thisOperationAmount = usableAmount;
                    operationAmount = operationAmount.subtract(thisOperationAmount);
                }
                monthBudgetEntity.setUsedAmount(monthBudgetEntity.getUsedAmount().subtract(thisOperationAmount));
                final BigDecimal finalThisOperationAmount = thisOperationAmount;
                budgetOperateList.add(new OperateMonthBudgetDto(){
                    {
                        this.setBusinessCode(monthBudgetEntity.getPlanItemCode());
                        this.setMonthBudgetCode(monthBudgetEntity.getMonthBudgetCode());
                        this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                        this.setOperationAmount(finalThisOperationAmount);
                    }
                });
                if (!StringUtils.isNotBlank((CharSequence)monthBudgetEntity.getRelateStrategyCode())) continue;
                strategyOperateList.add(new OperateMarketingStrategyBudgetDto(){
                    {
                        this.setBusinessCode(monthBudgetEntity.getPlanItemCode());
                        this.setStrategyCode(monthBudgetEntity.getRelateStrategyCode());
                        this.setStrategyItemCode(monthBudgetEntity.getRelateStrategyItemCode());
                        this.setMonthBudgetCode(monthBudgetEntity.getMonthBudgetCode());
                        this.setOperationType(BudgetOperationTypeEnum.RETURN.getCode());
                        this.setOperationAmount(finalThisOperationAmount);
                    }
                });
            }
        }
        this.activityPlanBudgetService.updateOperateBudget(activityPlanBudgets, detailList);
        if (!CollectionUtils.isEmpty((Collection)strategyOperateList)) {
            this.marketingStrategyBudgetSdkService.operateAmount((List)strategyOperateList);
        }
        if (!CollectionUtils.isEmpty((Collection)budgetOperateList)) {
            this.monthBudgetService.operateBudget((List)budgetOperateList);
        }
    }

    public void updatePlanItemRollbackBudget(List<String> planItemCodeList) {
        this.activityPlanItemRepository.updatePlanItemRollbackBudget(planItemCodeList);
    }

    public List<ActivityPlanBudget> validateOperateBudget(List<OperateActivityPlanBudgetVerticalDto> operateList) {
        for (OperateActivityPlanBudgetVerticalDto operateMonthBudgetDto : operateList) {
            Validate.notNull((Object)operateMonthBudgetDto.getOperationAmount(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)operateMonthBudgetDto.getOperationType(), (String)"\u64cd\u4f5c\u9884\u7b97\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)operateMonthBudgetDto.getPlanItemCode(), (String)"\u64cd\u4f5c\u65b9\u6848\u9884\u7b97\u65f6\uff0c\u65b9\u6848\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        List<String> operateCodeList = operateList.stream().map(OperateActivityPlanBudgetVerticalDto::getPlanItemCode).distinct().collect(Collectors.toList());
        LinkedList<ActivityPlanBudget> budgetEntityList = this.activityPlanBudgetRepository.listByOperateCodeListVertical(operateCodeList);
        for (ActivityPlanBudget activityPlanItem : budgetEntityList) {
            if (null == activityPlanItem.getUseAmount()) {
                activityPlanItem.setUseAmount(BigDecimal.ZERO);
            }
            if (null == activityPlanItem.getUsedAmount()) {
                activityPlanItem.setUsedAmount(BigDecimal.ZERO);
            }
            if (null != activityPlanItem.getReturnAmount()) continue;
            activityPlanItem.setReturnAmount(BigDecimal.ZERO);
        }
        return budgetEntityList;
    }
}

