/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemAsyncService;
import com.google.common.collect.Lists;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="activityPlanItemAsyncService")
public class ActivityPlanItemAsyncServiceImpl
implements ActivityPlanItemAsyncService {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanItemAsyncServiceImpl.class);
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    @Async
    public void closeActivityDetailPlanItem(List<String> itemCodeList, AbstractCrmUserIdentity userIdentity) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return;
        }
        this.loginUserService.refreshAuthentication((Object)userIdentity);
        List entityGroupList = Lists.partition(itemCodeList, (int)400);
        entityGroupList.forEach(list -> {
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(JSON.toJSONString((Object)list));
            mqMessageVo.setTopic("TPM_ACTIVITY_PLAN_CLOSE_TOPIC" + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag("TPM_ACTIVITY_PLAN_CLOSE_AUTO_CLOSE_DETAIL_PLAN");
            this.rocketMqProducer.sendMqMsg(mqMessageVo);
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        });
    }
}

