/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemTerminalRepository;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.budget.item.sdk.enums.FeeBelongEnum;
import com.biz.crm.tpm.business.marketing.strategy.sdk.pojo.MarketingStrategyItemBase;
import com.biz.crm.tpm.business.marketing.strategy.sdk.service.MarketingStrategyItemSdkService;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.gateway.websocket.client.sdk.service.ChannelMsgService;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class ActivityPlanItemPageCacheHelper
extends MnPageCacheHelper<ActivityPlanItemVo, ActivityPlanItemDto> {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanItemPageCacheHelper.class);
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private ActivityPlanItemRepository activityPlanItemRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private MarketingStrategyItemSdkService marketingStrategyItemSdkService;
    @Autowired(required=false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;
    @Autowired(required=false)
    private ActivityPlanItemTerminalRepository activityPlanItemTerminalRepository;
    @Autowired(required=false)
    private ChannelMsgService channelMsgService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Value(value="${spring.application.name:}")
    private String applicationName;
    private ThreadLocal<Integer> websocketOrder = new ThreadLocal();

    public String getCacheKeyPrefix() {
        return "activity_plan:item_cache:new";
    }

    public Class<ActivityPlanItemDto> getDtoClass() {
        return ActivityPlanItemDto.class;
    }

    public Class<ActivityPlanItemVo> getVoClass() {
        return ActivityPlanItemVo.class;
    }

    public List<ActivityPlanItemDto> findDtoListFromRepository(ActivityPlanItemDto dto, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)dto.getPlanCode())) {
            return Lists.newArrayList();
        }
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        List<ActivityPlanItemDto> allDtoList = this.activityPlanItemRepository.findDtoAndAttachListByPlanCode(dto.getPlanCode());
        allDtoList.sort(Comparator.comparing(ActivityPlanItemDto::getPlanItemCode));
        Map<String, List<ActivityPlanItemDto>> allMap = allDtoList.stream().collect(Collectors.groupingBy(ActivityPlanItemBase::getTemplateConfigCode));
        for (Map.Entry<String, List<ActivityPlanItemDto>> entry : allMap.entrySet()) {
            String thisRedisIdCacheKey = redisCacheIdKey.replace(templateCode, entry.getKey());
            String thisRedisDataCacheKey = redisCacheDataKey.replace(templateCode, entry.getKey());
            Map newItemMap = entry.getValue().stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
            this.redisService.lPushAll(thisRedisIdCacheKey, Long.valueOf(this.getExpireTime()), entry.getValue().stream().map(this::getDtoKey).toArray());
            this.redisTemplate.opsForHash().putAll((Object)thisRedisDataCacheKey, newItemMap);
            this.redisService.expire(thisRedisDataCacheKey, this.getExpireTime());
        }
        return allMap.get(templateCode);
    }

    public void fillVoListProperties(List<ActivityPlanItemVo> records) {
        super.fillVoListProperties(records);
    }

    public boolean initToCacheFromRepository() {
        return false;
    }

    public List<ActivityPlanItemDto> newItem(String cacheKey, List<ActivityPlanItemDto> itemList) {
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        ActivityPlanItemDto newItem = new ActivityPlanItemDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        newItem.setTemplateConfigCode(templateCode);
        return Lists.newArrayList((Object[])new ActivityPlanItemDto[]{newItem});
    }

    public void importNewItem(String cacheKey, List<ActivityPlanItemDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        for (ActivityPlanItemDto newItem : itemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setTemplateConfigCode(templateCode);
        }
        Object[] newIdArr = itemList.stream().map(this::getDtoKey).toArray();
        this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), newIdArr);
        Map updateMap = itemList.stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
        this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, updateMap);
        this.redisService.expire(redisCacheDataKey, this.getExpireTime());
    }

    public List<ActivityPlanItemDto> copyItem(String cacheKey, List<ActivityPlanItemDto> itemList) {
        List newItemList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityPlanItemDto.class, ActivityPlanItemDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (ActivityPlanItemDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setPlanItemCode(null);
        }
        return newItemList;
    }

    public void updateItem(String cacheKey, List<ActivityPlanItemDto> itemList) {
        String[] split = cacheKey.split(":");
        String lockKey = "activity_plan:lock:save:" + split[0];
        if (this.redisLockService.isLock(lockKey)) {
            throw new RuntimeException("\u6570\u636e\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
        }
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null != requestAttributes) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
            String businessUnitCode = servletRequestAttributes.getRequest().getParameter("businessUnitCode");
            if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode)) {
                for (ActivityPlanItemDto itemDto : itemList) {
                    if (CollectionUtils.isEmpty((Collection)itemDto.getBudgetShares())) continue;
                    BigDecimal headFeeAmount = BigDecimal.ZERO;
                    BigDecimal regionAutomaticFeeAmount = BigDecimal.ZERO;
                    BigDecimal regionReferendumFeeAmount = BigDecimal.ZERO;
                    HashSet headMonthBudgetCodeSet = Sets.newHashSet();
                    HashSet regionAutomaticMonthBudgetCodeSet = Sets.newHashSet();
                    HashSet regionReferendumMonthBudgetCodeSet = Sets.newHashSet();
                    HashSet headBudgetItemCodeSet = Sets.newHashSet();
                    HashSet regionAutomaticBudgetItemCodeSet = Sets.newHashSet();
                    HashSet regionReferendumBudgetItemCodeSet = Sets.newHashSet();
                    HashSet headBudgetItemNameSet = Sets.newHashSet();
                    HashSet regionAutomaticBudgetItemNameSet = Sets.newHashSet();
                    HashSet regionReferendumBudgetItemNameSet = Sets.newHashSet();
                    for (ActivityPlanBudgetDto budgetDto : itemDto.getBudgetShares()) {
                        if (StringUtils.isEmpty((CharSequence)budgetDto.getFeeBelongCode())) continue;
                        if (StringUtils.isNotEmpty((CharSequence)budgetDto.getUseAmountStr())) {
                            NumberStringDealUtil.validateNumberStrAndSet((String)budgetDto.getUseAmountStr(), (String)"\u672c\u6b21\u4f7f\u7528\u9884\u7b97\u91d1\u989d", (boolean)false, arg_0 -> ((ActivityPlanBudgetDto)budgetDto).setUseAmount(arg_0), BigDecimal.class);
                            if (FeeBelongEnum.HEAD.getCode().equals(budgetDto.getFeeBelongCode())) {
                                headFeeAmount = headFeeAmount.add(budgetDto.getUseAmount());
                            } else if (FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(budgetDto.getFeeBelongCode())) {
                                regionAutomaticFeeAmount = regionAutomaticFeeAmount.add(budgetDto.getUseAmount());
                            } else if (FeeBelongEnum.REGION_REFERENDUM.getCode().equals(budgetDto.getFeeBelongCode())) {
                                regionReferendumFeeAmount = regionReferendumFeeAmount.add(budgetDto.getUseAmount());
                            }
                        }
                        if (FeeBelongEnum.HEAD.getCode().equals(budgetDto.getFeeBelongCode())) {
                            if (StringUtils.isNotEmpty((CharSequence)budgetDto.getMonthBudgetCode())) {
                                headMonthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemCode())) {
                                headBudgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                            }
                            if (!StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemName())) continue;
                            headBudgetItemNameSet.add(budgetDto.getBudgetItemName());
                            continue;
                        }
                        if (FeeBelongEnum.REGION_AUTOMATIC.getCode().equals(budgetDto.getFeeBelongCode())) {
                            if (StringUtils.isNotEmpty((CharSequence)budgetDto.getMonthBudgetCode())) {
                                regionAutomaticMonthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemCode())) {
                                regionAutomaticBudgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                            }
                            if (!StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemName())) continue;
                            regionAutomaticBudgetItemNameSet.add(budgetDto.getBudgetItemName());
                            continue;
                        }
                        if (!FeeBelongEnum.REGION_REFERENDUM.getCode().equals(budgetDto.getFeeBelongCode())) continue;
                        if (StringUtils.isNotEmpty((CharSequence)budgetDto.getMonthBudgetCode())) {
                            regionReferendumMonthBudgetCodeSet.add(budgetDto.getMonthBudgetCode());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemCode())) {
                            regionReferendumBudgetItemCodeSet.add(budgetDto.getBudgetItemCode());
                        }
                        if (!StringUtils.isNotEmpty((CharSequence)budgetDto.getBudgetItemName())) continue;
                        regionReferendumBudgetItemNameSet.add(budgetDto.getBudgetItemName());
                    }
                    itemDto.setHeadFeeAmount(headFeeAmount);
                    itemDto.setHeadFeeAmountStr(headFeeAmount.toString());
                    itemDto.setRegionAutomaticFeeAmount(regionAutomaticFeeAmount);
                    itemDto.setRegionAutomaticFeeAmountStr(regionAutomaticFeeAmount.toString());
                    itemDto.setRegionReferendumFeeAmount(regionReferendumFeeAmount);
                    itemDto.setRegionReferendumFeeAmountStr(regionReferendumFeeAmount.toString());
                    itemDto.setHeadMonthBudgetCode(String.join((CharSequence)",", headMonthBudgetCodeSet));
                    itemDto.setRegionAutomaticMonthBudgetCode(String.join((CharSequence)",", regionAutomaticMonthBudgetCodeSet));
                    itemDto.setRegionReferendumMonthBudgetCode(String.join((CharSequence)",", regionReferendumMonthBudgetCodeSet));
                    itemDto.setHeadBudgetItemCode(String.join((CharSequence)",", headBudgetItemCodeSet));
                    itemDto.setRegionAutomaticBudgetItemCode(String.join((CharSequence)",", regionAutomaticBudgetItemCodeSet));
                    itemDto.setRegionReferendumBudgetItemCode(String.join((CharSequence)",", regionReferendumBudgetItemCodeSet));
                    itemDto.setHeadBudgetItemName(String.join((CharSequence)",", headBudgetItemNameSet));
                    itemDto.setRegionAutomaticBudgetItemName(String.join((CharSequence)",", regionAutomaticBudgetItemNameSet));
                    itemDto.setRegionReferendumBudgetItemName(String.join((CharSequence)",", regionReferendumBudgetItemNameSet));
                }
                String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
                List idList = itemList.stream().map(ActivityPlanItemBase::getId).collect(Collectors.toList());
                List existsObjList = this.redisTemplate.opsForHash().multiGet((Object)redisCacheDataKey, idList);
                if (!CollectionUtils.isEmpty((Collection)existsObjList)) {
                    List existsList = existsObjList;
                    Map existsMap = existsList.stream().collect(Collectors.toMap(ActivityPlanItemBase::getId, Function.identity()));
                    for (ActivityPlanItemDto itemDto : itemList) {
                        ActivityPlanItemDto existItemDto = (ActivityPlanItemDto)existsMap.get(itemDto.getId());
                        if (null == existItemDto || CollectionUtils.isEmpty((Collection)existItemDto.getActivityPlanItemTerminalList())) continue;
                        itemDto.setActivityPlanItemTerminalList(existItemDto.getActivityPlanItemTerminalList());
                    }
                }
            }
            if (BusinessUnitEnum.HEADQUARTERS.getCode().equals(businessUnitCode)) {
                List<String> relatePlanItemCodes = itemList.stream().map(ActivityPlanItemBase::getRelatePlanItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<ActivityPlanItemVo> activityPlanItemVoList = this.activityPlanItemRepository.findRelatedPlanItemByCodes(relatePlanItemCodes);
                Map activityPlanMap = activityPlanItemVoList.stream().collect(Collectors.toMap(ActivityPlanItemBase::getPlanItemCode, Function.identity()));
                List relateStrategyItemCodes = itemList.stream().map(ActivityPlanItemBase::getRelateStrategyItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List strategyItemVos = this.marketingStrategyItemSdkService.findByItemCodes(relateStrategyItemCodes);
                Map strategyItemVoMap = strategyItemVos.stream().collect(Collectors.toMap(MarketingStrategyItemBase::getStrategyItemCode, Function.identity()));
                List templateCodes = itemList.stream().map(ActivityPlanItemBase::getTemplateConfigCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List templateList = this.activitiesTemplateSdkService.findByCodeList(templateCodes);
                Map templateMap = templateList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));
                for (ActivityPlanItemDto item : itemList) {
                    ActivitiesTemplateConfigVo templateConfigVo;
                    ActivityPlanItemVo relatePlanItemVo;
                    if (!(StringUtils.isEmpty((CharSequence)item.getRelatePlanItemCode()) || CollectionUtils.isEmpty(activityPlanMap) || StringUtils.isEmpty((CharSequence)item.getRelateStrategyItemCode()) || CollectionUtils.isEmpty(strategyItemVoMap))) {
                        relatePlanItemVo = (ActivityPlanItemVo)activityPlanMap.get(item.getRelatePlanItemCode());
                        if (null == relatePlanItemVo) {
                            throw new IllegalArgumentException("\u83b7\u53d6\u627f\u63a5\u7684\u65b9\u6848\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u5173\u8054\u7684\u65b9\u6848\u660e\u7ec6\u4fe1\u606f! \u65b9\u6848\u660e\u7ec6\u7f16\u7801[" + item.getRelatePlanItemCode() + "]");
                        }
                        MarketingStrategyItemVo relateStrategyItemVo = (MarketingStrategyItemVo)strategyItemVoMap.get(item.getRelateStrategyItemCode());
                        if (null == relateStrategyItemVo) {
                            throw new IllegalArgumentException("\u83b7\u53d6\u627f\u63a5\u7684\u7b56\u7565\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u5173\u8054\u7684\u7b56\u7565\u660e\u7ec6\u4fe1\u606f! \u7b56\u7565\u660e\u7ec6\u7f16\u7801[" + item.getRelateStrategyItemCode() + "]");
                        }
                        ActivitiesTemplateConfigVo templateConfigVo2 = (ActivitiesTemplateConfigVo)templateMap.get(item.getTemplateConfigCode());
                        if (null == templateConfigVo2) {
                            throw new IllegalArgumentException("\u5904\u7406\u627f\u63a5\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6d3b\u52a8\u6a21\u677f\u914d\u7f6e\u4fe1\u606f! \u6a21\u677f\u7f16\u7801[" + item.getTemplateConfigCode() + "]");
                        }
                        ActivityPlanItemDto relatePlanItemDto = (ActivityPlanItemDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)relatePlanItemVo, ActivityPlanItemDto.class, HashSet.class, ArrayList.class, new String[0]);
                        ObjectConvertStringUtil.fillObjectStrProperties((Object)relatePlanItemDto, ActivityPlanItemDto.class);
                        ActivityPlanItemDto correspondenceDto = this.correspondence(relateStrategyItemVo);
                        ObjectConvertStringUtil.fillObjectStrProperties((Object)correspondenceDto, ActivityPlanItemDto.class);
                        this.handleAcceptFieldData(item, relatePlanItemDto, correspondenceDto, templateConfigVo2);
                        continue;
                    }
                    if (!StringUtils.isEmpty((CharSequence)item.getRelatePlanItemCode()) && !CollectionUtils.isEmpty(activityPlanMap) && StringUtils.isEmpty((CharSequence)item.getRelateStrategyItemCode())) {
                        relatePlanItemVo = (ActivityPlanItemVo)activityPlanMap.get(item.getRelatePlanItemCode());
                        if (null == relatePlanItemVo) {
                            throw new IllegalArgumentException("\u83b7\u53d6\u627f\u63a5\u7684\u65b9\u6848\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u5173\u8054\u7684\u65b9\u6848\u660e\u7ec6\u4fe1\u606f! \u65b9\u6848\u660e\u7ec6\u7f16\u7801[" + item.getRelatePlanItemCode() + "]");
                        }
                        templateConfigVo = (ActivitiesTemplateConfigVo)templateMap.get(item.getTemplateConfigCode());
                        if (null == templateConfigVo) {
                            throw new IllegalArgumentException("\u5904\u7406\u627f\u63a5\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6d3b\u52a8\u6a21\u677f\u914d\u7f6e\u4fe1\u606f! \u6a21\u677f\u7f16\u7801[" + item.getTemplateConfigCode() + "]");
                        }
                        ActivityPlanItemDto relatePlanItemDto = (ActivityPlanItemDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)relatePlanItemVo, ActivityPlanItemDto.class, HashSet.class, ArrayList.class, new String[0]);
                        ObjectConvertStringUtil.fillObjectStrProperties((Object)relatePlanItemDto, ActivityPlanItemDto.class);
                        this.handleAcceptFieldData(item, relatePlanItemDto, templateConfigVo);
                        continue;
                    }
                    if (!StringUtils.isEmpty((CharSequence)item.getRelatePlanItemCode()) || StringUtils.isEmpty((CharSequence)item.getRelateStrategyItemCode()) || CollectionUtils.isEmpty(strategyItemVoMap)) continue;
                    MarketingStrategyItemVo relateStrategyItemVo = (MarketingStrategyItemVo)strategyItemVoMap.get(item.getRelateStrategyItemCode());
                    if (null == relateStrategyItemVo) {
                        throw new IllegalArgumentException("\u83b7\u53d6\u627f\u63a5\u7684\u7b56\u7565\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u5173\u8054\u7684\u7b56\u7565\u660e\u7ec6\u4fe1\u606f! \u7b56\u7565\u660e\u7ec6\u7f16\u7801[" + item.getRelateStrategyItemCode() + "]");
                    }
                    templateConfigVo = (ActivitiesTemplateConfigVo)templateMap.get(item.getTemplateConfigCode());
                    if (null == templateConfigVo) {
                        throw new IllegalArgumentException("\u5904\u7406\u627f\u63a5\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6d3b\u52a8\u6a21\u677f\u914d\u7f6e\u4fe1\u606f! \u6a21\u677f\u7f16\u7801[" + item.getTemplateConfigCode() + "]");
                    }
                    ActivityPlanItemDto correspondenceDto = this.correspondence(relateStrategyItemVo);
                    ObjectConvertStringUtil.fillObjectStrProperties((Object)correspondenceDto, ActivityPlanItemDto.class);
                    this.handleAcceptFieldData(item, correspondenceDto, templateConfigVo);
                }
            }
        }
    }

    public List<ActivityPlanItemVo> dtoListToVoList(List<ActivityPlanItemDto> itemDtoList) {
        return super.dtoListToVoList(itemDtoList);
    }

    public String getRedisCacheInitKey(String cacheKey) {
        String redisCacheInitKey = super.getRedisCacheInitKey(cacheKey);
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        return redisCacheInitKey.replace(templateCode, "");
    }

    public Object getDtoKey(ActivityPlanItemDto activityPlanItemDto) {
        return activityPlanItemDto.getId();
    }

    public String getCheckedStatus(ActivityPlanItemDto activityPlanItemDto) {
        return activityPlanItemDto.getChecked();
    }

    private void handleAcceptFieldData(ActivityPlanItemDto item, ActivityPlanItemDto relateDto, ActivitiesTemplateConfigVo templateConfigVo) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanItemDto.class);
        Map propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        if (BooleanEnum.TRUE.getNumStr().equals(item.getHeadMonthBudgetFullAccept())) {
            for (ActivitiesTemplateConfigDetailVo config : templateConfigVo.getDetails()) {
                if (null == config.getEditableWhenUndertake() || config.getEditableWhenUndertake().booleanValue()) continue;
                if (!propertyMap.containsKey(config.getField())) {
                    throw new RuntimeException("\u6a21\u677f[" + templateConfigVo.getConfigCode() + templateConfigVo.getConfigName() + "]\u5c5e\u6027[" + config.getTitle() + "]\u7684\u5c5e\u6027[" + config.getField() + "]\u914d\u7f6e\u6709\u8bef!");
                }
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyMap.get(config.getField());
                if (null != propertyDescriptor) {
                    try {
                        Object itemInvoke = propertyDescriptor.getReadMethod().invoke((Object)relateDto, new Object[0]);
                        if (null == itemInvoke) continue;
                        propertyDescriptor.getWriteMethod().invoke((Object)item, itemInvoke);
                        continue;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException("[" + config.getTitle() + "]\u914d\u7f6e\u6709\u8bef\uff01");
                    }
                }
                throw new RuntimeException("[" + config.getTitle() + "]\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        } else {
            for (ActivitiesTemplateConfigDetailVo config : templateConfigVo.getDetails()) {
                if (null == config.getEditableWhenUndertakePart() || config.getEditableWhenUndertakePart().booleanValue()) continue;
                if (!propertyMap.containsKey(config.getField())) {
                    throw new RuntimeException("\u6a21\u677f[" + templateConfigVo.getConfigCode() + templateConfigVo.getConfigName() + "]\u5c5e\u6027[" + config.getTitle() + "]\u7684\u5c5e\u6027[" + config.getField() + "]\u914d\u7f6e\u6709\u8bef!");
                }
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyMap.get(config.getField());
                if (null != propertyDescriptor) {
                    try {
                        Object itemInvoke = propertyDescriptor.getReadMethod().invoke((Object)relateDto, new Object[0]);
                        if (null == itemInvoke) continue;
                        propertyDescriptor.getWriteMethod().invoke((Object)item, itemInvoke);
                        continue;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException("[" + config.getTitle() + "]\u914d\u7f6e\u6709\u8bef\uff01");
                    }
                }
                throw new RuntimeException("[" + config.getTitle() + "]\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
    }

    private void handleAcceptFieldData(ActivityPlanItemDto item, ActivityPlanItemDto relatePlanItemDto, ActivityPlanItemDto relateStrategyItemData, ActivitiesTemplateConfigVo templateConfigVo) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(ActivityPlanItemDto.class);
        Map propertyMap = Arrays.stream(propertyDescriptors).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        if (BooleanEnum.TRUE.getNumStr().equals(item.getHeadMonthBudgetFullAccept()) && BooleanEnum.TRUE.getNumStr().equals(item.getMonthBudgetFullAccept())) {
            for (ActivitiesTemplateConfigDetailVo config : templateConfigVo.getDetails()) {
                if (null == config.getEditableWhenUndertake() || config.getEditableWhenUndertake().booleanValue()) continue;
                if (!propertyMap.containsKey(config.getField())) {
                    throw new RuntimeException("\u6a21\u677f[" + templateConfigVo.getConfigName() + "]\u5c5e\u6027[" + config.getTitle() + "]\u914d\u7f6e\u6709\u8bef");
                }
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyMap.get(config.getField());
                if (null != propertyDescriptor) {
                    try {
                        Object itemInvoke = propertyDescriptor.getReadMethod().invoke((Object)relatePlanItemDto, new Object[0]);
                        if (null == itemInvoke) continue;
                        propertyDescriptor.getWriteMethod().invoke((Object)item, itemInvoke);
                        continue;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException("[" + config.getTitle() + "]\u8bfb\u53d6\u5931\u8d25\uff01");
                    }
                }
                throw new RuntimeException("[" + config.getTitle() + "]\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        } else if (!BooleanEnum.TRUE.getNumStr().equals(item.getHeadMonthBudgetFullAccept()) && !BooleanEnum.TRUE.getNumStr().equals(item.getMonthBudgetFullAccept())) {
            for (ActivitiesTemplateConfigDetailVo config : templateConfigVo.getDetails()) {
                if (null == config.getEditableWhenUndertakePart() || config.getEditableWhenUndertakePart().booleanValue()) continue;
                if (!propertyMap.containsKey(config.getField())) {
                    throw new RuntimeException("\u6a21\u677f[" + templateConfigVo.getConfigName() + "]\u5c5e\u6027[" + config.getTitle() + "]\u914d\u7f6e\u6709\u8bef");
                }
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyMap.get(config.getField());
                if (null != propertyDescriptor) {
                    try {
                        Object itemInvoke = propertyDescriptor.getReadMethod().invoke((Object)relateStrategyItemData, new Object[0]);
                        if (null == itemInvoke) continue;
                        propertyDescriptor.getWriteMethod().invoke((Object)item, itemInvoke);
                        continue;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException("[" + config.getTitle() + "]\u8bfb\u53d6\u5931\u8d25\uff01");
                    }
                }
                throw new RuntimeException("[" + config.getTitle() + "]\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        } else {
            for (ActivitiesTemplateConfigDetailVo config : templateConfigVo.getDetails()) {
                if (null == config.getEditableWhenUndertake() || config.getEditableWhenUndertake().booleanValue() || null == config.getEditableWhenUndertakePart() || !config.getEditableWhenUndertakePart().booleanValue()) continue;
                if (!propertyMap.containsKey(config.getField())) {
                    throw new RuntimeException("\u6a21\u677f[" + templateConfigVo.getConfigName() + "]\u5c5e\u6027[" + config.getTitle() + "]\u914d\u7f6e\u6709\u8bef");
                }
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyMap.get(config.getField());
                if (null != propertyDescriptor) {
                    try {
                        Object itemInvoke = propertyDescriptor.getReadMethod().invoke((Object)relatePlanItemDto, new Object[0]);
                        if (null == itemInvoke) continue;
                        propertyDescriptor.getWriteMethod().invoke((Object)item, itemInvoke);
                        continue;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException("[" + config.getTitle() + "]\u8bfb\u53d6\u5931\u8d25\uff01");
                    }
                }
                throw new RuntimeException("[" + config.getTitle() + "]\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
    }

    private ActivityPlanItemDto correspondence(MarketingStrategyItemVo relateVo) {
        relateVo.setActivityNumber(null);
        ActivityPlanItemDto dto = (ActivityPlanItemDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)relateVo, ActivityPlanItemDto.class, HashSet.class, ArrayList.class, new String[0]);
        return dto;
    }

    public void sendMsg(String remark) {
        this.sendMsg(remark, ExecStatusEnum.RUNNING.getKey());
    }

    public void sendMsg(String remark, String execStatus) {
        this.sendMsg("activity_plan_save", remark, execStatus);
    }

    public void sendCloseMsg(String remark) {
        this.sendCloseMsg(remark, ExecStatusEnum.RUNNING.getKey());
    }

    public void sendCloseMsg(String remark, String execStatus) {
        this.sendMsg("activity_plan_item_close", remark, execStatus);
    }

    public void sendMsg(String modelCode, String remark, String execStatus) {
        Integer order = this.websocketOrder.get();
        if (null == order) {
            order = 0;
        }
        this.websocketOrder.set(order + 1);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("remark", (Object)remark);
        String time = DateUtil.getDateStrByFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        jsonObject.put("time", (Object)time);
        jsonObject.put("applicationName", (Object)this.applicationName);
        jsonObject.put("execStatus", (Object)execStatus);
        jsonObject.put("order", (Object)order);
        if (ExecStatusEnum.FINISH.getKey().equals(execStatus)) {
            this.websocketOrder.remove();
        }
        byte[] jsonBytes = JSONObject.toJSONBytes((Object)jsonObject, (SerializerFeature[])new SerializerFeature[0]);
        String tenantCode = TenantUtils.getTenantCode();
        log.info(" activity_plan model send msg2: tenantCode = {} , applicationName = {} , modelCode = {} ", new Object[]{tenantCode, this.applicationName, modelCode});
        UserIdentity loginUser = this.loginUserService.getLoginUser();
        this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(tenantCode, this.applicationName, modelCode, loginUser.getAccount(), jsonBytes);
    }
}

