/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRelateDetailItemRepository;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemRelateDetailItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemRelateDetailItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class ActivityPlanItemRelateDetailItemPageCacheHelper
extends MnPageCacheHelper<ActivityPlanItemRelateDetailItemVo, ActivityPlanItemRelateDetailItemDto> {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanItemRelateDetailItemPageCacheHelper.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private ActivityPlanItemRelateDetailItemRepository activityPlanItemRelateDetailItemRepository;

    public String getCacheKeyPrefix() {
        return "activity_plan_item_relate_detail_item_cache_key_prefix:item_cache:new";
    }

    public Class<ActivityPlanItemRelateDetailItemDto> getDtoClass() {
        return ActivityPlanItemRelateDetailItemDto.class;
    }

    public Class<ActivityPlanItemRelateDetailItemVo> getVoClass() {
        return ActivityPlanItemRelateDetailItemVo.class;
    }

    public List<ActivityPlanItemRelateDetailItemDto> findDtoListFromRepository(ActivityPlanItemRelateDetailItemDto dto, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)dto.getPlanCode())) {
            return Lists.newArrayList();
        }
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        List<ActivityPlanItemRelateDetailItemDto> allDtoList = this.activityPlanItemRelateDetailItemRepository.findDtoListByPlanCode(dto.getPlanCode());
        ObjectConvertStringUtil.fillObjectListStrProperties(allDtoList, ActivityPlanItemRelateDetailItemDto.class);
        allDtoList.sort(Comparator.comparing(ActivityPlanItemRelateDetailItemDto::getPlanItemCode));
        Map<String, List<ActivityPlanItemRelateDetailItemDto>> allMap = allDtoList.stream().collect(Collectors.groupingBy(ActivityPlanItemRelateDetailItemDto::getTemplateConfigCode));
        for (Map.Entry<String, List<ActivityPlanItemRelateDetailItemDto>> entry : allMap.entrySet()) {
            String thisRedisIdCacheKey = redisCacheIdKey.replace(templateCode, entry.getKey());
            String thisRedisDataCacheKey = redisCacheDataKey.replace(templateCode, entry.getKey());
            Map newItemMap = entry.getValue().stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
            this.redisService.lPushAll(thisRedisIdCacheKey, Long.valueOf(this.getExpireTime()), entry.getValue().stream().map(this::getDtoKey).toArray());
            this.redisTemplate.opsForHash().putAll((Object)thisRedisDataCacheKey, newItemMap);
            this.redisService.expire(thisRedisDataCacheKey, this.getExpireTime());
        }
        return allMap.get(templateCode);
    }

    public boolean initToCacheFromRepository() {
        return false;
    }

    public void fillVoListProperties(List<ActivityPlanItemRelateDetailItemVo> records) {
        for (ActivityPlanItemRelateDetailItemVo record : records) {
            record.setActivityForm(record.getActivityFormName());
            record.setActivityType(record.getActivityTypeName());
        }
    }

    public String getRedisCacheInitKey(String cacheKey) {
        String redisCacheInitKey = super.getRedisCacheInitKey(cacheKey);
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        return redisCacheInitKey.replace(templateCode, "");
    }

    public List<ActivityPlanItemRelateDetailItemDto> newItem(String cacheKey, List<ActivityPlanItemRelateDetailItemDto> itemList) {
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        ActivityPlanItemRelateDetailItemDto newItem = new ActivityPlanItemRelateDetailItemDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        newItem.setTemplateConfigCode(templateCode);
        return Lists.newArrayList((Object[])new ActivityPlanItemRelateDetailItemDto[]{newItem});
    }

    public List<ActivityPlanItemRelateDetailItemDto> copyItem(String cacheKey, List<ActivityPlanItemRelateDetailItemDto> itemList) {
        List newItemList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, ActivityPlanItemRelateDetailItemDto.class, ActivityPlanItemRelateDetailItemDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (ActivityPlanItemRelateDetailItemDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setPlanItemCode(null);
        }
        return newItemList;
    }

    public Object getDtoKey(ActivityPlanItemRelateDetailItemDto activityPlanItemRelateDetailItemDto) {
        return activityPlanItemRelateDetailItemDto.getId();
    }

    public String getCheckedStatus(ActivityPlanItemRelateDetailItemDto activityPlanItemRelateDetailItemDto) {
        return activityPlanItemRelateDetailItemDto.getChecked();
    }

    public void importNewItem(String cacheKey, List<ActivityPlanItemRelateDetailItemDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        String[] split = cacheKey.split(":");
        String templateCode = split[split.length - 1];
        for (ActivityPlanItemRelateDetailItemDto newItem : itemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setTemplateConfigCode(templateCode);
        }
        Object[] newIdArr = itemList.stream().map(this::getDtoKey).toArray();
        this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), newIdArr);
        Map updateMap = itemList.stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
        this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, updateMap);
        this.redisService.expire(redisCacheDataKey, this.getExpireTime());
    }
}

