/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItemRelateDetailItem;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRelateDetailItemRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemRelateDetailItemService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemRelateDetailItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemRelateDetailItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="activityPlanItemRelateDetailItemService")
public class ActivityPlanItemRelateDetailItemServiceImpl
extends MnPageCacheServiceImpl<ActivityPlanItemRelateDetailItemVo, ActivityPlanItemRelateDetailItemDto>
implements ActivityPlanItemRelateDetailItemService {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanItemRelateDetailItemServiceImpl.class);
    @Autowired(required=false)
    private ActivityPlanItemRelateDetailItemRepository activityPlanItemRelateDetailItemRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public void savePlanItemRelateDetailItem(ActivityPlan entity, boolean update, List<ActivityPlanItemRelateDetailItemDto> relateDetailItemDtoList) {
        Collection activityPlanItemRelateDetailItems;
        Object relateDetailItemVoList;
        if (CollectionUtils.isEmpty(relateDetailItemDtoList)) {
            this.activityPlanItemRelateDetailItemRepository.deleteByPlanCode(entity.getPlanCode());
            return;
        }
        ObjectConvertStringUtil.convertObjectListStrProperties(relateDetailItemDtoList, ActivityPlanItemRelateDetailItemDto.class, (boolean)true);
        ArrayList<ActivityPlanItemRelateDetailItemDto> updateDtoList = new ArrayList<ActivityPlanItemRelateDetailItemDto>();
        ArrayList<ActivityPlanItemRelateDetailItemDto> saveDtoList = new ArrayList<ActivityPlanItemRelateDetailItemDto>();
        Map<Object, Object> oldMap = new HashMap();
        if (update && CollectionUtils.isNotEmpty((Collection)(relateDetailItemVoList = this.activityPlanItemRelateDetailItemRepository.findListByPlanCode(entity.getPlanCode())))) {
            oldMap = relateDetailItemVoList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        for (ActivityPlanItemRelateDetailItemDto relateDetailItemDto : relateDetailItemDtoList) {
            if (oldMap.containsKey(relateDetailItemDto.getId())) {
                updateDtoList.add(relateDetailItemDto);
                oldMap.remove(relateDetailItemDto.getId());
                continue;
            }
            saveDtoList.add(relateDetailItemDto);
        }
        if (CollectionUtils.isNotEmpty(saveDtoList)) {
            activityPlanItemRelateDetailItems = this.nebulaToolkitService.copyCollectionByWhiteList(saveDtoList, ActivityPlanItemRelateDetailItemDto.class, ActivityPlanItemRelateDetailItem.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            activityPlanItemRelateDetailItems.forEach(item -> {
                item.setId(null);
                item.setTenantCode(TenantUtils.getTenantCode());
                item.setPlanCode(entity.getPlanCode());
            });
            this.activityPlanItemRelateDetailItemRepository.saveBatch(activityPlanItemRelateDetailItems);
        }
        if (CollectionUtils.isNotEmpty(updateDtoList)) {
            activityPlanItemRelateDetailItems = this.nebulaToolkitService.copyCollectionByWhiteList(updateDtoList, ActivityPlanItemRelateDetailItemDto.class, ActivityPlanItemRelateDetailItem.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.activityPlanItemRelateDetailItemRepository.updateBatchById(activityPlanItemRelateDetailItems);
        }
        if (MapUtils.isNotEmpty(oldMap)) {
            Set ids = oldMap.keySet();
            this.activityPlanItemRelateDetailItemRepository.removeByIds(ids);
        }
    }

    @Override
    public List<ActivityPlanItemRelateDetailItemDto> findDtoByPlanCodeList(List<String> planCodeList) {
        if (CollectionUtils.isEmpty(planCodeList)) {
            return Lists.newArrayList();
        }
        List<ActivityPlanItemRelateDetailItem> activityPlanItemRelateDetailItemList = this.activityPlanItemRelateDetailItemRepository.findDtoByPlanCodeList(planCodeList);
        if (CollectionUtils.isEmpty(activityPlanItemRelateDetailItemList)) {
            return Lists.newArrayList();
        }
        Collection activityPlanItemRelateDetailItemDtos = this.nebulaToolkitService.copyCollectionByWhiteList(activityPlanItemRelateDetailItemList, ActivityPlanItemRelateDetailItem.class, ActivityPlanItemRelateDetailItemDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)activityPlanItemRelateDetailItemDtos;
    }
}

