/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanBudget;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItem;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.RedPacketQueryScheme2Dto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.RedPacketQueryScheme2Vo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ActivityPlanItemSdkServiceImpl
implements ActivityPlanItemSdkService {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanItemSdkServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityPlanItemRepository activityPlanItemRepository;
    @Autowired(required=false)
    private ActivityPlanBudgetRepository activityPlanBudgetRepository;
    @Autowired(required=false)
    private ActivityPlanItemService activityPlanItemService;

    public Page<ActivityPlanItemVo> findByConditions(Pageable pageable, ActivityPlanItemDto activityPlanItemDto) {
        return this.activityPlanItemService.findByConditions(pageable, activityPlanItemDto);
    }

    public List<ActivityPlanItemBudgetVo> findItemBudgetListByConditions(ActivityPlanItemBudgetDto activityPlanItemBudgetDto) {
        return this.activityPlanItemService.findItemBudgetListByConditions(activityPlanItemBudgetDto);
    }

    public List<ActivityPlanItemVo> listByItemCodeList(List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return Lists.newArrayList();
        }
        List<ActivityPlanItem> activityPlanItemList = this.activityPlanItemRepository.listByDetailCodeList(itemCodeList);
        if (CollectionUtils.isEmpty(activityPlanItemList)) {
            return Lists.newArrayList();
        }
        List activityPlanItemVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(activityPlanItemList, ActivityPlanItem.class, ActivityPlanItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<ActivityPlanBudget> budgetList = this.activityPlanBudgetRepository.listByDetailCodeList(itemCodeList);
        if (!CollectionUtils.isEmpty(budgetList)) {
            List activityPlanBudgetVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(budgetList, ActivityPlanBudget.class, ActivityPlanBudgetVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            Map<String, List<ActivityPlanBudgetVo>> budgetMap = activityPlanBudgetVos.stream().collect(Collectors.groupingBy(ActivityPlanBudgetVo::getPlanItemCode));
            activityPlanItemVos.forEach(activityPlanItemVo -> activityPlanItemVo.setBudgetShares((List)budgetMap.get(activityPlanItemVo.getPlanItemCode())));
        }
        return activityPlanItemVos;
    }

    public void operationBudget(List<ActivityPlanBudgetDto> operationBudgetList) {
        if (CollectionUtils.isEmpty(operationBudgetList)) {
            return;
        }
        Set planItemCodeSet = operationBudgetList.stream().map(ActivityPlanBudgetDto::getPlanItemCode).collect(Collectors.toSet());
        List<ActivityPlanItem> activityPlanItems = this.activityPlanItemRepository.listByDetailCodeList(new ArrayList<String>(planItemCodeSet));
        Map<String, List<ActivityPlanBudgetDto>> planBudgetDtoMap = operationBudgetList.stream().collect(Collectors.groupingBy(ActivityPlanBudgetDto::getPlanItemCode));
        Map itemMap = activityPlanItems.stream().collect(Collectors.toMap(ActivityPlanItem::getPlanItemCode, Function.identity()));
        planBudgetDtoMap.forEach((planItemCode, planBudgetDtoList) -> {
            ActivityPlanItem activityPlanItem = (ActivityPlanItem)((Object)((Object)itemMap.get(planItemCode)));
            BigDecimal downAmount = Optional.ofNullable(activityPlanItem.getDownAmount()).orElse(BigDecimal.ZERO);
            activityPlanItem.setDownAmount(downAmount.add(planBudgetDtoList.stream().map(ActivityPlanBudgetDto::getThisDownAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)));
            BigDecimal add = Optional.ofNullable(activityPlanItem.getHeadFeeAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(activityPlanItem.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO));
            if (activityPlanItem.getDownAmount().compareTo(add) >= 0) {
                activityPlanItem.setIsAllDown(BooleanEnum.TRUE.getCapital());
            } else {
                activityPlanItem.setIsAllDown(BooleanEnum.FALSE.getCapital());
            }
            this.activityPlanItemRepository.updateById((Object)activityPlanItem);
        });
    }

    public List<RedPacketQueryScheme2Vo> redPacketQueryScheme(RedPacketQueryScheme2Dto dto) {
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)dto.getPlanName()) && StringUtils.isEmpty((CharSequence)dto.getDepartmentName()) && StringUtils.isEmpty((CharSequence)dto.getSupplierName())) {
            throw new RuntimeException("\u8f93\u5165\u7684\u53c2\u6570\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        List<RedPacketQueryScheme2Vo> redPacketQueryScheme2Vos = this.activityPlanItemRepository.redPacketQueryScheme(dto);
        return redPacketQueryScheme2Vos;
    }

    public Boolean getAllColseByActNumber(String actNo) {
        if (StringUtils.isBlank((CharSequence)actNo)) {
            return false;
        }
        int count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityPlanItemRepository.lambdaQuery().eq(ActivityPlanItem::getActivityNumber, (Object)actNo)).eq(ActivityPlanItem::getIsClose, (Object)BooleanEnum.FALSE.getCapital())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).count();
        return count == 0;
    }

    public Integer findTotalByConditions(ActivityPlanItemDto activityPlanItemDto) {
        return this.activityPlanItemService.findTotalByConditions(activityPlanItemDto);
    }

    public List<ActivityPlanItemVo> findRelatedPlanItemByCodes(List<String> relatePlanItemCodes) {
        if (CollectionUtils.isEmpty(relatePlanItemCodes)) {
            return Lists.newArrayList();
        }
        return this.activityPlanItemRepository.findRelatedPlanItemByCodes(relatePlanItemCodes);
    }

    public List<ActivityPlanItemVo> findByHeadquartersPlanItemCode(String planItemCode) {
        if (StringUtils.isEmpty((CharSequence)planItemCode)) {
            return Lists.newArrayList();
        }
        return this.activityPlanItemService.findByHeadquartersPlanItemCode(planItemCode);
    }

    public ActivityPlanItemVo findListByPlanItemCode(String planItemCode) {
        if (StringUtils.isEmpty((CharSequence)planItemCode)) {
            return null;
        }
        return this.activityPlanItemService.findListByPlanItemCode(planItemCode);
    }

    public List<String> findItemCodeListByRelatePlanItemCodeList(List<String> planItemCodeList) {
        if (CollectionUtils.isEmpty(planItemCodeList)) {
            return null;
        }
        return this.activityPlanItemRepository.findItemCodeListByRelatePlanItemCodeList(planItemCodeList);
    }

    public List<ActivityPlanBudgetVo> findItemBudgetListByPlanCode(String planCode) {
        if (StringUtils.isEmpty((CharSequence)planCode)) {
            return Lists.newArrayList();
        }
        return this.activityPlanItemService.findItemBudgetListByPlanCode(planCode);
    }

    public void updateAuditStatusByCodes(List<String> auditPlanItemCodes) {
        if (CollectionUtils.isNotEmpty(auditPlanItemCodes)) {
            this.activityPlanItemService.updateAuditStatusByCodes(auditPlanItemCodes);
        }
    }

    public List<ActivityPlanBudgetVo> findItemBudgetListByPlanItemCode(String planItemCode) {
        if (StringUtils.isEmpty((CharSequence)planItemCode)) {
            return Lists.newArrayList();
        }
        return this.activityPlanItemService.findItemBudgetListByPlanItemCode(planItemCode);
    }

    public void updateWholeAuditByPlanItemCode(String businessCode) {
        this.activityPlanItemRepository.updateWholeAuditByPlanItemCode(businessCode);
    }

    public List<ActivityPlanItemVo> findListForFR(List<ActivityPlanItemDto> activityPlanItemDtos) {
        if (CollectionUtils.isEmpty(activityPlanItemDtos)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        return this.activityPlanItemRepository.findListForFR(activityPlanItemDtos);
    }

    public List<ActivityPlanItemVo> findCostListForFR(List<ActivityPlanItemDto> itemDtos, String code) {
        if (CollectionUtils.isEmpty(itemDtos)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        return this.activityPlanItemRepository.findCostListForFR(itemDtos, code);
    }

    public void updateAlreadyAuditAmount(List<ActivityPlanItemDto> activityPlanItemDtoList) {
        if (CollectionUtils.isEmpty(activityPlanItemDtoList)) {
            return;
        }
        Map activityPlanItemDtoMap = activityPlanItemDtoList.stream().collect(Collectors.toMap(ActivityPlanItemDto::getPlanItemCode, Function.identity()));
        List<String> planItemCodes = activityPlanItemDtoList.stream().map(ActivityPlanItemDto::getPlanItemCode).collect(Collectors.toList());
        List<ActivityPlanItemDto> activityPlanItemDtos = this.activityPlanItemRepository.findDtoListByPlanItemCodeList(planItemCodes);
        ArrayList<ActivityPlanItem> activityPlanItemUpadtes = new ArrayList<ActivityPlanItem>();
        for (ActivityPlanItemDto activityPlanItemDto : activityPlanItemDtos) {
            ActivityPlanItem activityPlanItem = new ActivityPlanItem();
            activityPlanItem.setId(activityPlanItemDto.getId());
            ActivityPlanItemDto activityPlanItemDto1 = (ActivityPlanItemDto)activityPlanItemDtoMap.get(activityPlanItemDto.getPlanItemCode());
            if (activityPlanItemDto1 == null) continue;
            activityPlanItem.setAlreadyAuditAmount(Optional.ofNullable(activityPlanItemDto.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO).add(activityPlanItemDto1.getAlreadyAuditAmount()));
            activityPlanItemUpadtes.add(activityPlanItem);
        }
        this.activityPlanItemRepository.updateBatchById(activityPlanItemUpadtes);
    }
}

