/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.SalesDataDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.kms.business.invoice.sales.data.sdk.vo.SalesDataVo;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.service.PromotersVoService;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItemTerminal;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemTerminalRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemTerminalService;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanItemPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemTerminalDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.WriteOffMethodEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemTerminalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ActivityPlanItemTerminalServiceImpl
implements ActivityPlanItemTerminalService {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanItemTerminalServiceImpl.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityPlanItemTerminalRepository activityPlanItemTerminalRepository;
    @Autowired(required=false)
    private ActivityPlanItemPageCacheHelper itemHelper;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;
    @Autowired(required=false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;
    @Autowired(required=false)
    private PromotersVoService promotersVoService;

    @Override
    public void saveActivityPlanItemTerminal(ActivityPlan entity, boolean update, List<ActivityPlanItemDto> itemDtoList, String cacheKey) {
        if (update) {
            ((LambdaUpdateChainWrapper)this.activityPlanItemTerminalRepository.lambdaUpdate().eq(ActivityPlanItemTerminal::getPlanCode, (Object)entity.getPlanCode())).remove();
        }
        ArrayList allList = new ArrayList();
        for (ActivityPlanItemDto itemDto : itemDtoList) {
            List terminalList = itemDto.getActivityPlanItemTerminalList();
            if (CollectionUtils.isEmpty((Collection)terminalList)) continue;
            for (ActivityPlanItemTerminalDto dto : terminalList) {
                dto.setPlanCode(entity.getPlanCode());
                dto.setPlanItemCode(itemDto.getPlanItemCode());
                dto.setBeginDate(itemDto.getActivityBeginDate());
                dto.setEndDate(itemDto.getActivityEndDate());
                dto.setTenantCode(TenantUtils.getTenantCode());
            }
            List activityPlanItemTerminals = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)terminalList, ActivityPlanItemTerminalDto.class, ActivityPlanItemTerminal.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            allList.addAll(activityPlanItemTerminals);
        }
        if (!CollectionUtils.isEmpty(allList)) {
            List partition = com.google.common.collect.Lists.partition(allList, (int)1000);
            int i = 0;
            int size = allList.size();
            for (List activityPlanItemTerminals : partition) {
                this.itemHelper.sendMsg("\u6b63\u5728\u66f4\u65b0\u7b2c[" + 1000 * i++ + "/" + size + "]\u6761\u65b9\u6848\u95e8\u5e97\u660e\u7ec6...");
                this.activityPlanItemTerminalRepository.saveBatch(activityPlanItemTerminals);
            }
        }
    }

    @Override
    public void createValidateList(ActivityPlanDto planDto, ActivityPlanItemDto itemDto, List<ActivityPlanItemTerminalDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        ObjectConvertStringUtil.convertObjectListStrProperties(dtoList, ActivityPlanItemTerminalDto.class);
    }

    @Override
    public void addTerminalFromCache(ActivityPlanItemDto dto) {
        String cacheKey = dto.getCacheKey();
        if (!StringUtils.hasText((String)cacheKey)) {
            return;
        }
        List<ActivityPlanItemTerminalDto> cacheList = this.findCacheList(cacheKey + ":" + dto.getId());
        dto.setActivityPlanItemTerminalList(cacheList);
    }

    @Override
    public void changeTerminalDetail(ActivityPlanItemDto dto, boolean autoFill) {
        String cacheKey = dto.getCacheKey();
        log.info("\u66f4\u65b0\u65b9\u6848\u660e\u7ec6[" + cacheKey + "]\u95e8\u5e97\u6570\u636e1");
        if (!StringUtils.hasText((String)cacheKey)) {
            return;
        }
        log.info("\u66f4\u65b0\u65b9\u6848\u660e\u7ec6[" + cacheKey + "]\u95e8\u5e97\u6570\u636e2");
        cacheKey = cacheKey + ":" + dto.getId();
        if (autoFill) {
            this.saveListCache(cacheKey, dto.getActivityPlanItemTerminalList());
        } else {
            this.saveCurrentPageCache(cacheKey, dto.getActivityPlanItemTerminalList());
        }
    }

    @Override
    public void importNewItem(String cacheKey, List<ActivityPlanItemTerminalDto> itemTerminalDtoList) {
        String itemId;
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        ActivityPlanItemDto itemDto = (ActivityPlanItemDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1));
        if (null == itemDto) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
        }
        List itemTerminalList = itemDto.getActivityPlanItemTerminalList();
        if (null == itemTerminalList) {
            itemTerminalList = Lists.newArrayList();
            itemDto.setActivityPlanItemTerminalList(itemTerminalList);
        }
        for (ActivityPlanItemTerminalDto terminalDto : itemTerminalDtoList) {
            terminalDto.setId(UUID.randomUUID().toString().replace("-", ""));
            terminalDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            terminalDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        itemTerminalList.addAll(0, itemTerminalDtoList);
        HashMap updateMap = Maps.newHashMap();
        updateMap.put(itemId, itemDto);
        this.itemHelper.doSaveItem(itemCacheKey, updateMap);
    }

    @Override
    public void clearCache(String cacheKey) {
        String itemId;
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        ActivityPlanItemDto itemDto = (ActivityPlanItemDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1));
        if (null == itemDto) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
        }
        itemDto.setActivityPlanItemTerminalList(null);
        HashMap updateMap = Maps.newHashMap();
        updateMap.put(itemId, itemDto);
        this.itemHelper.doSaveItem(itemCacheKey, updateMap);
    }

    @Override
    public void addItemCache(String cacheKey, List<ActivityPlanItemTerminalDto> itemList) {
        String itemId;
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        ActivityPlanItemDto itemDto = (ActivityPlanItemDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1));
        if (null == itemDto) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
        }
        List itemTerminalList = itemDto.getActivityPlanItemTerminalList();
        if (null == itemTerminalList) {
            itemTerminalList = Lists.newArrayList();
            itemDto.setActivityPlanItemTerminalList(itemTerminalList);
        }
        ActivityPlanItemTerminalDto newItem = new ActivityPlanItemTerminalDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        itemTerminalList.add(0, newItem);
        HashMap updateMap = Maps.newHashMap();
        updateMap.put(itemId, itemDto);
        this.itemHelper.doSaveItem(itemCacheKey, updateMap);
    }

    @Override
    public Page<ActivityPlanItemTerminalVo> findCachePageList(Pageable pageable, ActivityPlanItemTerminalDto dto, String cacheKey) {
        String itemId;
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        ActivityPlanItemDto itemDto = (ActivityPlanItemDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1));
        if (null == itemDto) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page.setTotal(0L);
        page.setRecords((List)com.google.common.collect.Lists.newArrayList());
        List dtoList = itemDto.getActivityPlanItemTerminalList();
        if (CollectionUtils.isEmpty((Collection)dtoList)) {
            return page;
        }
        page.setTotal((long)dtoList.size());
        long start = page.offset();
        if (page.getTotal() > start) {
            long end = page.offset() + page.getSize();
            if (page.getTotal() < end) {
                end = page.getTotal();
            }
            List recordDtoList = dtoList.subList((int)page.offset(), (int)end);
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(recordDtoList, ActivityPlanItemTerminalDto.class, ActivityPlanItemTerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
            page.setRecords(voList);
        }
        return page;
    }

    @Override
    public List<ActivityPlanItemTerminalDto> findCacheList(String cacheKey) {
        String itemId;
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        ActivityPlanItemDto itemDto = (ActivityPlanItemDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1));
        if (null == itemDto) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
        }
        return itemDto.getActivityPlanItemTerminalList();
    }

    @Override
    public void saveListCache(String cacheKey, List<ActivityPlanItemTerminalDto> itemList) {
        String itemId;
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        ActivityPlanItemDto itemDto = (ActivityPlanItemDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1));
        if (null == itemDto) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
        }
        itemDto.setActivityPlanItemTerminalList(itemList);
        HashMap updateMap = Maps.newHashMap();
        updateMap.put(itemId, itemDto);
        log.info("\u66f4\u65b0\u65b9\u6848\u660e\u7ec6[" + itemId + "]\u95e8\u5e97\u6570\u636e" + JSON.toJSONString((Object)itemDto.getActivityPlanItemTerminalList()));
        this.itemHelper.doSaveItem(itemCacheKey, updateMap);
    }

    @Override
    public void copyItemListCache(String cacheKey, List<ActivityPlanItemTerminalDto> updateList) {
        String itemId;
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        ActivityPlanItemDto itemDto = (ActivityPlanItemDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1));
        if (null == itemDto) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
        }
        List itemTerminalList = itemDto.getActivityPlanItemTerminalList();
        if (null == itemTerminalList) {
            itemTerminalList = Lists.newArrayList();
            itemDto.setActivityPlanItemTerminalList(itemTerminalList);
        }
        Map existsMap = itemTerminalList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        for (ActivityPlanItemTerminalDto terminalDto : updateList) {
            ActivityPlanItemTerminalDto oldTerminalDto = (ActivityPlanItemTerminalDto)existsMap.get(terminalDto.getId());
            if (BooleanEnum.TRUE.getNumStr().equals(terminalDto.getChecked())) {
                ActivityPlanItemTerminalDto copyTerminalDto = (ActivityPlanItemTerminalDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)terminalDto, ActivityPlanItemTerminalDto.class, HashSet.class, ArrayList.class, new String[0]);
                copyTerminalDto.setId(UUID.randomUUID().toString().replace("-", ""));
                copyTerminalDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                copyTerminalDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                itemTerminalList.add(0, copyTerminalDto);
                continue;
            }
            if (null == oldTerminalDto) continue;
            BeanUtils.copyProperties((Object)terminalDto, (Object)oldTerminalDto);
        }
        HashMap updateMap = Maps.newHashMap();
        updateMap.put(itemId, itemDto);
        this.itemHelper.doSaveItem(itemCacheKey, updateMap);
    }

    @Override
    public void saveCurrentPageCache(String cacheKey, List<ActivityPlanItemTerminalDto> updateList) {
        String itemId;
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        ActivityPlanItemDto itemDto = (ActivityPlanItemDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1));
        if (null == itemDto) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
        }
        List itemTerminalList = itemDto.getActivityPlanItemTerminalList();
        if (null == itemTerminalList) {
            itemTerminalList = Lists.newArrayList();
            itemDto.setActivityPlanItemTerminalList(itemTerminalList);
        }
        Map existsMap = itemTerminalList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        for (ActivityPlanItemTerminalDto terminalDto : updateList) {
            ActivityPlanItemTerminalDto oldTerminalDto = (ActivityPlanItemTerminalDto)existsMap.get(terminalDto.getId());
            if (null == oldTerminalDto) continue;
            BeanUtils.copyProperties((Object)terminalDto, (Object)oldTerminalDto);
        }
        HashMap updateMap = Maps.newHashMap();
        updateMap.put(itemId, itemDto);
        this.itemHelper.doSaveItem(itemCacheKey, updateMap);
    }

    @Override
    public void deleteCacheList(String cacheKey, List<ActivityPlanItemTerminalDto> updateList) {
        String itemId;
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        ActivityPlanItemDto itemDto = (ActivityPlanItemDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1));
        if (null == itemDto) {
            throw new RuntimeException("\u660e\u7ec6\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u8bf7\u68c0\u67e5");
        }
        List itemTerminalList = itemDto.getActivityPlanItemTerminalList();
        ArrayList newItemTerminalList = Lists.newArrayList();
        Map updateTerminalMap = updateList.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        for (ActivityPlanItemTerminalDto terminalDto : itemTerminalList) {
            if (updateTerminalMap.containsKey(terminalDto.getId())) {
                ActivityPlanItemTerminalDto newTerminalDto = (ActivityPlanItemTerminalDto)updateTerminalMap.get(terminalDto.getId());
                if (BooleanEnum.TRUE.getNumStr().equals(newTerminalDto.getChecked())) continue;
                newItemTerminalList.add(newTerminalDto);
                continue;
            }
            newItemTerminalList.add(terminalDto);
        }
        itemDto.setActivityPlanItemTerminalList((List)newItemTerminalList);
        HashMap updateMap = Maps.newHashMap();
        updateMap.put(itemId, itemDto);
        this.itemHelper.doSaveItem(itemCacheKey, updateMap);
    }

    @Override
    public void proportionByTerminal(ActivityPlanItemDto dto) {
        Integer periodPromotionalNumberInteger;
        Validate.notBlank((CharSequence)dto.getRegion(), (String)"\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSystemCode(), (String)"\u96f6\u552e\u5546\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BigDecimal totalFeeAmount = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getTotalFeeAmountStr())) {
            try {
                String totalFeeAmountStr = dto.getTotalFeeAmountStr();
                totalFeeAmount = new BigDecimal(totalFeeAmountStr);
                dto.setTotalFeeAmount(totalFeeAmount);
            }
            catch (Exception e) {
                throw new RuntimeException("\u8d39\u7528\u5408\u8ba1\u683c\u5f0f\u6709\u8bef\uff01");
            }
        } else {
            throw new RuntimeException("\u8d39\u7528\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.addTerminalFromCache(dto);
        boolean autoFill = false;
        if (CollectionUtils.isEmpty((Collection)dto.getActivityPlanItemTerminalList())) {
            List<TerminalVo> terminalVoList = this.findAvaiableTerminal(dto);
            ArrayList<ActivityPlanItemTerminalDto> activityPlanItemTerminalDtoList = new ArrayList<ActivityPlanItemTerminalDto>();
            for (TerminalVo terminalVo : terminalVoList) {
                ActivityPlanItemTerminalDto activityPlanItemTerminalDto = new ActivityPlanItemTerminalDto();
                activityPlanItemTerminalDto.setTerminalCode(terminalVo.getTerminalCode());
                activityPlanItemTerminalDto.setTerminalName(terminalVo.getTerminalName());
                activityPlanItemTerminalDto.setId(UUID.randomUUID().toString().replace("-", ""));
                activityPlanItemTerminalDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                activityPlanItemTerminalDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                activityPlanItemTerminalDtoList.add(activityPlanItemTerminalDto);
            }
            dto.setActivityPlanItemTerminalList(activityPlanItemTerminalDtoList);
            autoFill = true;
        }
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getActivityPlanItemTerminalList()) ? 1 : 0) != 0, (String)"\u95e8\u5e97\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getPeriodPromotionalNumberStr())) {
            try {
                dto.setPeriodPromotionalNumber(Integer.valueOf(Integer.parseInt(dto.getPeriodPromotionalNumberStr())));
            }
            catch (Exception e) {
                throw new RuntimeException("\u671f\u95f4\u4fc3\u9500\u4ef6\u6570\u683c\u5f0f\u6709\u8bef\uff01");
            }
        }
        if ("\u9648\u5217\u65b9\u6848\u6a21\u677f".equals(dto.getTemplateConfigName())) {
            Validate.notBlank((CharSequence)dto.getDisplayQuantityStr(), (String)"\u9648\u5217\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            periodPromotionalNumberInteger = new BigDecimal(dto.getDisplayQuantityStr()).intValue();
        } else {
            periodPromotionalNumberInteger = dto.getPeriodPromotionalNumber();
            Validate.notNull((Object)periodPromotionalNumberInteger, (String)"\u671f\u95f4\u4fc3\u9500\u4ef6\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        int terminalNum = dto.getActivityPlanItemTerminalList().size();
        int average = periodPromotionalNumberInteger / terminalNum;
        int averageAddOne = 0;
        if (periodPromotionalNumberInteger > 0) {
            averageAddOne = average + 1;
        } else if (periodPromotionalNumberInteger < 0) {
            averageAddOne = average - 1;
        }
        BigDecimal averageDecimal = new BigDecimal(average);
        BigDecimal averageAddOneDecimal = new BigDecimal(averageAddOne);
        int remainder = Math.abs(periodPromotionalNumberInteger % terminalNum);
        Iterator iterator = dto.getActivityPlanItemTerminalList().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            ActivityPlanItemTerminalDto activityPlanItemTerminalDto = (ActivityPlanItemTerminalDto)iterator.next();
            if ("\u9648\u5217\u65b9\u6848\u6a21\u677f".equals(dto.getTemplateConfigName())) {
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getPriceStr())) {
                    activityPlanItemTerminalDto.setStandard(new BigDecimal(dto.getPriceStr()));
                }
            } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getSingleApplicationFeeStr())) {
                activityPlanItemTerminalDto.setStandard(new BigDecimal(dto.getSingleApplicationFeeStr()));
            }
            if (i < remainder) {
                activityPlanItemTerminalDto.setQuantity(averageAddOneDecimal);
            } else {
                activityPlanItemTerminalDto.setQuantity(averageDecimal);
            }
            if (Objects.nonNull(activityPlanItemTerminalDto.getStandard()) && Objects.nonNull(activityPlanItemTerminalDto.getQuantity())) {
                activityPlanItemTerminalDto.setAmount(activityPlanItemTerminalDto.getStandard().multiply(activityPlanItemTerminalDto.getQuantity()));
            }
            ++i;
            if (null == activityPlanItemTerminalDto.getAmount() || activityPlanItemTerminalDto.getAmount().compareTo(BigDecimal.ZERO) == 0) {
                iterator.remove();
                continue;
            }
            activityPlanItemTerminalDto.setFloatingRateStr(dto.getFloatingRateStr());
            activityPlanItemTerminalDto.setFloatingRate(dto.getFloatingRate());
        }
        this.proportionAmountByTotalFeeAmount(dto);
        this.changeTerminalDetail(dto, autoFill);
    }

    @Override
    public void proportionByTerminalEmployee(ActivityPlanItemDto dto) {
        Validate.notBlank((CharSequence)dto.getRegion(), (String)"\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BigDecimal totalFeeAmount = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getTotalFeeAmountStr())) {
            try {
                String totalFeeAmountStr = dto.getTotalFeeAmountStr();
                totalFeeAmount = new BigDecimal(totalFeeAmountStr);
                dto.setTotalFeeAmount(totalFeeAmount);
            }
            catch (Exception e) {
                throw new RuntimeException("\u8d39\u7528\u5408\u8ba1\u683c\u5f0f\u6709\u8bef\uff01");
            }
        } else {
            throw new RuntimeException("\u8d39\u7528\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.addTerminalFromCache(dto);
        boolean autoFill = false;
        if (CollectionUtils.isEmpty((Collection)dto.getActivityPlanItemTerminalList())) {
            PromotersDto promotersDto = new PromotersDto();
            promotersDto.setRegionCode(dto.getRegion());
            promotersDto.setCustomerRetailerCode(dto.getSystemCode());
            promotersDto.setDistrictLevelCode(dto.getCityLevel());
            promotersDto.setTerminalTypeCode(dto.getAcStoreType());
            promotersDto.setPointsWarehouseCode(dto.getAcWarehouseCode());
            promotersDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            List promotersVoList = this.promotersVoService.findTerminalPromoters(promotersDto);
            ArrayList<ActivityPlanItemTerminalDto> activityPlanItemTerminalDtoList = new ArrayList<ActivityPlanItemTerminalDto>();
            for (PromotersVo promotersVo : promotersVoList) {
                ActivityPlanItemTerminalDto activityPlanItemTerminalDto = new ActivityPlanItemTerminalDto();
                BeanUtils.copyProperties((Object)promotersVo, (Object)activityPlanItemTerminalDto);
                activityPlanItemTerminalDto.setId(UUID.randomUUID().toString().replace("-", ""));
                activityPlanItemTerminalDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                activityPlanItemTerminalDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                activityPlanItemTerminalDtoList.add(activityPlanItemTerminalDto);
            }
            dto.setActivityPlanItemTerminalList(activityPlanItemTerminalDtoList);
            autoFill = true;
        }
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getActivityPlanItemTerminalList()) ? 1 : 0) != 0, (String)"\u95e8\u5e97\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Iterator iterator = dto.getActivityPlanItemTerminalList().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            ActivityPlanItemTerminalDto activityPlanItemTerminalDto = (ActivityPlanItemTerminalDto)dto.getActivityPlanItemTerminalList().get(i);
            activityPlanItemTerminalDto.setQuantity(BigDecimal.ONE);
            if (Objects.nonNull(activityPlanItemTerminalDto.getStandard()) && Objects.nonNull(activityPlanItemTerminalDto.getQuantity())) {
                activityPlanItemTerminalDto.setAmount(activityPlanItemTerminalDto.getStandard().multiply(activityPlanItemTerminalDto.getQuantity()));
            }
            ++i;
            if (null == activityPlanItemTerminalDto.getAmount() || activityPlanItemTerminalDto.getAmount().compareTo(BigDecimal.ZERO) == 0) {
                iterator.remove();
                continue;
            }
            activityPlanItemTerminalDto.setFloatingRateStr(dto.getFloatingRateStr());
            activityPlanItemTerminalDto.setFloatingRate(dto.getFloatingRate());
        }
        this.proportionAmountByTotalFeeAmount(dto);
        this.changeTerminalDetail(dto, autoFill);
    }

    @Override
    public void proportionByPos(ActivityPlanDto dto, String cacheKey, List<ActivityPlanItemDto> itemCacheList) {
        if (!BusinessUnitEnum.VERTICAL.getCode().equals(dto.getBusinessUnitCode())) {
            return;
        }
        if (CollectionUtils.isEmpty(itemCacheList)) {
            return;
        }
        itemCacheList.forEach(item -> this.clearCache(cacheKey + ":" + item.getId()));
        for (int i = 0; i < itemCacheList.size(); ++i) {
            try {
                ActivityPlanItemDto item2 = itemCacheList.get(i);
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)item2.getTerminalCode())) continue;
                item2.setCacheKey(cacheKey);
                item2.setTemplateConfigName(dto.getTemplateConfigName());
                this.proportionByPos(item2);
                continue;
            }
            catch (Exception e) {
                List itemIdList = itemCacheList.stream().map(ActivityPlanItemBase::getId).collect(Collectors.toList());
                for (int k = 0; k <= i; ++k) {
                    this.clearCache(cacheKey + ":" + (String)itemIdList.get(k));
                }
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("\u7b2c\u3010" + (i + 1) + "\u3011\u884c\uff0c" + e.getMessage());
            }
        }
    }

    public void proportionByPos(ActivityPlanItemDto dto) {
        Validate.notBlank((CharSequence)dto.getRegion(), (String)"\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSystemCode(), (String)"\u96f6\u552e\u5546\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getActivityBeginDateStr(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getActivityEndDateStr(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ArrayList<ActivityPlanItemTerminalDto> activityPlanItemTerminalDtoList = new ArrayList<ActivityPlanItemTerminalDto>();
        List<TerminalVo> terminalVoList = this.findAvaiableTerminal(dto);
        for (TerminalVo terminalVo : terminalVoList) {
            ActivityPlanItemTerminalDto activityPlanItemTerminalDto = new ActivityPlanItemTerminalDto();
            activityPlanItemTerminalDto.setTerminalCode(terminalVo.getTerminalCode());
            activityPlanItemTerminalDto.setTerminalName(terminalVo.getTerminalName());
            activityPlanItemTerminalDto.setId(UUID.randomUUID().toString().replace("-", ""));
            activityPlanItemTerminalDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            activityPlanItemTerminalDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            activityPlanItemTerminalDtoList.add(activityPlanItemTerminalDto);
        }
        dto.setActivityPlanItemTerminalList(activityPlanItemTerminalDtoList);
        this.proportionByTerminalPos(dto);
    }

    public void proportionByTerminalPos(ActivityPlanItemDto dto) {
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getActivityPlanItemTerminalList()) ? 1 : 0) != 0, (String)"\u95e8\u5e97\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SalesDataDto salesDataDto = new SalesDataDto();
        try {
            SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date beginDate = dayFormat.parse(dto.getActivityBeginDateStr());
            Date endDate = dayFormat.parse(dto.getActivityEndDateStr());
            Calendar instance = Calendar.getInstance();
            instance.setTime(beginDate);
            instance.add(2, -1);
            salesDataDto.setStartTime(dayFormat.format(instance.getTime()));
            instance.setTime(endDate);
            instance.add(2, -1);
            salesDataDto.setEndTime(dayFormat.format(instance.getTime()) + " 23:59:59");
        }
        catch (Exception e) {
            throw new RuntimeException("\u6d3b\u52a8\u65f6\u95f4\u683c\u5f0f\u6709\u8bef\uff01");
        }
        BigDecimal feeAmount = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getFeeAmountStr())) {
            try {
                String feeAmountStr = dto.getFeeAmountStr();
                feeAmount = new BigDecimal(feeAmountStr);
                dto.setFeeAmount(feeAmount);
            }
            catch (Exception e) {
                throw new RuntimeException("\u6211\u65b9\u627f\u62c5\u91d1\u989d\u683c\u5f0f\u6709\u8bef\uff01");
            }
        } else {
            throw new RuntimeException("\u6211\u65b9\u627f\u62c5\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List terminalCodeList = dto.getActivityPlanItemTerminalList().stream().map(ActivityPlanItemTerminalDto::getTerminalCode).collect(Collectors.toList());
        salesDataDto.setDeliveryPartyCodeList(terminalCodeList);
        salesDataDto.setGoodsCode(dto.getProductCode());
        List kmsPosList = this.invoiceSalesDataVoService.findKmsPosList(salesDataDto);
        boolean proportionAvage = false;
        int terminalSize = dto.getActivityPlanItemTerminalList().size();
        BigDecimal avageAmount = feeAmount.divide(new BigDecimal(terminalSize), 2, RoundingMode.HALF_UP);
        BigDecimal totalSalesAmount = BigDecimal.ONE;
        Map<Object, Object> kmsPosMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty((Collection)kmsPosList)) {
            proportionAvage = true;
        } else {
            totalSalesAmount = kmsPosList.stream().map(SalesDataVo::getSalesAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (totalSalesAmount.compareTo(BigDecimal.ZERO) == 0) {
                proportionAvage = true;
            }
            kmsPosMap = kmsPosList.stream().collect(Collectors.toMap(item -> item.getDeliveryPartyCode() + item.getGoodsCode(), Function.identity()));
        }
        Iterator iterator = dto.getActivityPlanItemTerminalList().iterator();
        BigDecimal leaveFeeAmount = feeAmount;
        while (iterator.hasNext()) {
            ActivityPlanItemTerminalDto activityPlanItemTerminalDto = (ActivityPlanItemTerminalDto)iterator.next();
            if (proportionAvage) {
                activityPlanItemTerminalDto.setFeeAmount(avageAmount);
            } else {
                String key = activityPlanItemTerminalDto.getTerminalCode() + dto.getProductCode();
                if (kmsPosMap.containsKey(key)) {
                    BigDecimal salesAmount = Optional.ofNullable(((SalesDataVo)kmsPosMap.get(key)).getSalesAmount()).orElse(BigDecimal.ZERO);
                    BigDecimal amount = feeAmount.multiply(salesAmount).divide(totalSalesAmount, 2, RoundingMode.HALF_UP);
                    activityPlanItemTerminalDto.setFeeAmount(amount);
                }
            }
            if (null == activityPlanItemTerminalDto.getFeeAmount() || activityPlanItemTerminalDto.getFeeAmount().compareTo(BigDecimal.ZERO) == 0) {
                iterator.remove();
                continue;
            }
            leaveFeeAmount = leaveFeeAmount.subtract(activityPlanItemTerminalDto.getFeeAmount());
            activityPlanItemTerminalDto.setFloatingRateStr(dto.getFloatingRateStr());
            activityPlanItemTerminalDto.setFloatingRate(dto.getFloatingRate());
        }
        if (leaveFeeAmount.compareTo(BigDecimal.ZERO) != 0) {
            ActivityPlanItemTerminalDto lastTerminalDto = (ActivityPlanItemTerminalDto)dto.getActivityPlanItemTerminalList().get(dto.getActivityPlanItemTerminalList().size() - 1);
            lastTerminalDto.setFeeAmount(lastTerminalDto.getFeeAmount().add(leaveFeeAmount));
        }
        this.proportionAmountByFeeAmount(dto);
        this.changeTerminalDetail(dto, true);
    }

    private void proportionAmountByFeeAmount(ActivityPlanItemDto dto) {
        List activityPlanItemTerminalList = dto.getActivityPlanItemTerminalList();
        if (CollectionUtils.isEmpty((Collection)activityPlanItemTerminalList)) {
            return;
        }
        Map<String, BigDecimal> feeAmountMap = activityPlanItemTerminalList.stream().filter(item -> null != item.getFeeAmount()).collect(Collectors.toMap(UuidDto::getId, ActivityPlanItemTerminalDto::getFeeAmount));
        BigDecimal feeAmount = dto.getFeeAmount();
        BigDecimal totalFeeAmount = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getTotalFeeAmountStr())) {
            try {
                String totalFeeAmountStr = dto.getTotalFeeAmountStr();
                totalFeeAmount = new BigDecimal(totalFeeAmountStr);
                dto.setTotalFeeAmount(totalFeeAmount);
            }
            catch (Exception e) {
                throw new RuntimeException("\u8d39\u7528\u5408\u8ba1\u683c\u5f0f\u6709\u8bef\uff01");
            }
            Iterator iterator = activityPlanItemTerminalList.iterator();
            BigDecimal leaveAmount = totalFeeAmount;
            while (iterator.hasNext()) {
                ActivityPlanItemTerminalDto activityPlanItemTerminalDto = (ActivityPlanItemTerminalDto)iterator.next();
                String key = activityPlanItemTerminalDto.getId();
                BigDecimal thisFeeAmount = Optional.ofNullable(feeAmountMap.get(key)).orElse(BigDecimal.ZERO);
                BigDecimal thisAmount = totalFeeAmount.multiply(thisFeeAmount).divide(feeAmount, 2, RoundingMode.HALF_UP);
                activityPlanItemTerminalDto.setAmount(thisAmount);
                leaveAmount = leaveAmount.subtract(thisAmount);
            }
            if (leaveAmount.compareTo(BigDecimal.ZERO) != 0) {
                ActivityPlanItemTerminalDto lastTerminalDto = (ActivityPlanItemTerminalDto)activityPlanItemTerminalList.get(activityPlanItemTerminalList.size() - 1);
                lastTerminalDto.setAmount(lastTerminalDto.getAmount().add(leaveAmount));
            }
        }
        BigDecimal systemBorneAmount = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getSystemBorneAmountStr())) {
            try {
                String systemBorneAmountStr = dto.getSystemBorneAmountStr();
                systemBorneAmount = new BigDecimal(systemBorneAmountStr);
                dto.setSystemBorneAmount(systemBorneAmount);
            }
            catch (Exception e) {
                throw new RuntimeException("\u7cfb\u7edf\u627f\u62c5\u91d1\u989d\u683c\u5f0f\u6709\u8bef\uff01");
            }
            Iterator iterator = activityPlanItemTerminalList.iterator();
            BigDecimal leaveAmount = systemBorneAmount;
            while (iterator.hasNext()) {
                ActivityPlanItemTerminalDto activityPlanItemTerminalDto = (ActivityPlanItemTerminalDto)iterator.next();
                String key = activityPlanItemTerminalDto.getId();
                BigDecimal thisFeeAmount = Optional.ofNullable(feeAmountMap.get(key)).orElse(BigDecimal.ZERO);
                BigDecimal thisAmount = systemBorneAmount.multiply(thisFeeAmount).divide(feeAmount, 2, RoundingMode.HALF_UP);
                activityPlanItemTerminalDto.setSystemBorneAmount(thisAmount);
                leaveAmount = leaveAmount.subtract(thisAmount);
            }
            if (leaveAmount.compareTo(BigDecimal.ZERO) != 0) {
                ActivityPlanItemTerminalDto lastTerminalDto = (ActivityPlanItemTerminalDto)activityPlanItemTerminalList.get(activityPlanItemTerminalList.size() - 1);
                lastTerminalDto.setSystemBorneAmount(lastTerminalDto.getSystemBorneAmount().add(leaveAmount));
            }
        }
    }

    @Override
    public void proportionAmountByTotalFeeAmount(ActivityPlanItemDto dto) {
        List activityPlanItemTerminalList = dto.getActivityPlanItemTerminalList();
        if (CollectionUtils.isEmpty((Collection)activityPlanItemTerminalList)) {
            return;
        }
        Map<String, BigDecimal> feeAmountMap = activityPlanItemTerminalList.stream().filter(item -> null != item.getAmount()).collect(Collectors.toMap(UuidDto::getId, ActivityPlanItemTerminalDto::getAmount));
        BigDecimal totalFeeAmount = dto.getTotalFeeAmount();
        BigDecimal feeAmount = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getFeeAmountStr())) {
            try {
                String feeAmountStr = dto.getFeeAmountStr();
                feeAmount = new BigDecimal(feeAmountStr);
                dto.setFeeAmount(feeAmount);
            }
            catch (Exception e) {
                throw new RuntimeException("\u6211\u65b9\u627f\u62c5\u91d1\u989d\u683c\u5f0f\u6709\u8bef\uff01");
            }
            Iterator iterator = activityPlanItemTerminalList.iterator();
            BigDecimal leaveAmount = feeAmount;
            while (iterator.hasNext()) {
                ActivityPlanItemTerminalDto activityPlanItemTerminalDto = (ActivityPlanItemTerminalDto)iterator.next();
                String key = activityPlanItemTerminalDto.getId();
                BigDecimal thisTotalAmount = Optional.ofNullable(feeAmountMap.get(key)).orElse(BigDecimal.ZERO);
                BigDecimal thisAmount = feeAmount.multiply(thisTotalAmount).divide(totalFeeAmount, 2, RoundingMode.HALF_UP);
                activityPlanItemTerminalDto.setFeeAmount(thisAmount);
                leaveAmount = leaveAmount.subtract(thisAmount);
            }
            if (leaveAmount.compareTo(BigDecimal.ZERO) != 0) {
                ActivityPlanItemTerminalDto lastTerminalDto = (ActivityPlanItemTerminalDto)activityPlanItemTerminalList.get(activityPlanItemTerminalList.size() - 1);
                lastTerminalDto.setFeeAmount(lastTerminalDto.getFeeAmount().add(leaveAmount));
            }
        }
        BigDecimal systemBorneAmount = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getSystemBorneAmountStr())) {
            try {
                String systemBorneAmountStr = dto.getSystemBorneAmountStr();
                systemBorneAmount = new BigDecimal(systemBorneAmountStr);
                dto.setSystemBorneAmount(systemBorneAmount);
            }
            catch (Exception e) {
                throw new RuntimeException("\u7cfb\u7edf\u627f\u62c5\u91d1\u989d\u683c\u5f0f\u6709\u8bef\uff01");
            }
            Iterator iterator = activityPlanItemTerminalList.iterator();
            BigDecimal leaveAmount = systemBorneAmount;
            while (iterator.hasNext()) {
                ActivityPlanItemTerminalDto activityPlanItemTerminalDto = (ActivityPlanItemTerminalDto)iterator.next();
                String key = activityPlanItemTerminalDto.getId();
                BigDecimal thisFeeAmount = Optional.ofNullable(feeAmountMap.get(key)).orElse(BigDecimal.ZERO);
                BigDecimal thisAmount = systemBorneAmount.multiply(thisFeeAmount).divide(totalFeeAmount, 2, RoundingMode.HALF_UP);
                activityPlanItemTerminalDto.setSystemBorneAmount(thisAmount);
                leaveAmount = leaveAmount.subtract(thisAmount);
            }
            if (leaveAmount.compareTo(BigDecimal.ZERO) != 0) {
                ActivityPlanItemTerminalDto lastTerminalDto = (ActivityPlanItemTerminalDto)activityPlanItemTerminalList.get(activityPlanItemTerminalList.size() - 1);
                lastTerminalDto.setSystemBorneAmount(lastTerminalDto.getSystemBorneAmount().add(leaveAmount));
            }
        }
    }

    @Override
    public List<TerminalVo> findAvaiableTerminal(ActivityPlanItemDto dto) {
        List terminalVoList;
        TerminalPaginationDto terminalPaginationDto = new TerminalPaginationDto();
        terminalPaginationDto.setRegionCode(dto.getRegion());
        terminalPaginationDto.setCustomerRetailerCode(dto.getSystemCode());
        terminalPaginationDto.setTerminalTypeCode(dto.getAcStoreType());
        terminalPaginationDto.setDistrictLevelCode(dto.getCityLevel());
        terminalPaginationDto.setTerminalTypeCode(dto.getAcStoreType());
        terminalPaginationDto.setPointsWarehouseCode(dto.getAcWarehouseCode());
        terminalPaginationDto.setTerminalState("1");
        terminalPaginationDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        terminalPaginationDto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        if (WriteOffMethodEnum.THINGS.getCode().equals(dto.getWriteOffMethod())) {
            terminalPaginationDto.setSettleDestination("1");
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getTerminalCode())) {
            terminalPaginationDto.setTerminalCode(dto.getTerminalCode());
        }
        if (!CollectionUtils.isEmpty((Collection)(terminalVoList = this.terminalVoService.findListByConditions(terminalPaginationDto)))) {
            terminalVoList = terminalVoList.stream().filter(item -> StringUtil.isNotEmpty((String)item.getSellerCode()) && StringUtil.isNotEmpty((String)item.getSalesInstitutionCode())).collect(Collectors.toList());
        }
        return terminalVoList;
    }

    @Override
    public void initActivityPlanItemTerminal(ActivityPlanItemTerminalDto dto, String cacheKey) {
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        String itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1);
        ActivityPlanItemDto itemDto = (ActivityPlanItemDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId);
        List<TerminalVo> terminalVoList = this.findAvaiableTerminal(itemDto);
        ArrayList activityPlanItemTerminalDtoList = Lists.newArrayList();
        for (TerminalVo terminalVo : terminalVoList) {
            ActivityPlanItemTerminalDto activityPlanItemTerminalDto = new ActivityPlanItemTerminalDto();
            activityPlanItemTerminalDto.setTerminalCode(terminalVo.getTerminalCode());
            activityPlanItemTerminalDto.setTerminalName(terminalVo.getTerminalName());
            activityPlanItemTerminalDto.setId(UUID.randomUUID().toString().replace("-", ""));
            activityPlanItemTerminalDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            activityPlanItemTerminalDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            activityPlanItemTerminalDtoList.add(activityPlanItemTerminalDto);
        }
        itemDto.setActivityPlanItemTerminalList((List)activityPlanItemTerminalDtoList);
        this.changeTerminalDetail(itemDto, true);
    }

    @Override
    public void proportionPosByCurrTerminal(ActivityPlanItemTerminalDto dto, String cacheKey) {
        String itemCacheKey = cacheKey.substring(0, cacheKey.lastIndexOf(":"));
        String itemId = cacheKey.substring(cacheKey.lastIndexOf(":") + 1);
        ActivityPlanItemDto itemDto = (ActivityPlanItemDto)this.itemHelper.getDtoByKey(itemCacheKey, itemId);
        itemDto.setCacheKey(itemCacheKey);
        this.proportionByTerminalPos(itemDto);
    }
}

