/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItem;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanLockService;
import com.biz.crm.tpm.business.activity.plan.local.service.internal.ActivityPlanItemPageCacheHelper;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityPlanLockServiceImpl
implements ActivityPlanLockService {
    @Autowired(required=false)
    private ActivityPlanItemService activityPlanItemService;
    @Autowired(required=false)
    private ActivityPlanRepository activityPlanRepository;
    @Autowired(required=false)
    private ActivityPlanItemRepository activityPlanItemRepository;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private ActivityPlanItemPageCacheHelper activityPlanItemPageCacheHelper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void closeItemList(List<ActivityPlanItem> itemList) {
        this.activityPlanItemPageCacheHelper.sendCloseMsg("\u5f00\u59cb\u6267\u884c\u6d3b\u52a8\u65b9\u6848\u4e00\u952e\u5173\u95ed...");
        if (CollectionUtil.isEmpty(itemList)) {
            this.activityPlanItemPageCacheHelper.sendCloseMsg("\u8bf7\u9009\u62e9\u65b9\u6848\u660e\u7ec6,\u6d3b\u52a8\u65b9\u6848\u5173\u95ed\u5904\u7406\u7ed3\u675f!", ExecStatusEnum.FINISH.getKey());
            return;
        }
        boolean lockSuccess = false;
        List ids = itemList.stream().map(UuidEntity::getId).collect(Collectors.toList());
        try {
            lockSuccess = this.redisLockService.batchLock("activity_plan:lock:item_close:", ids, TimeUnit.HOURS, 1);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.activityPlanItemService.closeItemList(itemList, true);
            this.activityPlanItemPageCacheHelper.sendCloseMsg("\u6d3b\u52a8\u65b9\u6848\u5173\u95ed\u5904\u7406\u6210\u529f!", ExecStatusEnum.FINISH.getKey());
        }
        catch (Exception e) {
            this.activityPlanItemPageCacheHelper.sendCloseMsg("\u6d3b\u52a8\u65b9\u6848\u5173\u95ed\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage(), ExecStatusEnum.FINISH.getKey());
            throw e;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.batchUnLock("activity_plan:lock:item_close:", ids);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void closeItemByPlanIds(List<String> ids) {
        this.activityPlanItemPageCacheHelper.sendCloseMsg("\u5f00\u59cb\u6267\u884c\u6d3b\u52a8\u65b9\u6848\u4e00\u952e\u5173\u95ed...", ExecStatusEnum.RUNNING.getKey());
        if (CollectionUtils.isEmpty(ids)) {
            this.activityPlanItemPageCacheHelper.sendCloseMsg("\u8bf7\u9009\u62e9\u65b9\u6848,\u6d3b\u52a8\u65b9\u6848\u5173\u95ed\u5904\u7406\u7ed3\u675f", ExecStatusEnum.FINISH.getKey());
            return;
        }
        List planList = this.activityPlanRepository.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)planList)) {
            this.activityPlanItemPageCacheHelper.sendCloseMsg("\u9009\u62e9\u7684\u65b9\u6848\u4e0d\u5b58\u5728,\u6d3b\u52a8\u65b9\u6848\u5173\u95ed\u5904\u7406\u7ed3\u675f", ExecStatusEnum.FINISH.getKey());
            return;
        }
        List<String> planCodeList = planList.stream().map(ActivityPlan::getPlanCode).collect(Collectors.toList());
        List<String> itemIds = this.activityPlanItemRepository.listIdByPlanCodes(planCodeList);
        if (CollectionUtils.isEmpty(itemIds)) {
            this.activityPlanItemPageCacheHelper.sendCloseMsg("\u9009\u62e9\u7684\u65b9\u6848\u672a\u627e\u5230\u65b9\u6848\u660e\u7ec6,\u6d3b\u52a8\u65b9\u6848\u5173\u95ed\u5904\u7406\u7ed3\u675f", ExecStatusEnum.FINISH.getKey());
            return;
        }
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.batchLock("activity_plan:lock:item_close:", ids, TimeUnit.HOURS, 1);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            List<String> errorMsgList = this.activityPlanItemService.closeItem(itemIds, false);
            Assert.isTrue((boolean)CollectionUtils.isEmpty(errorMsgList), (String)String.join((CharSequence)",", errorMsgList));
            this.activityPlanItemPageCacheHelper.sendCloseMsg("\u6d3b\u52a8\u65b9\u6848\u5173\u95ed\u5904\u7406\u6210\u529f", ExecStatusEnum.FINISH.getKey());
        }
        catch (Exception e) {
            this.activityPlanItemPageCacheHelper.sendCloseMsg("\u6d3b\u52a8\u65b9\u6848\u5173\u95ed\u5904\u7406\u7ed3\u675f:" + e.getMessage(), ExecStatusEnum.FINISH.getKey());
            throw e;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.batchUnLock("activity_plan:lock:item_close:", ids);
            }
        }
    }
}

