/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanRelatePlan;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanRelatePlanRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanRelatePlanService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanRelatePlanDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityPlanRelatePlanServiceImpl
implements ActivityPlanRelatePlanService {
    @Autowired(required=false)
    private ActivityPlanRelatePlanRepository activityPlanRelatePlanRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveActivityPlanRelatePlanList(ActivityPlan entity, boolean update, List<ActivityPlanRelatePlanDto> planList) {
        Map<Object, Object> oldMap = Maps.newHashMap();
        if (update) {
            List<ActivityPlanRelatePlan> oldList = this.activityPlanRelatePlanRepository.findListByPlanCode(entity.getPlanCode());
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        if (CollectionUtils.isEmpty(planList)) {
            if (oldMap.size() > 0) {
                this.activityPlanRelatePlanRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
            }
            return;
        }
        List activityPlanRelatePlans = (List)this.nebulaToolkitService.copyCollectionByWhiteList(planList, ActivityPlanRelatePlanDto.class, ActivityPlanRelatePlan.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (ActivityPlanRelatePlan item : activityPlanRelatePlans) {
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
                oldMap.remove(item.getId());
                continue;
            }
            item.setPlanCode(entity.getPlanCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            item.setId(null);
            saveList.add(item);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.activityPlanRelatePlanRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.activityPlanRelatePlanRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            this.activityPlanRelatePlanRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }
}

