/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanRelatePlanRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanStrategyRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanBudgetService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanOutDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.OperateActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanRelatePlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanStrategyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class ActivityPlanSdkServiceImpl
implements ActivityPlanSdkService {
    @Autowired(required=false)
    private ActivityPlanService activityPlanService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityPlanRepository activityPlanRepository;
    @Autowired(required=false)
    private ActivityPlanItemRepository activityPlanItemRepository;
    @Autowired(required=false)
    private ActivityPlanBudgetService activityPlanBudgetService;
    @Autowired(required=false)
    private ActivityPlanRelatePlanRepository activityPlanRelatePLanRepository;
    @Autowired(required=false)
    private ActivityPlanStrategyRepository activityPlanStrategyRepository;

    public Page<ActivityPlanVo> findByConditions(Pageable pageable, ActivityPlanDto dto) {
        return this.activityPlanService.findByConditions(pageable, dto);
    }

    public void operateBudget(List<OperateActivityPlanBudgetDto> planBudgetOperateList) {
        this.activityPlanBudgetService.operateBudget(planBudgetOperateList);
    }

    public void operateCustomerBudget(List<OperateActivityPlanBudgetDto> planBudgetOperateList) {
        this.activityPlanBudgetService.operateCustomerBudget(planBudgetOperateList);
    }

    public List<ActivityPlanVo> findByCodes(Set<String> planCodes) {
        if (CollectionUtils.isEmpty(planCodes)) {
            return Lists.newArrayList();
        }
        return this.activityPlanService.findByCodes(planCodes);
    }

    public List<ActivityPlanVo> findByPlanCodeList(Set<String> planCodes) {
        if (CollectionUtils.isEmpty(planCodes)) {
            return Lists.newArrayList();
        }
        List<ActivityPlan> list = this.activityPlanRepository.findByPlanCodeList(Lists.newArrayList(planCodes));
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, ActivityPlan.class, ActivityPlanVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public String findPlanCodeByPlanName(String planName) {
        return null;
    }

    public List<ActivityPlanDto> buildActivityPlanParms(List<String> businessNoList) {
        return this.activityPlanService.buildActivityPlanParms(businessNoList);
    }

    public List<ActivityPlanDto> findPlanDtoListByCodeList(List<String> planCodeList) {
        return this.activityPlanRepository.findDtoListByPlanCodeList(planCodeList);
    }

    public List<ActivityPlanItemDto> findItemDtoAndAttachListByPlanCodeList(List<String> planCodeList) {
        return this.activityPlanItemRepository.findDtoAndAttachListByPlanCodeList(planCodeList);
    }

    public List<ActivityPlanVo> findPlanActivityEndTime(Set<String> activityDetailCodes) {
        return this.activityPlanService.findPlanActivityEndTime(activityDetailCodes);
    }

    public List<ActivityPlanItemDto> findByPlanItem(String planCode) {
        return this.activityPlanService.findByPlanItem(planCode);
    }

    public List<ActivityPlanRelatePlanVo> findRelatePLan(String planCode) {
        if (!StringUtils.hasText((String)planCode)) {
            return Collections.emptyList();
        }
        return this.activityPlanRelatePLanRepository.findListVoByPlanCode(planCode);
    }

    public List<ActivityPlanStrategyVo> findActivityPlanStrategyVoList(List<String> planCodeList) {
        return this.activityPlanStrategyRepository.findListVoByPlanCodeList(planCodeList);
    }

    public void createActivityPlan(ActivityPlanDto planDto) {
        if (Objects.isNull(planDto)) {
            return;
        }
        this.activityPlanService.createActivityPlan(planDto);
    }

    public ActivityPlanVo findByPlanItemCode(String planItemCode) {
        if (!StringUtils.hasText((String)planItemCode)) {
            return null;
        }
        return this.activityPlanService.findByPlanItemCode(planItemCode);
    }

    public ActivityPlanVo findById(String id) {
        return null;
    }

    public ActivityPlanOutDto createForOut(ActivityPlanOutDto dto) {
        return null;
    }

    public ActivityPlanOutDto updateForOut(ActivityPlanOutDto dto) {
        return null;
    }

    public void delete(List<String> ids) {
    }

    public Object atomCreate(ActivityPlanOutDto dto) {
        this.activityPlanService.atomSaveActivityPlan((ActivityPlanDto)dto);
        return null;
    }

    @Transactional
    public void updateActivityDelayEndTime(List<ActivityPlanItemDto> list) {
        this.activityPlanService.updateActivityDelayEndTime(list);
    }

    public List<ActivityPlanBudgetVo> findHeadquartersByRegionPlanCodes(Set<String> planCodes) {
        if (CollectionUtils.isEmpty(planCodes)) {
            return Lists.newArrayList();
        }
        return this.activityPlanRepository.findHeadquartersByRegionPlanCodes(planCodes);
    }

    public List<ActivityPlanVo> findActivityUsableBudget(List<String> planCodeList) {
        return this.activityPlanRepository.findActivityUsableBudget(planCodeList);
    }

    public List<ActivityPlanVo> findOrgCodeByPlanCode(List<String> planCodes) {
        if (CollectionUtils.isEmpty(planCodes)) {
            return Lists.newArrayList();
        }
        List<ActivityPlanVo> list = this.activityPlanRepository.findOrgCodeByPlanCode(planCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }
}

