/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlan;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanTemplate;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanTemplateRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanTemplateService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanTemplateDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityPlanTemplateServiceImpl
implements ActivityPlanTemplateService {
    @Autowired(required=false)
    private ActivityPlanTemplateRepository activityPlanTemplateRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveActivityPlanTemplateList(ActivityPlan entity, boolean update, List<ActivityPlanTemplateDto> templateList) {
        if (CollectionUtils.isEmpty(templateList)) {
            return;
        }
        Map<Object, Object> oldMap = Maps.newHashMap();
        if (update) {
            List<ActivityPlanTemplate> oldList = this.activityPlanTemplateRepository.findListByPlanCode(entity.getPlanCode());
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        List activityPlanStrategies = (List)this.nebulaToolkitService.copyCollectionByWhiteList(templateList, ActivityPlanTemplateDto.class, ActivityPlanTemplate.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (ActivityPlanTemplate item : activityPlanStrategies) {
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
                oldMap.remove(item.getId());
                continue;
            }
            item.setPlanCode(entity.getPlanCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            item.setId(null);
            saveList.add(item);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.activityPlanTemplateRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.activityPlanTemplateRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            this.activityPlanTemplateRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }
}

