/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanBudget;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanBudgetRepository;
import com.biz.crm.tpm.business.activity.plan.local.repository.ActivityPlanItemRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanVoService;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanBudgetSumVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessMappingVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityPlanVoServiceImpl
implements ActivityPlanVoService {
    @Autowired(required=false)
    private ActivityPlanBudgetRepository activityPlanBudgetRepository;
    @Autowired(required=false)
    private ActivityPlanItemRepository activityPlanItemRepository;
    @Autowired(required=false)
    private ProcessBusinessMappingService processBusinessMappingService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;

    @Override
    public List<ActivityPlanItemVo> findActivityPlanItemSumInfoByProcessNo(String processNo) {
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return Lists.newArrayList();
        }
        List processBusinessMappingVos = this.processBusinessMappingService.findAllByProcessNoCollection((Collection)Lists.newArrayList((Object[])new String[]{processNo}));
        List<String> planCodeList = processBusinessMappingVos.stream().map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
        List<ActivityPlanItemVo> planItemDtos = this.activityPlanItemRepository.findVoListByPlanCodeList(planCodeList);
        Map<String, List<ActivityPlanItemVo>> groupMap = planItemDtos.stream().collect(Collectors.groupingBy(item -> item.getFeeYearMonthStr() + item.getActivityOrgCode() + item.getActivityTypeCode() + item.getActivityFormCode()));
        ArrayList result = Lists.newArrayList();
        BigDecimal multiplicand = new BigDecimal(100);
        for (Map.Entry<String, List<ActivityPlanItemVo>> entry : groupMap.entrySet()) {
            List<ActivityPlanItemVo> value = entry.getValue();
            ActivityPlanItemVo firstVo = value.get(0);
            ActivityPlanItemVo vo = new ActivityPlanItemVo();
            vo.setFeeYearMonthStr(firstVo.getFeeYearMonthStr());
            vo.setActivityOrgCode(firstVo.getActivityOrgCode());
            vo.setActivityOrgName(firstVo.getActivityOrgName());
            vo.setActivityTypeCode(firstVo.getActivityTypeCode());
            vo.setActivityTypeName(firstVo.getActivityTypeName());
            vo.setActivityForm(firstVo.getActivityFormCode());
            vo.setActivityFormName(firstVo.getActivityFormName());
            vo.setTotalFeeAmount(BigDecimal.ZERO);
            vo.setHeadFeeAmount(BigDecimal.ZERO);
            vo.setDepartmentFeeAmount(BigDecimal.ZERO);
            vo.setSalesAmount(BigDecimal.ZERO);
            for (ActivityPlanItemVo activityPlanItemVo : value) {
                if (null != activityPlanItemVo.getTotalFeeAmount()) {
                    vo.setTotalFeeAmount(vo.getTotalFeeAmount().add(activityPlanItemVo.getTotalFeeAmount()));
                }
                if (null != activityPlanItemVo.getHeadFeeAmount()) {
                    vo.setHeadFeeAmount(vo.getHeadFeeAmount().add(activityPlanItemVo.getHeadFeeAmount()));
                }
                if (null != activityPlanItemVo.getDepartmentFeeAmount()) {
                    vo.setDepartmentFeeAmount(vo.getDepartmentFeeAmount().add(activityPlanItemVo.getDepartmentFeeAmount()));
                }
                if (null == activityPlanItemVo.getSalesAmount()) continue;
                vo.setSalesAmount(vo.getSalesAmount().add(activityPlanItemVo.getSalesAmount()));
            }
            String feeRateStr = null;
            if (null != vo.getSalesAmount() && vo.getSalesAmount().compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal feeRate = vo.getTotalFeeAmount().multiply(multiplicand).divide(vo.getSalesAmount(), 2, 4);
                feeRateStr = feeRate + "%";
            }
            vo.setFeeRateStr(feeRateStr);
            result.add(vo);
        }
        return result;
    }

    @Override
    public List<ActivityPlanBudgetSumVo> findActivityPlanBudgetSumInfoByProcessNo(String processNo) {
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return Lists.newArrayList();
        }
        List processBusinessMappingVos = this.processBusinessMappingService.findAllByProcessNoCollection((Collection)Lists.newArrayList((Object[])new String[]{processNo}));
        List<String> planCodeList = processBusinessMappingVos.stream().map(ProcessBusinessMappingVo::getBusinessNo).collect(Collectors.toList());
        List<ActivityPlanBudget> activityPlanBudgets = this.activityPlanBudgetRepository.listByPlanCodeList(planCodeList);
        List monthBudgetCodeList = activityPlanBudgets.stream().map(ActivityPlanBudget::getMonthBudgetCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List monthBudgetVos = this.monthBudgetService.listByCodes(monthBudgetCodeList);
        Map<String, List<MonthBudgetVo>> budgetGroupMap = monthBudgetVos.stream().collect(Collectors.groupingBy(item -> item.getBudgetItemCode() + item.getYearMonthLy()));
        HashMap resultMap = Maps.newHashMap();
        for (Map.Entry<String, List<MonthBudgetVo>> entry : budgetGroupMap.entrySet()) {
            List<MonthBudgetVo> value = entry.getValue();
            MonthBudgetVo firstMonthBudgetVo = value.get(0);
            ActivityPlanBudgetSumVo activityPlanBudgetSumVo = resultMap.computeIfAbsent(entry.getKey(), tempKey -> {
                ActivityPlanBudgetSumVo tempSumVo = new ActivityPlanBudgetSumVo();
                tempSumVo.setYearMonthLy(firstMonthBudgetVo.getYearMonthLy());
                tempSumVo.setBudgetItemCode(firstMonthBudgetVo.getBudgetItemCode());
                tempSumVo.setBudgetItemName(firstMonthBudgetVo.getBudgetItemName());
                tempSumVo.setAccumulatedAvailableBalance(BigDecimal.ZERO);
                tempSumVo.setControlBalanceAmount(BigDecimal.ZERO);
                tempSumVo.setUseAmount(BigDecimal.ZERO);
                return tempSumVo;
            });
            for (MonthBudgetVo monthBudgetVo : value) {
                if (null != monthBudgetVo.getAccumulatedAvailableBalance()) {
                    activityPlanBudgetSumVo.setAccumulatedAvailableBalance(activityPlanBudgetSumVo.getAccumulatedAvailableBalance().add(monthBudgetVo.getAccumulatedAvailableBalance()));
                }
                if (null == monthBudgetVo.getControlBalanceAmount()) continue;
                activityPlanBudgetSumVo.setControlBalanceAmount(activityPlanBudgetSumVo.getControlBalanceAmount().add(monthBudgetVo.getControlBalanceAmount()));
            }
        }
        Map budgetMap = monthBudgetVos.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
        for (ActivityPlanBudget activityPlanBudget : activityPlanBudgets) {
            if (StringUtils.isEmpty((CharSequence)activityPlanBudget.getMonthBudgetCode())) continue;
            MonthBudgetVo monthBudgetVo = (MonthBudgetVo)budgetMap.get(activityPlanBudget.getMonthBudgetCode());
            String key = monthBudgetVo.getBudgetItemCode() + monthBudgetVo.getYearMonthLy();
            ActivityPlanBudgetSumVo activityPlanBudgetSumVo = (ActivityPlanBudgetSumVo)resultMap.get(key);
            if (null == activityPlanBudget.getUseAmount()) continue;
            activityPlanBudgetSumVo.setUseAmount(activityPlanBudget.getUseAmount());
        }
        return Lists.newArrayList(resultMap.values());
    }
}

