/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.local.service.internal;

import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.retailer.sdk.dto.CustomerRetailerDto;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.plan.local.entity.CorrectionDiscountRateQuantum;
import com.biz.crm.tpm.business.activity.plan.local.repository.CorrectionDiscountRateQuantumRepository;
import com.biz.crm.tpm.business.activity.plan.local.service.CorrectionDiscountRateQuantumService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.AuditFormEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.dto.SurplusFeePoolBalanceDto;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.service.SurplusFeePoolBalanceSdkService;
import com.biz.crm.tpm.business.budget.discount.rate.sdk.vo.SurplusFeePoolBalanceVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CorrectionDiscountRateQuantumServiceImpl
implements CorrectionDiscountRateQuantumService {
    private static final Logger log = LoggerFactory.getLogger(CorrectionDiscountRateQuantumServiceImpl.class);
    private static final String DICT_REGION_CODE = "MDM_CUSTOMIZE_ORG";
    @Autowired(required=false)
    private CorrectionDiscountRateQuantumRepository correctionDiscountRateQuantumRepository;
    @Autowired(required=false)
    private CustomerRetailerVoService customerRetailerVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private SalesGoalService salesGoalService;
    @Autowired(required=false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;
    @Autowired(required=false)
    private SurplusFeePoolBalanceSdkService surplusFeePoolBalanceSdkService;

    @Override
    @Transactional
    public void frJob(List<String> yearMonths, String regionCode, String systemCode) {
        this.correctionDiscountRateQuantumRepository.removeByYearMonth(yearMonths, regionCode, systemCode);
        PageRequest pageable = PageRequest.of((int)1, (int)200);
        CustomerRetailerDto dto = new CustomerRetailerDto();
        dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        dto.setCustomerRetailerCode(systemCode);
        Page customerRetailerVoPage = this.customerRetailerVoService.findByConditions((Pageable)pageable, dto);
        if (Objects.isNull(customerRetailerVoPage) || CollectionUtils.isEmpty((Collection)customerRetailerVoPage.getRecords())) {
            return;
        }
        List dictDataVoList = this.dictDataVoService.findByDictTypeCode(DICT_REGION_CODE);
        if (CollectionUtils.isEmpty((Collection)dictDataVoList)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)regionCode)) {
            dictDataVoList = dictDataVoList.stream().filter(o -> regionCode.equals(o.getDictCode())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)dictDataVoList)) {
            return;
        }
        ArrayList quantumList = Lists.newArrayList();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
        List finalDictDataVoList = dictDataVoList;
        yearMonths.forEach(yearMonth -> customerRetailerVoPage.getRecords().forEach(retailer -> finalDictDataVoList.forEach(dict -> {
            CorrectionDiscountRateQuantum quantum = new CorrectionDiscountRateQuantum();
            quantum.setTenantCode(TenantUtils.getTenantCode());
            quantum.setYearMonthStr((String)yearMonth);
            YearMonth ym = YearMonth.parse(yearMonth, formatter);
            ym = ym.plusMonths(-1L);
            quantum.setLastMonth(ym.format(formatter));
            ym = ym.plusMonths(-1L);
            quantum.setLastLastMonth(ym.format(formatter));
            quantum.setRegionCode(dict.getDictCode());
            quantum.setRegionName(dict.getDictValue());
            quantum.setSystemCode(retailer.getCustomerRetailerCode());
            quantum.setSystemName(retailer.getCustomerRetailerName());
            quantum.setQuantum(StringUtils.join((Object[])new String[]{quantum.getRegionName(), quantum.getSystemName()}));
            quantum.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            quantum.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            quantumList.add(quantum);
        })));
        Lists.partition((List)quantumList, (int)200).forEach(p -> {
            List salesGoalDtos = p.stream().map(e -> new SalesGoalDto((CorrectionDiscountRateQuantum)((Object)((Object)e))){
                final /* synthetic */ CorrectionDiscountRateQuantum val$e;
                {
                    this.val$e = correctionDiscountRateQuantum;
                    this.setYearMonthLy(this.val$e.getYearMonthStr());
                    this.setRegionCode(this.val$e.getRegionCode());
                    this.setSystemCode(this.val$e.getSystemCode());
                    this.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                    this.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
                }
            }).collect(Collectors.toList());
            List salesGoalVos = this.salesGoalService.findListForFR(salesGoalDtos);
            Map salesGoalVoMap = salesGoalVos.stream().collect(Collectors.toMap(e -> StringUtils.join((Object[])new String[]{e.getYearMonthLy(), e.getRegionCode(), e.getSystemCode()}), Function.identity(), (v1, v2) -> v1));
            List activityPlanItemDtos = p.stream().map(e -> new ActivityPlanItemDto((CorrectionDiscountRateQuantum)((Object)((Object)e))){
                final /* synthetic */ CorrectionDiscountRateQuantum val$e;
                {
                    this.val$e = correctionDiscountRateQuantum;
                    this.setYearMonthLy(this.val$e.getYearMonthStr());
                    this.setRegion(this.val$e.getRegionCode());
                    this.setSystemCode(this.val$e.getSystemCode());
                    this.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                    this.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
                }
            }).collect(Collectors.toList());
            List activityPlanItemVos = this.activityPlanItemSdkService.findListForFR(activityPlanItemDtos);
            Map activityPlanItemVoMap = activityPlanItemVos.stream().collect(Collectors.toMap(e -> StringUtils.join((Object[])new String[]{e.getYearMonthLy(), e.getRegion(), e.getSystemCode()}), Function.identity(), (v1, v2) -> v1));
            List itemDtos = p.stream().map(e -> new ActivityPlanItemDto((CorrectionDiscountRateQuantum)((Object)((Object)e))){
                final /* synthetic */ CorrectionDiscountRateQuantum val$e;
                {
                    this.val$e = correctionDiscountRateQuantum;
                    this.setYearMonthLy(this.val$e.getLastMonth());
                    this.setRegion(this.val$e.getRegionCode());
                    this.setSystemCode(this.val$e.getSystemCode());
                }
            }).collect(Collectors.toList());
            List itemVoList = this.activityPlanItemSdkService.findCostListForFR(itemDtos, AuditFormEnum.DISCOUNT.getCode());
            Map itemVoMap = itemVoList.stream().collect(Collectors.toMap(e -> StringUtils.join((Object[])new String[]{this.getNextMonth(formatter, e.getYearMonthLy()), e.getRegion(), e.getSystemCode()}), Function.identity(), (v1, v2) -> v1));
            List itemVoList1 = this.activityPlanItemSdkService.findCostListForFR(itemDtos, AuditFormEnum.RED_INVOICE.getCode());
            Map itemVoMap1 = itemVoList1.stream().collect(Collectors.toMap(e -> StringUtils.join((Object[])new String[]{e.getYearMonthLy(), e.getRegion(), e.getSystemCode()}), Function.identity(), (v1, v2) -> v1));
            List balanceDtos = p.stream().map(e -> new SurplusFeePoolBalanceDto((CorrectionDiscountRateQuantum)((Object)((Object)e))){
                final /* synthetic */ CorrectionDiscountRateQuantum val$e;
                {
                    this.val$e = correctionDiscountRateQuantum;
                    this.setYearMonthStr(this.val$e.getYearMonthStr());
                    this.setRegionCode(this.val$e.getRegionCode());
                    this.setCustomerRetailerCode(this.val$e.getSystemCode());
                }
            }).collect(Collectors.toList());
            List balanceVos = this.surplusFeePoolBalanceSdkService.findListForFR(balanceDtos, BusinessUnitEnum.VERTICAL.getCode());
            Map balanceVoMap = balanceVos.stream().collect(Collectors.toMap(e -> StringUtils.join((Object[])new String[]{e.getYearMonthStr(), e.getRegionCode(), e.getCustomerRetailerCode()}), Function.identity()));
            p.forEach(e -> {
                String key = StringUtils.join((Object[])new String[]{e.getYearMonthStr(), e.getRegionCode(), e.getSystemCode()});
                e.setDiscountAfterSalesAmount(BigDecimal.ZERO);
                if (salesGoalVoMap.containsKey(key)) {
                    e.setDiscountAfterSalesAmount(((SalesGoalVo)salesGoalVoMap.get(key)).getDeliveryDiscountSalesAmount());
                }
                e.setEventCentreAmount(BigDecimal.ZERO);
                if (activityPlanItemVoMap.containsKey(key)) {
                    e.setEventCentreAmount(((ActivityPlanItemVo)activityPlanItemVoMap.get(key)).getTotalFeeAmount());
                }
                e.setEventAfterAmount(BigDecimal.ZERO);
                if (itemVoMap.containsKey(key)) {
                    e.setEventAfterAmount(((ActivityPlanItemVo)itemVoMap.get(key)).getTotalFeeAmount());
                }
                e.setRedTicket(BigDecimal.ZERO);
                if (itemVoMap1.containsKey(key)) {
                    e.setRedTicket(((ActivityPlanItemVo)itemVoMap1.get(key)).getTotalFeeAmount());
                }
                e.setCostPoolResidue(BigDecimal.ZERO);
                if (balanceVoMap.containsKey(key)) {
                    e.setCostPoolResidue(((SurplusFeePoolBalanceVo)balanceVoMap.get(key)).getBalance());
                }
                e.setCostTotal(e.getEventCentreAmount().add(e.getEventAfterAmount()).add(e.getRedTicket()).add(e.getCostPoolResidue()));
                e.setDiscountBeforeSalesAmount(e.getDiscountAfterSalesAmount().add(e.getCostTotal()));
                e.setCorrectionDiscountBeforeRate(BigDecimal.ZERO);
                if (BigDecimal.ZERO.compareTo(e.getDiscountBeforeSalesAmount()) != 0) {
                    e.setCorrectionDiscountBeforeRate(e.getCostTotal().divide(e.getDiscountBeforeSalesAmount(), 4, 4));
                }
                e.setCorrectionDiscountAfterRate(BigDecimal.ZERO);
                if (BigDecimal.ZERO.compareTo(e.getDiscountAfterSalesAmount()) != 0) {
                    e.setCorrectionDiscountAfterRate(e.getCostTotal().divide(e.getDiscountAfterSalesAmount(), 4, 4));
                }
                BigDecimal before = BigDecimal.ZERO;
                e.setBudgetDiscountAfterRate(BigDecimal.ZERO);
                if (salesGoalVoMap.containsKey(key)) {
                    before = ((SalesGoalVo)salesGoalVoMap.get(key)).getDeliverySalesAmount();
                }
                if (BigDecimal.ZERO.compareTo(e.getDiscountAfterSalesAmount()) != 0) {
                    e.setBudgetDiscountAfterRate(before.subtract(e.getDiscountAfterSalesAmount()).divide(e.getDiscountAfterSalesAmount(), 4, 4));
                }
                e.setVsOffset(e.getCorrectionDiscountAfterRate().subtract(e.getBudgetDiscountAfterRate()));
            });
            this.correctionDiscountRateQuantumRepository.saveOrUpdateBatch((Collection)p);
        });
    }

    private String getNextMonth(DateTimeFormatter formatter, String yearMonthLy) {
        YearMonth ym = YearMonth.parse(yearMonthLy, formatter);
        ym = ym.plusMonths(1L);
        return ym.format(formatter);
    }
}

